/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.constant.CourseSignStatus;
import com.baijia.tianxiao.biz.erp.dto.LessonTime;
import com.baijia.tianxiao.biz.erp.dto.request.AddCourseLessonRequestDto;
import com.baijia.tianxiao.biz.erp.dto.request.EditLessonRequestDto;
import com.baijia.tianxiao.biz.erp.dto.request.ListLessonsRequestDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonTimeTableResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.ListLessonResponseDto;
import com.baijia.tianxiao.biz.erp.enums.BatchOperateType;
import com.baijia.tianxiao.biz.erp.service.CourseLessonService;
import com.baijia.tianxiao.biz.erp.teacherCenter.service.ExcelCourseExportService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.CommentStatus;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.org.po.OrgTeacherLesson;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.pcAuthority.dao.TXPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.dao.TxAccountPermissionDao;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.excel.dto.ExportField;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.comment.constant.CommentErrorCode;
import com.baijia.tianxiao.sal.course.dto.HeaderDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentsChooseListDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.room.dto.ClassRoomDto;
import com.baijia.tianxiao.sal.room.service.ClassRoomService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.date.TimeStamp;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.beust.jcommander.internal.Lists;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CourseLessonServiceImpl
implements CourseLessonService {
    private static final Logger log = LoggerFactory.getLogger(CourseLessonServiceImpl.class);
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private OrgClassRoomDao orgClassRoomDao;
    @Resource
    private OrgLessonCommentDao orgLessonCommentDao;
    @Resource
    private OrgCourseListService orgCourseListService;
    @Resource
    private CourseStudentService courseStudentService;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Resource
    private ClassRoomService classRoomService;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgStudentCourseService orgStudentCourseService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TxAccountPermissionDao txAccountPermissionDao;
    @Autowired
    private TXPermissionDao txPermissionDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addClassLessons(Long orgId, Date startDay, Date endDay, AddCourseLessonRequestDto dto) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((startDay != null ? 1 : 0) != 0, (Object)"start day can not be null");
        Preconditions.checkArgument((dto != null ? 1 : 0) != 0, (Object)"class lessons param is illegal");
        Preconditions.checkArgument((dto.getCourseId() != null && dto.getCourseId() > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        List<Calendar> calens = dto.getRepeatUnit().getAvaliableDays(startDay, dto.getRepeatCount(), dto.getRepeatRange());
        TimeStamp startTime = TimeStamp.parse((String)dto.getStartTime());
        TimeStamp endTime = TimeStamp.parse((String)dto.getEndTime());
        OrgClassLesson lesson = null;
        List lessons = Lists.newArrayList();
        int index = 1;
        for (Calendar cal : calens) {
            LessonTime lessonTime = new LessonTime(cal, startTime, endTime);
            lesson = new OrgClassLesson();
            lesson.setStartTime(lessonTime.getStartTime());
            lesson.setEndTime(lessonTime.getEndTime());
            lesson.setCourseId(dto.getCourseId());
            lesson.setCreateTime(new Date());
            lesson.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
            lesson.setLayoutId(Long.valueOf(0L));
            lesson.setRoomId(Long.valueOf(dto.getRoomId() != null ? dto.getRoomId() : 0L));
            lesson.setUpdateTime(new Date());
            lesson.setNumber(Integer.valueOf(index));
            lesson.setOrgId(orgId);
            lessons.add(lesson);
            ++index;
        }
        log.info("save {} lessons into db,params:{}", (Object)lessons.size(), (Object)dto);
        this.orgClassLessonDao.saveAll(lessons, new String[]{"startTime", "endTime", "courseId", "createTime", "delStatus", "layoutId", "roomId", "updateTime", "orgId"});
        HashSet roomIds = Sets.newHashSet();
        roomIds.add(dto.getRoomId() != null ? dto.getRoomId() : 0L);
        this.classRoomService.addClassRoomCourse(Long.valueOf(orgId), dto.getCourseId(), (Collection)roomIds);
        this.resetLessonNumber(orgId, dto.getCourseId());
        for (OrgClassLesson classLesson : lessons) {
            this.courseStudentService.addStudentToLesson(orgId, classLesson.getCourseId(), classLesson.getId(), dto.getStudentIds(), true);
            HashSet teacherIds = Sets.newHashSet();
            if (dto.getTeacherId() == null || dto.getTeacherId() <= 0L) continue;
            teacherIds.add(dto.getTeacherId());
            HashSet tempTeacherIds = Sets.newHashSet();
            tempTeacherIds.addAll(teacherIds);
            this.courseTeacherService.addTeacherToCourse(orgId, classLesson.getCourseId(), (Collection)teacherIds);
            this.courseTeacherService.addTeacherToLesson(orgId, classLesson.getCourseId(), classLesson.getId(), (Collection)tempTeacherIds);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public ListLessonResponseDto listLessons(Long orgId, ListLessonsRequestDto params) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        HashMap<Long, Long> lessonIdTeacherIdMap = new HashMap<Long, Long>();
        List<OrgClassLesson> lessons = this.queryLesson(orgId, lessonIdTeacherIdMap, params, true);
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Collections.sort(lessons, new Comparator<OrgClassLesson>(){

                @Override
                public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                    return o1.getNumber().compareTo(o2.getNumber());
                }
            });
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }
            Map<Object, Object> courseMap = Maps.newHashMap();
            courseMap = this.getOrgCourseMap(orgId, courseIds);
            Map<Object, Object> lessonIdTeacherNameMap = Maps.newHashMap();
            if (params.isNeedTeacherName()) {
                lessonIdTeacherNameMap = this.getLessonIdTeacherName(orgId, lessonIds, lessonIdTeacherIdMap);
            }
            Map<Object, Object> classRoomMap = Maps.newHashMap();
            if (params.isNeedRoomName()) {
                classRoomMap = this.getOrgClassRoomMap(roomIds);
            }
            Map studentCountMap = this.orgStudentLessonDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
            Map signStudentCountMap = Maps.newHashMap();
            if (!params.isNeedStudentSignStatus() && params.isNeedSignInfo()) {
                signStudentCountMap = this.orgLessonSignDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
            }
            Map commentCount = Maps.newHashMap();
            Map lessonSignStatus = Maps.newHashMap();
            if (params.isNeedStudentSignStatus()) {
                Preconditions.checkArgument((params.getStudentId() != null && params.getStudentId() > 0L ? 1 : 0) != 0, (Object)"\u5b66\u751fID\u4e0d\u6b63\u786e");
                Long userId = this.orgStudentDao.getUserId(params.getStudentId());
                commentCount = this.orgLessonCommentDao.getLessonCommentCountMap((Collection)lessonIds, orgId, userId, null, Integer.valueOf(UserRole.STUDENT.getRole()), Boolean.valueOf(false));
                List lessonSign = this.orgLessonSignDao.getStudentSign(orgId, userId, Integer.valueOf(UserRole.STUDENT.getRole()), (Collection)lessonIds, new String[]{"lessonId", "status"});
                if (CollectionUtils.isNotEmpty((Collection)lessonSign)) {
                    lessonSignStatus = CollectorUtil.collectMap((Collection)lessonSign, (Function)new Function<OrgLessonSign, Long>(){

                        public Long apply(OrgLessonSign input) {
                            return input.getLessonId();
                        }
                    }, (Function)new Function<OrgLessonSign, Integer>(){

                        public Integer apply(OrgLessonSign input) {
                            return input.getStatus();
                        }
                    });
                    log.debug("student lesson sign:{}", (Object)lessonSignStatus);
                }
            }
            result = this.buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap, studentCountMap, signStudentCountMap, commentCount, lessonSignStatus);
        } else {
            result.setFirstLessonStartTime(params.getFirstLessonStartTime());
            result.setLastLessonStartTime(params.getLastLessonStartTime());
            if (params.getFirstLessonStartTime() == null && params.getLastLessonStartTime() == null) {
                result.setFirstLessonStartTime(DateUtil.getCurrentDate());
            }
        }
        return result;
    }

    private Map<Long, String> getLessonIdTeacherName(Long orgId, Collection<Long> lessonIds, Map<Long, Long> lessonTeacherIdMap) {
        if (MapUtils.isEmpty(lessonTeacherIdMap)) {
            lessonTeacherIdMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, lessonIds);
        }
        Map teacherNameMap = this.teacherDao.getTeacherRealNameMap(lessonTeacherIdMap.values());
        HashMap<Long, String> lessonIdTeacherNameMap = new HashMap<Long, String>(lessonTeacherIdMap.size());
        for (Long lessonId : lessonTeacherIdMap.keySet()) {
            lessonIdTeacherNameMap.put(lessonId, (String)teacherNameMap.get(lessonTeacherIdMap.get(lessonId)));
        }
        return lessonIdTeacherNameMap;
    }

    private List<OrgClassLesson> queryLesson(Long orgId, Map<Long, Long> lessonIdTeacherIdMap, ListLessonsRequestDto params, boolean isTimeTable) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet teacherIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        if (params.getCourseId() != null) {
            courseIds.add(params.getCourseId());
        }
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0]);
            if (txCascadeAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                log.debug("before clear courseIds:{}", (Object)courseIds);
                List tempIds = this.orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId());
                log.debug("user cascadeId={},courseIds={}", (Object)TianxiaoMContext.getTXCascadeId(), (Object)tempIds);
                if (CollectionUtils.isEmpty((Collection)courseIds)) {
                    courseIds.addAll(tempIds);
                } else if (!tempIds.containsAll(courseIds)) {
                    courseIds.clear();
                }
                log.debug("after set courseIds:{}", (Object)courseIds);
                if (CollectionUtils.isEmpty((Collection)courseIds)) {
                    return Collections.EMPTY_LIST;
                }
            }
        }
        if (params.getRoomId() != null) {
            roomIds.add(params.getRoomId());
        }
        if (params.getTeacherId() != null) {
            teacherIds.add(params.getTeacherId());
        }
        if (params.getStudentId() != null) {
            lessonIds.addAll(this.courseStudentService.getStudentLessonIds(orgId, params.getStudentId()));
            if (CollectionUtils.isEmpty((Collection)lessonIds)) {
                return Collections.emptyList();
            }
        }
        lessonIdTeacherIdMap = this.queryLessonIdByTeacherId(orgId, teacherIds);
        if (CollectionUtils.isNotEmpty((Collection)teacherIds) && lessonIdTeacherIdMap.isEmpty()) {
            return Collections.emptyList();
        }
        lessonIds.addAll(lessonIdTeacherIdMap.keySet());
        Date startTime = params.getStartTime();
        Date endTime = params.getEndTime();
        if (isTimeTable) {
            startTime = params.getFirstLessonStartTime();
            endTime = params.getLastLessonStartTime();
        }
        List lessons = this.orgClassLessonDao.queryLessons(orgId, (Collection)courseIds, (Collection)roomIds, (Collection)lessonIds, startTime, endTime, params.getPageDto(), new String[0]);
        return lessons;
    }

    @Override
    @Transactional(readOnly=true)
    public List<LessonTimeTableResponseDto> queryTimeTable(Long orgId, ListLessonsRequestDto params) {
        Preconditions.checkArgument((params.getStartTime() != null && params.getEndTime() != null ? 1 : 0) != 0, (Object)"start time or end time is null");
        Preconditions.checkArgument((boolean)params.getEndTime().after(params.getStartTime()), (Object)"time condition error");
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        Map<Long, Long> lessonIdTeacherIdMap = new HashMap<Long, Long>();
        List<OrgClassLesson> lessons = this.queryLesson(orgId, lessonIdTeacherIdMap, params, false);
        if (CollectionUtils.isNotEmpty(lessons)) {
            HashSet lessonIds = Sets.newHashSet();
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }
            if (lessonIdTeacherIdMap.isEmpty()) {
                lessonIdTeacherIdMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)lessonIds);
                log.debug("query lessonId teacherId map:{}by lessonIds:{}", lessonIdTeacherIdMap, (Object)lessonIds);
            }
            Map<Long, OrgCourse> courseMap = this.getOrgCourseMap(orgId, courseIds);
            Map teacherNameMap = this.teacherDao.getTeacherRealNameMap(lessonIdTeacherIdMap.values());
            Map<Long, OrgClassRoom> classRoomMap = this.getOrgClassRoomMap(roomIds);
            List result = Lists.newArrayList();
            for (OrgClassLesson lesson : lessons) {
                Long teacherId = lessonIdTeacherIdMap.get(lesson.getId());
                OrgCourse tempCourse = courseMap.get(lesson.getCourseId());
                if (tempCourse == null || tempCourse.getIsDel() != 0) continue;
                LessonTimeTableResponseDto dto = this.buildTimeTableDto(lesson, tempCourse, classRoomMap.get(lesson.getRoomId()), teacherId, (String)teacherNameMap.get(teacherId));
                result.add(dto);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private Map<Long, OrgClassRoom> getOrgClassRoomMap(Collection<Long> roomIds) {
        List classRooms = this.orgClassRoomDao.getByIds(roomIds, new String[]{"id", "roomName", "roomSize"});
        return CollectorUtil.collectMap((Collection)classRooms, (Function)new Function<OrgClassRoom, Long>(){

            public Long apply(OrgClassRoom input) {
                return input.getId();
            }
        });
    }

    private Map<Long, OrgCourse> getOrgCourseMap(Long orgId, Collection<Long> courseIds) {
        List courseList = this.orgCourseDao.getByIds(courseIds, new String[]{"id", "cover", "name", "color", "isDel"});
        Iterator courseIter = courseList.iterator();
        while (courseIter.hasNext()) {
            OrgCourse orgCourse = (OrgCourse)courseIter.next();
            if (orgCourse.getIsDel() == 0) continue;
            courseIter.remove();
        }
        this.orgCourseListService.getCourseList(courseList, orgId, false, false, false, Boolean.valueOf(false), false, false, false);
        return CollectorUtil.collectMap((Collection)courseList, (Function)new Function<OrgCourse, Long>(){

            public Long apply(OrgCourse input) {
                return input.getId();
            }
        });
    }

    private LessonTimeTableResponseDto buildTimeTableDto(OrgClassLesson lesson, OrgCourse course, OrgClassRoom classRoom, Long teacherId, String teacherName) {
        LessonTimeTableResponseDto dto = new LessonTimeTableResponseDto();
        dto.setCourseId(lesson.getCourseId());
        if (course != null) {
            dto.setCourseColor(course.getColor());
            dto.setCourseName(course.getName());
        }
        dto.setCreateTime(lesson.getCreateTime());
        dto.setEndTime(lesson.getEndTime());
        dto.setLessonId(lesson.getId());
        dto.setIndex(lesson.getNumber());
        dto.setRoomId(lesson.getRoomId());
        if (classRoom != null) {
            dto.setRoomName(classRoom.getRoomName());
        }
        dto.setStartTime(lesson.getStartTime());
        dto.setUpdateTime(lesson.getUpdateTime());
        dto.setTeacherId(teacherId);
        dto.setTeacherName(teacherName);
        return dto;
    }

    private ListLessonResponseDto buildListLessonResponseDto(List<OrgClassLesson> lessons, Map<Long, OrgCourse> courseMap, Map<Long, String> lessonIdTeacherNameMap, Map<Long, OrgClassRoom> classRoomMap, Map<Long, Integer> studentCountMap, Map<Long, Integer> signStudentCountMap, Map<Long, Integer> commentCount, Map<Long, Integer> lessonSignStatus) {
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Date now = new Date();
            for (OrgClassLesson lesson : lessons) {
                if (result.getFirstLessonStartTime() == null || result.getFirstLessonStartTime().after(lesson.getStartTime())) {
                    result.setFirstLessonStartTime(lesson.getStartTime());
                }
                if (result.getLastLessonStartTime() == null || result.getLastLessonStartTime().before(lesson.getStartTime())) {
                    result.setLastLessonStartTime(lesson.getStartTime());
                }
                LessonResponseDto dto = new LessonResponseDto();
                dto.setCourseId(lesson.getCourseId());
                dto.setIndex(lesson.getNumber());
                OrgCourse course = courseMap.get(lesson.getCourseId());
                if (course == null) continue;
                if (StringUtils.isNotBlank((CharSequence)course.getName())) {
                    dto.setCourseName(course.getName());
                }
                OrgClassRoom classRoom = classRoomMap.get(lesson.getRoomId());
                dto.setRoomId(lesson.getRoomId());
                if (classRoom != null) {
                    dto.setRoomName(classRoom.getRoomName());
                }
                dto.setTeacherName(lessonIdTeacherNameMap.get(lesson.getId()));
                dto.setLessonEndTime(lesson.getEndTime());
                dto.setLessonId(lesson.getId());
                dto.setLessonStartTime(lesson.getStartTime());
                CourseSignStatus signStatus = CourseSignStatus.HAS_NOT_STARTED;
                if (now.after(lesson.getEndTime())) {
                    signStatus = CourseSignStatus.NO_SIGN;
                    dto.setIsOver(1);
                }
                if (now.after(lesson.getStartTime()) && now.before(lesson.getEndTime())) {
                    signStatus = CourseSignStatus.SIGNING;
                }
                Integer signCount = signStudentCountMap.get(lesson.getId());
                SignStatus stuSignStatus = SignStatus.getSignStatusByCode((Integer)lessonSignStatus.get(lesson.getId()));
                if (stuSignStatus != null) {
                    log.debug("lessonId:{},lessonSignStatus:{},status:{}", new Object[]{lesson.getId(), lessonSignStatus, stuSignStatus});
                    dto.setSignStatusEnum(stuSignStatus);
                } else {
                    dto.setCourseSignStatusEnum(signStatus);
                }
                Integer commentCnt = commentCount.get(lesson.getId());
                if (commentCnt != null && commentCnt > 0) {
                    dto.setCommentEnum(CommentStatus.COMMENTED);
                } else {
                    dto.setCommentEnum(CommentStatus.getCommentStatusByTime((Date)lesson.getStartTime(), (Date)lesson.getEndTime(), (boolean)true));
                }
                Integer studentCount = studentCountMap.get(lesson.getId());
                dto.setSignCount(signCount != null ? signCount : 0);
                dto.setStudentCount(studentCount != null ? studentCount : 0);
                result.getList().add(dto);
            }
        }
        return result;
    }

    private Map<Long, Long> queryLessonIdByTeacherId(Long orgId, Collection<Long> teacherIds) {
        if (CollectionUtils.isEmpty(teacherIds)) {
            return Collections.emptyMap();
        }
        List teacherLessons = this.orgTeacherLessonDao.queryTeacherLessons(orgId, teacherIds, new String[]{"lessonId", "teacherId"});
        if (CollectionUtils.isNotEmpty((Collection)teacherLessons)) {
            HashMap<Long, Long> result = new HashMap<Long, Long>();
            for (OrgTeacherLesson orgTeacherLesson : teacherLessons) {
                result.put(orgTeacherLesson.getLessonId(), orgTeacherLesson.getTeacherId());
            }
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    @Transactional(readOnly=true)
    public LessonTimeTableResponseDto lessonInfo(Long orgId, Long lessonId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        Date now = new Date();
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", (Object)lessonId, (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        }
        LessonTimeTableResponseDto dto = new LessonTimeTableResponseDto();
        OrgCourse course = this.orgCourseDao.getByCourseId(lesson.getCourseId(), new String[]{"id", "name", "color"});
        if (course == null) {
            log.warn("can not found course by lesson:{}", (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u73ed\u7ea7");
        }
        dto.setCourseColor(course.getColor());
        dto.setCourseId(course.getId());
        dto.setCourseName(course.getName());
        dto.setCreateTime(lesson.getCreateTime());
        dto.setEndTime(lesson.getEndTime());
        dto.setIndex(lesson.getNumber());
        dto.setLessonId(lesson.getId());
        CourseSignStatus signStatus = CourseSignStatus.HAS_NOT_STARTED;
        if (now.after(lesson.getStartTime())) {
            signStatus = CourseSignStatus.NO_SIGN;
            if (now.before(lesson.getEndTime())) {
                signStatus = CourseSignStatus.SIGNING;
            }
        }
        dto.setRoomId(lesson.getRoomId());
        dto.setSignStatusEnum(signStatus);
        dto.setStartTime(lesson.getStartTime());
        dto.setUpdateTime(lesson.getUpdateTime());
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public LessonTimeTableResponseDto lessonDetail(Long orgId, Long lessonId, boolean needStudentSign) {
        LessonTimeTableResponseDto dto = this.lessonInfo(orgId, lessonId);
        dto.setStudents(this.courseStudentService.getLessonStudent(orgId, lessonId, needStudentSign));
        for (OrgStudentsChooseListDto student : dto.getStudents()) {
            if (student.getSignStatus() == null || SignStatus.SIGNED.getCode() != student.getSignStatus().intValue()) continue;
            dto.increaseSignStudent();
        }
        List teacherDtos = this.courseTeacherService.getLessonTeacher(orgId, lessonId);
        if (CollectionUtils.isNotEmpty((Collection)teacherDtos)) {
            TeacherResponseDto teacherDto = (TeacherResponseDto)teacherDtos.get(0);
            dto.setTeacherId(teacherDto.getTeacherId());
            dto.setTeacherName(teacherDto.getTeacherName());
        }
        if (dto.getRoomId() != null && dto.getRoomId() > 0L) {
            OrgClassRoom classRoom = (OrgClassRoom)this.orgClassRoomDao.getById((Serializable)dto.getRoomId(), new String[]{"id", "roomName"});
            dto.setRoomName(classRoom.getRoomName());
        }
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delLesson(Long orgId, Long lessonId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", (Object)lessonId, (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        }
        if (CollectionUtils.isNotEmpty((Collection)this.orgLessonCommentDao.getLessonComments(lessonId, null, null, new String[]{"id"}))) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.LESSON_WITH_COMMENT);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.orgLessonSignDao.getLessonSignList(orgId, null, lessonId, null, null, null, null, null, new String[]{"id"}))) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.LESSON_WITH_SIGN);
        }
        this.courseStudentService.deleteStudentFromLesson(orgId, lessonId, null);
        this.courseTeacherService.delTeacherFromLesson(orgId, lessonId, null);
        this.orgClassLessonDao.delById((Serializable)lessonId);
        this.resetLessonNumber(orgId, lesson.getCourseId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editLesson(Long orgId, EditLessonRequestDto editDto) {
        Preconditions.checkNotNull((Object)editDto, (Object)"param can not be null");
        editDto.validate();
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)editDto.getLessonId(), new String[0]);
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", (Object)editDto.getLessonId(), (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        }
        lesson.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        boolean needRearrange = false;
        if (!editDto.getEndTime().equals(lesson.getEndTime()) || !editDto.getStartTime().equals(lesson.getStartTime())) {
            lesson.setEndTime(editDto.getEndTime());
            lesson.setStartTime(editDto.getStartTime());
            needRearrange = true;
        }
        List teacherIds = Lists.newArrayList();
        if (editDto.getRoomId() == null) {
            editDto.setRoomId(0L);
        }
        if (editDto.getTeacherId() == null) {
            editDto.setTeacherId(0L);
        } else {
            teacherIds.add(editDto.getTeacherId());
        }
        lesson.setRoomId(editDto.getRoomId());
        lesson.setUpdateTime(new Date());
        this.orgClassLessonDao.update((Object)lesson, new String[0]);
        if (needRearrange) {
            this.resetLessonNumber(orgId, lesson.getCourseId());
        }
        HashSet roomIds = Sets.newHashSet();
        roomIds.add(editDto.getRoomId() != null ? editDto.getRoomId() : 0L);
        this.classRoomService.addClassRoomCourse(Long.valueOf(orgId), lesson.getCourseId(), (Collection)roomIds);
        this.courseTeacherService.resetLessonTeacher(orgId, lesson.getCourseId(), lesson.getId(), (Collection)teacherIds);
    }

    private void resetLessonNumber(Long orgId, Long courseId) {
        List lessons = this.orgClassLessonDao.queryLessons(orgId, (Collection)Lists.newArrayList((Object[])new Long[]{courseId}), null, null, null, null, null, new String[]{"id"});
        if (CollectionUtils.isNotEmpty((Collection)lessons)) {
            int index = 1;
            Map[] params = new Map[lessons.size()];
            for (OrgClassLesson lesson : lessons) {
                HashMap<String, Number> param = new HashMap<String, Number>();
                param.put("id", lesson.getId());
                param.put("number", index);
                params[index - 1] = param;
                ++index;
            }
            this.orgClassLessonDao.batchUpdateLessonNumber(params);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Long getTeacherId(Long orgId, Long lessonId) {
        OrgTeacherLesson teacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lessonId);
        if (teacherLesson != null) {
            return teacherLesson.getTeacherId();
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Long> getLessonStudentUserIds(Long orgId, Collection<Long> lessonIds) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Lists.newArrayList();
        }
        return this.orgStudentLessonDao.getUserIdsByLessonIds(orgId, lessonIds);
    }

    @Override
    public void export(HttpServletResponse response, Long orgId, ListLessonsRequestDto param, List<LessonTimeTableResponseDto> dtoList) {
        Preconditions.checkArgument((param.getStartTime() != null ? 1 : 0) != 0, (Object)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((param.getEndTime() != null ? 1 : 0) != 0, (Object)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        String orgName = this.orgInfoDao.getOrgShortNameByOrgId(Integer.valueOf(orgId.intValue()));
        String startTimeStr = TianXiaoConstant.DAY_FORMAT.format(param.getStartTime());
        String endTimeStr = TianXiaoConstant.DAY_FORMAT.format(param.getEndTime());
        String fileName = orgName + "-\u8bfe\u8868\u7edf\u8ba1-" + startTimeStr + "~" + endTimeStr + ".xlsx";
        SXSSFWorkbook workbook = null;
        List dates = DateUtil.getDateBetween((Date)param.getStartTime(), (Date)param.getEndTime());
        try {
            workbook = new SXSSFWorkbook(200);
            HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>();
            List summaryFields = Lists.newArrayList();
            summaryFields.add(new ExportField(" ", "@", 5620));
            for (Date date : dates) {
                summaryFields.add(new ExportField("\u5468" + DateUtil.getChineseWeekDay((Date)date) + "(" + DateUtil.getDayStr((Date)date) + ")", "@", 5120));
            }
            List titles = Lists.newArrayList();
            titles.add(startTimeStr + "~" + endTimeStr + "\u8bfe\u8868\u7edf\u8ba1");
            ExcelCourseExportService.createSheet((Workbook)workbook, "\u8bfe\u8868\u7edf\u8ba1", titles, cellStyleMap, summaryFields, dtoList, param.getStartTime());
            ExcelCourseExportService.exportExcel(response, (Workbook)workbook, fileName);
            log.debug("course lesson export success");
        }
        catch (Exception var20) {
            log.error("export catch exception:", (Throwable)var20);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u6570\u636e\u5904\u7406\u5f02\u5e38");
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException var19) {
                log.error("close workbook catch error:", (Throwable)var19);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        String json = FileUtils.readFileToString((File)new File("/Users/wengshengli/Downloads/response.json"));
        List dtoList = JacksonUtil.str2List((String)json, LessonTimeTableResponseDto.class);
        Date startDate = new Date(1465747200682L);
        Date endDate = new Date(1466351999682L);
        System.out.println(DateUtil.getDateDiff((Date)startDate, (Date)endDate));
        List dates = DateUtil.getDateBetween((Date)startDate, (Date)endDate);
        SXSSFWorkbook workbook = new SXSSFWorkbook(200);
        HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>();
        List summaryFields = Lists.newArrayList();
        summaryFields.add(new ExportField("", "@", 5620));
        for (Date date : dates) {
            summaryFields.add(new ExportField("\u5468" + DateUtil.getChineseWeekDay((Date)date) + "(" + DateUtil.getDayStr((Date)date) + ")", "@", 5120));
        }
        List titles = Lists.newArrayList();
        titles.add("\u8bfe\u8282\u6c47\u603b\u8868");
        ExcelCourseExportService.createSheet((Workbook)workbook, "\u8bfe\u8282\u6c47\u603b", titles, cellStyleMap, summaryFields, dtoList, startDate);
        File excelFile = new File("/Users/wengshengli/Documents/test1.xlsx");
        workbook.write((OutputStream)new FileOutputStream(excelFile));
    }

    @Override
    public HeaderDto getHeaderInfo() {
        HeaderDto dto = new HeaderDto();
        Integer txCascadeAccountId = TianxiaoMContext.getTXCascadeId();
        if (txCascadeAccountId == null) {
            return dto;
        }
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(TianxiaoMContext.getOrgId().intValue(), new String[0]);
        if (orgAccount == null) {
            log.info("orgAccount doesn't exist! orgAccountId:{}", (Object)TianxiaoMContext.getOrgId());
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u60a8\u65e0\u6743\u4f7f\u7528\u6b64\u529f\u80fd");
        }
        TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)txCascadeAccountId, new String[0]);
        if (txCascadeAccount == null) {
            log.info("txCascadeAccount doesn't exist! txCascadeAccountId:{}", (Object)txCascadeAccountId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u60a8\u65e0\u6743\u4f7f\u7528\u6b64\u529f\u80fd");
        }
        List courseIds = Lists.newArrayList();
        Integer notSignCount = 0;
        if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue() && CollectionUtils.isNotEmpty((Collection)(courseIds = this.orgCourseDao.getCourseIdsByCascadeId(txCascadeAccountId)))) {
            notSignCount = this.orgClassLessonDao.getLessonCount(orgAccount.getId(), courseIds, new Date());
        }
        if (txCascadeAccount.getAccountType().intValue() == CascadeType.MANAGER.getValue()) {
            notSignCount = this.orgClassLessonDao.getLessonCount(orgAccount.getId(), courseIds, new Date());
            courseIds = this.orgCourseDao.getCourseIds(Long.valueOf(orgAccount.getNumber().longValue()), null);
        }
        Integer totalCount = courseIds.size();
        dto.setClassCount(totalCount);
        dto.setSignCount(notSignCount);
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public ListLessonResponseDto queryCourseLessons(Long orgId, ListLessonsRequestDto params) {
        HashMap<Long, Long> lessonIdTeacherIdMap = new HashMap<Long, Long>();
        List<OrgClassLesson> lessons = this.queryLesson(orgId, lessonIdTeacherIdMap, params, true);
        ArrayList<Long> courseIds = new ArrayList<Long>();
        HashSet roomIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Collections.sort(lessons, new Comparator<OrgClassLesson>(){

                @Override
                public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                    return o1.getNumber().compareTo(o2.getNumber());
                }
            });
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }
            Map<Long, OrgCourse> courseMap = this.getOrgCourseMap(orgId, courseIds);
            Map studentCountMap = this.orgStudentLessonDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
            Map signStudentCountMap = Maps.newHashMap();
            if (!params.isNeedStudentSignStatus() && params.isNeedSignInfo()) {
                signStudentCountMap = this.orgLessonSignDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
            }
            Map commentCount = Maps.newHashMap();
            Map lessonSignStatus = Maps.newHashMap();
            if (params.isNeedStudentSignStatus()) {
                Preconditions.checkArgument((params.getStudentId() != null && params.getStudentId() > 0L ? 1 : 0) != 0, (Object)"\u5b66\u751fID\u4e0d\u6b63\u786e");
                Long userId = this.orgStudentDao.getUserId(params.getStudentId());
                commentCount = this.orgLessonCommentDao.getLessonCommentCountMap((Collection)lessonIds, orgId, userId, null, Integer.valueOf(UserRole.STUDENT.getRole()), Boolean.valueOf(false));
                List lessonSign = this.orgLessonSignDao.getStudentSign(orgId, userId, Integer.valueOf(UserRole.STUDENT.getRole()), (Collection)lessonIds, new String[]{"lessonId", "status"});
                if (CollectionUtils.isNotEmpty((Collection)lessonSign)) {
                    lessonSignStatus = CollectorUtil.collectMap((Collection)lessonSign, (Function)new Function<OrgLessonSign, Long>(){

                        public Long apply(OrgLessonSign input) {
                            return input.getLessonId();
                        }
                    }, (Function)new Function<OrgLessonSign, Integer>(){

                        public Integer apply(OrgLessonSign input) {
                            return input.getStatus();
                        }
                    });
                    log.debug("student lesson sign:{}", (Object)lessonSignStatus);
                }
            }
            HashMap lessonIdTeacherNameMap = Maps.newHashMap();
            HashMap classRoomMap = Maps.newHashMap();
            result = this.buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap, studentCountMap, signStudentCountMap, commentCount, lessonSignStatus);
            Date now = new Date();
            int lastRow = result.getList().size() - 1;
            result.setNewLessonId(result.getList().get(lastRow).getLessonId());
            for (LessonResponseDto lesson : result.getList()) {
                if (!now.before(lesson.getLessonEndTime())) continue;
                result.setNewLessonId(lesson.getLessonId());
                break;
            }
        } else {
            result.setFirstLessonStartTime(params.getFirstLessonStartTime());
            result.setLastLessonStartTime(params.getLastLessonStartTime());
            if (params.getFirstLessonStartTime() == null && params.getLastLessonStartTime() == null) {
                result.setFirstLessonStartTime(DateUtil.getCurrentDate());
            }
        }
        return result;
    }

    @Override
    @Transactional
    public void batchOperateLesson(Long orgId, Long courseId, List<Long> lessonIds, BatchOperateType operateType, String targetId) {
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            if (operateType == BatchOperateType.del_lesson) {
                this.delLesson(orgId, courseId, lessonIds, targetId);
            } else if (operateType == BatchOperateType.add_student) {
                this.addStudent(orgId, courseId, lessonIds, targetId);
            } else if (operateType == BatchOperateType.del_student) {
                this.delStudent(orgId, courseId, lessonIds, targetId);
            } else if (operateType == BatchOperateType.change_teacher) {
                this.changeTeacher(orgId, courseId, lessonIds, targetId);
            } else if (operateType == BatchOperateType.change_classroom) {
                this.changeClassroom(orgId, courseId, lessonIds, targetId);
            } else if (operateType == BatchOperateType.change_time) {
                this.changeTime(orgId, courseId, lessonIds, targetId);
            }
        }
    }

    private void delLesson(Long orgId, Long courseId, List<Long> lessonIds, String targetId) {
        Map signCountMap = this.orgLessonSignDao.queryLessonStudentCountMap(orgId, lessonIds);
        for (Long lessonId : lessonIds) {
            Integer tempCount = (Integer)signCountMap.get(lessonId);
            if (tempCount == null || tempCount <= 0) continue;
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u7a0b\u5df2\u7b7e\u5230\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.orgClassLessonDao.delByIds(lessonIds);
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonIds);
        this.orgStudentLessonDao.delByCondition((Map)condition);
        HashMap<String, List<Long>> delCondition = new HashMap<String, List<Long>>();
        delCondition.put("lessonId", lessonIds);
        this.orgTeacherLessonDao.delByCondition(delCondition);
        this.resetLessonNumber(orgId, courseId);
    }

    private void addStudent(Long orgId, Long courseId, List<Long> lessonIds, String targetId) {
        ArrayList studentIds = null;
        try {
            studentIds = (ArrayList)JacksonUtil.str2Obj((String)targetId, (TypeReference)new TypeReference<List<Long>>(){});
        }
        catch (Exception e1) {
            log.warn("json class cast exception");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u8f6c\u6362\u4e00\u573a");
        }
        if (CollectionUtils.isEmpty((Collection)studentIds)) {
            log.warn("add student ids is empty");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u4e3a\u7a7a");
        }
        Map userIdMap = this.orgStudentDao.getStudentIdUserIdMap((Collection)studentIds);
        if (MapUtils.isEmpty((Map)userIdMap)) {
            log.warn("add student ids is empty");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u4e3a\u7a7a");
        }
        studentIds = new ArrayList(userIdMap.values());
        List courseStudents = this.orgStudentCourseDao.getStudents(orgId, courseId, Integer.valueOf(0));
        if (!courseStudents.containsAll(studentIds)) {
            studentIds.retainAll(courseStudents);
            log.warn("lesson studeng:{} is not all course student ids:{}", studentIds, (Object)courseStudents);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5fc5\u987b\u4ece\u8bfe\u7a0b\u5b66\u751f\u4e2d\u6dfb\u52a0\u8bfe\u8282\u5b66\u751f");
        }
        Map lessonStudentIds = this.orgStudentLessonDao.getLessonStudentList(lessonIds);
        log.info("check orgStudentLessonDao.getLessonStudentList(lessonIds):{},result={}", lessonIds, (Object)lessonStudentIds);
        List saveStudentLessons = Lists.newArrayList();
        for (Long lessonId : lessonIds) {
            List addedStuIds;
            ArrayList tempStudentIds = new ArrayList(studentIds);
            if (lessonStudentIds.containsKey(lessonId) && CollectionUtils.isNotEmpty((Collection)(addedStuIds = (List)lessonStudentIds.get(lessonId)))) {
                tempStudentIds.removeAll(addedStuIds);
            }
            OrgStudentLesson po = null;
            for (Long studentId : tempStudentIds) {
                po = new OrgStudentLesson();
                po.setCreateTime(new Date());
                po.setLessonId(lessonId);
                po.setOrgId(orgId);
                po.setUserId(studentId);
                saveStudentLessons.add(po);
            }
        }
        log.info("save students :{} to lessonid:{}", (Object)saveStudentLessons, lessonIds);
        this.orgStudentLessonDao.saveAll(saveStudentLessons, new String[]{"createTime", "lessonId", "orgId", "userId"});
    }

    private int delStudent(Long orgId, Long courseId, List<Long> lessonIds, String targetId) {
        ArrayList studentIds = null;
        try {
            studentIds = (ArrayList)JacksonUtil.str2Obj((String)targetId, (TypeReference)new TypeReference<List<Long>>(){});
        }
        catch (Exception e1) {
            log.warn("json class cast exception");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u8f6c\u6362\u4e00\u573a");
        }
        if (CollectionUtils.isEmpty((Collection)studentIds)) {
            log.warn("add student ids is empty");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u4e3a\u7a7a");
        }
        Map userIdMap = this.orgStudentDao.getStudentIdUserIdMap((Collection)studentIds);
        if (MapUtils.isEmpty((Map)userIdMap)) {
            log.warn("add student ids is empty");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u4e3a\u7a7a");
        }
        studentIds = new ArrayList(userIdMap.values());
        List courseStudents = this.orgStudentCourseDao.getStudents(orgId, courseId, Integer.valueOf(0));
        if (!courseStudents.containsAll(studentIds)) {
            log.warn("lesson teacher:{} is not all course teacher ids:{}", studentIds, (Object)courseStudents);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5fc5\u987b\u4ece\u8bfe\u7a0b\u5b66\u751f\u4e2d\u5220\u9664\u8bfe\u8282\u5b66\u751f");
        }
        HashMap<String, Object> countCondition = new HashMap<String, Object>();
        countCondition.put("orgId", orgId);
        countCondition.put("courseId", courseId);
        countCondition.put("lessonId", lessonIds);
        countCondition.put("userId", studentIds);
        countCondition.put("status", SignStatus.SIGNED.getCode());
        countCondition.put("userRole", UserRoleEnum.STUDENT.getCode());
        int count = this.orgLessonSignDao.countByCondition(countCondition, "userId", false);
        if (count > 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5df2\u7ecf\u7b7e\u5230\u7684\u5b66\u751f\u4e0d\u80fd\u5220\u9664");
        }
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonIds);
        condition.put("userId", studentIds);
        return this.orgStudentLessonDao.delByCondition((Map)condition);
    }

    private void changeTeacher(Long orgId, Long courseId, List<Long> lessonIds, String targetId) {
        Long teacherId = Long.valueOf(targetId);
        HashMap<String, List<Long>> delCondition = new HashMap<String, List<Long>>();
        delCondition.put("lessonId", lessonIds);
        int result = this.orgTeacherLessonDao.delByCondition(delCondition);
        log.info("del from org teacher lesson by lessonId:{},result:{}", lessonIds, (Object)result);
        List saveLessonTeachers = Lists.newArrayList();
        OrgTeacherLesson po = null;
        for (Long lessonId : lessonIds) {
            po = new OrgTeacherLesson();
            po.setCreateTime(new Date());
            po.setLessonId(lessonId);
            po.setOrgId(orgId);
            po.setTeacherId(teacherId);
            saveLessonTeachers.add(po);
        }
        log.info("save teachers :{} to lessonId:{}", (Object)saveLessonTeachers, lessonIds);
        this.orgTeacherLessonDao.saveAll(saveLessonTeachers, new String[]{"createTime", "lessonId", "orgId", "teacherId"});
        List courseTeachers = this.orgCourseTeacherDao.getTeacher(orgId, courseId);
        HashSet userIds = Sets.newHashSet();
        for (OrgCourseTeacher courseTeacher : courseTeachers) {
            userIds.add(courseTeacher.getUserId());
        }
        if (!userIds.contains(teacherId)) {
            ArrayList<Long> teacherIds = new ArrayList<Long>();
            teacherIds.add(teacherId);
            this.courseTeacherService.addTeacherToCourse(orgId, courseId, teacherIds);
        }
    }

    private void changeClassroom(Long orgId, Long courseId, List<Long> lessonIds, String targetId) {
        Long roomId = Long.valueOf(targetId);
        this.orgClassLessonDao.updateLessonClassRoom(orgId, lessonIds, roomId);
        List roomList = this.classRoomService.listOrgCourseRooms(orgId, courseId);
        ArrayList<Long> currentRoomIds = new ArrayList<Long>();
        for (ClassRoomDto dto : roomList) {
            currentRoomIds.add(dto.getRoomId());
        }
        if (!currentRoomIds.contains(roomId)) {
            ArrayList<Long> newCourseIds = new ArrayList<Long>();
            newCourseIds.add(roomId);
            this.classRoomService.addClassRoomCourse(orgId, courseId, newCourseIds);
        }
    }

    private void changeTime(Long orgId, Long courseId, List<Long> lessonIds, String targetId) {
        String[] time = targetId.split(",");
        String startTimeStr = time[0];
        String endTimeStr = time[1];
        TimeStamp startTime = TimeStamp.parse((String)startTimeStr);
        TimeStamp endTime = TimeStamp.parse((String)endTimeStr);
        List list = this.orgClassLessonDao.getByIds(lessonIds, new String[0]);
        for (OrgClassLesson lesson : list) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(lesson.getStartTime());
            LessonTime lessonTime = new LessonTime(cal, startTime, endTime);
            HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>();
            map.put("id", lesson.getId());
            map.put("startTime", lessonTime.getStartTime());
            map.put("endTime", lessonTime.getEndTime());
            this.orgClassLessonDao.update(map, new String[]{"startTime", "endTime"});
        }
    }
}

