/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.service.impl;

import com.baijia.tianxiao.biz.dashboard.constants.StatPageType;
import com.baijia.tianxiao.biz.dashboard.dto.MarkingOrg;
import com.baijia.tianxiao.biz.dashboard.dto.MarkingUser;
import com.baijia.tianxiao.biz.dashboard.service.MarkingMsgService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.course.dao.TeacherClassCourseDao;
import com.baijia.tianxiao.dal.course.dao.TeacherCourseDao;
import com.baijia.tianxiao.dal.course.dao.VideoCourseDao;
import com.baijia.tianxiao.dal.course.po.TeacherClassCourse;
import com.baijia.tianxiao.dal.course.po.TeacherCourse;
import com.baijia.tianxiao.dal.course.po.VideoCourse;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.constant.IntentionLevel;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MarkingMsgServiceImpl
implements MarkingMsgService {
    private static final Logger log = LoggerFactory.getLogger(MarkingMsgServiceImpl.class);
    @Resource
    private ConsultMessageService consultMessageService;
    @Resource
    private OrgAccountService orgAccountService;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private VideoCourseDao videoCourseDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private TxConsultUserDao consultUserDao;
    @Resource
    private UserDao userDao;
    @Resource
    private StudentDao studentDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private TeacherClassCourseDao teacherClassCourseDao;
    @Resource
    private TeacherCourseDao teacherCourseDao;
    @Autowired
    private ConsulterAPIService consulterAPIService;

    @Override
    public boolean sendMessage(Long orgNumber, long userNumber, int pageType, long typeNumber) {
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(Integer.valueOf(orgNumber.intValue()));
        if (orgAccount == null) {
            return false;
        }
        MsgUser sender = this.builderSender(orgAccount.getId().longValue(), userNumber);
        MsgUser receiver = this.buildReceiver(orgAccount.getId().longValue(), orgNumber);
        if (sender == null || receiver == null) {
            log.warn("sender :{} or receiver:{} is null,skip marking  msg:{}", (Object)sender, (Object)receiver);
            return false;
        }
        ConsultMessage msgContent = this.buildPushMessageContent(sender, pageType, typeNumber);
        log.info("send marking msg sender:{},receiver:{},msgContent:{}", new Object[]{sender.getName(), receiver, msgContent});
        boolean result = this.consultMessageService.sendConsultMessage(sender, receiver, msgContent);
        log.info("send marking msg msg:{},sender:{},receiver:{},result:{}", new Object[]{msgContent, sender, receiver, result});
        return true;
    }

    private MsgUser builderSender(Long orgId, Long userNumber) {
        User user = this.userDao.getByNumber(userNumber, new String[0]);
        if (user == null) {
            return null;
        }
        String userName = "";
        long consultId = -1L;
        Student student = this.studentDao.getByUserId(user.getId(), new String[0]);
        if (student != null) {
            userName = student.getRealName();
        }
        List consultUsers = this.consultUserDao.lookByUserId(orgId, student.getUserId(), new String[0]);
        log.info("txbug== builderSender look orgId ={},userId = {}, txConsutUser ==={}", new Object[]{orgId, student.getUserId(), consultUsers});
        if (CollectionUtils.isNotEmpty((Collection)consultUsers)) {
            userName = ((TxConsultUser)consultUsers.get(0)).getName();
            consultId = ((TxConsultUser)consultUsers.get(0)).getId();
        } else {
            TxConsultUser txConsultUser = new TxConsultUser();
            txConsultUser.setName(student.getRealName());
            txConsultUser.setMobile(user.getMobile());
            txConsultUser.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
            txConsultUser.setConsultSource(Integer.valueOf(MessageSource.MARKING.getValue()));
            txConsultUser.setIntensionLevel(Integer.valueOf(IntentionLevel.LEVEL_2.getValue()));
            txConsultUser.setCascadeId(Long.valueOf(-1L));
            this.consulterAPIService.saveConsultUser(txConsultUser);
            userName = txConsultUser.getName();
            consultId = txConsultUser.getId();
        }
        if (StringUtils.isBlank((CharSequence)userName)) {
            userName = "\u533f\u540d\u7528\u6237";
        }
        return this.buildToMsgUser(consultId, userName, userNumber);
    }

    private MsgUser buildReceiver(Long orgId, Long orgNumber) {
        return new MarkingOrg(orgId, orgNumber);
    }

    private ConsultMessage buildPushMessageContent(MsgUser sender, int pageType, long typeNumber) {
        StringBuilder desc = new StringBuilder();
        desc.append("[").append(sender.getName()).append("]");
        desc.append("\u67e5\u770b\u4e86");
        if (pageType == StatPageType.WEI_COURSE.getCode()) {
            OrgCourse orgCourse = this.orgCourseDao.getByCourseNumber(Long.valueOf(typeNumber), new String[0]);
            if (orgCourse == null) {
                return null;
            }
            desc.append(StatPageType.WEI_COURSE.getName());
            desc.append("\u3010");
            desc.append(orgCourse.getName());
            desc.append("\u3011");
        } else if (pageType == StatPageType.VIDEO_COURSE.getCode()) {
            VideoCourse videoCourse = this.videoCourseDao.getByNumber(typeNumber);
            if (videoCourse == null) {
                return null;
            }
            desc.append(StatPageType.VIDEO_COURSE.getName());
            desc.append("\u3010");
            desc.append(videoCourse.getName());
            desc.append("\u3011");
        } else if (pageType == StatPageType.ORG_TEACHER_DETAIL.getCode()) {
            Teacher teacher = this.teacherDao.getByNumber(Long.valueOf(typeNumber), new String[0]);
            if (teacher == null) {
                return null;
            }
            desc.append(StatPageType.ORG_TEACHER.getName());
            desc.append("\u3010");
            desc.append(teacher.getRealName());
            desc.append("\u3011");
        } else if (pageType == StatPageType.CLASS_COURSE.getCode()) {
            TeacherClassCourse teacherClassCourse = this.teacherClassCourseDao.getByCouseNumber(Long.valueOf(typeNumber));
            if (teacherClassCourse == null) {
                return null;
            }
            desc.append(StatPageType.CLASS_COURSE.getName());
            desc.append("\u3010");
            desc.append(teacherClassCourse.getName());
            desc.append("\u3011");
        } else if (pageType == StatPageType.ONEONE_COURSE.getCode()) {
            TeacherCourse teacherCourse = this.teacherCourseDao.getByCouseNumber(Long.valueOf(typeNumber));
            if (teacherCourse == null) {
                return null;
            }
            desc.append(StatPageType.ONEONE_COURSE.getName());
            desc.append("\u3010");
            desc.append(teacherCourse.getName());
            desc.append("\u3011");
        }
        ConsultMessage pushMsg = new ConsultMessage();
        pushMsg.setConsultType(MessageSource.MARKING.getValue());
        pushMsg.setCreateTime(new Date());
        pushMsg.setMsgType(MsgType.TEXT.getValue());
        pushMsg.setContent(desc.toString());
        return pushMsg;
    }

    private MsgUser buildToMsgUser(long consultId, String userName, long userNumber) {
        MarkingUser user = new MarkingUser();
        user.setUserId(consultId);
        user.setUserNumber(userNumber);
        user.setName(userName);
        return user;
    }
}

