/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.service.impl;

import com.baijia.tianxiao.biz.dashboard.constants.KexiaoRecordType;
import com.baijia.tianxiao.biz.dashboard.constants.OrderKey;
import com.baijia.tianxiao.biz.dashboard.constants.OrderType;
import com.baijia.tianxiao.biz.dashboard.constants.RankType;
import com.baijia.tianxiao.biz.dashboard.dto.FeeRecordDto;
import com.baijia.tianxiao.biz.dashboard.dto.OperationReportRequest;
import com.baijia.tianxiao.biz.dashboard.dto.OperationReportResponse;
import com.baijia.tianxiao.biz.dashboard.service.OperationReportService;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroup;
import com.baijia.tianxiao.dal.org.dao.OrgCourseKexiaoDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.StringUtils;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperationReportServiceImpl
implements OperationReportService {
    private static final Logger log = LoggerFactory.getLogger(OperationReportServiceImpl.class);
    @Autowired
    private OrgSubAccountService subAccountService;
    @Autowired
    private OrgStudentKexiaoRecordDao studentKexiaoRecordDao;
    @Autowired
    private OrgCourseKexiaoDao courseKexiaoDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgCourseGroupDao courseGroupDao;
    @Autowired
    private OrgCourseGroupRelateDao courseGroupRelateDao;

    @Override
    public List<OperationReportResponse> getOperationReport(OperationReportRequest paramDto) {
        Long orgId = TianxiaoPCContext.getOrgIdLong();
        paramDto.setIsMaster(this.subAccountService.isMasterAccount(orgId));
        boolean isMaster = paramDto.getIsMaster();
        List<Long> orgIds = paramDto.getOrgIds();
        List<Long> courseTypeIds = paramDto.getCourseTypeIds();
        int rankType = paramDto.getRankType();
        List<Object> data = new ArrayList();
        ArrayList<String> names = new ArrayList<String>();
        if (rankType == RankType.SCHOOL.getCode()) {
            if (isMaster) {
                if (CollectionUtils.isEmpty(orgIds)) {
                    orgIds = new ArrayList<Long>();
                    List subAccounts = this.subAccountService.getMasterandslavesOrgId(orgId);
                    Iterator iterator = subAccounts.iterator();
                    while (iterator.hasNext()) {
                        OrgSubAccount subAccount = (OrgSubAccount)iterator.next();
                        orgIds.add(subAccount.getOrgId().longValue());
                        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(subAccount.getOrgId(), new String[0]);
                        names.add(orgInfo.getShortName());
                    }
                } else {
                    for (Long _orgId : orgIds) {
                        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(_orgId.intValue()), new String[0]);
                        names.add(orgInfo.getShortName());
                    }
                }
            } else {
                orgIds = new ArrayList<Long>();
                orgIds.add(orgId);
                OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
                names.add(orgInfo.getShortName());
            }
            if (CollectionUtils.isEmpty(courseTypeIds)) {
                courseTypeIds = new ArrayList<Long>();
                List courseGroupIds = this.courseGroupDao.getOrgsCourseGroupList(orgIds);
                courseTypeIds.addAll(courseGroupIds);
            }
            paramDto.setOrgIds(orgIds);
            paramDto.setNames(names);
            paramDto.setCourseTypeIds(courseTypeIds);
            data = this.getSchoolData(paramDto);
        } else if (rankType == RankType.COURSETYPE.getCode()) {
            List courseGroups;
            if (isMaster) {
                orgIds = new ArrayList<Long>();
                List subAccounts = this.subAccountService.getMasterandslavesOrgId(orgId);
                for (OrgSubAccount subAccount : subAccounts) {
                    orgIds.add(subAccount.getOrgId().longValue());
                }
            } else {
                orgIds.add(orgId);
            }
            if (CollectionUtils.isEmpty(courseTypeIds)) {
                courseGroups = this.courseGroupDao.getBathCourseGroupList(orgIds);
                courseTypeIds = new ArrayList<Long>();
                for (OrgCourseGroup orgCourseGroup : courseGroups) {
                    courseTypeIds.add(orgCourseGroup.getId().longValue());
                    names.add(orgCourseGroup.getName());
                }
            } else {
                courseGroups = this.courseGroupDao.getByIds(courseTypeIds, new String[0]);
                for (OrgCourseGroup orgCourseGroup : courseGroups) {
                    names.add(orgCourseGroup.getName());
                }
            }
            paramDto.setOrgIds(orgIds);
            paramDto.setCourseTypeIds(courseTypeIds);
            paramDto.setNames(names);
            data = this.getCourseData(paramDto);
        } else {
            return null;
        }
        return data;
    }

    @Override
    public void importOldData() {
        this.courseKexiaoDao.deleteAll();
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(Integer.valueOf(0));
        pageDto.setPageSize(Integer.valueOf(1000));
        List courseKexiaos = this.studentKexiaoRecordDao.getRecordEveryday(KexiaoRecordType.COURSE.getCode(), pageDto);
        int pageNum = courseKexiaos.size();
        while (courseKexiaos.size() > 0) {
            pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
            courseKexiaos = this.studentKexiaoRecordDao.getRecordEveryday(KexiaoRecordType.COURSE.getCode(), pageDto);
            pageNum += courseKexiaos.size();
            this.courseKexiaoDao.saveAll(courseKexiaos, new String[0]);
        }
        log.info("\u5bfc\u5165\u8bfe\u7a0b\u6570\u636e{}", (Object)pageNum);
        pageDto.setPageNum(Integer.valueOf(0));
        List classKexiaos = this.studentKexiaoRecordDao.getRecordEveryday(KexiaoRecordType.CLASS.getCode(), pageDto);
        pageNum = classKexiaos.size();
        while (classKexiaos.size() > 0) {
            pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
            classKexiaos = this.studentKexiaoRecordDao.getRecordEveryday(KexiaoRecordType.CLASS.getCode(), pageDto);
            pageNum += classKexiaos.size();
            this.courseKexiaoDao.saveAll(classKexiaos, new String[0]);
        }
        log.info("\u5bfc\u5165\u73ed\u7ea7\u6570\u636e{}", (Object)pageNum);
    }

    @Override
    public void importData() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date start = calendar.getTime();
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.add(5, -1);
        calendarEnd.set(11, 23);
        calendarEnd.set(12, 59);
        calendarEnd.set(13, 59);
        calendarEnd.set(14, 999);
        Date end = calendarEnd.getTime();
        this.courseKexiaoDao.deleteByTime(start, end);
        List courseKexiaos = this.studentKexiaoRecordDao.getYesterdayRecord(KexiaoRecordType.COURSE.getCode(), start, end);
        this.courseKexiaoDao.saveAll(courseKexiaos, new String[0]);
        log.info("\u4fdd\u5b58\u8bfe\u7a0b\u6570\u636e{}", (Object)courseKexiaos.size());
        List classKexiaos = this.studentKexiaoRecordDao.getYesterdayRecord(KexiaoRecordType.CLASS.getCode(), start, end);
        this.courseKexiaoDao.saveAll(classKexiaos, new String[0]);
        log.info("\u4fdd\u5b58\u73ed\u7ea7\u6570\u636e{}", (Object)classKexiaos.size());
    }

    private List<OperationReportResponse> getSchoolData(OperationReportRequest paramDto) {
        ArrayList<OperationReportResponse> operationReportResponses = new ArrayList<OperationReportResponse>();
        List<Long> orgIds = paramDto.getOrgIds();
        List<String> names = paramDto.getNames();
        List<Long> courseTypeIds = paramDto.getCourseTypeIds();
        long start = paramDto.getStartTime();
        long end = paramDto.getEndTime();
        Date dateStart = new Date(start);
        Date dateEnd = new Date(end);
        int orderKey = paramDto.getOrderKey();
        int orderType = paramDto.getOrderType();
        for (int var = 0; var < orgIds.size(); ++var) {
            String name = names.get(var);
            OperationReportResponse operationReportResponse = new OperationReportResponse();
            long orgId = orgIds.get(var);
            operationReportResponse.setId(orgId);
            operationReportResponse.setName(name);
            long kexiao = this.getCourseKexiao(dateStart, dateEnd, courseTypeIds);
            double kexiaoYuan = (double)kexiao / 100.0;
            operationReportResponse.setIncome(kexiaoYuan);
            long cost = this.getCourseCost(courseTypeIds, orgId, start, end);
            double costYuan = (double)cost / 100.0;
            operationReportResponse.setCost(costYuan);
            double profit = kexiaoYuan - costYuan;
            operationReportResponse.setProfit(profit);
            List<Long> subjectIds = this.getFilterSubjectId();
            long subjectsCost = this.getCourseSubjectsCost(subjectIds, courseTypeIds, orgId, start, end);
            double subjectCostYuan = (double)subjectsCost / 100.0;
            double ebitda = kexiaoYuan - subjectCostYuan;
            operationReportResponse.setEbitda(ebitda);
            log.info("\u6536\u5165:{},\u6536\u8d39{},\u5229\u6da6{},EBITDA{}", new Object[]{kexiaoYuan, costYuan, profit, ebitda});
            operationReportResponses.add(operationReportResponse);
        }
        operationReportResponses.sort(this.getCompare(orderKey, orderType));
        return operationReportResponses;
    }

    private List<OperationReportResponse> getCourseData(OperationReportRequest paramDto) {
        ArrayList<OperationReportResponse> operationReportResponses = new ArrayList<OperationReportResponse>();
        List<Long> orgIds = paramDto.getOrgIds();
        List<String> names = paramDto.getNames();
        List<Long> courseTypeIds = paramDto.getCourseTypeIds();
        long start = paramDto.getStartTime();
        long end = paramDto.getEndTime();
        Date dateStart = new Date(start);
        Date dateEnd = new Date(end);
        int orderKey = paramDto.getOrderKey();
        int orderType = paramDto.getOrderType();
        for (int var = 0; var < courseTypeIds.size(); ++var) {
            String name = names.get(var);
            OperationReportResponse operationReportResponse = new OperationReportResponse();
            long courseTypeId = courseTypeIds.get(var);
            operationReportResponse.setId(courseTypeId);
            operationReportResponse.setName(name);
            double kexiao = this.getSchoolKexiao(dateStart, dateEnd, orgIds);
            double kexiaoYuan = kexiao / 100.0;
            operationReportResponse.setIncome(kexiaoYuan);
            long cost = this.getSchoolCost(courseTypeId, orgIds, start, end);
            double costYuan = (double)cost / 100.0;
            operationReportResponse.setCost(costYuan);
            double profit = kexiaoYuan - costYuan;
            operationReportResponse.setProfit(profit);
            List<Long> subjectIds = this.getFilterSubjectId();
            long subjectsCost = this.getSchoolSubjectsCost(subjectIds, courseTypeId, orgIds, start, end);
            double subjectCostYuan = (double)subjectsCost / 100.0;
            double ebitda = kexiaoYuan - subjectCostYuan;
            operationReportResponse.setEbitda(ebitda);
            log.info("\u6536\u5165:{},\u6536\u8d39{},\u5229\u6da6{},EBITDA{}", new Object[]{kexiaoYuan, costYuan, profit, ebitda});
            operationReportResponses.add(operationReportResponse);
        }
        operationReportResponses.sort(this.getCompare(orderKey, orderType));
        return operationReportResponses;
    }

    private long getCourseSubjectsCost(List<Long> subjectIds, List<Long> courseTypeIds, Long orgId, Long start, Long end) {
        long cost = 0L;
        String url = this.getSearchURL();
        for (Long courseTypeId : courseTypeIds) {
            HashMap param = Maps.newHashMap();
            param.put("courseTypeId", courseTypeId.toString());
            param.put("schoolId", orgId.toString());
            param.put("incrurreStartTime", start.toString());
            param.put("incurreEndTime", end.toString());
            for (Long subjectId : subjectIds) {
                param.put("subjectId", subjectId.toString());
                String responseStr = HttpClientUtils.doGet((String)url, (Map)param);
                List feeRecordDtos = null;
                try {
                    feeRecordDtos = JacksonUtil.str2List((String)responseStr, FeeRecordDto.class);
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
                long amount = 0L;
                for (FeeRecordDto feeRecordDto : feeRecordDtos) {
                    amount += feeRecordDto.getAmount().longValue();
                }
                cost += amount;
            }
        }
        return cost;
    }

    private long getSchoolSubjectsCost(List<Long> subjectIds, Long courseTypeId, List<Long> orgIds, Long start, Long end) {
        long cost = 0L;
        String url = this.getSearchURL();
        for (Long orgId : orgIds) {
            HashMap param = Maps.newHashMap();
            param.put("courseTypeId", courseTypeId.toString());
            param.put("schoolId", orgId.toString());
            param.put("incrurreStartTime", start.toString());
            param.put("incurreEndTime", end.toString());
            for (Long subjectId : subjectIds) {
                param.put("subjectId", subjectId.toString());
                String responseStr = HttpClientUtils.doGet((String)url, (Map)param);
                List feeRecordDtos = null;
                try {
                    feeRecordDtos = JacksonUtil.str2List((String)responseStr, FeeRecordDto.class);
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
                long amount = 0L;
                for (FeeRecordDto feeRecordDto : feeRecordDtos) {
                    amount += feeRecordDto.getAmount().longValue();
                }
                cost += amount;
            }
        }
        return cost;
    }

    private long getCourseCost(List<Long> courseTypeIds, Long orgId, Long start, Long end) {
        long cost = 0L;
        String url = this.getSearchURL();
        for (Long courseTypeId : courseTypeIds) {
            HashMap param = Maps.newHashMap();
            param.put("courseTypeId", courseTypeId.toString());
            param.put("schoolId", orgId.toString());
            param.put("createStartTime", start.toString());
            param.put("createEndTime", end.toString());
            String responseStr = HttpClientUtils.doGet((String)url, (Map)param);
            List feeRecordDtos = null;
            try {
                if (!StringUtils.isEmpty((String)responseStr)) {
                    feeRecordDtos = JacksonUtil.str2List((String)responseStr, FeeRecordDto.class);
                }
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            long amount = 0L;
            if (feeRecordDtos != null) {
                for (FeeRecordDto feeRecordDto : feeRecordDtos) {
                    amount += feeRecordDto.getAmount().longValue();
                }
            }
            cost += amount;
        }
        return cost;
    }

    private long getSchoolCost(Long courseTypeId, List<Long> orgIds, Long start, Long end) {
        long cost = 0L;
        String url = this.getSearchURL();
        for (Long orgId : orgIds) {
            HashMap param = Maps.newHashMap();
            param.put("courseTypeId", courseTypeId.toString());
            param.put("schoolId", orgId.toString());
            param.put("incrurreStartTime", start.toString());
            param.put("incurreEndTime", end.toString());
            String responseStr = HttpClientUtils.doGet((String)url, (Map)param);
            List feeRecordDtos = null;
            try {
                feeRecordDtos = JacksonUtil.str2List((String)responseStr, FeeRecordDto.class);
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            long amount = 0L;
            for (FeeRecordDto feeRecordDto : feeRecordDtos) {
                amount += feeRecordDto.getAmount().longValue();
            }
            cost += amount;
        }
        return cost;
    }

    private String getSearchURL() {
        String urlStr = PropertiesReader.getProperties((String)"fee.properties").getProperty("fee.url.search");
        return urlStr;
    }

    private List<Long> getFilterSubjectId() {
        String subjectStr = PropertiesReader.getProperties((String)"subjectfilter.properties").getProperty("fitersubject");
        String[] idStr = subjectStr.split(".");
        ArrayList<Long> ids = new ArrayList<Long>();
        for (String id : idStr) {
            ids.add(Long.parseLong(id));
        }
        return ids;
    }

    private long getSchoolKexiao(Date start, Date end, List<Long> orgIds) {
        return this.courseKexiaoDao.getSchoolIncome(start, end, orgIds);
    }

    private long getCourseKexiao(Date start, Date end, List<Long> courseTypeIds) {
        List courseIds = this.courseGroupRelateDao.getCourseIdsByGroupIds(courseTypeIds);
        log.info("\u7b26\u5408\u6761\u4ef6\u8bfe\u7a0b:{}", (Object)courseIds);
        return this.courseKexiaoDao.getIncome(start, end, courseIds);
    }

    private Comparator<OperationReportResponse> getCompare(final int orderKey, final int orderType) {
        return new Comparator<OperationReportResponse>(){

            @Override
            public int compare(OperationReportResponse o1, OperationReportResponse o2) {
                if (orderKey == OrderKey.INCOME.getCode()) {
                    if (orderType == OrderType.ASC.getCode()) {
                        return (int)(o1.getIncome() - o2.getIncome());
                    }
                    return (int)(o2.getIncome() - o1.getIncome());
                }
                if (orderKey == OrderKey.COST.getCode()) {
                    if (orderType == OrderType.ASC.getCode()) {
                        return (int)(o1.getCost() - o2.getCost());
                    }
                    return (int)(o2.getCost() - o1.getCost());
                }
                if (orderKey == OrderKey.PROFIT.getCode()) {
                    if (orderType == OrderType.ASC.getCode()) {
                        return (int)(o1.getProfit() - o2.getProfit());
                    }
                    return (int)(o2.getProfit() - o1.getProfit());
                }
                if (orderType == OrderType.ASC.getCode()) {
                    return (int)(o1.getEbitda() - o2.getEbitda());
                }
                return (int)(o2.getEbitda() - o1.getEbitda());
            }
        };
    }
}

