/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.sync.impl;

import com.baijia.tianxiao.biz.dashboard.constants.StatPageType;
import com.baijia.tianxiao.biz.dashboard.service.MonitorService;
import com.baijia.tianxiao.biz.dashboard.sync.SyncDataService;
import com.baijia.tianxiao.dal.course.dao.TeacherClassCourseDao;
import com.baijia.tianxiao.dal.course.dao.TeacherCourseDao;
import com.baijia.tianxiao.dal.course.dao.VideoCourseDao;
import com.baijia.tianxiao.dal.course.po.TeacherClassCourse;
import com.baijia.tianxiao.dal.course.po.TeacherCourse;
import com.baijia.tianxiao.dal.course.po.VideoCourse;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.sync.dao.TxMonitorCourseDayDao;
import com.baijia.tianxiao.dal.sync.dao.TxMonitorOrgDayDao;
import com.baijia.tianxiao.dal.sync.dao.TxMonitorTypeDayDao;
import com.baijia.tianxiao.dal.sync.po.TxMonitorCourseDay;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.statistics.TxMonitorTodayMinService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="syncMonitorDayService")
public class SyncMonitorDayServiceImpl
implements SyncDataService {
    private static final Logger log = LoggerFactory.getLogger(SyncMonitorDayServiceImpl.class);
    @Resource
    private MonitorService monitorService;
    @Resource
    private TxMonitorTodayMinService txMonitorTodayMinService;
    @Resource
    private TxMonitorTypeDayDao txMonitorTypeDayDao;
    @Resource
    private TxMonitorCourseDayDao txMonitorCourseDayDao;
    @Resource
    private TxMonitorOrgDayDao txMonitorOrgDayDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private VideoCourseDao videoCourseDao;
    @Resource
    private TeacherCourseDao teacherCourseDao;
    @Resource
    private TeacherClassCourseDao teacherClassCourseDao;

    @Override
    public void sync() {
        this.cleanRedisSendMsg();
        this.syncDbDay();
    }

    public void syncDbDay() {
        try {
            this.syncOrgPage();
            this.syncOrgType();
            this.syncOrgCourse();
            this.deleteTodayBase();
        }
        catch (Exception e) {
            log.warn("sync dbDay error ", (Throwable)e);
        }
    }

    public void cleanRedisSendMsg() {
        try {
            this.monitorService.cleanRedisMsg();
        }
        catch (Exception e) {
            log.warn("sync msg redis data errer {}", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.UNKNOW);
        }
    }

    private void syncOrgPage() {
        List orgDays = this.txMonitorTodayMinService.groupByOrgDay(null);
        log.info("syncOrgPage size is {}", (Object)orgDays.size());
        this.txMonitorOrgDayDao.saveAll(orgDays, new String[0]);
    }

    private void syncOrgType() {
        List typeDays = this.txMonitorTodayMinService.groupByTypeDay(null);
        log.info("syncOrgType size is {}", (Object)typeDays.size());
        this.txMonitorTypeDayDao.saveAll(typeDays, new String[0]);
    }

    private void syncOrgCourse() {
        List courseDays = this.txMonitorTodayMinService.groupByCourseDay(null, StatPageType.getCourseList());
        log.info("syncOrgCourse size is {}", (Object)courseDays.size());
        for (TxMonitorCourseDay one : courseDays) {
            VideoCourse videoCourse;
            if (one.getPageType().intValue() == StatPageType.WEI_COURSE.getCode()) {
                OrgCourse orgCourse = this.orgCourseDao.getByCourseNumber(one.getCourseNumber(), new String[0]);
                if (orgCourse != null) {
                    one.setCourseName(orgCourse.getName());
                }
            } else if (one.getPageType().intValue() == StatPageType.ONEONE_COURSE.getCode()) {
                TeacherCourse teacherCourse = this.teacherCourseDao.getByCouseNumber(one.getCourseNumber());
                if (teacherCourse != null) {
                    one.setCourseName(teacherCourse.getName());
                }
            } else if (one.getPageType().intValue() == StatPageType.CLASS_COURSE.getCode()) {
                TeacherClassCourse teacherClassCourse = this.teacherClassCourseDao.getByCouseNumber(one.getCourseNumber());
                if (teacherClassCourse != null) {
                    one.setCourseName(teacherClassCourse.getName());
                }
            } else if (one.getPageType().intValue() == StatPageType.VIDEO_COURSE.getCode() && (videoCourse = this.videoCourseDao.getByNumber(one.getCourseNumber().longValue())) != null) {
                one.setCourseName(videoCourse.getName());
            }
            if (one.getCourseName() != null) continue;
            one.setCourseName("");
        }
        this.txMonitorCourseDayDao.saveAll(courseDays, new String[0]);
    }

    private void deleteTodayBase() {
        this.txMonitorTodayMinService.deleteTodayBase();
    }
}

