/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.service.impl;

import com.baijia.tianxiao.biz.dashboard.dto.FeeRecordDto;
import com.baijia.tianxiao.biz.dashboard.dto.YunyingIndexDto;
import com.baijia.tianxiao.biz.dashboard.dto.YunyingIndexRequestParamDto;
import com.baijia.tianxiao.biz.dashboard.service.YunyingIndexService;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroup;
import com.baijia.tianxiao.dal.org.dao.OrgCourseKexiaoDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class YunyingIndexServiceImpl
implements YunyingIndexService {
    private static final Logger log = LoggerFactory.getLogger(YunyingIndexServiceImpl.class);
    @Autowired
    private OrgSubAccountService subAccountService;
    @Autowired
    private OrgStudentKexiaoRecordDao studentKexiaoRecordDao;
    @Autowired
    private OrgCourseKexiaoDao courseKexiaoDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgCourseGroupDao courseGroupDao;
    @Autowired
    private OrgCourseGroupRelateDao courseGroupRelateDao;

    @Override
    public List<YunyingIndexDto> getIndexDashBoard(YunyingIndexRequestParamDto paramDto) {
        boolean isMaster = paramDto.getIsMaster();
        List<Long> orgIds = paramDto.getOrgIds();
        List<Long> courseTypeIds = paramDto.getCourseTypeIds();
        int rankType = paramDto.getRankType();
        Long orgId = paramDto.getOrgId();
        List<Object> data = new ArrayList();
        ArrayList<String> names = new ArrayList<String>();
        if (rankType == 0) {
            if (isMaster) {
                if (CollectionUtils.isEmpty(orgIds)) {
                    orgIds = new ArrayList<Long>();
                    List subAccounts = this.subAccountService.getMasterandslavesOrgId(orgId);
                    Iterator iterator = subAccounts.iterator();
                    while (iterator.hasNext()) {
                        OrgSubAccount subAccount = (OrgSubAccount)iterator.next();
                        orgIds.add(subAccount.getOrgId().longValue());
                        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(subAccount.getOrgId(), new String[0]);
                        names.add(orgInfo.getShortName());
                    }
                } else {
                    for (Long _orgId : orgIds) {
                        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(_orgId.intValue()), new String[0]);
                        names.add(orgInfo.getShortName());
                    }
                }
            } else {
                orgIds = new ArrayList<Long>();
                orgIds.add(orgId);
                OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
                names.add(orgInfo.getShortName());
            }
            if (CollectionUtils.isEmpty(courseTypeIds)) {
                courseTypeIds = new ArrayList<Long>();
                List courseGroupIds = this.courseGroupDao.getOrgsCourseGroupList(orgIds);
                courseTypeIds.addAll(courseGroupIds);
            }
            paramDto.setOrgIds(orgIds);
            paramDto.setNames(names);
            paramDto.setCourseTypeIds(courseTypeIds);
            data = this.getSchoolData(paramDto);
        } else if (rankType == 1) {
            List courseGroups;
            if (isMaster) {
                orgIds = new ArrayList<Long>();
                List subAccounts = this.subAccountService.getMasterandslavesOrgId(orgId);
                for (OrgSubAccount subAccount : subAccounts) {
                    orgIds.add(subAccount.getOrgId().longValue());
                }
            } else {
                orgIds.add(orgId);
            }
            if (CollectionUtils.isEmpty(courseTypeIds)) {
                courseGroups = this.courseGroupDao.getBathCourseGroupList(orgIds);
                courseTypeIds = new ArrayList<Long>();
                for (OrgCourseGroup orgCourseGroup : courseGroups) {
                    courseTypeIds.add(orgCourseGroup.getId().longValue());
                    names.add(orgCourseGroup.getName());
                }
            } else {
                courseGroups = this.courseGroupDao.getByIds(courseTypeIds, new String[0]);
                for (OrgCourseGroup orgCourseGroup : courseGroups) {
                    names.add(orgCourseGroup.getName());
                }
            }
            paramDto.setOrgIds(orgIds);
            paramDto.setCourseTypeIds(courseTypeIds);
            paramDto.setNames(names);
            data = this.getCourseData(paramDto);
        } else {
            return null;
        }
        return data;
    }

    @Override
    public void importOldData() {
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(Integer.valueOf(0));
        pageDto.setPageSize(Integer.valueOf(1000));
        List courseKexiaos = this.studentKexiaoRecordDao.getRecordEveryday(0, pageDto);
        while (courseKexiaos.size() > 0) {
            pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
            courseKexiaos = this.studentKexiaoRecordDao.getRecordEveryday(0, pageDto);
            this.courseKexiaoDao.saveAll(courseKexiaos, new String[0]);
        }
        List classKexiaos = this.studentKexiaoRecordDao.getRecordEveryday(1, pageDto);
        while (classKexiaos.size() > 0) {
            pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
            classKexiaos = this.studentKexiaoRecordDao.getRecordEveryday(1, pageDto);
            this.courseKexiaoDao.saveAll(classKexiaos, new String[0]);
        }
    }

    @Override
    public void importData() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date start = calendar.getTime();
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.add(5, -1);
        calendarEnd.set(11, 23);
        calendarEnd.set(12, 59);
        calendarEnd.set(13, 59);
        calendarEnd.set(14, 999);
        Date end = calendarEnd.getTime();
        List courseKexiaos = this.studentKexiaoRecordDao.getYesterdayRecord(0, start, end);
        this.courseKexiaoDao.saveAll(courseKexiaos, new String[0]);
        List classKexiaos = this.studentKexiaoRecordDao.getYesterdayRecord(1, start, end);
        this.courseKexiaoDao.saveAll(classKexiaos, new String[0]);
    }

    private List<YunyingIndexDto> getSchoolData(YunyingIndexRequestParamDto paramDto) {
        ArrayList<YunyingIndexDto> yunyingIndexDtos = new ArrayList<YunyingIndexDto>();
        List<Long> orgIds = paramDto.getOrgIds();
        List<String> names = paramDto.getNames();
        List<Long> courseTypeIds = paramDto.getCourseTypeIds();
        long start = paramDto.getStartTime();
        long end = paramDto.getEndTime();
        Date dateStart = new Date(start);
        Date dateEnd = new Date(end);
        int orderKey = paramDto.getOrderKey();
        int orderType = paramDto.getOrderType();
        for (int var = 0; var < orgIds.size(); ++var) {
            String name = names.get(var);
            YunyingIndexDto yunyingIndexDto = new YunyingIndexDto();
            long orgId = orgIds.get(var);
            yunyingIndexDto.setId(orgId);
            yunyingIndexDto.setName(name);
            long kexiao = this.getCourseKexiao(dateStart, dateEnd, courseTypeIds);
            yunyingIndexDto.setIncome(kexiao);
            long cost = this.getCourseCost(courseTypeIds, orgId, start, end);
            yunyingIndexDto.setCost(cost);
            long profit = kexiao - cost;
            yunyingIndexDto.setProfit(profit);
            List<Long> subjectIds = this.getFilterSubjectId();
            long subjectsCost = this.getCourseSubjectsCost(subjectIds, courseTypeIds, orgId, start, end);
            long ebitda = kexiao - subjectsCost;
            yunyingIndexDto.setEbitda(ebitda);
            yunyingIndexDtos.add(yunyingIndexDto);
        }
        yunyingIndexDtos.sort(this.getCompare(orderKey, orderType));
        return yunyingIndexDtos;
    }

    private List<YunyingIndexDto> getCourseData(YunyingIndexRequestParamDto paramDto) {
        ArrayList<YunyingIndexDto> yunyingIndexDtos = new ArrayList<YunyingIndexDto>();
        List<Long> orgIds = paramDto.getOrgIds();
        List<String> names = paramDto.getNames();
        List<Long> courseTypeIds = paramDto.getCourseTypeIds();
        long start = paramDto.getStartTime();
        long end = paramDto.getEndTime();
        Date dateStart = new Date(start);
        Date dateEnd = new Date(end);
        int orderKey = paramDto.getOrderKey();
        int orderType = paramDto.getOrderType();
        for (int var = 0; var < courseTypeIds.size(); ++var) {
            String name = names.get(var);
            YunyingIndexDto yunyingIndexDto = new YunyingIndexDto();
            long courseTypeId = courseTypeIds.get(var);
            yunyingIndexDto.setId(courseTypeId);
            yunyingIndexDto.setName(name);
            long kexiao = this.getSchoolKexiao(dateStart, dateEnd, orgIds);
            yunyingIndexDto.setIncome(kexiao);
            long cost = this.getSchoolCost(courseTypeId, orgIds, start, end);
            yunyingIndexDto.setCost(cost);
            long profit = kexiao - cost;
            yunyingIndexDto.setProfit(profit);
            List<Long> subjectIds = this.getFilterSubjectId();
            long subjectsCost = this.getSchoolSubjectsCost(subjectIds, courseTypeId, orgIds, start, end);
            long ebitda = kexiao - subjectsCost;
            yunyingIndexDto.setEbitda(ebitda);
            yunyingIndexDtos.add(yunyingIndexDto);
        }
        yunyingIndexDtos.sort(this.getCompare(orderKey, orderType));
        return yunyingIndexDtos;
    }

    private long getCourseSubjectsCost(List<Long> subjectIds, List<Long> courseTypeIds, long orgId, long start, long end) {
        long cost = 0L;
        String url = this.getSearchURL();
        for (Long courseTypeId : courseTypeIds) {
            HashMap param = Maps.newHashMap();
            param.put("courseTypeId", courseTypeId);
            param.put("schoolId", orgId);
            param.put("incrurreStartTime", start);
            param.put("incurreEndTime", end);
            for (Long subjectId : subjectIds) {
                param.put("subjectId", subjectId);
                String responseStr = HttpClientUtils.doGet((String)url, (Map)param, (String)"application/json;charset=UTF-8");
                List feeRecordDtos = null;
                try {
                    feeRecordDtos = JacksonUtil.str2List((String)responseStr, FeeRecordDto.class);
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
                double amount = 0.0;
                for (FeeRecordDto feeRecordDto : feeRecordDtos) {
                    amount += feeRecordDto.getAmount().doubleValue();
                }
                cost = (long)((double)cost + amount);
            }
        }
        return cost;
    }

    private long getSchoolSubjectsCost(List<Long> subjectIds, long courseTypeId, List<Long> orgIds, long start, long end) {
        long cost = 0L;
        String url = this.getSearchURL();
        for (Long orgId : orgIds) {
            HashMap param = Maps.newHashMap();
            param.put("courseTypeId", courseTypeId);
            param.put("schoolId", orgId);
            param.put("incrurreStartTime", start);
            param.put("incurreEndTime", end);
            for (Long subjectId : subjectIds) {
                param.put("subjectId", subjectId);
                String responseStr = HttpClientUtils.doGet((String)url, (Map)param, (String)"application/json;charset=UTF-8");
                List feeRecordDtos = null;
                try {
                    feeRecordDtos = JacksonUtil.str2List((String)responseStr, FeeRecordDto.class);
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
                double amount = 0.0;
                for (FeeRecordDto feeRecordDto : feeRecordDtos) {
                    amount += feeRecordDto.getAmount().doubleValue();
                }
                cost = (long)((double)cost + amount);
            }
        }
        return cost;
    }

    private long getCourseCost(List<Long> courseTypeIds, long orgId, long start, long end) {
        long cost = 0L;
        String url = this.getSearchURL();
        for (Long courseTypeId : courseTypeIds) {
            HashMap param = Maps.newHashMap();
            param.put("courseTypeId", courseTypeId);
            param.put("schoolId", orgId);
            param.put("incrurreStartTime", start);
            param.put("incurreEndTime", end);
            String responseStr = HttpClientUtils.doGet((String)url, (Map)param, (String)"application/json;charset=UTF-8");
            List feeRecordDtos = null;
            try {
                feeRecordDtos = JacksonUtil.str2List((String)responseStr, FeeRecordDto.class);
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            double amount = 0.0;
            for (FeeRecordDto feeRecordDto : feeRecordDtos) {
                amount += feeRecordDto.getAmount().doubleValue();
            }
            cost = (long)((double)cost + amount);
        }
        return cost;
    }

    private long getSchoolCost(long courseTypeId, List<Long> orgIds, long start, long end) {
        long cost = 0L;
        String url = this.getSearchURL();
        for (Long orgId : orgIds) {
            HashMap param = Maps.newHashMap();
            param.put("courseTypeId", courseTypeId);
            param.put("schoolId", orgId);
            param.put("incrurreStartTime", start);
            param.put("incurreEndTime", end);
            String responseStr = HttpClientUtils.doGet((String)url, (Map)param, (String)"application/json;charset=UTF-8");
            List feeRecordDtos = null;
            try {
                feeRecordDtos = JacksonUtil.str2List((String)responseStr, FeeRecordDto.class);
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            double amount = 0.0;
            for (FeeRecordDto feeRecordDto : feeRecordDtos) {
                amount += feeRecordDto.getAmount().doubleValue();
            }
            cost = (long)((double)cost + amount);
        }
        return cost;
    }

    private String getSearchURL() {
        String urlStr = PropertiesReader.getProperties((String)"fee.properties").getProperty("fee.url.search");
        return urlStr;
    }

    private List<Long> getFilterSubjectId() {
        String subjectStr = PropertiesReader.getProperties((String)"subjectfilter.properties").getProperty("fitersubject");
        String[] idStr = subjectStr.split(".");
        ArrayList<Long> ids = new ArrayList<Long>();
        for (String id : idStr) {
            ids.add(Long.parseLong(id));
        }
        return ids;
    }

    private long getSchoolKexiao(Date start, Date end, List<Long> orgIds) {
        return this.courseKexiaoDao.getSchoolIncome(start, end, orgIds);
    }

    private long getCourseKexiao(Date start, Date end, List<Long> courseTypeIds) {
        List courseIds = this.courseGroupRelateDao.getCourseIdsByGroupIds(courseTypeIds);
        return this.courseKexiaoDao.getIncome(start, end, courseIds);
    }

    private Comparator<YunyingIndexDto> getCompare(final int orderKey, final int orderType) {
        return new Comparator<YunyingIndexDto>(){

            @Override
            public int compare(YunyingIndexDto o1, YunyingIndexDto o2) {
                if (orderKey == 0) {
                    if (orderType == 0) {
                        return (int)(o1.getIncome() - o2.getIncome());
                    }
                    return (int)(o2.getIncome() - o1.getIncome());
                }
                if (orderKey == 1) {
                    if (orderType == 0) {
                        return (int)(o1.getCost() - o2.getCost());
                    }
                    return (int)(o2.getCost() - o1.getCost());
                }
                if (orderKey == 2) {
                    if (orderType == 0) {
                        return (int)(o1.getProfit() - o2.getProfit());
                    }
                    return (int)(o2.getProfit() - o1.getProfit());
                }
                if (orderKey == 0) {
                    return (int)(o1.getEbitda() - o2.getEbitda());
                }
                return (int)(o2.getEbitda() - o1.getEbitda());
            }
        };
    }
}

