/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.service.impl;

import com.baijia.tianxiao.biz.dashboard.dto.unKexiao.constant.StatisticsScaleEnum;
import com.baijia.tianxiao.biz.dashboard.dto.unKexiao.reponse.ClassStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.unKexiao.reponse.ClassUnKexiaoDto;
import com.baijia.tianxiao.biz.dashboard.dto.unKexiao.reponse.OrgUnKexiaoDto;
import com.baijia.tianxiao.biz.dashboard.dto.unKexiao.reponse.StudentStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.unKexiao.reponse.StudentUnKexiaoDto;
import com.baijia.tianxiao.biz.dashboard.dto.unKexiao.reponse.UnKexiaoStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.unKexiao.request.ClassUnKexiaoListParam;
import com.baijia.tianxiao.biz.dashboard.dto.unKexiao.request.OrgUnKexiaoListParam;
import com.baijia.tianxiao.biz.dashboard.dto.unKexiao.request.StudentUnKexiaoListParam;
import com.baijia.tianxiao.biz.dashboard.service.DashboardUnKexiaoService;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStudentStat;
import com.baijia.tianxiao.sal.kexiao.dto.LessonKexiaoStatisticsDto;
import com.baijia.tianxiao.sal.kexiao.service.KexiaoStatisticsService;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DashboardUnKexiaoServiceImpl
implements DashboardUnKexiaoService {
    private static final Logger log = LoggerFactory.getLogger(DashboardUnKexiaoServiceImpl.class);
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgCourseConsumeRuleDao courseConsumeRuleDao;
    @Autowired
    private KexiaoApiService kexiaoApiService;
    @Autowired
    private KexiaoStatisticsService kexiaoStatisticsService;

    @Override
    public OrgUnKexiaoDto getOrgUnKexiaoStatistics(Long orgId, boolean containSubOrg, Collection<Integer> filterSubOrgTypes) {
        log.info("getOrgUnKexiaoStatistics params : orgId = {}, containSubOrg = {}, filterSubOrgTypes = {}", new Object[]{orgId, containSubOrg, filterSubOrgTypes});
        OrgUnKexiaoListParam param = new OrgUnKexiaoListParam();
        param.setOrgId(orgId);
        param.setContainSubOrg(containSubOrg);
        param.setFilterSubOrgTypes(filterSubOrgTypes);
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[]{"id", "orgId", "shortName"});
        Long orgNumber = (Long)this.orgAccountDao.getOrgNumbersByOrgIds((Collection)Sets.newHashSet((Object[])new Long[]{orgId})).get(orgId);
        return OrgUnKexiaoDto.from(orgInfo, orgNumber, this.getOrgUnKexiaoTotal(param));
    }

    @Override
    public List<OrgUnKexiaoDto> getOrgUnKexiaoList(OrgUnKexiaoListParam param) {
        log.info("getOrgUnKexiaoList param : {}", (Object)param);
        param.validate();
        List<Object> result = Lists.newArrayList();
        if (param.isContainSubOrg()) {
            result = this.getOrgSelfAndSlavesUnKexiaoInfo(param.getOrgId(), param.getFilterSubOrgTypes());
        } else {
            OrgUnKexiaoDto orgUnKexiaoDto = this.getOrgSelfUnKexiaoInfo(param.getOrgId());
            if (orgUnKexiaoDto != null) {
                result.add(orgUnKexiaoDto);
            }
        }
        log.info("getOrgUnKexiaoList result.size() : {}", (Object)result.size());
        return result;
    }

    private OrgUnKexiaoDto getOrgSelfUnKexiaoInfo(Long orgId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"\u6821\u533aid\u4e3a\u7a7a");
        UnKexiaoStatisticsDto unKexiaoStatisticsDto = this.getOrgSelfUnKexiaoTotal(orgId);
        if (UnKexiaoStatisticsDto.isZero(unKexiaoStatisticsDto)) {
            return null;
        }
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[]{"id", "orgId", "shortName"});
        Long orgNumber = (Long)this.orgAccountDao.getOrgNumbersByOrgIds((Collection)Sets.newHashSet((Object[])new Long[]{orgId})).get(orgId);
        OrgUnKexiaoDto orgUnKexiaoDto = OrgUnKexiaoDto.from(orgInfo, orgNumber, unKexiaoStatisticsDto);
        return orgUnKexiaoDto;
    }

    private List<OrgUnKexiaoDto> getOrgSelfAndSlavesUnKexiaoInfo(Long orgId, Collection<Integer> filterSubOrgTypes) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"\u6821\u533aid\u4e3a\u7a7a");
        ArrayList allOrgIds = Lists.newArrayList((Object[])new Long[]{orgId});
        List<Long> subOrgIds = this.getOrgSlaveIds(orgId, filterSubOrgTypes);
        if (CollectionUtils.isNotEmpty(subOrgIds)) {
            allOrgIds.addAll(subOrgIds);
        }
        Map<Long, UnKexiaoStatisticsDto> orgUnkexiaoStisticsMap = this.getOrgUnKexiaoInfoMap(allOrgIds);
        HashMap effectiveOrgUnkexiaoStisticsMap = Maps.newHashMap();
        orgUnkexiaoStisticsMap.forEach((k, e) -> {
            if (!UnKexiaoStatisticsDto.isZero(e)) {
                effectiveOrgUnkexiaoStisticsMap.put(k, e);
            }
        });
        if (MapUtils.isEmpty((Map)effectiveOrgUnkexiaoStisticsMap)) {
            return Collections.emptyList();
        }
        ArrayList orgIds = Lists.newArrayList();
        ArrayList orgIdsInt = Lists.newArrayList();
        allOrgIds.forEach(o -> {
            if (effectiveOrgUnkexiaoStisticsMap.keySet().contains(o)) {
                orgIdsInt.add(o.intValue());
                orgIds.add(o);
            }
        });
        List orgList = this.orgInfoDao.getOrgInfos((Collection)orgIdsInt, new String[]{"id", "orgId", "shortName"});
        Map<Long, OrgInfo> orgInfoMap = orgList.stream().collect(Collectors.toMap(o -> o.getOrgId().longValue(), o -> o));
        Map orgIdNumberMap = this.orgAccountDao.getOrgNumbersByOrgIds((Collection)allOrgIds);
        return OrgUnKexiaoDto.listFrom(orgIds, orgIdNumberMap, orgInfoMap, orgUnkexiaoStisticsMap);
    }

    private Map<Long, UnKexiaoStatisticsDto> getOrgUnKexiaoInfoMap(List<Long> orgIds) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(orgIds), (Object)"\u6821\u533aids\u4e3a\u7a7a");
        HashMap dtoMap = Maps.newHashMap();
        Map signupMap = this.kexiaoStatisticsService.getSignupCourseStatisticsMapOfOrg(orgIds);
        if (LessonKexiaoStatisticsDto.isZeroMap((Map)signupMap)) {
            for (Long orgId : orgIds) {
                dtoMap.put(orgId, UnKexiaoStatisticsDto.createWithZeroValue());
            }
        } else {
            Map freeLessonMap = this.kexiaoStatisticsService.getLessonFreeMapOfOrg(orgIds);
            Map kexiaoFinishedMap = this.kexiaoStatisticsService.getKexiaoFinishedMapOfOrg(orgIds);
            Map refundMap = this.kexiaoStatisticsService.getRefundMapOfOrg(orgIds);
            Map transferMap = this.kexiaoStatisticsService.getTransferMapOfOrg(orgIds);
            for (Long id : orgIds) {
                LessonKexiaoStatisticsDto signupStatisticsDto = (LessonKexiaoStatisticsDto)signupMap.get(id);
                LessonKexiaoStatisticsDto freeLessonStatisticsDto = (LessonKexiaoStatisticsDto)freeLessonMap.get(id);
                LessonKexiaoStatisticsDto kexiaoFinishedStatisticsDto = (LessonKexiaoStatisticsDto)kexiaoFinishedMap.get(id);
                LessonKexiaoStatisticsDto refundStatisticsDto = (LessonKexiaoStatisticsDto)refundMap.get(id);
                LessonKexiaoStatisticsDto transferStatisticsDto = (LessonKexiaoStatisticsDto)transferMap.get(id);
                UnKexiaoStatisticsDto dto = UnKexiaoStatisticsDto.fromLessonKexiaoStatisticsDto(signupStatisticsDto, freeLessonStatisticsDto, kexiaoFinishedStatisticsDto, refundStatisticsDto, transferStatisticsDto);
                dtoMap.put(id, dto);
            }
        }
        return dtoMap;
    }

    @Override
    public UnKexiaoStatisticsDto getOrgUnKexiaoTotal(OrgUnKexiaoListParam param) {
        log.info("getOrgUnKexiaoTotal param : {}", (Object)param);
        param.validate();
        UnKexiaoStatisticsDto result = null;
        result = param.isContainSubOrg() ? this.getOrgSelfAndSlavesUnKexiaoTotal(param.getOrgId(), param.getFilterSubOrgTypes()) : this.getOrgSelfUnKexiaoTotal(param.getOrgId());
        log.info("getOrgUnKexiaoTotal result : {}", (Object)result);
        return result;
    }

    private UnKexiaoStatisticsDto getOrgSelfUnKexiaoTotal(Long orgId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"\u6821\u533aid\u4e3a\u7a7a");
        UnKexiaoStatisticsDto result = this.getUnKexiaoSumOfOrgs(Sets.newHashSet((Object[])new Long[]{orgId}));
        return result;
    }

    private List<Long> getOrgSlaveIds(Long orgId, Collection<Integer> filterSubOrgTypes) {
        if (orgId == null) {
            return Collections.emptyList();
        }
        ArrayList orgIds = Lists.newArrayList();
        List subAccounts = this.orgSubAccountDao.getSlavesByMasterOrgId(Integer.valueOf(orgId.intValue()), null);
        if (CollectionUtils.isNotEmpty((Collection)subAccounts)) {
            for (OrgSubAccount account : subAccounts) {
                if (CollectionUtils.isNotEmpty(filterSubOrgTypes) && filterSubOrgTypes.contains((int)account.getAccountType())) continue;
                orgIds.add(account.getOrgId().longValue());
            }
        }
        return orgIds;
    }

    private UnKexiaoStatisticsDto getOrgSelfAndSlavesUnKexiaoTotal(Long orgId, Collection<Integer> filterSubOrgTypes) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"\u6821\u533aid\u4e3a\u7a7a");
        ArrayList allOrgIds = Lists.newArrayList((Object[])new Long[]{orgId});
        List<Long> subOrgIds = this.getOrgSlaveIds(orgId, filterSubOrgTypes);
        if (CollectionUtils.isNotEmpty(subOrgIds)) {
            allOrgIds.addAll(subOrgIds);
        }
        UnKexiaoStatisticsDto result = this.getUnKexiaoSumOfOrgs(allOrgIds);
        return result;
    }

    private UnKexiaoStatisticsDto getUnKexiaoSumOfOrgs(Collection<Long> orgIds) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(orgIds), (Object)"\u6821\u533aids\u4e3a\u7a7a");
        UnKexiaoStatisticsDto result = null;
        Map signupMap = this.kexiaoStatisticsService.getSignupCourseStatisticsMapOfOrg(orgIds);
        if (LessonKexiaoStatisticsDto.isZeroMap((Map)signupMap)) {
            result = UnKexiaoStatisticsDto.createWithZeroValue();
        } else {
            LessonKexiaoStatisticsDto signupStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto freeLessonStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto kexiaoFinishedStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto refundStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto transferStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            Map freeLessonMap = this.kexiaoStatisticsService.getLessonFreeMapOfOrg(orgIds);
            Map kexiaoFinishedMap = this.kexiaoStatisticsService.getKexiaoFinishedMapOfOrg(orgIds);
            Map refundMap = this.kexiaoStatisticsService.getRefundMapOfOrg(orgIds);
            Map transferMap = this.kexiaoStatisticsService.getTransferMapOfOrg(orgIds);
            for (Long id : orgIds) {
                LessonKexiaoStatisticsDto signupStatisticsDto = (LessonKexiaoStatisticsDto)signupMap.get(id);
                signupStatisticsTotalDto.add(signupStatisticsDto);
                LessonKexiaoStatisticsDto freeLessonStatisticsDto = (LessonKexiaoStatisticsDto)freeLessonMap.get(id);
                freeLessonStatisticsTotalDto.add(freeLessonStatisticsDto);
                LessonKexiaoStatisticsDto kexiaoFinishedStatisticsDto = (LessonKexiaoStatisticsDto)kexiaoFinishedMap.get(id);
                kexiaoFinishedStatisticsTotalDto.add(kexiaoFinishedStatisticsDto);
                LessonKexiaoStatisticsDto refundStatisticsDto = (LessonKexiaoStatisticsDto)refundMap.get(id);
                refundStatisticsTotalDto.add(refundStatisticsDto);
                LessonKexiaoStatisticsDto transferStatisticsDto = (LessonKexiaoStatisticsDto)transferMap.get(id);
                transferStatisticsTotalDto.add(transferStatisticsDto);
            }
            result = UnKexiaoStatisticsDto.fromLessonKexiaoStatisticsDto(signupStatisticsTotalDto, freeLessonStatisticsTotalDto, kexiaoFinishedStatisticsTotalDto, refundStatisticsTotalDto, transferStatisticsTotalDto);
        }
        return result;
    }

    @Override
    public ClassStatisticsDto getClassUnKexiaoStatistics(Long orgId, Long classId) {
        OrgCourseConsumeRule kexiaoRule;
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"\u6821\u533aid\u4e3a\u7a7a");
        Preconditions.checkArgument((classId != null ? 1 : 0) != 0, (Object)"\u73ed\u7ea7id\u4e3a\u7a7a");
        OrgCourse orgClass = this.orgCourseDao.getByCourseId(classId, new String[]{"id", "name", "courseType", "chargeType", "chargeUnit", "parentId"});
        Preconditions.checkArgument((orgClass != null ? 1 : 0) != 0, (Object)"\u73ed\u7ea7\u4e0d\u5b58\u5728");
        long courseId = classId;
        if (orgClass.getParentId() != null && orgClass.getParentId() > 0L) {
            courseId = orgClass.getParentId();
        }
        Integer kexiaoRuleInt = (kexiaoRule = this.courseConsumeRuleDao.getRuleByCourseId(orgId, Long.valueOf(courseId))) == null ? null : kexiaoRule.getRuleValue();
        Integer studentCount = this.orgStudentCourseDao.countStudents(orgId, classId, Integer.valueOf(StudentCourseStatus.NORMAL.getCode()));
        UnKexiaoStatisticsDto unKexiaoStatisticsDto = this.getClassUnKexiaoInfo(classId);
        return ClassStatisticsDto.from(orgClass, kexiaoRuleInt, studentCount, unKexiaoStatisticsDto);
    }

    @Override
    public List<ClassUnKexiaoDto> getClassUnKexiaoList(ClassUnKexiaoListParam param) {
        List studentClass;
        log.info("getClassUnKexiaoList  params : {}", (Object)param);
        param.validate();
        OrgAccount org = (OrgAccount)this.orgAccountDao.getById((Serializable)param.getOrgId(), new String[0]);
        if (org == null) {
            return Collections.emptyList();
        }
        List<Object> classIds = Lists.newArrayList();
        if (param.getScale().intValue() == StatisticsScaleEnum.ORG.getCode()) {
            classIds = this.orgCourseDao.listCourseIdIgnoreStatus(Long.valueOf(org.getNumber().longValue()), null, param.getKeyword(), CourseTypeEnum.getCourseTypeList((Integer)param.getCourseType()), param.getChargeType(), param.getChargeUnit(), null);
        } else if (param.getScale().intValue() == StatisticsScaleEnum.STUDENT.getCode() && CollectionUtils.isNotEmpty((Collection)(classIds = (studentClass = this.orgStudentCourseDao.listByStudentUserId(param.getOrgId(), param.getStudentUserId(), null, null)).stream().map(OrgStudentCourse::getCourseId).collect(Collectors.toList())))) {
            classIds = this.orgCourseDao.listCourseIdIgnoreStatus(Long.valueOf(org.getNumber().longValue()), (Collection)classIds, param.getKeyword(), CourseTypeEnum.getCourseTypeList((Integer)param.getCourseType()), param.getChargeType(), param.getChargeUnit(), null);
        }
        if (CollectionUtils.isEmpty((Collection)classIds)) {
            return Collections.emptyList();
        }
        Map<Object, Object> classUnkexiaoStisticsMap = Maps.newHashMap();
        classUnkexiaoStisticsMap = param.getScale().intValue() == StatisticsScaleEnum.ORG.getCode() ? this.getClassUnKexiaoInfoMap(classIds) : this.getStudentClassUnKexiaoInfoMap(param.getStudentUserId(), classIds);
        HashMap effectiveClassUnkexiaoStisticsMap = Maps.newHashMap();
        classUnkexiaoStisticsMap.forEach((k, e) -> {
            if (!UnKexiaoStatisticsDto.isZero(e)) {
                effectiveClassUnkexiaoStisticsMap.put(k, e);
            }
        });
        if (MapUtils.isEmpty((Map)effectiveClassUnkexiaoStisticsMap)) {
            return Collections.emptyList();
        }
        List orgClassList = this.orgCourseDao.getClassList(effectiveClassUnkexiaoStisticsMap.keySet(), (List)Lists.newArrayList((Object[])new Order[]{Order.desc((String[])new String[]{"id"})}), param.getPageDto(), new String[]{"id", "name", "courseType", "chargeType", "chargeUnit", "isDel"});
        Map<Long, OrgCourse> orgClassMap = orgClassList.stream().collect(Collectors.toMap(o -> o.getId(), o -> o));
        classIds = orgClassList.stream().map(OrgCourse::getId).collect(Collectors.toList());
        return ClassUnKexiaoDto.listFrom(classIds, orgClassMap, effectiveClassUnkexiaoStisticsMap);
    }

    @Override
    public UnKexiaoStatisticsDto getClassUnKexiaoTotal(ClassUnKexiaoListParam param) {
        param.validate();
        if (param.getScale().intValue() == StatisticsScaleEnum.ORG.getCode() && param.isEmptyConditionQuery()) {
            return this.getOrgSelfUnKexiaoInfo(param.getOrgId());
        }
        if (param.getScale().intValue() == StatisticsScaleEnum.STUDENT.getCode() && param.isEmptyConditionQuery()) {
            return this.getStudentUnKexiaoInfo(param.getStudentUserId());
        }
        UnKexiaoStatisticsDto result = null;
        OrgAccount org = (OrgAccount)this.orgAccountDao.getById((Serializable)param.getOrgId(), new String[0]);
        if (org == null) {
            result = UnKexiaoStatisticsDto.createWithZeroValue();
        } else {
            List studentClass;
            List<Object> classIds = Lists.newArrayList();
            if (param.getScale().intValue() == StatisticsScaleEnum.ORG.getCode()) {
                classIds = this.orgCourseDao.listCourseIdIgnoreStatus(Long.valueOf(org.getNumber().longValue()), null, param.getKeyword(), CourseTypeEnum.getCourseTypeList((Integer)param.getCourseType()), param.getChargeType(), param.getChargeUnit(), null);
            } else if (param.getScale().intValue() == StatisticsScaleEnum.STUDENT.getCode() && CollectionUtils.isNotEmpty((Collection)(classIds = (studentClass = this.orgStudentCourseDao.listByStudentUserId(param.getOrgId(), param.getStudentUserId(), null, null)).stream().map(OrgStudentCourse::getCourseId).collect(Collectors.toList())))) {
                classIds = this.orgCourseDao.listCourseIdIgnoreStatus(Long.valueOf(org.getNumber().longValue()), (Collection)classIds, param.getKeyword(), CourseTypeEnum.getCourseTypeList((Integer)param.getCourseType()), param.getChargeType(), param.getChargeUnit(), null);
            }
            result = CollectionUtils.isEmpty((Collection)classIds) ? UnKexiaoStatisticsDto.createWithZeroValue() : (param.getScale().intValue() == StatisticsScaleEnum.ORG.getCode() ? this.getUnKexiaoSumOfClasses(classIds) : this.getUnKexiaoSumOfStudentClasses(param.getStudentUserId(), classIds));
        }
        return result;
    }

    private UnKexiaoStatisticsDto getClassUnKexiaoInfo(Long classId) {
        Preconditions.checkArgument((classId != null ? 1 : 0) != 0, (Object)"\u73ed\u7ea7id\u4e3a\u7a7a");
        return this.getUnKexiaoSumOfClasses(Sets.newHashSet((Object[])new Long[]{classId}));
    }

    private UnKexiaoStatisticsDto getUnKexiaoSumOfClasses(Collection<Long> classIds) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(classIds), (Object)"\u73ed\u7ea7ids\u4e3a\u7a7a");
        UnKexiaoStatisticsDto result = null;
        Map signupMap = this.kexiaoStatisticsService.getSignupCourseStatisticsMapOfClass(classIds);
        if (LessonKexiaoStatisticsDto.isZeroMap((Map)signupMap)) {
            result = UnKexiaoStatisticsDto.createWithZeroValue();
        } else {
            LessonKexiaoStatisticsDto signupStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto freeLessonStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto kexiaoFinishedStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto refundStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto transferStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            Map freeLessonMap = this.kexiaoStatisticsService.getLessonFreeMapOfClass(classIds);
            Map kexiaoFinishedMap = this.kexiaoStatisticsService.getKexiaoFinishedMapOfClass(classIds);
            Map refundMap = this.kexiaoStatisticsService.getRefundMapOfClass(classIds);
            Map transferMap = this.kexiaoStatisticsService.getTransferMapOfClass(classIds);
            for (Long id : classIds) {
                LessonKexiaoStatisticsDto signupStatisticsDto = (LessonKexiaoStatisticsDto)signupMap.get(id);
                signupStatisticsTotalDto.add(signupStatisticsDto);
                LessonKexiaoStatisticsDto freeLessonStatisticsDto = (LessonKexiaoStatisticsDto)freeLessonMap.get(id);
                freeLessonStatisticsTotalDto.add(freeLessonStatisticsDto);
                LessonKexiaoStatisticsDto kexiaoFinishedStatisticsDto = (LessonKexiaoStatisticsDto)kexiaoFinishedMap.get(id);
                kexiaoFinishedStatisticsTotalDto.add(kexiaoFinishedStatisticsDto);
                LessonKexiaoStatisticsDto refundStatisticsDto = (LessonKexiaoStatisticsDto)refundMap.get(id);
                refundStatisticsTotalDto.add(refundStatisticsDto);
                LessonKexiaoStatisticsDto transferStatisticsDto = (LessonKexiaoStatisticsDto)transferMap.get(id);
                transferStatisticsTotalDto.add(transferStatisticsDto);
            }
            result = UnKexiaoStatisticsDto.fromLessonKexiaoStatisticsDto(signupStatisticsTotalDto, freeLessonStatisticsTotalDto, kexiaoFinishedStatisticsTotalDto, refundStatisticsTotalDto, transferStatisticsTotalDto);
        }
        return result;
    }

    private UnKexiaoStatisticsDto getUnKexiaoSumOfStudentClasses(Long userId, Collection<Long> classIds) {
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u5b66\u5458id\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(classIds), (Object)"\u73ed\u7ea7ids\u4e3a\u7a7a");
        UnKexiaoStatisticsDto result = null;
        Map signupMap = this.kexiaoStatisticsService.getSignupCourseStatisticsMapOfStudentClass(userId, classIds);
        if (LessonKexiaoStatisticsDto.isZeroMap((Map)signupMap)) {
            result = UnKexiaoStatisticsDto.createWithZeroValue();
        } else {
            LessonKexiaoStatisticsDto signupStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto freeLessonStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto kexiaoFinishedStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto refundStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto transferStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            Map freeLessonMap = this.kexiaoStatisticsService.getLessonFreeMapOfStudentClass(userId, classIds);
            Map kexiaoFinishedMap = this.kexiaoStatisticsService.getKexiaoFinishedMapOfStudentClass(userId, classIds);
            Map refundMap = this.kexiaoStatisticsService.getRefundMapOfStudentClass(userId, classIds);
            Map transferMap = this.kexiaoStatisticsService.getTransferMapOfStudentClass(userId, classIds);
            for (Long id : classIds) {
                LessonKexiaoStatisticsDto signupStatisticsDto = (LessonKexiaoStatisticsDto)signupMap.get(id);
                signupStatisticsTotalDto.add(signupStatisticsDto);
                LessonKexiaoStatisticsDto freeLessonStatisticsDto = (LessonKexiaoStatisticsDto)freeLessonMap.get(id);
                freeLessonStatisticsTotalDto.add(freeLessonStatisticsDto);
                LessonKexiaoStatisticsDto kexiaoFinishedStatisticsDto = (LessonKexiaoStatisticsDto)kexiaoFinishedMap.get(id);
                kexiaoFinishedStatisticsTotalDto.add(kexiaoFinishedStatisticsDto);
                LessonKexiaoStatisticsDto refundStatisticsDto = (LessonKexiaoStatisticsDto)refundMap.get(id);
                refundStatisticsTotalDto.add(refundStatisticsDto);
                LessonKexiaoStatisticsDto transferStatisticsDto = (LessonKexiaoStatisticsDto)transferMap.get(id);
                transferStatisticsTotalDto.add(transferStatisticsDto);
            }
            result = UnKexiaoStatisticsDto.fromLessonKexiaoStatisticsDto(signupStatisticsTotalDto, freeLessonStatisticsTotalDto, kexiaoFinishedStatisticsTotalDto, refundStatisticsTotalDto, transferStatisticsTotalDto);
        }
        return result;
    }

    private Map<Long, UnKexiaoStatisticsDto> getClassUnKexiaoInfoMap(List<Long> classIds) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(classIds), (Object)"\u73ed\u7ea7ids\u4e3a\u7a7a");
        HashMap dtoMap = Maps.newHashMap();
        Map signupMap = this.kexiaoStatisticsService.getSignupCourseStatisticsMapOfClass(classIds);
        if (LessonKexiaoStatisticsDto.isZeroMap((Map)signupMap)) {
            for (Long orgId : classIds) {
                dtoMap.put(orgId, UnKexiaoStatisticsDto.createWithZeroValue());
            }
        } else {
            Map freeLessonMap = this.kexiaoStatisticsService.getLessonFreeMapOfClass(classIds);
            Map kexiaoFinishedMap = this.kexiaoStatisticsService.getKexiaoFinishedMapOfClass(classIds);
            Map refundMap = this.kexiaoStatisticsService.getRefundMapOfClass(classIds);
            Map transferMap = this.kexiaoStatisticsService.getTransferMapOfClass(classIds);
            for (Long id : classIds) {
                LessonKexiaoStatisticsDto signupStatisticsDto = (LessonKexiaoStatisticsDto)signupMap.get(id);
                LessonKexiaoStatisticsDto freeLessonStatisticsDto = (LessonKexiaoStatisticsDto)freeLessonMap.get(id);
                LessonKexiaoStatisticsDto kexiaoFinishedStatisticsDto = (LessonKexiaoStatisticsDto)kexiaoFinishedMap.get(id);
                LessonKexiaoStatisticsDto refundStatisticsDto = (LessonKexiaoStatisticsDto)refundMap.get(id);
                LessonKexiaoStatisticsDto transferStatisticsDto = (LessonKexiaoStatisticsDto)transferMap.get(id);
                UnKexiaoStatisticsDto dto = UnKexiaoStatisticsDto.fromLessonKexiaoStatisticsDto(signupStatisticsDto, freeLessonStatisticsDto, kexiaoFinishedStatisticsDto, refundStatisticsDto, transferStatisticsDto);
                dtoMap.put(id, dto);
            }
        }
        return dtoMap;
    }

    private Map<Long, UnKexiaoStatisticsDto> getStudentClassUnKexiaoInfoMap(Long userId, List<Long> classIds) {
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u5b66\u5458id\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(classIds), (Object)"\u73ed\u7ea7ids\u4e3a\u7a7a");
        HashMap dtoMap = Maps.newHashMap();
        Map signupMap = this.kexiaoStatisticsService.getSignupCourseStatisticsMapOfStudentClass(userId, classIds);
        if (LessonKexiaoStatisticsDto.isZeroMap((Map)signupMap)) {
            for (Long orgId : classIds) {
                dtoMap.put(orgId, UnKexiaoStatisticsDto.createWithZeroValue());
            }
        } else {
            Map freeLessonMap = this.kexiaoStatisticsService.getLessonFreeMapOfStudentClass(userId, classIds);
            Map kexiaoFinishedMap = this.kexiaoStatisticsService.getKexiaoFinishedMapOfStudentClass(userId, classIds);
            Map refundMap = this.kexiaoStatisticsService.getRefundMapOfStudentClass(userId, classIds);
            Map transferMap = this.kexiaoStatisticsService.getTransferMapOfStudentClass(userId, classIds);
            for (Long id : classIds) {
                LessonKexiaoStatisticsDto signupStatisticsDto = (LessonKexiaoStatisticsDto)signupMap.get(id);
                LessonKexiaoStatisticsDto freeLessonStatisticsDto = (LessonKexiaoStatisticsDto)freeLessonMap.get(id);
                LessonKexiaoStatisticsDto kexiaoFinishedStatisticsDto = (LessonKexiaoStatisticsDto)kexiaoFinishedMap.get(id);
                LessonKexiaoStatisticsDto refundStatisticsDto = (LessonKexiaoStatisticsDto)refundMap.get(id);
                LessonKexiaoStatisticsDto transferStatisticsDto = (LessonKexiaoStatisticsDto)transferMap.get(id);
                UnKexiaoStatisticsDto dto = UnKexiaoStatisticsDto.fromLessonKexiaoStatisticsDto(signupStatisticsDto, freeLessonStatisticsDto, kexiaoFinishedStatisticsDto, refundStatisticsDto, transferStatisticsDto);
                dtoMap.put(id, dto);
            }
        }
        return dtoMap;
    }

    @Override
    public StudentStatisticsDto getStudentUnKexiaoStatistics(Long orgId, Long studentUserId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"\u6821\u533aid\u4e3a\u7a7a");
        Preconditions.checkArgument((studentUserId != null ? 1 : 0) != 0, (Object)"\u5b66\u5458id\u4e3a\u7a7a");
        OrgStudent student = this.orgStudentDao.getStudentByUserId(orgId, studentUserId, new String[]{"id", "userId", "name"});
        Preconditions.checkArgument((student != null ? 1 : 0) != 0, (Object)"\u5b66\u5458\u4e0d\u5b58\u5728");
        Integer classCount = this.orgStudentCourseDao.getStudentSignupCourseCount(orgId, studentUserId, Integer.valueOf(StudentCourseStatus.NORMAL.getCode()));
        Long payMoneyLong = 0L;
        Long remainingMoneyLong = 0L;
        KexiaoStudentStat kexiaoStudentStat = (KexiaoStudentStat)this.kexiaoApiService.queryUserKexiaoStat(orgId, (Collection)Sets.newHashSet((Object[])new Long[]{studentUserId})).get(studentUserId);
        if (kexiaoStudentStat != null) {
            payMoneyLong = kexiaoStudentStat.getTotalAmount();
            remainingMoneyLong = kexiaoStudentStat.getLeftAmount();
        }
        UnKexiaoStatisticsDto unKexiaoStatisticsDto = this.getStudentUnKexiaoInfo(studentUserId);
        return StudentStatisticsDto.from(student, classCount, payMoneyLong, remainingMoneyLong, unKexiaoStatisticsDto);
    }

    private UnKexiaoStatisticsDto getStudentUnKexiaoInfo(Long userId) {
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u5b66\u5458id\u4e3a\u7a7a");
        return this.getUnKexiaoSumOfStudents(Sets.newHashSet((Object[])new Long[]{userId}));
    }

    private UnKexiaoStatisticsDto getUnKexiaoSumOfStudents(Collection<Long> userIds) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(userIds), (Object)"\u5b66\u5458ids\u4e3a\u7a7a");
        UnKexiaoStatisticsDto result = null;
        Map signupMap = this.kexiaoStatisticsService.getSignupCourseStatisticsMapOfStudent(userIds);
        if (LessonKexiaoStatisticsDto.isZeroMap((Map)signupMap)) {
            result = UnKexiaoStatisticsDto.createWithZeroValue();
        } else {
            LessonKexiaoStatisticsDto signupStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto freeLessonStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto kexiaoFinishedStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto refundStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto transferStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            Map freeLessonMap = this.kexiaoStatisticsService.getLessonFreeMapOfStudent(userIds);
            Map kexiaoFinishedMap = this.kexiaoStatisticsService.getKexiaoFinishedMapOfStudent(userIds);
            Map refundMap = this.kexiaoStatisticsService.getRefundMapOfStudent(userIds);
            Map transferMap = this.kexiaoStatisticsService.getTransferMapOfStudent(userIds);
            for (Long id : userIds) {
                LessonKexiaoStatisticsDto signupStatisticsDto = (LessonKexiaoStatisticsDto)signupMap.get(id);
                signupStatisticsTotalDto.add(signupStatisticsDto);
                LessonKexiaoStatisticsDto freeLessonStatisticsDto = (LessonKexiaoStatisticsDto)freeLessonMap.get(id);
                freeLessonStatisticsTotalDto.add(freeLessonStatisticsDto);
                LessonKexiaoStatisticsDto kexiaoFinishedStatisticsDto = (LessonKexiaoStatisticsDto)kexiaoFinishedMap.get(id);
                kexiaoFinishedStatisticsTotalDto.add(kexiaoFinishedStatisticsDto);
                LessonKexiaoStatisticsDto refundStatisticsDto = (LessonKexiaoStatisticsDto)refundMap.get(id);
                refundStatisticsTotalDto.add(refundStatisticsDto);
                LessonKexiaoStatisticsDto transferStatisticsDto = (LessonKexiaoStatisticsDto)transferMap.get(id);
                transferStatisticsTotalDto.add(transferStatisticsDto);
            }
            result = UnKexiaoStatisticsDto.fromLessonKexiaoStatisticsDto(signupStatisticsTotalDto, freeLessonStatisticsTotalDto, kexiaoFinishedStatisticsTotalDto, refundStatisticsTotalDto, transferStatisticsTotalDto);
        }
        return result;
    }

    private UnKexiaoStatisticsDto getUnKexiaoSumOfClassStudents(Long classId, Collection<Long> userIds) {
        Preconditions.checkArgument((classId != null ? 1 : 0) != 0, (Object)"\u73ed\u7ea7id\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(userIds), (Object)"\u5b66\u5458ids\u4e3a\u7a7a");
        UnKexiaoStatisticsDto result = null;
        Map signupMap = this.kexiaoStatisticsService.getSignupCourseStatisticsMapOfClassStudent(classId, userIds);
        if (LessonKexiaoStatisticsDto.isZeroMap((Map)signupMap)) {
            result = UnKexiaoStatisticsDto.createWithZeroValue();
        } else {
            LessonKexiaoStatisticsDto signupStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto freeLessonStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto kexiaoFinishedStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto refundStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            LessonKexiaoStatisticsDto transferStatisticsTotalDto = new LessonKexiaoStatisticsDto();
            Map freeLessonMap = this.kexiaoStatisticsService.getLessonFreeMapOfClassStudent(classId, userIds);
            Map kexiaoFinishedMap = this.kexiaoStatisticsService.getKexiaoFinishedMapOfClassStudent(classId, userIds);
            Map refundMap = this.kexiaoStatisticsService.getRefundMapOfClassStudent(classId, userIds);
            Map transferMap = this.kexiaoStatisticsService.getTransferMapOfClassStudent(classId, userIds);
            for (Long id : userIds) {
                LessonKexiaoStatisticsDto signupStatisticsDto = (LessonKexiaoStatisticsDto)signupMap.get(id);
                signupStatisticsTotalDto.add(signupStatisticsDto);
                LessonKexiaoStatisticsDto freeLessonStatisticsDto = (LessonKexiaoStatisticsDto)freeLessonMap.get(id);
                freeLessonStatisticsTotalDto.add(freeLessonStatisticsDto);
                LessonKexiaoStatisticsDto kexiaoFinishedStatisticsDto = (LessonKexiaoStatisticsDto)kexiaoFinishedMap.get(id);
                kexiaoFinishedStatisticsTotalDto.add(kexiaoFinishedStatisticsDto);
                LessonKexiaoStatisticsDto refundStatisticsDto = (LessonKexiaoStatisticsDto)refundMap.get(id);
                refundStatisticsTotalDto.add(refundStatisticsDto);
                LessonKexiaoStatisticsDto transferStatisticsDto = (LessonKexiaoStatisticsDto)transferMap.get(id);
                transferStatisticsTotalDto.add(transferStatisticsDto);
            }
            result = UnKexiaoStatisticsDto.fromLessonKexiaoStatisticsDto(signupStatisticsTotalDto, freeLessonStatisticsTotalDto, kexiaoFinishedStatisticsTotalDto, refundStatisticsTotalDto, transferStatisticsTotalDto);
        }
        return result;
    }

    @Override
    public List<StudentUnKexiaoDto> getStudentUnKexiaoList(StudentUnKexiaoListParam param) {
        List classStudent;
        log.info("getStudentUnKexiaoList params : {}", (Object)param);
        param.validate();
        OrgAccount org = (OrgAccount)this.orgAccountDao.getById((Serializable)param.getOrgId(), new String[0]);
        if (org == null) {
            return Collections.emptyList();
        }
        List<Object> studentUserIds = Lists.newArrayList();
        if (param.getScale().intValue() == StatisticsScaleEnum.ORG.getCode()) {
            studentUserIds = this.orgStudentDao.listUserIdIgnoreStatus(param.getOrgId(), null, param.getKeyword(), null);
        } else if (param.getScale().intValue() == StatisticsScaleEnum.CLASS.getCode() && CollectionUtils.isNotEmpty((Collection)(studentUserIds = (classStudent = this.orgStudentCourseDao.listByCourseId(param.getOrgId(), param.getClassId(), null, null)).stream().map(OrgStudentCourse::getUserId).collect(Collectors.toList())))) {
            studentUserIds = this.orgStudentDao.listUserIdIgnoreStatus(param.getOrgId(), (Collection)studentUserIds, param.getKeyword(), null);
        }
        if (CollectionUtils.isEmpty((Collection)studentUserIds)) {
            return Collections.emptyList();
        }
        Map<Object, Object> studentUnkexiaoStisticsMap = Maps.newHashMap();
        studentUnkexiaoStisticsMap = param.getScale().intValue() == StatisticsScaleEnum.ORG.getCode() ? this.getStudentUnKexiaoInfoMap(studentUserIds) : this.getClassStudentUnKexiaoInfoMap(param.getClassId(), studentUserIds);
        HashMap effectiveUnkexiaoStisticsMap = Maps.newHashMap();
        studentUnkexiaoStisticsMap.forEach((k, e) -> {
            if (!UnKexiaoStatisticsDto.isZero(e)) {
                effectiveUnkexiaoStisticsMap.put(k, e);
            }
        });
        if (MapUtils.isEmpty((Map)effectiveUnkexiaoStisticsMap)) {
            return Collections.emptyList();
        }
        List orgStudentList = this.orgStudentDao.getStudentLists(effectiveUnkexiaoStisticsMap.keySet(), (List)Lists.newArrayList((Object[])new Order[]{Order.desc((String[])new String[]{"id"})}), param.getPageDto(), new String[]{"id", "userId", "name", "delStatus"});
        Map<Long, OrgStudent> orgStudentMap = orgStudentList.stream().collect(Collectors.toMap(o -> o.getUserId(), o -> o));
        studentUserIds = orgStudentList.stream().map(OrgStudent::getUserId).collect(Collectors.toList());
        return StudentUnKexiaoDto.listFrom(studentUserIds, orgStudentMap, effectiveUnkexiaoStisticsMap);
    }

    private Map<Long, UnKexiaoStatisticsDto> getStudentUnKexiaoInfoMap(List<Long> userIds) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(userIds), (Object)"\u5b66\u5458ids\u4e3a\u7a7a");
        HashMap dtoMap = Maps.newHashMap();
        Map signupMap = this.kexiaoStatisticsService.getSignupCourseStatisticsMapOfStudent(userIds);
        if (LessonKexiaoStatisticsDto.isZeroMap((Map)signupMap)) {
            for (Long orgId : userIds) {
                dtoMap.put(orgId, UnKexiaoStatisticsDto.createWithZeroValue());
            }
        } else {
            Map freeLessonMap = this.kexiaoStatisticsService.getLessonFreeMapOfStudent(userIds);
            Map kexiaoFinishedMap = this.kexiaoStatisticsService.getKexiaoFinishedMapOfStudent(userIds);
            Map refundMap = this.kexiaoStatisticsService.getRefundMapOfStudent(userIds);
            Map transferMap = this.kexiaoStatisticsService.getTransferMapOfStudent(userIds);
            for (Long id : userIds) {
                LessonKexiaoStatisticsDto signupStatisticsDto = (LessonKexiaoStatisticsDto)signupMap.get(id);
                LessonKexiaoStatisticsDto freeLessonStatisticsDto = (LessonKexiaoStatisticsDto)freeLessonMap.get(id);
                LessonKexiaoStatisticsDto kexiaoFinishedStatisticsDto = (LessonKexiaoStatisticsDto)kexiaoFinishedMap.get(id);
                LessonKexiaoStatisticsDto refundStatisticsDto = (LessonKexiaoStatisticsDto)refundMap.get(id);
                LessonKexiaoStatisticsDto transferStatisticsDto = (LessonKexiaoStatisticsDto)transferMap.get(id);
                UnKexiaoStatisticsDto dto = UnKexiaoStatisticsDto.fromLessonKexiaoStatisticsDto(signupStatisticsDto, freeLessonStatisticsDto, kexiaoFinishedStatisticsDto, refundStatisticsDto, transferStatisticsDto);
                dtoMap.put(id, dto);
            }
        }
        return dtoMap;
    }

    private Map<Long, UnKexiaoStatisticsDto> getClassStudentUnKexiaoInfoMap(Long classId, List<Long> userIds) {
        Preconditions.checkArgument((classId != null ? 1 : 0) != 0, (Object)"\u73ed\u7ea7id\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(userIds), (Object)"\u5b66\u5458ids\u4e3a\u7a7a");
        HashMap dtoMap = Maps.newHashMap();
        Map signupMap = this.kexiaoStatisticsService.getSignupCourseStatisticsMapOfClassStudent(classId, userIds);
        if (LessonKexiaoStatisticsDto.isZeroMap((Map)signupMap)) {
            for (Long orgId : userIds) {
                dtoMap.put(orgId, UnKexiaoStatisticsDto.createWithZeroValue());
            }
        } else {
            Map freeLessonMap = this.kexiaoStatisticsService.getLessonFreeMapOfClassStudent(classId, userIds);
            Map kexiaoFinishedMap = this.kexiaoStatisticsService.getKexiaoFinishedMapOfClassStudent(classId, userIds);
            Map refundMap = this.kexiaoStatisticsService.getRefundMapOfClassStudent(classId, userIds);
            Map transferMap = this.kexiaoStatisticsService.getTransferMapOfClassStudent(classId, userIds);
            for (Long id : userIds) {
                LessonKexiaoStatisticsDto signupStatisticsDto = (LessonKexiaoStatisticsDto)signupMap.get(id);
                LessonKexiaoStatisticsDto freeLessonStatisticsDto = (LessonKexiaoStatisticsDto)freeLessonMap.get(id);
                LessonKexiaoStatisticsDto kexiaoFinishedStatisticsDto = (LessonKexiaoStatisticsDto)kexiaoFinishedMap.get(id);
                LessonKexiaoStatisticsDto refundStatisticsDto = (LessonKexiaoStatisticsDto)refundMap.get(id);
                LessonKexiaoStatisticsDto transferStatisticsDto = (LessonKexiaoStatisticsDto)transferMap.get(id);
                UnKexiaoStatisticsDto dto = UnKexiaoStatisticsDto.fromLessonKexiaoStatisticsDto(signupStatisticsDto, freeLessonStatisticsDto, kexiaoFinishedStatisticsDto, refundStatisticsDto, transferStatisticsDto);
                dtoMap.put(id, dto);
            }
        }
        return dtoMap;
    }

    @Override
    public UnKexiaoStatisticsDto getStudentUnKexiaoTotal(StudentUnKexiaoListParam param) {
        param.validate();
        if (param.getScale().intValue() == StatisticsScaleEnum.ORG.getCode() && param.isEmptyConditionQuery()) {
            return this.getOrgSelfUnKexiaoInfo(param.getOrgId());
        }
        if (param.getScale().intValue() == StatisticsScaleEnum.CLASS.getCode() && param.isEmptyConditionQuery()) {
            return this.getClassUnKexiaoInfo(param.getClassId());
        }
        UnKexiaoStatisticsDto result = null;
        OrgAccount org = (OrgAccount)this.orgAccountDao.getById((Serializable)param.getOrgId(), new String[0]);
        if (org == null) {
            result = UnKexiaoStatisticsDto.createWithZeroValue();
        } else {
            List classStudent;
            List<Object> studentUserIds = Lists.newArrayList();
            if (param.getScale().intValue() == StatisticsScaleEnum.ORG.getCode()) {
                studentUserIds = this.orgStudentDao.listUserIdIgnoreStatus(param.getOrgId(), null, param.getKeyword(), null);
            } else if (param.getScale().intValue() == StatisticsScaleEnum.CLASS.getCode() && CollectionUtils.isNotEmpty((Collection)(studentUserIds = (classStudent = this.orgStudentCourseDao.listByCourseId(param.getOrgId(), param.getClassId(), null, null)).stream().map(OrgStudentCourse::getUserId).collect(Collectors.toList())))) {
                studentUserIds = this.orgStudentDao.listUserIdIgnoreStatus(param.getOrgId(), (Collection)studentUserIds, param.getKeyword(), null);
            }
            result = CollectionUtils.isEmpty((Collection)studentUserIds) ? UnKexiaoStatisticsDto.createWithZeroValue() : (param.getScale().intValue() == StatisticsScaleEnum.ORG.getCode() ? this.getUnKexiaoSumOfStudents(studentUserIds) : this.getUnKexiaoSumOfClassStudents(param.getClassId(), studentUserIds));
        }
        return result;
    }
}

