/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.service.impl;

import com.baijia.tianxiao.biz.dashboard.dto.kexiao.DashboadrKexiaoDtoHelper;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.allorg.AllOrgListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.allorg.MainStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.classdetail.ClassDetailListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.classdetail.ClassDetailStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail.OrgDetailClassListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail.OrgDetailKexiaoListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail.OrgDetailStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail.OrgDetailStudentListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.AllOrgListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.ClassDetailListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.OrgDetailClassListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.OrgDetailKexiaoListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.OrgDetailStudentListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.StudentDetailListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.studentdetail.StudentDetailListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.studentdetail.StudentDetailStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.service.DashboardKeXiaoService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceAccountDao;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccount;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dto.ChargeUnitStatisticDto;
import com.baijia.tianxiao.dal.org.dto.KexiaoSumDto;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentKexiaoRecord;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStudentStat;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.date.DateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DashboardKeXiaoServiceImpl
implements DashboardKeXiaoService {
    private static final Logger log = LoggerFactory.getLogger(DashboardKeXiaoServiceImpl.class);
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgCourseConsumeRuleDao courseConsumeRuleDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgSignupRefundDao orgSignupRefundDao;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private OrgTeacherLessonDao teacherLessonDao;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private KexiaoApiService kexiaoApiService;
    @Autowired
    private TxStudentFinanceAccountDao studentFinanceAccountDao;

    static <T> List<T> getArrayList(T obj) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(obj);
        return list;
    }

    @Override
    public MainStatisticsDto getMainStatisticsDto(Long mainOrgId) {
        AllOrgListParamDto weekParam = new AllOrgListParamDto();
        weekParam.setMainOrgId(mainOrgId);
        weekParam.setStartDate(DateUtil.getStartOfWeek().getTime());
        weekParam.setEndDate(DateUtil.getEndOfWeek().getTime());
        AllOrgListParamDto monthParam = new AllOrgListParamDto();
        monthParam.setMainOrgId(mainOrgId);
        monthParam.setStartDate(DateUtil.getStartOfMonth().getTime());
        monthParam.setEndDate(DateUtil.getEndOfMonth().getTime());
        AllOrgListDto weekDto = this.getAllOrgListTotal(weekParam);
        AllOrgListDto monthDto = this.getAllOrgListTotal(monthParam);
        MainStatisticsDto dto = new MainStatisticsDto();
        if (weekDto != null && weekDto.getTotalKexiaoMoney() != null) {
            dto.setWeekKexiaoMoney(weekDto.getTotalKexiaoMoneyLong());
        } else {
            dto.setWeekKexiaoMoney(0L);
        }
        if (monthDto != null && monthDto.getTotalKexiaoMoney() != null) {
            dto.setMonthKexiaoMoney(monthDto.getTotalKexiaoMoneyLong());
        } else {
            dto.setMonthKexiaoMoney(0L);
        }
        return dto;
    }

    @Override
    public List<AllOrgListDto> listAllOrgListDto(AllOrgListParamDto param, PageDto pageDto) {
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        DateUtil.durationUnderOneYearValidate((Date)startTime, (Date)endTime);
        Map<Long, OrgInfo> orgMap = this.orgListSearch(param, true);
        Integer count = orgMap.size();
        if (pageDto != null) {
            pageDto.setCount(count);
        }
        if (count == 0) {
            log.info("listAllOrgListDto - return - orgmap is empty");
            return new ArrayList<AllOrgListDto>();
        }
        Set<Long> orgIds = orgMap.keySet();
        if (pageDto != null) {
            HashSet<Long> orgIdsTemp = new HashSet<Long>();
            int cursor = 0;
            int limitFrom = pageDto.firstNum();
            int limitTo = pageDto.firstNum() + pageDto.getPageSize();
            for (Long orgId : orgIds) {
                if (cursor > limitTo) break;
                if (cursor >= limitFrom) {
                    orgIdsTemp.add(orgId);
                }
                ++cursor;
            }
            orgIds = orgIdsTemp;
        }
        ArrayList<AllOrgListDto> list = new ArrayList<AllOrgListDto>();
        if (CollectionUtils.isNotEmpty(orgIds)) {
            Map refundFeeMap = this.orgSignupRefundDao.mapRefundFeeByOrgIds(orgIds, startTime, endTime);
            Map kexiaoListMap = this.orgStudentKexiaoRecordDao.mapOrgChargeUnitStatisticDto(orgIds, startTime, endTime);
            Map dataMap = null;
            OrgInfo orgInfo = null;
            AllOrgListDto dto = null;
            Long refundFee = null;
            for (Long oid : orgIds) {
                orgInfo = orgMap.get(oid);
                dataMap = (Map)kexiaoListMap.get(oid);
                refundFee = (Long)refundFeeMap.get(oid);
                dto = new AllOrgListDto();
                dto.setOrgId(orgInfo.getOrgId().longValue());
                dto.setOrgName(orgInfo.getShortName());
                dto.setKexiaoTimes(0);
                dto.setKexiaoTimesMoney(0L);
                dto.setKexiaoMinute(0);
                dto.setKexiaoHourMoney(0L);
                if (dataMap != null) {
                    List codes;
                    ChargeUnitStatisticDto timesStatisticDto = (ChargeUnitStatisticDto)dataMap.get(ChargeUnit.BY_TIMES.getCode());
                    if (timesStatisticDto != null) {
                        dto.setKexiaoTimes(timesStatisticDto.getLineCount());
                        dto.setKexiaoTimesMoney(timesStatisticDto.getAmount());
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(codes = ChargeUnit.listByTimeCode()))) {
                        for (Integer code : codes) {
                            ChargeUnitStatisticDto durationStatisticDto = (ChargeUnitStatisticDto)dataMap.get(code);
                            if (durationStatisticDto == null) continue;
                            dto.setKexiaoMinute(dto.getKexiaoMinute() + durationStatisticDto.getLessonDurationMinute());
                            dto.setKexiaoHourMoney(dto.getKexiaoHourMoneyLong() + durationStatisticDto.getAmount());
                        }
                    }
                }
                if (refundFee != null) {
                    dto.setQuitClassMoney(refundFee);
                } else {
                    dto.setQuitClassMoney(0L);
                }
                dto.setTotalKexiaoMoney(dto.getKexiaoTimesMoneyLong() + dto.getKexiaoHourMoneyLong() + dto.getQuitClassMoneyLong());
                list.add(dto);
            }
        }
        return list;
    }

    @Override
    public AllOrgListDto getAllOrgListTotal(AllOrgListParamDto param) {
        Long mainOrgId = param.getMainOrgId();
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        DateUtil.durationUnderOneYearValidate((Date)startTime, (Date)endTime);
        AllOrgListDto dto = new AllOrgListDto();
        Integer kexiaoMinutes = 0;
        Long kexiaoHourMoney = 0L;
        Integer kexiaoTimes = 0;
        Long kexiaoTimesMoney = 0L;
        Long kexiaoTotalMoney = 0L;
        Long quitClassMoney = 0L;
        KexiaoSumDto durationDto = null;
        KexiaoSumDto timesDto = null;
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (param.getOrgId() != null) {
            orgIds.add(orgId);
            quitClassMoney = this.orgSignupRefundDao.sumRefundFeeByOrgIds(orgIds, startTime, endTime);
            durationDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, ChargeUnit.listByTimeCode(), startTime, endTime);
            timesDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, ChargeUnit.listByTimesCode(), startTime, endTime);
        } else {
            orgIds.add(mainOrgId);
            List subAccounts = this.orgSubAccountDao.getSlavesByMasterOrgId(Integer.valueOf(mainOrgId.intValue()), null);
            if (CollectionUtils.isNotEmpty((Collection)subAccounts)) {
                for (OrgSubAccount account : subAccounts) {
                    orgIds.add(account.getOrgId().longValue());
                }
            }
            quitClassMoney = this.orgSignupRefundDao.sumRefundFeeByOrgIds(orgIds, startTime, endTime);
            durationDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, ChargeUnit.listByTimeCode(), startTime, endTime);
            timesDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, ChargeUnit.listByTimesCode(), startTime, endTime);
        }
        if (durationDto != null) {
            kexiaoMinutes = durationDto.getSumKexiaoMinute();
            kexiaoHourMoney = kexiaoHourMoney + durationDto.getSumKexiaoMoney();
        }
        if (timesDto != null) {
            kexiaoTimes = timesDto.getSumKexiaoTimes();
            kexiaoTimesMoney = kexiaoTimesMoney + timesDto.getSumKexiaoMoney();
        }
        kexiaoTotalMoney = kexiaoTotalMoney + (kexiaoTimesMoney + kexiaoHourMoney + quitClassMoney);
        dto.setKexiaoMinute(kexiaoMinutes);
        dto.setKexiaoHourMoney(kexiaoHourMoney);
        dto.setKexiaoTimes(kexiaoTimes);
        dto.setKexiaoTimesMoney(kexiaoTimesMoney);
        dto.setTotalKexiaoMoney(kexiaoTotalMoney);
        dto.setQuitClassMoney(quitClassMoney);
        return dto;
    }

    Map<Long, OrgInfo> orgListSearch(AllOrgListParamDto param, boolean containsJoinType) {
        Long mainOrgId = param.getMainOrgId();
        Long orgId = param.getOrgId();
        HashMap<Long, OrgInfo> result = new HashMap<Long, OrgInfo>();
        if (orgId != null) {
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
            result.put(orgId, orgInfo);
        } else {
            List<Integer> orgIds = DashboardKeXiaoServiceImpl.getArrayList(mainOrgId.intValue());
            List subAccounts = this.orgSubAccountDao.getSlavesByMasterOrgId(Integer.valueOf(mainOrgId.intValue()), null);
            if (CollectionUtils.isNotEmpty((Collection)subAccounts)) {
                for (OrgSubAccount account : subAccounts) {
                    if (!containsJoinType && account.getAccountType() == 3) continue;
                    orgIds.add(account.getOrgId());
                }
            }
            List orgs = this.orgInfoDao.getOrgInfos(orgIds, new String[0]);
            for (OrgInfo orgInfo : orgs) {
                result.put(orgInfo.getOrgId().longValue(), orgInfo);
            }
        }
        return result;
    }

    @Override
    public OrgDetailStatisticsDto getOrgDetailStatisticsDto(Long orgId, Long startDate, Long endDate) {
        OrgDetailStatisticsDto dto = new OrgDetailStatisticsDto();
        Date startTime = startDate == null ? DateUtil.getCurrentDate() : new Date(startDate);
        Date endTime = endDate == null ? DateUtil.getDiffDateTime((Date)startTime, (int)1) : new Date(endDate);
        DateUtil.durationUnderOneYearValidate((Date)startTime, (Date)endTime);
        Integer todayKexiaoMinutes = 0;
        Integer todayKexiaoTimes = 0;
        Long todayKexiaoHourMoney = 0L;
        Long todayKexiaoTimesMoney = 0L;
        Long todayKexiaoTotalMoney = 0L;
        Long todayQuitClassMoney = 0L;
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
        List kexiaoRecords = this.orgStudentKexiaoRecordDao.listByOrgId(orgId, null, null, startTime, endTime);
        List signupRefunRecords = this.orgSignupRefundDao.listByUserId(orgId, null, null, startTime, endTime);
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                todayKexiaoTotalMoney = todayKexiaoTotalMoney + record.getAmount();
                if (ChargeUnit.isByTimes((int)record.getChargeUnit())) {
                    todayKexiaoTimes = todayKexiaoTimes + DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES;
                    todayKexiaoTimesMoney = todayKexiaoTimesMoney + record.getAmount();
                    continue;
                }
                todayKexiaoMinutes = todayKexiaoMinutes + record.getLessonDuration();
                todayKexiaoHourMoney = todayKexiaoHourMoney + record.getAmount();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefunRecords)) {
            for (OrgStudentKexiaoRecord record : signupRefunRecords) {
                todayKexiaoTotalMoney = todayKexiaoTotalMoney + record.getRefundFee();
                todayQuitClassMoney = todayQuitClassMoney + record.getRefundFee();
            }
        }
        dto.setOrgId(orgInfo.getOrgId().longValue());
        dto.setOrgName(orgInfo.getShortName());
        dto.setTodayKexiaoMinute(todayKexiaoMinutes);
        dto.setTodayKexiaoHourMoney(todayKexiaoHourMoney);
        dto.setTodayKexiaoTimes(todayKexiaoTimes);
        dto.setTodayKexiaoTimesMoney(todayKexiaoTimesMoney);
        dto.setTodayKexiaoTotalMoney(todayKexiaoTotalMoney);
        dto.setTodayQuitClassMoney(todayQuitClassMoney);
        dto.setKexiaoInfo();
        return dto;
    }

    @Override
    public List<OrgDetailClassListDto> listOrgDetailClassListDto(OrgDetailClassListParamDto param, PageDto pageDto) {
        long current = System.currentTimeMillis();
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        DateUtil.durationUnderOneYearValidate((Date)startTime, (Date)endTime);
        String keyword = param.getKeyword();
        List<Integer> courseTypes = param.getCourseTypeList();
        Integer chargeType = param.getChargeType();
        Integer chargeUnit = param.getChargeUnit();
        OrgAccount org = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        ArrayList<Long> orgClassIds = null;
        ArrayList<Long> kexiaoClassIds = this.orgStudentKexiaoRecordDao.pageDistinctClassId(orgId, null, startTime, endTime, null);
        List refundClassIds = this.orgSignupRefundDao.pageDistinctClassId(orgId, null, startTime, endTime, null);
        kexiaoClassIds.removeAll(refundClassIds);
        kexiaoClassIds.addAll(refundClassIds);
        if (param.conditionQuery()) {
            orgClassIds = this.orgCourseDao.listCourseId(Long.valueOf(org.getNumber().longValue()), keyword, courseTypes, chargeType, chargeUnit);
            orgClassIds.retainAll(kexiaoClassIds);
        } else {
            orgClassIds = kexiaoClassIds;
        }
        Integer count = orgClassIds.size();
        if (pageDto != null) {
            pageDto.setCount(count);
        }
        if (count == 0) {
            log.info("listOrgDetailClassListDto - return - kexiao record is empty");
            return new ArrayList<OrgDetailClassListDto>();
        }
        if (pageDto != null) {
            ArrayList<Long> orgClassIdsTemp = new ArrayList<Long>();
            int cursor = 0;
            int limitFrom = pageDto.firstNum();
            int limitTo = pageDto.firstNum() + pageDto.getPageSize() - 1;
            for (Long ocid : orgClassIds) {
                if (cursor > limitTo) break;
                if (cursor >= limitFrom) {
                    orgClassIdsTemp.add(ocid);
                }
                ++cursor;
            }
            orgClassIds = orgClassIdsTemp;
        }
        ArrayList<OrgDetailClassListDto> result = new ArrayList<OrgDetailClassListDto>();
        Map orgClassMap = this.orgCourseDao.getOrgCourseMap((Collection)orgClassIds, new String[0]);
        Map chargeUnitStatisticDtoMap = this.orgStudentKexiaoRecordDao.mapClassChargeUnitStatisticDto(orgId, (Collection)orgClassIds, startTime, endTime);
        Map refundFeeMap = this.orgSignupRefundDao.mapRefundFeeByClassIds((Collection)orgClassIds, startTime, endTime);
        for (Long classId : orgClassIds) {
            Map chargeUnitStatisticDtoData = (Map)chargeUnitStatisticDtoMap.get(classId);
            Long kexiaoMoney = 0L;
            Long refundFee = 0L;
            Integer kexiaoTimes = 0;
            Integer kexiaoMinutes = 0;
            OrgCourse orgClass = (OrgCourse)orgClassMap.get(classId);
            if (refundFeeMap.get(classId) != null) {
                refundFee = (Long)refundFeeMap.get(classId);
            }
            if (chargeUnitStatisticDtoData != null) {
                List codes;
                ChargeUnitStatisticDto data = (ChargeUnitStatisticDto)chargeUnitStatisticDtoData.get(ChargeUnit.BY_TIMES.getCode());
                if (data != null) {
                    kexiaoTimes = kexiaoTimes + data.getLineCount();
                    kexiaoMoney = kexiaoMoney + data.getAmount();
                }
                if (CollectionUtils.isNotEmpty((Collection)(codes = ChargeUnit.listByTimeCode()))) {
                    for (Integer code : codes) {
                        data = (ChargeUnitStatisticDto)chargeUnitStatisticDtoData.get(code);
                        if (data == null) continue;
                        kexiaoMinutes = data.getLessonDurationMinute();
                        kexiaoMoney = kexiaoMoney + data.getAmount();
                    }
                }
            }
            OrgDetailClassListDto dto = new OrgDetailClassListDto();
            dto.setChargeType(orgClass.getChargeType());
            dto.setChargeUnit(orgClass.getChargeUnit());
            dto.setClassId(orgClass.getId());
            dto.setClassName(orgClass.getName());
            dto.setCourseType(orgClass.getCourseType());
            dto.setKexiaoTimes(kexiaoTimes);
            dto.setKexiaoMinute(kexiaoMinutes);
            dto.setKexiaoMoney(kexiaoMoney);
            dto.setQuitClassMoney(refundFee);
            dto.setTotalKexiaoMoney(kexiaoMoney + refundFee);
            if (orgClass.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                dto.setKexiaoMinute(null);
            } else {
                dto.setKexiaoTimes(null);
            }
            result.add(dto);
        }
        log.info(" kexiao listOrgDetailClassListDto cost : {} ms", (Object)(System.currentTimeMillis() - current));
        return result;
    }

    @Override
    public OrgDetailClassListDto getOrgDetailClassListTotal(OrgDetailClassListParamDto param) {
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        DateUtil.durationUnderOneYearValidate((Date)startTime, (Date)endTime);
        String keyword = param.getKeyword();
        List<Integer> courseTypes = param.getCourseTypeList();
        Integer chargeType = param.getChargeType();
        Integer chargeUnit = param.getChargeUnit();
        OrgAccount org = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        OrgDetailClassListDto dto = new OrgDetailClassListDto();
        Integer kexiaoTimes = 0;
        Integer kexiaoMinutes = 0;
        Long kexiaoMoney = 0L;
        Long totalKexiaoMoney = 0L;
        Long quitClassMoney = 0L;
        KexiaoSumDto durationDto = null;
        KexiaoSumDto timesDto = null;
        List<Long> orgIds = DashboardKeXiaoServiceImpl.getArrayList(orgId);
        if (param.conditionQuery()) {
            List classIds = this.orgCourseDao.listCourseId(Long.valueOf(org.getNumber().longValue()), keyword, courseTypes, chargeType, chargeUnit);
            if (CollectionUtils.isNotEmpty((Collection)classIds)) {
                quitClassMoney = this.orgSignupRefundDao.sumRefundFeeByClassIds((Collection)classIds, startTime, endTime);
                durationDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, (Collection)classIds, null, ChargeUnit.listByTimeCode(), startTime, endTime);
                timesDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, (Collection)classIds, null, ChargeUnit.listByTimesCode(), startTime, endTime);
            }
        } else {
            quitClassMoney = this.orgSignupRefundDao.sumRefundFeeByOrgId(Long.valueOf(org.getId().longValue()), startTime, endTime);
            durationDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, ChargeUnit.listByTimeCode(), startTime, endTime);
            timesDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, ChargeUnit.listByTimesCode(), startTime, endTime);
        }
        if (durationDto != null) {
            kexiaoMinutes = durationDto.getSumKexiaoMinute();
            kexiaoMoney = kexiaoMoney + durationDto.getSumKexiaoMoney();
        }
        if (timesDto != null) {
            kexiaoTimes = timesDto.getSumKexiaoTimes();
            kexiaoMoney = kexiaoMoney + timesDto.getSumKexiaoMoney();
        }
        totalKexiaoMoney = kexiaoMoney + quitClassMoney;
        dto.setKexiaoTimes(kexiaoTimes);
        dto.setKexiaoMinute(kexiaoMinutes);
        dto.setKexiaoMoney(kexiaoMoney);
        dto.setTotalKexiaoMoney(totalKexiaoMoney);
        dto.setQuitClassMoney(quitClassMoney);
        return dto;
    }

    @Override
    public List<OrgDetailStudentListDto> listOrgDetailStudentListDto(OrgDetailStudentListParamDto param, PageDto pageDto) {
        long current = System.currentTimeMillis();
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        DateUtil.durationUnderOneYearValidate((Date)startTime, (Date)endTime);
        String keyword = param.getKeyword();
        ArrayList<Long> studentUserIds = null;
        ArrayList<Long> kexiaoUserIds = this.orgStudentKexiaoRecordDao.pageDistinctUserId(orgId, null, startTime, endTime, null);
        List refundUserIds = this.orgSignupRefundDao.pageDistinctUserId(orgId, null, startTime, endTime, null);
        kexiaoUserIds.removeAll(refundUserIds);
        kexiaoUserIds.addAll(refundUserIds);
        if (param.conditionQuery()) {
            studentUserIds = this.orgStudentDao.listUserId(orgId, keyword);
            studentUserIds.retainAll(kexiaoUserIds);
        } else {
            studentUserIds = kexiaoUserIds;
        }
        Integer count = studentUserIds.size();
        if (pageDto != null) {
            pageDto.setCount(count);
        }
        if (count == 0) {
            log.info("listOrgDetailStudentListDto - return - record is empty");
            return new ArrayList<OrgDetailStudentListDto>();
        }
        if (pageDto != null) {
            ArrayList<Long> studentUserIdsTemp = new ArrayList<Long>();
            int cursor = 0;
            int limitFrom = pageDto.firstNum();
            int limitTo = pageDto.firstNum() + pageDto.getPageSize() - 1;
            for (Long suid : studentUserIds) {
                if (cursor > limitTo) break;
                if (cursor >= limitFrom) {
                    studentUserIdsTemp.add(suid);
                }
                ++cursor;
            }
            studentUserIds = studentUserIdsTemp;
        }
        ArrayList<OrgDetailStudentListDto> result = new ArrayList<OrgDetailStudentListDto>();
        Map orgStudentMap = this.orgStudentDao.getOrgStudentMapByUserIds((Collection)studentUserIds);
        Map chargeUnitStatisticDtoMap = this.orgStudentKexiaoRecordDao.mapUserChargeUnitStatisticDto(orgId, (Collection)studentUserIds, startTime, endTime);
        Map refundFeeMap = this.orgSignupRefundDao.mapRefundFeeByUserIds(orgId, (Collection)studentUserIds, startTime, endTime);
        for (Long studentUserId : studentUserIds) {
            Map chargeUnitStatisticDtoData = (Map)chargeUnitStatisticDtoMap.get(studentUserId);
            Integer kexiaoTimes = 0;
            Integer kexiaoMinutes = 0;
            Long kexiaoTimesMoney = 0L;
            Long kexiaoHourMoney = 0L;
            Long refundFee = 0L;
            OrgStudent student = (OrgStudent)orgStudentMap.get(studentUserId);
            if (refundFeeMap.get(studentUserId) != null) {
                refundFee = (Long)refundFeeMap.get(studentUserId);
            }
            if (chargeUnitStatisticDtoData != null) {
                List codes;
                ChargeUnitStatisticDto data = (ChargeUnitStatisticDto)chargeUnitStatisticDtoData.get(ChargeUnit.BY_TIMES.getCode());
                if (data != null) {
                    kexiaoTimes = kexiaoTimes + data.getLineCount();
                    kexiaoTimesMoney = kexiaoTimesMoney + data.getAmount();
                }
                if (CollectionUtils.isNotEmpty((Collection)(codes = ChargeUnit.listByTimeCode()))) {
                    for (Integer code : codes) {
                        data = (ChargeUnitStatisticDto)chargeUnitStatisticDtoData.get(code);
                        if (data == null) continue;
                        kexiaoMinutes = data.getLessonDurationMinute();
                        kexiaoHourMoney = kexiaoHourMoney + data.getAmount();
                    }
                }
            }
            OrgDetailStudentListDto dto = new OrgDetailStudentListDto();
            dto.setStudentUserId(student.getUserId());
            dto.setStudentName(student.getName());
            dto.setKexiaoTimes(kexiaoTimes);
            dto.setKexiaoTimesMoney(kexiaoTimesMoney);
            dto.setKexiaoMinute(kexiaoMinutes);
            dto.setKexiaoHourMoney(kexiaoHourMoney);
            dto.setTotalKexiaoMoney(dto.getKexiaoTimesMoneyLong() + dto.getKexiaoHourMoneyLong());
            dto.setQuitClassMoney(refundFee);
            dto.setTotalKexiaoMoney(dto.getTotalKexiaoMoneyLong() + refundFee);
            result.add(dto);
        }
        log.info(" kexiao listOrgDetailStudentListDto cost time : {} ms ", (Object)(System.currentTimeMillis() - current));
        return result;
    }

    @Override
    public OrgDetailStudentListDto getOrgDetailStudentListTotal(OrgDetailStudentListParamDto param) {
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        DateUtil.durationUnderOneYearValidate((Date)startTime, (Date)endTime);
        String keyword = param.getKeyword();
        OrgDetailStudentListDto dto = new OrgDetailStudentListDto();
        Integer kexiaoTimes = 0;
        Integer kexiaoMinutes = 0;
        Long kexiaoTimesMoney = 0L;
        Long kexiaoHourMoney = 0L;
        Long totalKexiaoMoney = 0L;
        Long quitClassMoney = 0L;
        KexiaoSumDto durationDto = null;
        KexiaoSumDto timesDto = null;
        List<Long> orgIds = DashboardKeXiaoServiceImpl.getArrayList(orgId);
        if (param.conditionQuery()) {
            List studentUserIds = this.orgStudentDao.listUserId(orgId, keyword);
            if (CollectionUtils.isNotEmpty((Collection)studentUserIds)) {
                quitClassMoney = this.orgSignupRefundDao.sumRefundFeeByUserIds(orgId, (Collection)studentUserIds, startTime, endTime);
                durationDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, (Collection)studentUserIds, ChargeUnit.listByTimeCode(), startTime, endTime);
                timesDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, (Collection)studentUserIds, ChargeUnit.listByTimesCode(), startTime, endTime);
            }
        } else {
            quitClassMoney = this.orgSignupRefundDao.sumRefundFeeByOrgId(orgId, startTime, endTime);
            durationDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, ChargeUnit.listByTimeCode(), startTime, endTime);
            timesDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, ChargeUnit.listByTimesCode(), startTime, endTime);
        }
        if (durationDto != null) {
            kexiaoMinutes = durationDto.getSumKexiaoMinute();
            kexiaoHourMoney = kexiaoHourMoney + durationDto.getSumKexiaoMoney();
        }
        if (timesDto != null) {
            kexiaoTimes = timesDto.getSumKexiaoTimes();
            kexiaoTimesMoney = kexiaoTimesMoney + timesDto.getSumKexiaoMoney();
        }
        totalKexiaoMoney = kexiaoTimesMoney + kexiaoHourMoney + quitClassMoney;
        dto.setKexiaoTimes(kexiaoTimes);
        dto.setKexiaoMinute(kexiaoMinutes);
        dto.setKexiaoTimesMoney(kexiaoTimesMoney);
        dto.setKexiaoHourMoney(kexiaoHourMoney);
        dto.setTotalKexiaoMoney(totalKexiaoMoney);
        dto.setQuitClassMoney(quitClassMoney);
        return dto;
    }

    @Override
    public List<OrgDetailKexiaoListDto> listOrgDetailKexiaoListDto(OrgDetailKexiaoListParamDto param, PageDto pageDto) {
        OrgCourse orgClass;
        OrgStudent student;
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        DateUtil.durationUnderOneYearValidate((Date)startTime, (Date)endTime);
        OrgAccount org = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        List classIds = null;
        if (param.conditionQuery() && CollectionUtils.isEmpty((Collection)(classIds = this.orgCourseDao.listCourseId(Long.valueOf(org.getNumber().longValue()), param.getKeyword(), null, null, null)))) {
            log.info("listOrgDetailKexiaoListDto - return - search is empty");
            pageDto.setCount(Integer.valueOf(0));
            return new ArrayList<OrgDetailKexiaoListDto>();
        }
        Integer count = 0;
        List kexiaoRecords = null;
        List signupRefunRecords = null;
        count = this.orgStudentKexiaoRecordDao.countByClassIds(orgId, (Collection)classIds, startTime, endTime);
        count = count + this.orgSignupRefundDao.countByClassIds(orgId, (Collection)classIds, startTime, endTime);
        kexiaoRecords = this.orgStudentKexiaoRecordDao.pageByClassIds(orgId, (Collection)classIds, startTime, endTime, pageDto);
        if (pageDto != null) {
            pageDto.setCount(count);
            if (kexiaoRecords.size() < pageDto.getPageSize()) {
                PageDto pageDtoTemp = new PageDto();
                pageDtoTemp.setPageNum(Integer.valueOf(1));
                pageDtoTemp.setPageSize(Integer.valueOf(pageDto.getPageSize() - kexiaoRecords.size()));
                signupRefunRecords = this.orgSignupRefundDao.pageByClassIds(orgId, (Collection)classIds, startTime, endTime, pageDtoTemp);
            }
        } else {
            signupRefunRecords = this.orgSignupRefundDao.pageByClassIds(orgId, (Collection)classIds, startTime, endTime, null);
        }
        if (CollectionUtils.isEmpty((Collection)kexiaoRecords) && CollectionUtils.isEmpty((Collection)signupRefunRecords)) {
            log.info("listOrgDetailKexiaoListDto - return - record is empty");
            if (pageDto == null) {
                pageDto = new PageDto();
            }
            pageDto.setCount(Integer.valueOf(0));
            return new ArrayList<OrgDetailKexiaoListDto>();
        }
        ArrayList<OrgDetailKexiaoListDto> result = new ArrayList<OrgDetailKexiaoListDto>();
        Map studentMapKeyUserId = null;
        Map classMapKeyCourseId = null;
        OrgDetailKexiaoListDto dto = null;
        HashSet<Long> studentUserIdsInPage = new HashSet<Long>();
        HashSet<Long> classIdsInPage = new HashSet<Long>();
        HashSet<Long> lessonIds = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                studentUserIdsInPage.add(record.getUserId());
                classIdsInPage.add(record.getClassId());
                lessonIds.add(record.getLessonId());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefunRecords)) {
            for (OrgStudentKexiaoRecord record : signupRefunRecords) {
                studentUserIdsInPage.add(record.getUserId());
                classIdsInPage.add(record.getClassId());
            }
        }
        if (CollectionUtils.isNotEmpty(studentUserIdsInPage)) {
            studentMapKeyUserId = this.orgStudentDao.getStudentMap(studentUserIdsInPage, orgId, new String[0]);
        }
        if (CollectionUtils.isNotEmpty(classIdsInPage)) {
            classMapKeyCourseId = this.orgCourseDao.getOrgCourseMap(classIdsInPage, new String[0]);
        }
        Map<Long, Teacher> lessonTeacherMap = this.getLessonTeacherMap(orgId, lessonIds);
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecords)) {
            student = null;
            orgClass = null;
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                orgClass = (OrgCourse)classMapKeyCourseId.get(record.getClassId());
                student = (OrgStudent)studentMapKeyUserId.get(record.getUserId());
                Teacher teacher = lessonTeacherMap.get(record.getLessonId());
                dto = new OrgDetailKexiaoListDto();
                if (teacher != null) {
                    dto.setTeacherName(teacher.getRealName());
                }
                dto.setStudentName(student.getName());
                dto.setStudentUserId(student.getUserId());
                dto.setClassId(orgClass.getId());
                dto.setClassName(orgClass.getName());
                dto.setCourseType(orgClass.getCourseType());
                dto.setChargeUnit(orgClass.getChargeUnit());
                dto.setChargeType(orgClass.getChargeType());
                dto.setLessonStartTime(record.getStartTime());
                dto.setLessonEndTime(DateUtil.getDiffMinute((Date)record.getStartTime(), (int)record.getLessonDuration()));
                dto.setKexiaoMoney(record.getAmount());
                dto.setQuitClassMoney(0L);
                dto.setTotalKexiaoMoney(dto.getKexiaoMoneyLong());
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    dto.setLessonTimes(DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES);
                } else {
                    dto.setLessonMinute(record.getLessonDuration());
                }
                result.add(dto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefunRecords)) {
            student = null;
            orgClass = null;
            for (OrgStudentKexiaoRecord record : signupRefunRecords) {
                orgClass = (OrgCourse)classMapKeyCourseId.get(record.getClassId());
                student = (OrgStudent)studentMapKeyUserId.get(record.getUserId());
                dto = new OrgDetailKexiaoListDto();
                dto.setStudentName(student.getName());
                dto.setStudentUserId(student.getUserId());
                dto.setClassId(orgClass.getId());
                dto.setClassName(orgClass.getName());
                dto.setCourseType(orgClass.getChargeType());
                dto.setChargeUnit(orgClass.getChargeUnit());
                dto.setChargeType(orgClass.getChargeType());
                dto.setKexiaoMoney(0L);
                dto.setQuitClassMoney(record.getRefundFee());
                dto.setTotalKexiaoMoney(dto.getQuitClassMoneyLong());
                dto.setQuitClassTime(record.getCreateTime());
                result.add(dto);
            }
        }
        return result;
    }

    private Map<Long, Teacher> getLessonTeacherMap(Long orgId, Collection<Long> lessonIds) {
        Map lessonTeacherIdMap;
        HashMap<Long, Teacher> lessonTeacherMap = new HashMap<Long, Teacher>();
        if (CollectionUtils.isNotEmpty(lessonIds) && !(lessonTeacherIdMap = this.teacherLessonDao.queryLessonTeacherIdMap(orgId, lessonIds)).isEmpty()) {
            List teachers = this.teacherDao.getByUserIds(lessonTeacherIdMap.values(), new String[]{"userId", "id", "realName"});
            Map teacherMap = CollectionHelper.toKeyMap((Collection)teachers, (String)"userId");
            for (Long lessonId : lessonIds) {
                Long userId = (Long)lessonTeacherIdMap.get(lessonId);
                Teacher teacher = (Teacher)teacherMap.get(userId);
                lessonTeacherMap.put(lessonId, teacher);
            }
        }
        return lessonTeacherMap;
    }

    @Override
    public OrgDetailKexiaoListDto getOrgDetailKexiaoListTotal(OrgDetailKexiaoListParamDto param) {
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        DateUtil.durationUnderOneYearValidate((Date)startTime, (Date)endTime);
        OrgAccount org = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        OrgDetailKexiaoListDto dto = new OrgDetailKexiaoListDto();
        Integer lessonMinutes = 0;
        Integer lessonTimes = 0;
        Long kexiaoMoney = 0L;
        Long quitClassMoney = 0L;
        Long totalKexiaoMoney = 0L;
        KexiaoSumDto durationDto = null;
        KexiaoSumDto timesDto = null;
        List classIds = null;
        if (param.conditionQuery() && CollectionUtils.isEmpty((Collection)(classIds = this.orgCourseDao.listCourseId(Long.valueOf(org.getNumber().longValue()), param.getKeyword(), null, null, null)))) {
            dto.setKexiaoMoney(kexiaoMoney);
            dto.setQuitClassMoney(quitClassMoney);
            dto.setTotalKexiaoMoney(totalKexiaoMoney);
            dto.setLessonTimes(lessonTimes);
            dto.setLessonMinute(lessonMinutes);
            log.info("listOrgDetailKexiaoListDto - return - search is empty");
            return dto;
        }
        List<Long> orgIds = DashboardKeXiaoServiceImpl.getArrayList(orgId);
        durationDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, classIds, null, ChargeUnit.listByTimeCode(), startTime, endTime);
        timesDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, (Collection)classIds, null, ChargeUnit.listByTimesCode(), startTime, endTime);
        quitClassMoney = this.orgSignupRefundDao.sumRefundFeeByOrgIds(orgIds, startTime, endTime);
        if (durationDto != null) {
            lessonMinutes = durationDto.getSumKexiaoMinute();
            kexiaoMoney = kexiaoMoney + durationDto.getSumKexiaoMoney();
        }
        if (timesDto != null) {
            lessonTimes = timesDto.getSumKexiaoTimes();
            kexiaoMoney = kexiaoMoney + timesDto.getSumKexiaoMoney();
        }
        totalKexiaoMoney = kexiaoMoney + quitClassMoney;
        dto.setKexiaoMoney(kexiaoMoney);
        dto.setQuitClassMoney(quitClassMoney);
        dto.setTotalKexiaoMoney(totalKexiaoMoney);
        dto.setLessonTimes(lessonTimes);
        dto.setLessonMinute(lessonMinutes);
        return dto;
    }

    @Override
    public ClassDetailStatisticsDto getClassDetailStatisticsDto(Long orgId, Long classId) {
        ClassDetailStatisticsDto dto = new ClassDetailStatisticsDto();
        Date startTime = DateUtil.getCurrentDate();
        Date endTime = DateUtil.getDiffDateTime((Date)startTime, (int)1);
        OrgCourse orgClass = this.orgCourseDao.getByCourseId(classId, new String[0]);
        long courseId = classId;
        if (orgClass.getParentId() != null && orgClass.getParentId() > 0L) {
            courseId = orgClass.getParentId();
        }
        OrgCourseConsumeRule kexiaoRule = this.courseConsumeRuleDao.getRuleByCourseId(orgId, Long.valueOf(courseId));
        Integer studentCount = this.orgStudentCourseDao.countStudents(orgId, classId, Integer.valueOf(StudentCourseStatus.NORMAL.getCode()));
        Long todayKexiaoMoney = 0L;
        Long todayQuitClassMoney = 0L;
        Integer todayKexiaoMinutes = 0;
        Integer todayKexiaoTimes = 0;
        List kexiaoRecords = this.orgStudentKexiaoRecordDao.listByClassId(orgId, classId, null, startTime, endTime);
        List signupRefunRecords = this.orgSignupRefundDao.listByClassId(orgId, classId, null, startTime, endTime);
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                todayKexiaoMoney = todayKexiaoMoney + record.getAmount();
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    todayKexiaoTimes = todayKexiaoTimes + DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES;
                    continue;
                }
                todayKexiaoMinutes = todayKexiaoMinutes + record.getLessonDuration();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefunRecords)) {
            for (OrgStudentKexiaoRecord record : signupRefunRecords) {
                todayKexiaoMoney = todayKexiaoMoney + record.getRefundFee();
                todayQuitClassMoney = todayQuitClassMoney + record.getRefundFee();
            }
        }
        dto.setClassId(orgClass.getId());
        dto.setClassName(orgClass.getName());
        dto.setTodayQuitClassMoney(todayQuitClassMoney);
        dto.setTodayKexiaoMinute(todayKexiaoMinutes);
        dto.setTodayKexiaoMoney(todayKexiaoMoney);
        dto.setTodayKexiaoTimes(todayKexiaoTimes);
        dto.setStudentCount(studentCount);
        dto.setChargeType(orgClass.getChargeType());
        dto.setChargeUnit(orgClass.getChargeUnit());
        if (kexiaoRule != null) {
            dto.setKexiaoRule(kexiaoRule.getRuleValue());
        }
        return dto;
    }

    @Override
    public List<ClassDetailListDto> listClassDetailListDto(ClassDetailListParamDto param, PageDto pageDto) {
        Long orgId = param.getOrgId();
        Long classId = param.getClassId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        DateUtil.durationUnderOneYearValidate((Date)startTime, (Date)endTime);
        Map<Long, OrgStudent> orgStudentMap = this.classDetailListSearch(param);
        if (MapUtils.isEmpty(orgStudentMap)) {
            log.info("listClassDetailListDto - return - studentCourses is empty");
            return new ArrayList<ClassDetailListDto>();
        }
        Set<Long> studentUserIds = orgStudentMap.keySet();
        Object kexiaoRecordIds = this.orgStudentKexiaoRecordDao.listIdsByClassId(orgId, classId, studentUserIds, startTime, endTime);
        ArrayList<Integer> signupRefunIds = this.orgSignupRefundDao.listIdsByClassId(orgId, classId, studentUserIds, startTime, endTime);
        List kexiaoRecords = null;
        List signupRefunRecords = null;
        HashSet<Long> lessonIds = new HashSet<Long>();
        Integer count = kexiaoRecordIds.size() + signupRefunIds.size();
        if (pageDto != null) {
            pageDto.setCount(count);
        }
        if (count == 0) {
            log.info("listClassDetailListDto - return - kexiao record is empty");
            return new ArrayList<ClassDetailListDto>();
        }
        if (pageDto != null) {
            ArrayList kexiaoRecordIdsTemp = new ArrayList();
            ArrayList<Integer> signupRefunIdsTemp = new ArrayList<Integer>();
            int cursor = 0;
            int limitFrom = pageDto.firstNum();
            int limitTo = pageDto.firstNum() + pageDto.getPageSize() - 1;
            Iterator iterator = kexiaoRecordIds.iterator();
            while (iterator.hasNext()) {
                Long kxid = (Long)iterator.next();
                if (cursor > limitTo) break;
                if (cursor >= limitFrom) {
                    kexiaoRecordIdsTemp.add(kxid);
                }
                ++cursor;
            }
            for (Integer srid : signupRefunIds) {
                if (cursor > limitTo) break;
                if (cursor >= limitFrom) {
                    signupRefunIdsTemp.add(srid);
                }
                ++cursor;
            }
            kexiaoRecordIds = kexiaoRecordIdsTemp;
            signupRefunIds = signupRefunIdsTemp;
        }
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecordIds)) {
            kexiaoRecords = this.orgStudentKexiaoRecordDao.listOrderByStartTime((List)kexiaoRecordIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefunIds)) {
            signupRefunRecords = this.orgSignupRefundDao.listOrderByCreateTime((List)signupRefunIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                lessonIds.add(record.getLessonId());
            }
        }
        Map<Long, Teacher> lessonTeacherMap = this.getLessonTeacherMap(orgId, lessonIds);
        ArrayList<ClassDetailListDto> result = new ArrayList<ClassDetailListDto>();
        ClassDetailListDto dto = null;
        OrgStudent student = null;
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                student = orgStudentMap.get(record.getUserId());
                dto = new ClassDetailListDto();
                Teacher teacher = lessonTeacherMap.get(record.getLessonId());
                if (teacher != null) {
                    dto.setTeacherName(teacher.getRealName());
                }
                dto.setStudentUserId(student.getUserId());
                dto.setStudentName(student.getName());
                dto.setLessonStartTime(record.getStartTime());
                dto.setLessonEndTime(DateUtil.getDiffMinute((Date)record.getStartTime(), (int)record.getLessonDuration()));
                dto.setKexiaoMoney(record.getAmount());
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    dto.setLessonTimes(DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES);
                } else {
                    dto.setLessonMinute(record.getLessonDuration());
                }
                OrgLessonSign signData = this.orgLessonSignDao.getStudentLessonSign(orgId, classId, record.getLessonId(), student.getUserId(), Integer.valueOf(UserRole.STUDENT.getRole()));
                if (signData != null) {
                    dto.setSigninStatus(signData.getStatus());
                }
                result.add(dto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefunIds)) {
            for (OrgStudentKexiaoRecord record : signupRefunRecords) {
                student = orgStudentMap.get(record.getUserId());
                dto = new ClassDetailListDto();
                dto.setStudentUserId(student.getUserId());
                dto.setStudentName(student.getName());
                dto.setLessonStartTime(record.getCreateTime());
                dto.setKexiaoMoney(record.getRefundFee());
                dto.setQuitClassTime(record.getCreateTime());
                dto.setLessonMinute(null);
                result.add(dto);
            }
        }
        return result;
    }

    @Override
    public ClassDetailListDto getClassDetailListTotal(ClassDetailListParamDto param) {
        ClassDetailListDto result = new ClassDetailListDto();
        Long orgId = param.getOrgId();
        Long classId = param.getClassId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        DateUtil.durationUnderOneYearValidate((Date)startTime, (Date)endTime);
        Map<Long, OrgStudent> orgStudentMap = this.classDetailListSearch(param);
        if (MapUtils.isEmpty(orgStudentMap)) {
            log.info("getClassDetailListTotal - return - studentCourses is empty");
            result.setLessonMinute(null);
            result.setLessonTimes(null);
            result.setKexiaoMoney(0L);
            return result;
        }
        Set<Long> studentUserIds = orgStudentMap.keySet();
        List kexiaoRecords = this.orgStudentKexiaoRecordDao.listByClassId(orgId, classId, studentUserIds, startTime, endTime);
        List signupRefuns = this.orgSignupRefundDao.listByClassId(orgId, classId, studentUserIds, startTime, endTime);
        Integer lessonMinutes = 0;
        Integer lessonTimes = 0;
        Long kexiaoMoney = 0L;
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                kexiaoMoney = kexiaoMoney + record.getAmount();
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    lessonTimes = lessonTimes + DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES;
                    continue;
                }
                lessonMinutes = lessonMinutes + record.getLessonDuration();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefuns)) {
            for (OrgStudentKexiaoRecord record : signupRefuns) {
                kexiaoMoney = kexiaoMoney + record.getRefundFee();
            }
        }
        result.setLessonMinute(lessonMinutes);
        result.setLessonTimes(lessonTimes);
        result.setKexiaoMoney(kexiaoMoney);
        return result;
    }

    Map<Long, OrgStudent> classDetailListSearch(ClassDetailListParamDto param) {
        Long orgId = param.getOrgId();
        Long classId = param.getClassId();
        String keyword = param.getKeyword();
        List studentClass = this.orgStudentCourseDao.listByCourseId(orgId, classId, null, null);
        HashSet<Long> studentUserIds = null;
        if (CollectionUtils.isNotEmpty((Collection)studentClass)) {
            studentUserIds = new HashSet<Long>();
            for (OrgStudentCourse osc : studentClass) {
                studentUserIds.add(osc.getUserId());
            }
        } else {
            log.info("classDetailListSearch - return - studentCourses is empty");
            return null;
        }
        HashMap<Long, OrgStudent> orgStudentMap = this.orgStudentDao.getStudentMap(studentUserIds, orgId, new String[0]);
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            HashMap<Long, OrgStudent> orgStudentMapTemp = new HashMap<Long, OrgStudent>();
            OrgStudent student = null;
            for (Long key : orgStudentMap.keySet()) {
                student = (OrgStudent)orgStudentMap.get(key);
                if (!student.getName().contains(keyword)) continue;
                orgStudentMapTemp.put(key, student);
            }
            orgStudentMap = orgStudentMapTemp;
        }
        return orgStudentMap;
    }

    @Override
    public StudentDetailStatisticsDto getStudentDetailStatisticsDto(Long orgId, Long studentUserId) {
        StudentDetailStatisticsDto dto = new StudentDetailStatisticsDto();
        Date startTime = DateUtil.getCurrentDate();
        Date endTime = DateUtil.getDiffDateTime((Date)startTime, (int)1);
        OrgStudent student = this.orgStudentDao.getStudentByUserId(orgId, studentUserId, new String[0]);
        Map map = this.kexiaoApiService.queryUserKexiaoStat(orgId, Arrays.asList(studentUserId));
        Integer classCount = this.orgStudentCourseDao.getStudentSignupCourseCount(orgId, studentUserId, Integer.valueOf(StudentCourseStatus.NORMAL.getCode()));
        KexiaoStudentStat stat = (KexiaoStudentStat)map.get(studentUserId);
        if (stat == null) {
            stat = new KexiaoStudentStat();
        }
        Long payMoney = 0L;
        Long remainingMoney = 0L;
        Integer todayKexiaoMinutes = 0;
        Long todayKexiaoHourMoney = 0L;
        Integer todayKexiaoTimes = 0;
        Long todayKexiaoTimesMoney = 0L;
        Long todayKexiaoTotalMoney = 0L;
        Long quitClassMoney = 0L;
        List todayKexiaoRecords = this.orgStudentKexiaoRecordDao.listByUserId(orgId, null, studentUserId, startTime, endTime);
        List todaySignupRefunRecords = this.orgSignupRefundDao.listByUserId(orgId, null, studentUserId, startTime, endTime);
        for (OrgStudentKexiaoRecord record : todayKexiaoRecords) {
            if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                todayKexiaoTimes = todayKexiaoTimes + DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES;
                todayKexiaoTimesMoney = todayKexiaoTimesMoney + record.getAmount();
                continue;
            }
            todayKexiaoMinutes = todayKexiaoMinutes + record.getLessonDuration();
            todayKexiaoHourMoney = todayKexiaoHourMoney + record.getAmount();
        }
        for (OrgStudentKexiaoRecord record : todaySignupRefunRecords) {
            quitClassMoney = quitClassMoney + record.getRefundFee();
        }
        todayKexiaoTotalMoney = todayKexiaoTotalMoney + todayKexiaoTimesMoney;
        todayKexiaoTotalMoney = todayKexiaoTotalMoney + todayKexiaoHourMoney;
        todayKexiaoTotalMoney = todayKexiaoTotalMoney + quitClassMoney;
        dto.setStudentUserId(student.getUserId());
        dto.setStudentName(student.getName());
        dto.setClassCount(classCount);
        TxStudentFinanceAccount account = this.studentFinanceAccountDao.getFinanceAccount(orgId, student.getId());
        int balance = 0;
        if (account != null) {
            balance = (int)((long)balance + account.getBalance());
        }
        dto.setPayMoney(stat.getTotalAmount() + (long)balance);
        dto.setRemainingMoney(stat.getLeftAmount());
        dto.setTodayKexiaoMinute(todayKexiaoMinutes);
        dto.setTodayKexiaoHourMoney(todayKexiaoHourMoney);
        dto.setTodayKexiaoTimes(todayKexiaoTimes);
        dto.setTodayKexiaoTimesMoney(todayKexiaoTimesMoney);
        dto.setTodayKexiaoTotalMoney(todayKexiaoTotalMoney);
        dto.setTodayQuitClassMoney(quitClassMoney);
        return dto;
    }

    @Override
    public List<StudentDetailListDto> listStudentDetailListDto(StudentDetailListParamDto param, PageDto pageDto) {
        Long orgId = param.getOrgId();
        Long userId = param.getStudentUserId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        DateUtil.durationUnderOneYearValidate((Date)startTime, (Date)endTime);
        Map<Long, OrgCourse> orgClassMap = this.studentDetailListSearch(param);
        if (MapUtils.isEmpty(orgClassMap)) {
            log.info("listStudentDetailListDto - return - studentCourses is empty");
            return new ArrayList<StudentDetailListDto>();
        }
        Set<Long> classIds = orgClassMap.keySet();
        ArrayList<Long> kexiaoRecordIds = this.orgStudentKexiaoRecordDao.listIdsByUserId(orgId, classIds, userId, startTime, endTime);
        Object signupRefunIds = this.orgSignupRefundDao.listIdsByUserId(orgId, classIds, userId, startTime, endTime);
        List kexiaoRecords = null;
        List signupRefunRecords = null;
        Integer count = kexiaoRecordIds.size() + signupRefunIds.size();
        if (pageDto != null) {
            pageDto.setCount(count);
        }
        if (count == 0) {
            log.info("listStudentDetailListDto - return - kexiao record is empty");
            return new ArrayList<StudentDetailListDto>();
        }
        if (pageDto != null) {
            ArrayList<Long> kexiaoRecordIdsTemp = new ArrayList<Long>();
            ArrayList signupRefunIdsTemp = new ArrayList();
            int cursor = 0;
            int limitFrom = pageDto.firstNum();
            int limitTo = pageDto.firstNum() + pageDto.getPageSize() - 1;
            for (Long kxid : kexiaoRecordIds) {
                if (cursor > limitTo) break;
                if (cursor >= limitFrom) {
                    kexiaoRecordIdsTemp.add(kxid);
                }
                ++cursor;
            }
            Iterator iterator = signupRefunIds.iterator();
            while (iterator.hasNext()) {
                Integer srid = (Integer)iterator.next();
                if (cursor > limitTo) break;
                if (cursor >= limitFrom) {
                    signupRefunIdsTemp.add(srid);
                }
                ++cursor;
            }
            kexiaoRecordIds = kexiaoRecordIdsTemp;
            signupRefunIds = signupRefunIdsTemp;
        }
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecordIds)) {
            kexiaoRecords = this.orgStudentKexiaoRecordDao.listOrderByStartTime((List)kexiaoRecordIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefunIds)) {
            signupRefunRecords = this.orgSignupRefundDao.listOrderByCreateTime((List)signupRefunIds);
        }
        HashSet<Long> lessonIds = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                lessonIds.add(record.getLessonId());
            }
        }
        Map<Long, Teacher> lessonTeacherMap = this.getLessonTeacherMap(orgId, lessonIds);
        ArrayList<StudentDetailListDto> result = new ArrayList<StudentDetailListDto>();
        StudentDetailListDto dto = null;
        OrgCourse orgClass = null;
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecords)) {
            Map lessonIdVsSigninStatusMap = this.orgLessonSignDao.mapKeyLessonIdValueStatus(orgId, userId);
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                orgClass = orgClassMap.get(record.getClassId());
                dto = new StudentDetailListDto();
                Teacher teacher = lessonTeacherMap.get(record.getLessonId());
                if (teacher != null) {
                    dto.setTeacherName(teacher.getRealName());
                }
                dto.setClassId(orgClass.getId());
                dto.setClassName(orgClass.getName());
                dto.setLessonStartTime(record.getStartTime());
                dto.setLessonEndTime(DateUtil.getDiffMinute((Date)record.getStartTime(), (int)record.getLessonDuration()));
                dto.setKexiaoMoney(record.getAmount());
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    dto.setLessonTimes(DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES);
                } else {
                    dto.setLessonMinute(record.getLessonDuration());
                }
                dto.setSigninStatus((Integer)lessonIdVsSigninStatusMap.get(record.getLessonId()));
                result.add(dto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefunIds)) {
            for (OrgSignupRefund record : signupRefunRecords) {
                orgClass = orgClassMap.get(record.getClassId());
                dto = new StudentDetailListDto();
                dto.setClassId(orgClass.getId());
                dto.setClassName(orgClass.getName());
                dto.setLessonStartTime(record.getCreateTime());
                dto.setKexiaoMoney(record.getRefundFee());
                dto.setQuitClassTime(record.getCreateTime());
                result.add(dto);
            }
        }
        return result;
    }

    @Override
    public StudentDetailListDto getStudentDetailListTotal(StudentDetailListParamDto param) {
        StudentDetailListDto result = new StudentDetailListDto();
        Long orgId = param.getOrgId();
        Long userId = param.getStudentUserId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        DateUtil.durationUnderOneYearValidate((Date)startTime, (Date)endTime);
        Map<Long, OrgCourse> orgClassMap = this.studentDetailListSearch(param);
        if (MapUtils.isEmpty(orgClassMap)) {
            log.info("getStudentDetailListDtoTotal - return - studentCourses is empty");
            result.setLessonMinute(null);
            result.setLessonTimes(null);
            result.setKexiaoMoney(0L);
            return result;
        }
        Set<Long> classIds = orgClassMap.keySet();
        List kexiaoRecords = this.orgStudentKexiaoRecordDao.listByUserId(orgId, classIds, userId, startTime, endTime);
        List signupRefuns = this.orgSignupRefundDao.listByUserId(orgId, classIds, userId, startTime, endTime);
        Integer lessonMinutes = 0;
        Integer lessonTimes = 0;
        Long kexiaoMoney = 0L;
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                kexiaoMoney = kexiaoMoney + record.getAmount();
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    lessonTimes = lessonTimes + DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES;
                    continue;
                }
                lessonMinutes = lessonMinutes + record.getLessonDuration();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefuns)) {
            for (OrgStudentKexiaoRecord record : signupRefuns) {
                kexiaoMoney = kexiaoMoney + record.getRefundFee();
            }
        }
        result.setLessonMinute(lessonMinutes);
        result.setLessonTimes(lessonTimes);
        result.setKexiaoMoney(kexiaoMoney);
        return result;
    }

    Map<Long, OrgCourse> studentDetailListSearch(StudentDetailListParamDto param) {
        Long orgId = param.getOrgId();
        Long userId = param.getStudentUserId();
        String keyword = param.getKeyword();
        List studentClass = this.orgStudentCourseDao.listByUserId(orgId, userId, null, null);
        HashSet<Long> classIds = null;
        if (CollectionUtils.isNotEmpty((Collection)studentClass)) {
            classIds = new HashSet<Long>();
            for (OrgStudentCourse osc : studentClass) {
                classIds.add(osc.getCourseId());
            }
        } else {
            log.info("StudentDetailListDtoSearch - return - studentCourses is empty");
            return null;
        }
        HashMap<Long, OrgCourse> orgClassMap = this.orgCourseDao.getOrgCourseMap(classIds, new String[0]);
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            HashMap<Long, OrgCourse> orgClassMapTemp = new HashMap<Long, OrgCourse>();
            OrgCourse orgClass = null;
            for (Long key : orgClassMap.keySet()) {
                orgClass = (OrgCourse)orgClassMap.get(key);
                if (!orgClass.getName().contains(keyword)) continue;
                orgClassMapTemp.put(key, orgClass);
            }
            orgClassMap = orgClassMapTemp;
        }
        return orgClassMap;
    }
}

