/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.dto.unKexiao.reponse;

import com.baijia.tianxiao.biz.dashboard.dto.unKexiao.reponse.UnKexiaoStatisticsDto;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;

public class StudentUnKexiaoDto
extends UnKexiaoStatisticsDto {
    private Long studentUserId;
    private String studentName;
    private Integer isDel;

    public static StudentUnKexiaoDto from(OrgStudent orgStudent, UnKexiaoStatisticsDto statisticsDto) {
        StudentUnKexiaoDto studentDto = new StudentUnKexiaoDto();
        if (orgStudent != null) {
            studentDto.setStudentUserId(orgStudent.getUserId());
            String name = orgStudent.getName();
            if (orgStudent.getDelStatus() == 1) {
                name = name + "(\u5df2\u5220\u9664)";
            }
            studentDto.setStudentName(name);
            studentDto.setIsDel(orgStudent.getDelStatus());
        }
        if (statisticsDto == null) {
            statisticsDto = UnKexiaoStatisticsDto.createWithZeroValue();
        }
        BeanUtils.copyProperties((Object)statisticsDto, (Object)studentDto);
        return studentDto;
    }

    public static List<StudentUnKexiaoDto> listFrom(List<Long> userIds, @NonNull Map<Long, OrgStudent> OrgStudentMap, @NonNull Map<Long, UnKexiaoStatisticsDto> statisticsDtoMap) {
        if (OrgStudentMap == null) {
            throw new NullPointerException("OrgStudentMap");
        }
        if (statisticsDtoMap == null) {
            throw new NullPointerException("statisticsDtoMap");
        }
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (Long userId : userIds) {
            StudentUnKexiaoDto studentDto = StudentUnKexiaoDto.from(OrgStudentMap.get(userId), statisticsDtoMap.get(userId));
            result.add(studentDto);
        }
        return result;
    }

    public static UnKexiaoStatisticsDto sum(List<StudentUnKexiaoDto> dtoList) {
        UnKexiaoStatisticsDto sumDto = UnKexiaoStatisticsDto.createWithZeroValue();
        for (StudentUnKexiaoDto dto : dtoList) {
            sumDto.add(dto);
        }
        sumDto.transferUnit();
        return sumDto;
    }

    public Long getStudentUserId() {
        return this.studentUserId;
    }

    public String getStudentName() {
        return this.studentName;
    }

    public Integer getIsDel() {
        return this.isDel;
    }

    public void setStudentUserId(Long studentUserId) {
        this.studentUserId = studentUserId;
    }

    public void setStudentName(String studentName) {
        this.studentName = studentName;
    }

    public void setIsDel(Integer isDel) {
        this.isDel = isDel;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StudentUnKexiaoDto)) {
            return false;
        }
        StudentUnKexiaoDto other = (StudentUnKexiaoDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$studentUserId = this.getStudentUserId();
        Long other$studentUserId = other.getStudentUserId();
        if (this$studentUserId == null ? other$studentUserId != null : !((Object)this$studentUserId).equals(other$studentUserId)) {
            return false;
        }
        String this$studentName = this.getStudentName();
        String other$studentName = other.getStudentName();
        if (this$studentName == null ? other$studentName != null : !this$studentName.equals(other$studentName)) {
            return false;
        }
        Integer this$isDel = this.getIsDel();
        Integer other$isDel = other.getIsDel();
        return !(this$isDel == null ? other$isDel != null : !((Object)this$isDel).equals(other$isDel));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StudentUnKexiaoDto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Long $studentUserId = this.getStudentUserId();
        result = result * 59 + ($studentUserId == null ? 43 : ((Object)$studentUserId).hashCode());
        String $studentName = this.getStudentName();
        result = result * 59 + ($studentName == null ? 43 : $studentName.hashCode());
        Integer $isDel = this.getIsDel();
        result = result * 59 + ($isDel == null ? 43 : ((Object)$isDel).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "StudentUnKexiaoDto(super=" + super.toString() + ", studentUserId=" + this.getStudentUserId() + ", studentName=" + this.getStudentName() + ", isDel=" + this.getIsDel() + ")";
    }
}

