/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.sync.impl;

import com.baijia.tianxiao.biz.dashboard.sync.SyncSourceService;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.constant.ConsulterStatus;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.dao.TxUserSourceStatisticDayDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.dal.sync.po.TxUserSourceStatisticDay;
import com.baijia.tianxiao.util.date.DateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyncSourceServiceImpl
implements SyncSourceService {
    private static final Logger log = LoggerFactory.getLogger(SyncSourceServiceImpl.class);
    private AtomicBoolean msgSourceDayFlag = new AtomicBoolean(false);
    private AtomicBoolean consultUserSourceDayFlag = new AtomicBoolean(false);
    @Autowired
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Autowired
    private TxUserSourceStatisticDayDao txUserSourceStatisticDayDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private MessageDao messageDao;
    @Autowired
    private OrgStudentDao orgStudentDao;

    @Override
    @Transactional
    public void syncConsultSource(Long maxId, MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.getSyncInfo(syncType);
        if (syncInfo.getSyncId() < maxId) {
            this.syncTask(syncType, this.msgSourceDayFlag);
        }
    }

    @Override
    @Transactional
    public void sync() {
        this.syncTask(MsgSyncType.USER_SOURCE, this.msgSourceDayFlag);
        this.syncTask(MsgSyncType.CLUE_SOURCE, this.consultUserSourceDayFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncTask(MsgSyncType syncType, AtomicBoolean flag) {
        TxMsgSyncTimestamp syncInfo = this.getSyncInfo(syncType);
        try {
            if (!flag.get()) {
                log.info("sync consult stat info :{}", (Object)syncInfo);
                flag.set(true);
                switch (syncType) {
                    case CLUE_SOURCE: {
                        this.syncClueSource(syncInfo);
                        break;
                    }
                    case USER_SOURCE: {
                        this.syncUserSource(syncInfo);
                        break;
                    }
                }
                flag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", (Throwable)e);
        }
        finally {
            flag.set(false);
        }
        log.info("save sync info:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }

    private void syncUserSource(TxMsgSyncTimestamp syncInfo) {
        List consultMessages = this.messageDao.getConsultMessageListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[]{"senderId", "receiverId", "receiverRole", "consultType", "createTime"});
        log.info("[SysConsultMessage] save consultMessages:{} success", (Object)consultMessages.size());
        if (CollectionUtils.isNotEmpty((Collection)consultMessages)) {
            ArrayList<Long> consultIds = new ArrayList<Long>();
            for (ConsultMessage consultMessage : consultMessages) {
                consultIds.add(consultMessage.getSenderId());
            }
            Map consultUserMap = this.txConsultUserDao.getConsultUserByIds(null, consultIds, null);
            for (ConsultMessage consultMessage : consultMessages) {
                TxConsultUser txConsultUser;
                if (consultMessage.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(Long.valueOf(consultMessage.getId()));
                }
                if ((txConsultUser = (TxConsultUser)consultUserMap.get(consultMessage.getSenderId())) == null) continue;
                TxUserSourceStatisticDay txUserSourceStatisticDay = this.txUserSourceStatisticDayDao.getTxUserSourceStatisticDay(txConsultUser.getOrgId(), txConsultUser.getId(), Integer.valueOf(consultMessage.getConsultType()), DateUtil.getStartOfDay((Date)consultMessage.getCreateTime()), DateUtil.getEndOfDay((Date)consultMessage.getCreateTime()));
                log.info("[SysConsultMessageSource] txUserSourceStatisticDay param:{}, consultMessage.getId", (Object)txUserSourceStatisticDay, (Object)consultMessage.getId());
                if (txUserSourceStatisticDay == null) {
                    txUserSourceStatisticDay = this.buildTxUserSourceStatisticDayInstance(txConsultUser.getOrgId(), txConsultUser.getId(), consultMessage.getConsultType(), consultMessage.getCreateTime(), 1);
                    this.txUserSourceStatisticDayDao.save((Object)txUserSourceStatisticDay, new String[0]);
                    continue;
                }
                log.info("[SysConsultMessage] update souceStatistic txConsultSourceStatisticMonth param:{}", (Object)txUserSourceStatisticDay);
                if (consultMessage.getConsultType() == MessageSource.WECHAT.getValue() || consultMessage.getConsultType() == MessageSource.ONLINE_IM.getValue()) continue;
                txUserSourceStatisticDay.setNumber(Integer.valueOf(txUserSourceStatisticDay.getNumber() + 1));
                txUserSourceStatisticDay.setUpdateTime(new Date());
                this.txUserSourceStatisticDayDao.update((Object)txUserSourceStatisticDay, new String[0]);
                log.info("[SysConsultMessage] update souceStatistic param:{}", (Object)txUserSourceStatisticDay);
            }
        }
    }

    private void syncClueSource(TxMsgSyncTimestamp syncInfo) {
        List consultUsers = this.txConsultUserDao.getOrgConsultUserListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("[SysnConsultUser] save consultUser size:{} success", (Object)consultUsers.size());
        if (CollectionUtils.isNotEmpty((Collection)consultUsers)) {
            for (TxConsultUser consultUser : consultUsers) {
                if (consultUser.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(consultUser.getId());
                }
                if (consultUser.getIsConsulter().intValue() == ConsulterStatus.NOT.getValue()) continue;
                TxUserSourceStatisticDay txUserSourceStatisticDay = this.txUserSourceStatisticDayDao.getTxUserSourceStatisticDay(consultUser.getOrgId(), consultUser.getId(), consultUser.getConsultSource(), DateUtil.getStartOfDay((Date)consultUser.getCreateTime()), DateUtil.getEndOfDay((Date)consultUser.getCreateTime()));
                log.info("[SysConsultUserSource] txUserSourceStatisticDay param:{}, consultUserId:{}", (Object)txUserSourceStatisticDay, (Object)consultUser.getId());
                if (txUserSourceStatisticDay != null) continue;
                txUserSourceStatisticDay = this.buildTxUserSourceStatisticDayInstance(consultUser.getOrgId(), consultUser.getId(), consultUser.getConsultSource(), consultUser.getCreateTime(), 1);
                this.txUserSourceStatisticDayDao.save((Object)txUserSourceStatisticDay, new String[0]);
            }
        }
    }

    private TxUserSourceStatisticDay buildTxUserSourceStatisticDayInstance(Long orgId, Long consultUserId, Integer sourceType, Date visitDate, Integer number) {
        TxUserSourceStatisticDay userSource = new TxUserSourceStatisticDay();
        userSource.setOrgId(orgId);
        userSource.setConsultUserId(consultUserId);
        userSource.setSourceType(sourceType);
        userSource.setVisitDate(visitDate);
        userSource.setNumber(number);
        return userSource;
    }

    private boolean checkIsStudent(TxConsultUser consultUser) {
        boolean isStudent = false;
        Long userId = consultUser.getUserId();
        Long orgId = consultUser.getOrgId();
        Long studentId = consultUser.getStudentId();
        OrgStudent orgStudent = null;
        orgStudent = studentId != null && studentId > 0L ? (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]) : this.orgStudentDao.getStudentByUserId(orgId, userId, new String[0]);
        if (orgStudent != null && orgStudent.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()) {
            isStudent = true;
        }
        return isStudent;
    }
}

