/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.dto.unKexiao.reponse;

import com.baijia.tianxiao.biz.dashboard.dto.unKexiao.reponse.UnKexiaoStatisticsDto;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;

public class OrgUnKexiaoDto
extends UnKexiaoStatisticsDto {
    private String orgName;
    private Long campusNumber;

    public static OrgUnKexiaoDto from(OrgInfo orgInfo, Long orgNumber, UnKexiaoStatisticsDto dto) {
        OrgUnKexiaoDto orgDto = new OrgUnKexiaoDto();
        if (dto == null) {
            dto = UnKexiaoStatisticsDto.createWithZeroValue();
        }
        if (orgInfo != null) {
            orgDto.setOrgName(orgInfo.getShortName());
            orgDto.setCampusNumber(orgNumber);
        }
        BeanUtils.copyProperties((Object)dto, (Object)orgDto);
        return orgDto;
    }

    public static List<OrgUnKexiaoDto> listFrom(List<Long> orgIds, Map<Long, Long> orgNumbers, @NonNull Map<Long, OrgInfo> orgInfoMap, @NonNull Map<Long, UnKexiaoStatisticsDto> statisticsDtoMap) {
        if (orgInfoMap == null) {
            throw new NullPointerException("orgInfoMap");
        }
        if (statisticsDtoMap == null) {
            throw new NullPointerException("statisticsDtoMap");
        }
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (Long orgId : orgIds) {
            OrgUnKexiaoDto orgDto = OrgUnKexiaoDto.from(orgInfoMap.get(orgId), orgNumbers.get(orgId), statisticsDtoMap.get(orgId));
            result.add(orgDto);
        }
        return result;
    }

    public static UnKexiaoStatisticsDto sum(List<OrgUnKexiaoDto> dtoList) {
        UnKexiaoStatisticsDto sumDto = UnKexiaoStatisticsDto.createWithZeroValue();
        for (OrgUnKexiaoDto dto : dtoList) {
            sumDto.add(dto);
        }
        sumDto.transferUnit();
        return sumDto;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public Long getCampusNumber() {
        return this.campusNumber;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public void setCampusNumber(Long campusNumber) {
        this.campusNumber = campusNumber;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrgUnKexiaoDto)) {
            return false;
        }
        OrgUnKexiaoDto other = (OrgUnKexiaoDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$orgName = this.getOrgName();
        String other$orgName = other.getOrgName();
        if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
            return false;
        }
        Long this$campusNumber = this.getCampusNumber();
        Long other$campusNumber = other.getCampusNumber();
        return !(this$campusNumber == null ? other$campusNumber != null : !((Object)this$campusNumber).equals(other$campusNumber));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OrgUnKexiaoDto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $orgName = this.getOrgName();
        result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
        Long $campusNumber = this.getCampusNumber();
        result = result * 59 + ($campusNumber == null ? 43 : ((Object)$campusNumber).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "OrgUnKexiaoDto(super=" + super.toString() + ", orgName=" + this.getOrgName() + ", campusNumber=" + this.getCampusNumber() + ")";
    }
}

