package com.baijia.tianxiao.biz.dashboard.service.impl;

import com.baijia.tianxiao.biz.dashboard.constants.StatPageType;
import com.baijia.tianxiao.biz.dashboard.service.MonitorService;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.redis.AbstractBaseRedisDao;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.util.date.DateUtil;

import com.google.common.collect.Maps;

import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

import java.util.Iterator;
import java.util.Map;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * 曝光接口,实时存redis,天校白名单控制
 * <p/>
 * 发送营销消息和微信消息
 * <p/>
 * Created by wengshengli on 15/12/25.
 */
@Service
@Slf4j
public class MonitorServiceImpl extends AbstractBaseRedisDao implements MonitorService {

    @Resource
    private OrgInfoService orgInfoService;

    @Resource
    private OrgAccountDao orgAccountDao;

    @Override
    public synchronized boolean setPV(final Map<String, String> params) {

        final int pageType = Integer.parseInt(params.get("pageType"));
        final long orgNumber = Long.parseLong(params.get("orgNumber"));
        final long userNumber = Long.parseLong(params.get("userNumber"));
        final String uuid = params.get("uuid");

        final String pvKey = RedisKeyEnums.CRM.TX_PV_REDIS_PRE.getRedisKey();
        final String pvField = getPvField(params.get("orgNumber"), params.get("userNumber"), uuid, params.get("pageType"), params.get("typeNumber"));

        final String msgKey = getMsgKey(DateUtil.getToday());
        final String msgField = getMsgField(params.get("orgNumber"), params.get("userNumber"), uuid);

        boolean result = redisTemplate.execute(new RedisCallback<Boolean>() {
            @Override
            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(TianXiaoConstant.TX_PV_REDIS_DB);
                RedisSerializer<String> serializer = redisTemplate.getStringSerializer();
                byte[] key = serializer.serialize(pvKey);
                byte[] field = serializer.serialize(pvField);
                byte[] value = connection.hGet(key, field);
                int count = 1;
                if (value != null) {
                    count = Integer.parseInt(serializer.deserialize(value));
                    count = count + 1;
                }

                /**
                 * 判断是否需要发信息
                 */
                if (StatPageType.getSendMsgList().contains(pageType) && checkMarkdingStatus(orgNumber)) {
                    byte[] msgValue = connection.hGet(serializer.serialize(msgKey), serializer.serialize(msgField));
                    log.debug("get tianxiao pv=== msgKey:{},msgField:{},value:{}", msgKey, msgField, msgValue == null ? 0 : serializer.deserialize(msgValue));
                    if (msgValue == null) {
                        connection.hSet(serializer.serialize(msgKey), serializer.serialize(msgField), serializer.serialize(String.valueOf(1)));
                    } else {
                        int pageCount = Integer.parseInt(serializer.deserialize(msgValue));
                        if (pageCount == 1) {
                            long typeNumber = Long.parseLong(params.get("typeNumber"));
                            //markingMsgService.sendMessage(orgNumber, userNumber, pageType, typeNumber);
                            log.debug("set tianxiao pv=== msgKey:{},msgField:{},value:{}", msgKey, msgField, 2);
                            connection.hSet(serializer.serialize(msgKey), serializer.serialize(msgField), serializer.serialize(String.valueOf(2)));
                        }
                    }
                }

                /**
                 * 判断是否发微信推送消息
                 */
                if (StatPageType.getWechatMsgList().contains(pageType)) {
                    byte[] msgValue = connection.hGet(serializer.serialize(msgKey), serializer.serialize(msgField));
                    if (msgValue == null) {
                        connection.hSet(serializer.serialize(msgKey), serializer.serialize(msgField), serializer.serialize(String.valueOf(1)));
                    } else {
                        int pageCount = Integer.parseInt(serializer.deserialize(msgValue));
                        if (pageCount == 1) {
                            connection.hSet(serializer.serialize(msgKey), serializer.serialize(msgField), serializer.serialize(String.valueOf(2)));
                        }
                    }
                }

                log.debug("set tianxiao pv=== key:{},field:{},value:{}", pvKey, pvField, count);
                return connection.hSet(key, field, serializer.serialize(String.valueOf(count)));
            }
        });
        return result;
    }


    public Integer getPV(Map<String, String> params) {

        final String pvKey = RedisKeyEnums.CRM.TX_PV_REDIS_PRE.getRedisKey();
        final String pvField = getPvField(params.get("orgNumber"), params.get("userNumber"),params.get("uuid"), params.get("pageType"), params.get("typeNumber"));

        Integer pv = redisTemplate.execute(new RedisCallback<Integer>() {
            public Integer doInRedis(RedisConnection connection)
                    throws DataAccessException {
                connection.select(TianXiaoConstant.TX_PV_REDIS_DB);
                RedisSerializer<String> serializer = getRedisSerializer();
                byte[] key = serializer.serialize(pvKey);
                byte[] field = serializer.serialize(pvField);
                byte[] value = connection.hGet(key, field);
                if (value == null) {
                    return 0;
                }
                return Integer.parseInt(serializer.deserialize(value));
            }
        });
        log.info("set tianxiao pvKey:{}, pvField:{},value:{}", pvKey, pvField, pv);
        return pv == null ? 0 : pv;
    }

    @Override
    public void cleanRedisMsg() {
        redisTemplate.execute(new RedisCallback<Long>() {
            public Long doInRedis(RedisConnection connection)
                    throws DataAccessException {
                connection.select(TianXiaoConstant.TX_PV_REDIS_DB);
                RedisSerializer<String> serializer = getRedisSerializer();
                byte[] key = serializer.serialize(getMsgKey(DateUtil.getYesterday()));
                return connection.del(key);
            }
        });
    }


    @Override
    public synchronized Map<String, Integer> getFromRedisByMin() {
        final String pvKey = RedisKeyEnums.CRM.TX_PV_REDIS_PRE.getRedisKey();

        Map<String, Integer> result = redisTemplate.execute(new RedisCallback<Map<String, Integer>>() {
            @Override
            public Map<String, Integer> doInRedis(RedisConnection redisConnection) throws DataAccessException {
                redisConnection.select(TianXiaoConstant.TX_PV_REDIS_DB);
                RedisSerializer<String> serializer = getRedisSerializer();
                byte[] key = serializer.serialize(pvKey);

                Map<String, Integer> result = Maps.newHashMap();

                Map<byte[], byte[]> map = redisConnection.hGetAll(key);
                log.info("yesterday pv number from redis is {}", map.size());

                Iterator<byte[]> keymap = map.keySet().iterator();

                while (keymap.hasNext()) {
                    byte[] oneKey = keymap.next();
                    byte[] oneValue = map.get(oneKey);
                    result.put(serializer.deserialize(oneKey), Integer.parseInt(serializer.deserialize(oneValue)));
                }
                redisConnection.del(key);
                return result;
            }
        });
        log.debug("yesterday result  is {}", result);
        return result;
    }


    private String getMsgKey(String date) {
        StringBuilder sb = new StringBuilder();
        sb.append(RedisKeyEnums.CRM.TX_MSG_REDIS_PRE.getRedisKey());
        sb.append("#");
        sb.append(date);
        return sb.toString();
    }


    private String getMsgField(String orgNumber, String userNumber, String uuid) {
        StringBuilder sb = new StringBuilder();
        sb.append(orgNumber);
        sb.append("#");
        sb.append(userNumber);
        sb.append("#");
        sb.append(uuid);
        return sb.toString();
    }

    private String getPvField(String orgNumber, String userNumber, String uuid, String pageType, String typeNumber) {
        StringBuilder sb = new StringBuilder();
        sb.append(orgNumber);
        sb.append("#");
        sb.append(pageType);
        sb.append("#");
        sb.append(userNumber);
        sb.append("#");
        sb.append(uuid);
        sb.append("#");
        sb.append(typeNumber == null ? 0 : typeNumber);
        return sb.toString();
    }

    private boolean checkMarkdingStatus(long orgNumber) {
        boolean result = true;
        OrgAccount orgAccount = orgAccountDao.getAccountByNumber((int) orgNumber);
        if (orgAccount != null) {
            try {
                OrgInfoSimpleDto orgInfo = orgInfoService.getOrgInfo(Long.valueOf(orgAccount.getId()));
                if (orgInfo.getMarkingStatus() == 1) {
                    result = false;
                }
            } catch (Exception e) {
                log.error("checkMarkdingStatus erreer ", e);
            }
        }
        log.debug("checkMarkdingStatus success orgAccount:{},result={}", orgAccount, result);
        return result;
    }

}
