package com.baijia.tianxiao.biz.dashboard.service.impl;

import java.util.*;

import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceAccountDao;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccount;
import com.baijia.tianxiao.dal.org.dao.*;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStudentStat;
import com.baijia.tianxiao.util.CollectionHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.biz.dashboard.dto.kexiao.DashboadrKexiaoDtoHelper;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.allorg.AllOrgListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.allorg.AllOrgStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.allorg.MainStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.classdetail.ClassDetailListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.classdetail.ClassDetailStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail.OrgDetailClassListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail.OrgDetailKexiaoListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail.OrgDetailStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail.OrgDetailStudentListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.AllOrgListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.ClassDetailListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.OrgDetailClassListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.OrgDetailKexiaoListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.OrgDetailStudentListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.StudentDetailListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.studentdetail.StudentDetailListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.studentdetail.StudentDetailStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.service.DashboardKeXiaoService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.dto.ChargeUnitStatisticDto;
import com.baijia.tianxiao.dal.org.dto.KexiaoSumDto;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentKexiaoRecord;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.date.DateUtil;

import lombok.extern.slf4j.Slf4j;


/**
 * @author : zhenyujian
 * @title : DashboardKeXiaoServiceImpl
 * @description :
 * @date : 2017年1月3日 下午2:26:38
 */
@Service
@Slf4j
public class DashboardKeXiaoServiceImpl implements DashboardKeXiaoService {

    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgCourseConsumeRuleDao courseConsumeRuleDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;

    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgSignupRefundDao orgSignupRefundDao;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private OrgTeacherLessonDao teacherLessonDao;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private KexiaoApiService kexiaoApiService;
    @Autowired
    private TxStudentFinanceAccountDao studentFinanceAccountDao;


    static <T> List<T> getArrayList(T obj) {
        List<T> list = new ArrayList<T>();
        list.add(obj);
        return list;
    }


    @Override
    public MainStatisticsDto getMainStatisticsDto(Long mainOrgId) {

        AllOrgListParamDto weekParam = new AllOrgListParamDto();
        weekParam.setMainOrgId(mainOrgId);
        weekParam.setStartDate(DateUtil.getStartOfWeek().getTime());
        weekParam.setEndDate(DateUtil.getEndOfWeek().getTime());

        AllOrgListParamDto monthParam = new AllOrgListParamDto();
        monthParam.setMainOrgId(mainOrgId);
        monthParam.setStartDate(DateUtil.getStartOfMonth().getTime());
        monthParam.setEndDate(DateUtil.getEndOfMonth().getTime());

        AllOrgListDto weekDto = getAllOrgListTotal(weekParam);
        AllOrgListDto monthDto = getAllOrgListTotal(monthParam);


        MainStatisticsDto dto = new MainStatisticsDto();
        if (weekDto != null && weekDto.getTotalKexiaoMoney() != null) {
            dto.setWeekKexiaoMoney(weekDto.getTotalKexiaoMoneyLong());
        } else {
            dto.setWeekKexiaoMoney(0L);
        }

        if (monthDto != null && monthDto.getTotalKexiaoMoney() != null) {
            dto.setMonthKexiaoMoney(monthDto.getTotalKexiaoMoneyLong());
        } else {
            dto.setMonthKexiaoMoney(0L);
        }

        return dto;
    }


    @Override
    public AllOrgStatisticsDto getAllOrgStatisticsDto(Long mainOrgId) {
        Date startTime = DateUtil.getCurrentDate();
        Date endTime = DateUtil.getDiffDateTime(startTime, 1);
        AllOrgStatisticsDto dto = new AllOrgStatisticsDto();
        Double todayKexiaoHour = 0.00;
        Long todayKexiaoHourMoney = 0L;
        Integer todayKexiaoTimes = 0;
        Long todayKexiaoTimesMoney = 0L;
        Long todayKexiaoTotalMoney = 0L;
        Long todayQuitClassMoney = 0L;


        AllOrgListParamDto param = new AllOrgListParamDto();
        param.setMainOrgId(mainOrgId);
        Map<Long, OrgInfo> orgMapKeyOrgId = orgListSearch(param, false);
        Set<Long> orgIds = orgMapKeyOrgId.keySet();
        todayQuitClassMoney = orgSignupRefundDao.sumRefundFeeByOrgIds(orgIds, startTime, endTime);
        Map<Integer, ChargeUnitStatisticDto> kexiaoDataMapKeyChargeUnit = orgStudentKexiaoRecordDao.mapOrgKexiaoListDtoData(orgIds, startTime, endTime);
        ChargeUnitStatisticDto data = null;

        //按次
        data = kexiaoDataMapKeyChargeUnit.get(ChargeUnit.BY_TIMES.getCode());
        if (data != null) {
            todayKexiaoTimes = data.getLineCount();
            todayKexiaoTimesMoney = data.getAmount();
        }

        //按小时
        List<Integer> codes = ChargeUnit.listByTimeCode();
        if (CollectionUtils.isNotEmpty(codes)) {
            for (Integer code : codes) {
                data = kexiaoDataMapKeyChargeUnit.get(code);
                if (data != null) {
                    todayKexiaoHour = data.getLessonDurationHour();
                    todayKexiaoHourMoney = data.getAmount();
                }
            }
        }

        todayKexiaoTotalMoney += todayKexiaoTimesMoney + todayKexiaoHourMoney + todayQuitClassMoney;
        dto.setTodayKexiaoHour(todayKexiaoHour);
        dto.setTodayKexiaoHourMoney(todayKexiaoHourMoney);
        dto.setTodayKexiaoTimes(todayKexiaoTimes);
        dto.setTodayKexiaoTimesMoney(todayKexiaoTimesMoney);
        dto.setTodayKexiaoTotalMoney(todayKexiaoTotalMoney);
        dto.setTodayQuitClassMoney(todayQuitClassMoney);

        return dto;
    }

    @Override
    public List<AllOrgListDto> listAllOrgListDto(AllOrgListParamDto param, PageDto pageDto) {
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();

        Map<Long, OrgInfo> orgMap = orgListSearch(param, true);

        Integer count = orgMap.size();
        if (pageDto != null) {
            pageDto.setCount(count);
        }

        if (count == 0) {
            log.info("listAllOrgListDto - return - orgmap is empty");
            return new ArrayList<AllOrgListDto>();
        } else {
            Set<Long> orgIds = orgMap.keySet();
            if (pageDto != null) {
                Set<Long> orgIdsTemp = new HashSet<Long>();
                int cursor = 0;
                int limitFrom = pageDto.firstNum();
                int limitTo = pageDto.firstNum() + pageDto.getPageSize();

                for (Long orgId : orgIds) {
                    if (cursor > limitTo) {
                        break;
                    } else if (cursor >= limitFrom) {
                        orgIdsTemp.add(orgId);
                    }
                    cursor++;
                }
                orgIds = orgIdsTemp;
            }

            List<AllOrgListDto> list = new ArrayList<AllOrgListDto>();
            if (CollectionUtils.isNotEmpty(orgIds)) {
                Map<Long, Long> refundFeeMap = orgSignupRefundDao.mapRefundFeeByOrgIds(orgIds, startTime, endTime);
                Map<Long, Map<Integer, ChargeUnitStatisticDto>> kexiaoListMap = orgStudentKexiaoRecordDao.mapOrgChargeUnitStatisticDto(orgIds, startTime, endTime);

                Map<Integer, ChargeUnitStatisticDto> dataMap = null;
                OrgInfo orgInfo = null;
                AllOrgListDto dto = null;
                Long refundFee = null;

                for (Long oid : orgIds) {
                    orgInfo = orgMap.get(oid);
                    dataMap = kexiaoListMap.get(oid);
                    refundFee = refundFeeMap.get(oid);

                    dto = new AllOrgListDto();
                    dto.setOrgId(orgInfo.getOrgId().longValue());
                    dto.setOrgName(orgInfo.getShortName());
                    dto.setKexiaoTimes(0);
                    dto.setKexiaoTimesMoney(0L);
                    dto.setKexiaoMinute(0);
                    dto.setKexiaoHourMoney(0L);

                    if (dataMap != null) {
                        //按次
                        ChargeUnitStatisticDto timesStatisticDto = dataMap.get(ChargeUnit.BY_TIMES.getCode());
                        if (timesStatisticDto != null) {
                            dto.setKexiaoTimes(timesStatisticDto.getLineCount());
                            dto.setKexiaoTimesMoney(timesStatisticDto.getAmount());
                        }

                        //按小时
                        List<Integer> codes = ChargeUnit.listByTimeCode();
                        if (CollectionUtils.isNotEmpty(codes)) {
                            for (Integer code : codes) {
                                ChargeUnitStatisticDto durationStatisticDto = dataMap.get(code);
                                if (durationStatisticDto != null) {
                                    dto.setKexiaoHour(dto.getKexiaoHour() + durationStatisticDto.getLessonDurationHour());
                                    dto.setKexiaoHourMoney(dto.getKexiaoHourMoneyLong() + durationStatisticDto.getAmount());
                                }
                            }
                        }
                    }


                    if (refundFee != null) {
                        dto.setQuitClassMoney(refundFee);
                    } else {
                        dto.setQuitClassMoney(0L);
                    }

                    dto.setTotalKexiaoMoney(dto.getKexiaoTimesMoneyLong() + dto.getKexiaoHourMoneyLong() + dto.getQuitClassMoneyLong());
                    list.add(dto);
                }
            }
            return list;
        }


    }

    @Override
    public AllOrgListDto getAllOrgListTotal(AllOrgListParamDto param) {
        Long mainOrgId = param.getMainOrgId();
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();

        AllOrgListDto dto = new AllOrgListDto();
        Double kexiaoHour = 0.00;
        Long kexiaoHourMoney = 0L;
        Integer kexiaoTimes = 0;
        Long kexiaoTimesMoney = 0L;
        Long kexiaoTotalMoney = 0L;
        Long quitClassMoney = 0L;
        KexiaoSumDto durationDto = null;
        KexiaoSumDto timesDto = null;

        List<Long> orgIds = new ArrayList<Long>();
        if (param.getOrgId() != null) {
            orgIds.add(orgId);
            quitClassMoney = orgSignupRefundDao.sumRefundFeeByOrgIds(orgIds, startTime, endTime);
            durationDto = orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, ChargeUnit.listByTimeCode(), startTime, endTime);
            timesDto = orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, ChargeUnit.listByTimesCode(), startTime, endTime);
        } else {
            orgIds.add(mainOrgId);

            List<OrgSubAccount> subAccounts = orgSubAccountDao.getSlavesByMasterOrgId(mainOrgId.intValue(), null);
            if (CollectionUtils.isNotEmpty(subAccounts)) {
                for (OrgSubAccount account : subAccounts) {
                    orgIds.add(account.getOrgId().longValue());
                }
            }

            quitClassMoney = orgSignupRefundDao.sumRefundFeeByOrgIds(orgIds, startTime, endTime);
            durationDto = orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, ChargeUnit.listByTimeCode(), startTime, endTime);
            timesDto = orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, ChargeUnit.listByTimesCode(), startTime, endTime);
        }

        if (durationDto != null) {
            kexiaoHour = durationDto.getSumKexiaoHour();
            kexiaoHourMoney += durationDto.getSumKexiaoMoney();
        }
        if (timesDto != null) {
            kexiaoTimes = timesDto.getSumKexiaoTimes();
            kexiaoTimesMoney += timesDto.getSumKexiaoMoney();
        }

        kexiaoTotalMoney += kexiaoTimesMoney + kexiaoHourMoney + quitClassMoney;
        dto.setKexiaoHour(kexiaoHour);
        dto.setKexiaoHourMoney(kexiaoHourMoney);
        dto.setKexiaoTimes(kexiaoTimes);
        dto.setKexiaoTimesMoney(kexiaoTimesMoney);
        dto.setTotalKexiaoMoney(kexiaoTotalMoney);
        dto.setQuitClassMoney(quitClassMoney);

        return dto;
    }


    Map<Long, OrgInfo> orgListSearch(AllOrgListParamDto param, boolean containsJoinType) {
        Long mainOrgId = param.getMainOrgId();
        Long orgId = param.getOrgId();

        Map<Long, OrgInfo> result = new HashMap<Long, OrgInfo>();
        if (orgId != null) {
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
            result.put(orgId, orgInfo);
        } else {
            List<Integer> orgIds = getArrayList(mainOrgId.intValue());

            List<OrgSubAccount> subAccounts = orgSubAccountDao.getSlavesByMasterOrgId(mainOrgId.intValue(), null);
            if (CollectionUtils.isNotEmpty(subAccounts)) {
                for (OrgSubAccount account : subAccounts) {
                    //去除加盟校
                    if (!containsJoinType && account.getAccountType().intValue() == 3) {
                        continue;
                    }
                    orgIds.add(account.getOrgId());
                }
            }

            List<OrgInfo> orgs = orgInfoDao.getOrgInfos(orgIds);
            for (OrgInfo orgInfo : orgs) {
                result.put(orgInfo.getOrgId().longValue(), orgInfo);
            }
        }
        return result;
    }


    @Override
    public OrgDetailStatisticsDto getOrgDetailStatisticsDto(Long orgId) {
        OrgDetailStatisticsDto dto = new OrgDetailStatisticsDto();
        Date startTime = DateUtil.getCurrentDate();
        Date endTime = DateUtil.getDiffDateTime(startTime, 1);

        Double todayKexiaoHour = 0.00;
        Integer todayKexiaoTimes = 0;
        Long todayKexiaoHourMoney = 0L;
        Long todayKexiaoTimesMoney = 0L;
        Long todayKexiaoTotalMoney = 0L;
        Long todayQuitClassMoney = 0L;

        OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
        List<OrgStudentKexiaoRecord> kexiaoRecords = orgStudentKexiaoRecordDao.listByOrgId(orgId, null, null, startTime, endTime);
        List<OrgSignupRefund> signupRefunRecords = orgSignupRefundDao.listByUserId(orgId, null, null, startTime, endTime);

        if (CollectionUtils.isNotEmpty(kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                todayKexiaoTotalMoney += record.getAmount();
                if (ChargeUnit.isByTimes(record.getChargeUnit().intValue())) {
                    todayKexiaoTimes += DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES;
                    todayKexiaoTimesMoney += record.getAmount();
                } else {
                    todayKexiaoHour += record.getLessonDurationHour();
                    todayKexiaoHourMoney += record.getAmount();
                }
            }
        }
        if (CollectionUtils.isNotEmpty(signupRefunRecords)) {
            for (OrgSignupRefund record : signupRefunRecords) {
                todayKexiaoTotalMoney += record.getRefundFee();
                todayQuitClassMoney += record.getRefundFee();
            }
        }

        dto.setOrgId(orgInfo.getId().longValue());
        dto.setOrgName(orgInfo.getShortName());
        dto.setTodayKexiaoHour(todayKexiaoHour);
        dto.setTodayKexiaoHourMoney(todayKexiaoHourMoney);
        dto.setTodayKexiaoTimes(todayKexiaoTimes);
        dto.setTodayKexiaoTimesMoney(todayKexiaoTimesMoney);
        dto.setTodayKexiaoTotalMoney(todayKexiaoTotalMoney);
        dto.setTodayQuitClassMoney(todayQuitClassMoney);

        return dto;
    }


    @Override
    public List<OrgDetailClassListDto> listOrgDetailClassListDto(OrgDetailClassListParamDto param, PageDto pageDto) {
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        String keyword = param.getKeyword();
        List<Integer> courseTypes = param.getCourseTypeList();
        Integer chargeType = param.getChargeType();
        Integer chargeUnit = param.getChargeUnit();
        OrgAccount org = orgAccountDao.getById(orgId);


        List<Long> orgClassIds = null;

        List<Long> kexiaoClassIds = orgStudentKexiaoRecordDao.pageDistinctClassId(orgId, null, startTime, endTime, null);
        List<Long> refundClassIds = orgSignupRefundDao.pageDistinctClassId(orgId, null, startTime, endTime, null);
        kexiaoClassIds.removeAll(refundClassIds);
        kexiaoClassIds.addAll(refundClassIds);

        if (param.conditionQuery()) {
            orgClassIds = orgCourseDao.listCourseId(org.getNumber().longValue(), keyword, courseTypes, chargeType, chargeUnit);
            orgClassIds.retainAll(kexiaoClassIds);
        } else {
            orgClassIds = kexiaoClassIds;
        }

        Integer count = orgClassIds.size();
        if (pageDto != null) {
            pageDto.setCount(count);
        }
        if (count == 0) {
            log.info("listOrgDetailClassListDto - return - kexiao record is empty");
            return new ArrayList<OrgDetailClassListDto>();
        } else {
            if (pageDto != null) {
                List<Long> orgClassIdsTemp = new ArrayList<Long>();

                int cursor = 0;
                int limitFrom = pageDto.firstNum();
                int limitTo = pageDto.firstNum() + pageDto.getPageSize() - 1;
                for (Long ocid : orgClassIds) {
                    if (cursor > limitTo) {
                        break;
                    } else if (cursor >= limitFrom) {
                        orgClassIdsTemp.add(ocid);
                    }
                    cursor++;
                }
                orgClassIds = orgClassIdsTemp;
            }
        }

        List<OrgDetailClassListDto> result = new ArrayList<OrgDetailClassListDto>();
        Map<Long, OrgCourse> orgClassMap = orgCourseDao.getOrgCourseMap(orgClassIds);
        Map<Long, Map<Integer, ChargeUnitStatisticDto>> chargeUnitStatisticDtoMap = orgStudentKexiaoRecordDao.mapClassChargeUnitStatisticDto(orgClassIds, startTime, endTime);
        Map<Long, Long> refundFeeMap = orgSignupRefundDao.mapRefundFeeByClassIds(orgClassIds, startTime, endTime);

        for (Long classId : orgClassIds) {
            Map<Integer, ChargeUnitStatisticDto> chargeUnitStatisticDtoData = chargeUnitStatisticDtoMap.get(classId);
            Long kexiaoMoney = 0L;
            Long refundFee = 0L;
            Integer kexiaoTimes = 0;
            Double kexiaoHour = 0.00;
            OrgCourse orgClass = orgClassMap.get(classId);

            if (refundFeeMap.get(classId) != null) {
                refundFee = refundFeeMap.get(classId);
            }

            if (chargeUnitStatisticDtoData != null) {
                //按次
                ChargeUnitStatisticDto data = chargeUnitStatisticDtoData.get(ChargeUnit.BY_TIMES.getCode());
                if (data != null) {
                    kexiaoTimes += data.getLineCount();
                    kexiaoMoney += data.getAmount();
                }

                //按小时
                List<Integer> codes = ChargeUnit.listByTimeCode();
                if (CollectionUtils.isNotEmpty(codes)) {
                    for (Integer code : codes) {
                        data = chargeUnitStatisticDtoData.get(code);
                        if (data != null) {
                            kexiaoHour = data.getLessonDurationHour();
                            kexiaoMoney += data.getAmount();
                        }
                    }
                }
            }

            OrgDetailClassListDto dto = new OrgDetailClassListDto();
            dto.setChargeType(orgClass.getChargeType());
            dto.setChargeUnit(orgClass.getChargeUnit());
            dto.setClassId(orgClass.getId());
            dto.setClassName(orgClass.getName());
            dto.setCourseType(orgClass.getCourseType());
            dto.setKexiaoTimes(kexiaoTimes);
            dto.setKexiaoHour(kexiaoHour);
            dto.setKexiaoMoney(kexiaoMoney);
            dto.setQuitClassMoney(refundFee);
            dto.setTotalKexiaoMoney(kexiaoMoney + refundFee);

            if (orgClass.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                dto.setKexiaoHour(null);
            } else {
                dto.setKexiaoTimes(null);
            }
            result.add(dto);
        }

        log.info("listOrgDetailClassListDto - return");
        return result;
    }

    @Override
    public OrgDetailClassListDto getOrgDetailClassListTotal(OrgDetailClassListParamDto param) {
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        String keyword = param.getKeyword();
        List<Integer> courseTypes = param.getCourseTypeList();
        Integer chargeType = param.getChargeType();
        Integer chargeUnit = param.getChargeUnit();
        OrgAccount org = orgAccountDao.getById(orgId);

        OrgDetailClassListDto dto = new OrgDetailClassListDto();
        Integer kexiaoTimes = 0;
        Double kexiaoHour = 0.00;
        Long kexiaoMoney = 0L;
        Long totalKexiaoMoney = 0L;
        Long quitClassMoney = 0L;
        KexiaoSumDto durationDto = null;
        KexiaoSumDto timesDto = null;

        List<Long> orgIds = getArrayList(orgId);
        if (param.conditionQuery()) {
            List<Long> classIds = orgCourseDao.listCourseId(org.getNumber().longValue(), keyword, courseTypes, chargeType, chargeUnit);
            if (CollectionUtils.isNotEmpty(classIds)) {
                quitClassMoney = orgSignupRefundDao.sumRefundFeeByClassIds(classIds, startTime, endTime);
                durationDto = orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, classIds, null, ChargeUnit.listByTimeCode(), startTime, endTime);
                timesDto = orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, classIds, null, ChargeUnit.listByTimesCode(), startTime, endTime);
            }
        } else {
            quitClassMoney = orgSignupRefundDao.sumRefundFeeByOrgId(org.getId().longValue(), startTime, endTime);
            durationDto = orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, ChargeUnit.listByTimeCode(), startTime, endTime);
            timesDto = orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, ChargeUnit.listByTimesCode(), startTime, endTime);
        }

        if (durationDto != null) {
            kexiaoHour = durationDto.getSumKexiaoHour();
            kexiaoMoney += durationDto.getSumKexiaoMoney();
        }
        if (timesDto != null) {
            kexiaoTimes = timesDto.getSumKexiaoTimes();
            kexiaoMoney += timesDto.getSumKexiaoMoney();
        }
        totalKexiaoMoney = kexiaoMoney + quitClassMoney;

        dto.setKexiaoTimes(kexiaoTimes);
        dto.setKexiaoHour(kexiaoHour);
        dto.setKexiaoMoney(kexiaoMoney);
        dto.setTotalKexiaoMoney(totalKexiaoMoney);
        dto.setQuitClassMoney(quitClassMoney);

        return dto;
    }

    @Override
    public List<OrgDetailStudentListDto> listOrgDetailStudentListDto(OrgDetailStudentListParamDto param, PageDto pageDto) {
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        String keyword = param.getKeyword();

        List<Long> studentUserIds = null;
        List<Long> kexiaoUserIds = orgStudentKexiaoRecordDao.pageDistinctUserId(orgId, null, startTime, endTime, null);
        List<Long> refundUserIds = orgSignupRefundDao.pageDistinctUserId(orgId, null, startTime, endTime, null);
        kexiaoUserIds.removeAll(refundUserIds);
        kexiaoUserIds.addAll(refundUserIds);

        if (param.conditionQuery()) {
            studentUserIds = orgStudentDao.listUserId(orgId, keyword);
            studentUserIds.retainAll(kexiaoUserIds);
        } else {
            studentUserIds = kexiaoUserIds;
        }

        Integer count = studentUserIds.size();
        if (pageDto != null) {
            pageDto.setCount(count);
        }

        if (count == 0) {
            log.info("listOrgDetailStudentListDto - return - record is empty");
            return new ArrayList<OrgDetailStudentListDto>();
        } else {
            if (pageDto != null) {
                List<Long> studentUserIdsTemp = new ArrayList<Long>();

                int cursor = 0;
                int limitFrom = pageDto.firstNum();
                int limitTo = pageDto.firstNum() + pageDto.getPageSize() - 1;
                for (Long suid : studentUserIds) {
                    if (cursor > limitTo) {
                        break;
                    } else if (cursor >= limitFrom) {
                        studentUserIdsTemp.add(suid);
                    }
                    cursor++;
                }
                studentUserIds = studentUserIdsTemp;
            }
        }

        List<OrgDetailStudentListDto> result = new ArrayList<OrgDetailStudentListDto>();
        Map<Long, OrgStudent> orgStudentMap = orgStudentDao.getOrgStudentMapByUserIds(studentUserIds);
        Map<Long, Map<Integer, ChargeUnitStatisticDto>> chargeUnitStatisticDtoMap = orgStudentKexiaoRecordDao.mapUserChargeUnitStatisticDto(orgId, studentUserIds, startTime, endTime);
        Map<Long, Long> refundFeeMap = orgSignupRefundDao.mapRefundFeeByUserIds(orgId, studentUserIds, startTime, endTime);


        for (Long studentUserId : studentUserIds) {
            Map<Integer, ChargeUnitStatisticDto> chargeUnitStatisticDtoData = chargeUnitStatisticDtoMap.get(studentUserId);
            Integer kexiaoTimes = 0;
            Double kexiaoHour = 0.00;
            Long kexiaoTimesMoney = 0L;
            Long kexiaoHourMoney = 0L;
            Long refundFee = 0L;
            OrgStudent student = orgStudentMap.get(studentUserId);

            if (refundFeeMap.get(studentUserId) != null) {
                refundFee = refundFeeMap.get(studentUserId);
            }

            if (chargeUnitStatisticDtoData != null) {
                //按次
                ChargeUnitStatisticDto data = chargeUnitStatisticDtoData.get(ChargeUnit.BY_TIMES.getCode());
                if (data != null) {
                    kexiaoTimes += data.getLineCount();
                    kexiaoTimesMoney += data.getAmount();
                }

                //按小时
                List<Integer> codes = ChargeUnit.listByTimeCode();
                if (CollectionUtils.isNotEmpty(codes)) {
                    for (Integer code : codes) {
                        data = chargeUnitStatisticDtoData.get(code);
                        if (data != null) {
                            kexiaoHour = data.getLessonDurationHour();
                            kexiaoHourMoney += data.getAmount();
                        }
                    }
                }
            }

            OrgDetailStudentListDto dto = new OrgDetailStudentListDto();
            dto.setStudentUserId(student.getUserId());
            dto.setStudentName(student.getName());
            dto.setKexiaoTimes(kexiaoTimes);
            dto.setKexiaoTimesMoney(kexiaoTimesMoney);
            dto.setKexiaoHour(kexiaoHour);
            dto.setKexiaoHourMoney(kexiaoHourMoney);
            dto.setTotalKexiaoMoney(dto.getKexiaoTimesMoneyLong() + dto.getKexiaoHourMoneyLong());

            dto.setQuitClassMoney(refundFee);
            dto.setTotalKexiaoMoney(dto.getTotalKexiaoMoneyLong() + refundFee);
            result.add(dto);
        }

        log.info("listOrgDetailStudentListDto - return");
        return result;
    }

    @Override
    public OrgDetailStudentListDto getOrgDetailStudentListTotal(OrgDetailStudentListParamDto param) {
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        String keyword = param.getKeyword();

        OrgDetailStudentListDto dto = new OrgDetailStudentListDto();
        Integer kexiaoTimes = 0;
        Double kexiaoHour = 0.00;
        Long kexiaoTimesMoney = 0L;
        Long kexiaoHourMoney = 0L;
        Long totalKexiaoMoney = 0L;
        Long quitClassMoney = 0L;
        KexiaoSumDto durationDto = null;
        KexiaoSumDto timesDto = null;

        List<Long> orgIds = getArrayList(orgId);
        if (param.conditionQuery()) {
            List<Long> studentUserIds = orgStudentDao.listUserId(orgId, keyword);
            if (CollectionUtils.isNotEmpty(studentUserIds)) {
                quitClassMoney = orgSignupRefundDao.sumRefundFeeByUserIds(orgId, studentUserIds, startTime, endTime);
                durationDto = orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, studentUserIds, ChargeUnit.listByTimeCode(), startTime, endTime);
                timesDto = orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, studentUserIds, ChargeUnit.listByTimesCode(), startTime, endTime);
            }
        } else {
            quitClassMoney = orgSignupRefundDao.sumRefundFeeByOrgId(orgId, startTime, endTime);
            durationDto = orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, ChargeUnit.listByTimeCode(), startTime, endTime);
            timesDto = orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, ChargeUnit.listByTimesCode(), startTime, endTime);
        }

        if (durationDto != null) {
            kexiaoHour = durationDto.getSumKexiaoHour();
            kexiaoHourMoney += durationDto.getSumKexiaoMoney();
        }
        if (timesDto != null) {
            kexiaoTimes = timesDto.getSumKexiaoTimes();
            kexiaoTimesMoney += timesDto.getSumKexiaoMoney();
        }

        totalKexiaoMoney = kexiaoTimesMoney + kexiaoHourMoney + quitClassMoney;
        dto.setKexiaoTimes(kexiaoTimes);
        dto.setKexiaoHour(kexiaoHour);
        dto.setKexiaoTimesMoney(kexiaoTimesMoney);
        dto.setKexiaoHourMoney(kexiaoHourMoney);
        dto.setTotalKexiaoMoney(totalKexiaoMoney);
        dto.setQuitClassMoney(quitClassMoney);

        return dto;
    }


    @Override
    public List<OrgDetailKexiaoListDto> listOrgDetailKexiaoListDto(OrgDetailKexiaoListParamDto param, PageDto pageDto) {
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        OrgAccount org = orgAccountDao.getById(orgId);

        List<Long> classIds = null;
        if (param.conditionQuery()) {
            classIds = orgCourseDao.listCourseId(org.getNumber().longValue(), param.getKeyword(), null, null, null);
            if (CollectionUtils.isEmpty(classIds)) {
                log.info("listOrgDetailKexiaoListDto - return - search is empty");
                pageDto.setCount(0);
                return new ArrayList<OrgDetailKexiaoListDto>();
            }
        }

        Integer count = 0;
        List<OrgStudentKexiaoRecord> kexiaoRecords = null;
        List<OrgSignupRefund> signupRefunRecords = null;
        count = orgStudentKexiaoRecordDao.countByClassIds(orgId, classIds, startTime, endTime);
        count += orgSignupRefundDao.countByClassIds(orgId, classIds, startTime, endTime);
        kexiaoRecords = orgStudentKexiaoRecordDao.pageByClassIds(orgId, classIds, startTime, endTime, pageDto);
        if (pageDto != null) {
            pageDto.setCount(count);
            if (kexiaoRecords.size() < pageDto.getPageSize()) {
                PageDto pageDtoTemp = new PageDto();
                pageDtoTemp.setPageNum(1);
                pageDtoTemp.setPageSize(pageDto.getPageSize() - kexiaoRecords.size());
                signupRefunRecords = orgSignupRefundDao.pageByClassIds(orgId, classIds, startTime, endTime, pageDtoTemp);
            }
        } else {
            signupRefunRecords = orgSignupRefundDao.pageByClassIds(orgId, classIds, startTime, endTime, null);
        }

        //数据填充
        if (CollectionUtils.isEmpty(kexiaoRecords) && CollectionUtils.isEmpty(signupRefunRecords)) {
            log.info("listOrgDetailKexiaoListDto - return - record is empty");
            if (pageDto == null) {
                pageDto = new PageDto();
            }
            pageDto.setCount(0);
            return new ArrayList<OrgDetailKexiaoListDto>();
        } else {
            List<OrgDetailKexiaoListDto> result = new ArrayList<OrgDetailKexiaoListDto>();
            Map<Long, OrgStudent> studentMapKeyUserId = null;
            Map<Long, OrgCourse> classMapKeyCourseId = null;
            OrgDetailKexiaoListDto dto = null;

            Set<Long> studentUserIdsInPage = new HashSet<Long>();
            Set<Long> classIdsInPage = new HashSet<Long>();
            Set<Long> lessonIds = new HashSet<Long>();
            if (CollectionUtils.isNotEmpty(kexiaoRecords)) {
                for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                    studentUserIdsInPage.add(record.getUserId());
                    classIdsInPage.add(record.getClassId());
                    lessonIds.add(record.getLessonId());
                }
            }
            if (CollectionUtils.isNotEmpty(signupRefunRecords)) {
                for (OrgSignupRefund record : signupRefunRecords) {
                    studentUserIdsInPage.add(record.getUserId());
                    classIdsInPage.add(record.getClassId());
                }
            }

            if (CollectionUtils.isNotEmpty(studentUserIdsInPage)) {
                studentMapKeyUserId = orgStudentDao.getStudentMap(studentUserIdsInPage, orgId);
            }

            if (CollectionUtils.isNotEmpty(classIdsInPage)) {
                classMapKeyCourseId = orgCourseDao.getOrgCourseMap(classIdsInPage);
            }

            Map<Long, Teacher> lessonTeacherMap = getLessonTeacherMap(orgId, lessonIds);

            if (CollectionUtils.isNotEmpty(kexiaoRecords)) {
                OrgStudent student = null;
                OrgCourse orgClass = null;

                for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                    orgClass = classMapKeyCourseId.get(record.getClassId());
                    student = studentMapKeyUserId.get(record.getUserId());
                    Teacher teacher = lessonTeacherMap.get(record.getLessonId());
                    dto = new OrgDetailKexiaoListDto();
                    if (teacher != null) {
                        dto.setTeacherName(teacher.getRealName());
                    }
                    dto.setStudentName(student.getName());
                    dto.setStudentUserId(student.getUserId());
                    dto.setClassId(orgClass.getId());
                    dto.setClassName(orgClass.getName());
                    dto.setCourseType(orgClass.getCourseType());
                    dto.setChargeUnit(orgClass.getChargeUnit());
                    dto.setChargeType(orgClass.getChargeType());
                    dto.setLessonStartTime(record.getStartTime());
                    dto.setLessonEndTime(DateUtil.getDiffMinute(record.getStartTime(), record.getLessonDuration()));
                    dto.setKexiaoMoney(record.getAmount());
                    dto.setQuitClassMoney(0L);
                    dto.setTotalKexiaoMoney(dto.getKexiaoMoneyLong());
                    if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                        dto.setLessonTimes(DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES);
                    } else {
                        dto.setLessonMinute(record.getLessonDuration());
                    }

                    result.add(dto);
                }
            }

            if (CollectionUtils.isNotEmpty(signupRefunRecords)) {
                OrgStudent student = null;
                OrgCourse orgClass = null;

                for (OrgSignupRefund record : signupRefunRecords) {
                    orgClass = classMapKeyCourseId.get(record.getClassId());
                    student = studentMapKeyUserId.get(record.getUserId());

                    dto = new OrgDetailKexiaoListDto();
                    dto.setStudentName(student.getName());
                    dto.setStudentUserId(student.getUserId());
                    dto.setClassId(orgClass.getId());
                    dto.setClassName(orgClass.getName());
                    dto.setCourseType(orgClass.getChargeType());
                    dto.setChargeUnit(orgClass.getChargeUnit());
                    dto.setChargeType(orgClass.getChargeType());
                    dto.setKexiaoMoney(0L);
                    dto.setQuitClassMoney(record.getRefundFee());
                    dto.setTotalKexiaoMoney(dto.getQuitClassMoneyLong());
                    dto.setQuitClassTime(record.getCreateTime());

                    result.add(dto);
                }
            }
            return result;
        }
    }

    private Map<Long, Teacher> getLessonTeacherMap(Long orgId, Collection<Long> lessonIds) {
        Map<Long, Teacher> lessonTeacherMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            Map<Long, Long> lessonTeacherIdMap = teacherLessonDao.queryLessonTeacherIdMap(orgId, lessonIds);
            if (!lessonTeacherIdMap.isEmpty()) {
                List<Teacher> teachers = teacherDao.getByUserIds(lessonTeacherIdMap.values(), "userId", "id", "realName");
                Map<Long, Teacher> teacherMap = CollectionHelper.toKeyMap(teachers, "userId");

                for (Long lessonId : lessonIds) {
                    Long userId = lessonTeacherIdMap.get(lessonId);
                    Teacher teacher = teacherMap.get(userId);
                    lessonTeacherMap.put(lessonId, teacher);
                }
            }
        }
        return lessonTeacherMap;
    }

    @Override
    public OrgDetailKexiaoListDto getOrgDetailKexiaoListTotal(OrgDetailKexiaoListParamDto param) {
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        OrgAccount org = orgAccountDao.getById(orgId);

        OrgDetailKexiaoListDto dto = new OrgDetailKexiaoListDto();
        Double lessonHour = 0.00;
        Integer lessonTimes = 0;
        Long kexiaoMoney = 0L;
        Long quitClassMoney = 0L;
        Long totalKexiaoMoney = 0L;


        KexiaoSumDto durationDto = null;
        KexiaoSumDto timesDto = null;
        List<Long> classIds = null;
        if (param.conditionQuery()) {
            classIds = orgCourseDao.listCourseId(org.getNumber().longValue(), param.getKeyword(), null, null, null);
            if (CollectionUtils.isEmpty(classIds)) {
                dto.setKexiaoMoney(kexiaoMoney);
                dto.setQuitClassMoney(quitClassMoney);
                dto.setTotalKexiaoMoney(totalKexiaoMoney);
                dto.setLessonTimes(lessonTimes);
                dto.setLessonHour(lessonHour);

                log.info("listOrgDetailKexiaoListDto - return - search is empty");
                return dto;
            }
        }

        List<Long> orgIds = getArrayList(orgId);
        durationDto = orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, classIds, null, ChargeUnit.listByTimeCode(), startTime, endTime);
        timesDto = orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, classIds, null, ChargeUnit.listByTimesCode(), startTime, endTime);
        quitClassMoney = orgSignupRefundDao.sumRefundFeeByOrgIds(orgIds, startTime, endTime);

        if (durationDto != null) {
            lessonHour = durationDto.getSumKexiaoHour();
            kexiaoMoney += durationDto.getSumKexiaoMoney();
        }
        if (timesDto != null) {
            lessonTimes = timesDto.getSumKexiaoTimes();
            kexiaoMoney += timesDto.getSumKexiaoMoney();
        }

        totalKexiaoMoney = kexiaoMoney + quitClassMoney;
        dto.setKexiaoMoney(kexiaoMoney);
        dto.setQuitClassMoney(quitClassMoney);
        dto.setTotalKexiaoMoney(totalKexiaoMoney);
        dto.setLessonTimes(lessonTimes);
        dto.setLessonHour(lessonHour);

        return dto;
    }


    @Override
    public ClassDetailStatisticsDto getClassDetailStatisticsDto(Long orgId, Long classId) {
        ClassDetailStatisticsDto dto = new ClassDetailStatisticsDto();
        Date startTime = DateUtil.getCurrentDate();
        Date endTime = DateUtil.getDiffDateTime(startTime, 1);

        OrgCourse orgClass = orgCourseDao.getByCourseId(classId);
        long courseId = classId;
        if (orgClass.getParentId() != null && orgClass.getParentId() > 0) {
            courseId = orgClass.getParentId();
        }

        OrgCourseConsumeRule kexiaoRule = courseConsumeRuleDao.getRuleByCourseId(orgId, courseId);
        Integer studentCount = orgStudentCourseDao.countStudents(orgId, classId, StudentCourseStatus.NORMAL.getCode());
        Long todayKexiaoMoney = 0L;
        Long todayQuitClassMoney = 0L;
        Double todayKexiaoHour = 0.00;
        Integer todayKexiaoTimes = 0;

        //TODO 调整为 sql sum
        List<OrgStudentKexiaoRecord> kexiaoRecords = orgStudentKexiaoRecordDao.listByClassId(orgId, classId, null, startTime, endTime);
        List<OrgSignupRefund> signupRefunRecords = orgSignupRefundDao.listByClassId(orgId, classId, null, startTime, endTime);
        if (CollectionUtils.isNotEmpty(kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                todayKexiaoMoney += record.getAmount();
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    todayKexiaoTimes += DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES;
                } else {
                    todayKexiaoHour += record.getLessonDurationHour();
                }
            }
        }
        if (CollectionUtils.isNotEmpty(signupRefunRecords)) {
            for (OrgSignupRefund record : signupRefunRecords) {
                todayKexiaoMoney += record.getRefundFee();
                todayQuitClassMoney += record.getRefundFee();
            }
        }

        dto.setClassId(orgClass.getId());
        dto.setClassName(orgClass.getName());
        dto.setTodayQuitClassMoney(todayQuitClassMoney);
        dto.setTodayKexiaoHour(todayKexiaoHour);
        dto.setTodayKexiaoMoney(todayKexiaoMoney);
        dto.setTodayKexiaoTimes(todayKexiaoTimes);
        dto.setStudentCount(studentCount);
        dto.setChargeType(orgClass.getChargeType());
        dto.setChargeUnit(orgClass.getChargeUnit());
        if (kexiaoRule != null) {
            dto.setKexiaoRule(kexiaoRule.getRuleValue());
        }

        return dto;
    }

    @Override
    public List<ClassDetailListDto> listClassDetailListDto(ClassDetailListParamDto param, PageDto pageDto) {
        Long orgId = param.getOrgId();
        Long classId = param.getClassId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();

        //数据筛选
        Map<Long, OrgStudent> orgStudentMap = classDetailListSearch(param);
        if (MapUtils.isEmpty(orgStudentMap)) {
            log.info("listClassDetailListDto - return - studentCourses is empty");
            return new ArrayList<ClassDetailListDto>();
        }

        //数据查询
        Set<Long> studentUserIds = orgStudentMap.keySet();
        List<Long> kexiaoRecordIds = orgStudentKexiaoRecordDao.listIdsByClassId(orgId, classId, studentUserIds, startTime, endTime);
        List<Integer> signupRefunIds = orgSignupRefundDao.listIdsByClassId(orgId, classId, studentUserIds, startTime, endTime);
        List<OrgStudentKexiaoRecord> kexiaoRecords = null;
        List<OrgSignupRefund> signupRefunRecords = null;
        Set<Long> lessonIds = new HashSet<>();
        Integer count = kexiaoRecordIds.size() + signupRefunIds.size();
        if (pageDto != null) {
            pageDto.setCount(count);
        }

        if (count == 0) {
            log.info("listClassDetailListDto - return - kexiao record is empty");
            return new ArrayList<ClassDetailListDto>();
        } else {
            if (pageDto != null) {
                List<Long> kexiaoRecordIdsTemp = new ArrayList<Long>();
                List<Integer> signupRefunIdsTemp = new ArrayList<Integer>();

                int cursor = 0;
                int limitFrom = pageDto.firstNum();
                int limitTo = pageDto.firstNum() + pageDto.getPageSize() - 1;
                for (Long kxid : kexiaoRecordIds) {
                    if (cursor > limitTo) {
                        break;
                    } else if (cursor >= limitFrom) {
                        kexiaoRecordIdsTemp.add(kxid);
                    }
                    cursor++;
                }

                for (Integer srid : signupRefunIds) {
                    if (cursor > limitTo) {
                        break;
                    } else if (cursor >= limitFrom) {
                        signupRefunIdsTemp.add(srid);
                    }
                    cursor++;
                }
                kexiaoRecordIds = kexiaoRecordIdsTemp;
                signupRefunIds = signupRefunIdsTemp;
            }
        }
        if (CollectionUtils.isNotEmpty(kexiaoRecordIds)) {
            kexiaoRecords = orgStudentKexiaoRecordDao.listOrderByStartTime(kexiaoRecordIds);
        }
        if (CollectionUtils.isNotEmpty(signupRefunIds)) {
            signupRefunRecords = orgSignupRefundDao.listOrderByCreateTime(signupRefunIds);
        }

        if (CollectionUtils.isNotEmpty(kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                lessonIds.add(record.getLessonId());
            }
        }
        Map<Long, Teacher> lessonTeacherMap = getLessonTeacherMap(orgId, lessonIds);

        //数据填充
        List<ClassDetailListDto> result = new ArrayList<ClassDetailListDto>();
        ClassDetailListDto dto = null;
        OrgStudent student = null;

        if (CollectionUtils.isNotEmpty(kexiaoRecords)) {

            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                student = orgStudentMap.get(record.getUserId());

                dto = new ClassDetailListDto();
                Teacher teacher = lessonTeacherMap.get(record.getLessonId());
                if (teacher != null) {
                    dto.setTeacherName(teacher.getRealName());
                }
                dto.setStudentUserId(student.getUserId());
                dto.setStudentName(student.getName());
                dto.setLessonStartTime(record.getStartTime());
                dto.setLessonEndTime(DateUtil.getDiffMinute(record.getStartTime(), record.getLessonDuration()));
                dto.setKexiaoMoney(record.getAmount());
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    dto.setLessonTimes(DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES);
                } else {
                    dto.setLessonMinute(record.getLessonDuration());
                }

                OrgLessonSign signData = orgLessonSignDao.getStudentLessonSign(orgId, classId, record.getLessonId(), student.getUserId(), UserRole.STUDENT.getRole());
                if (signData != null) {
                    dto.setSigninStatus(signData.getStatus());
                }

                result.add(dto);
            }
        }

        if (CollectionUtils.isNotEmpty(signupRefunIds)) {
            for (OrgSignupRefund record : signupRefunRecords) {
                student = orgStudentMap.get(record.getUserId());

                dto = new ClassDetailListDto();
                dto.setStudentUserId(student.getUserId());
                dto.setStudentName(student.getName());
                dto.setLessonStartTime(record.getCreateTime());
                dto.setKexiaoMoney(record.getRefundFee());
                dto.setQuitClassTime(record.getCreateTime());
                dto.setLessonMinute(null);

                result.add(dto);
            }
        }

        return result;
    }

    @Override
    public ClassDetailListDto getClassDetailListTotal(ClassDetailListParamDto param) {
        ClassDetailListDto result = new ClassDetailListDto();
        Long orgId = param.getOrgId();
        Long classId = param.getClassId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();

        Map<Long, OrgStudent> orgStudentMap = classDetailListSearch(param);
        if (MapUtils.isEmpty(orgStudentMap)) {
            log.info("getClassDetailListTotal - return - studentCourses is empty");
            result.setLessonMinute(null);
            result.setLessonTimes(null);
            result.setKexiaoMoney(0L);
            return result;
        }

        Set<Long> studentUserIds = orgStudentMap.keySet();
        List<OrgStudentKexiaoRecord> kexiaoRecords = orgStudentKexiaoRecordDao.listByClassId(orgId, classId, studentUserIds, startTime, endTime);
        List<OrgSignupRefund> signupRefuns = orgSignupRefundDao.listByClassId(orgId, classId, studentUserIds, startTime, endTime);

        Double lessonHour = 0.00;
        Integer lessonTimes = 0;
        Long kexiaoMoney = 0L;

        if (CollectionUtils.isNotEmpty(kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                kexiaoMoney += record.getAmount();
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    lessonTimes += DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES;
                } else {
                    lessonHour += record.getLessonDurationHour();
                }
            }
        }
        if (CollectionUtils.isNotEmpty(signupRefuns)) {
            for (OrgSignupRefund record : signupRefuns) {
                kexiaoMoney += record.getRefundFee();
            }
        }

        result.setLessonHour(lessonHour);
        result.setLessonTimes(lessonTimes);
        result.setKexiaoMoney(kexiaoMoney);
        return result;
    }


    Map<Long, OrgStudent> classDetailListSearch(ClassDetailListParamDto param) {
        Long orgId = param.getOrgId();
        Long classId = param.getClassId();
        String keyword = param.getKeyword();

        //查询班级
        List<OrgStudentCourse> studentClass = orgStudentCourseDao.listByCourseId(orgId, classId, null, null);
        Set<Long> studentUserIds = null;

        if (CollectionUtils.isNotEmpty(studentClass)) {
            studentUserIds = new HashSet<Long>();
            for (OrgStudentCourse osc : studentClass) {
                studentUserIds.add(osc.getUserId());
            }
        } else {
            log.info("classDetailListSearch - return - studentCourses is empty");
            return null;
        }

        //搜索词筛选
        Map<Long, OrgStudent> orgStudentMap = orgStudentDao.getStudentMap(studentUserIds, orgId);

        if (StringUtils.isNotBlank(keyword)) {
            Map<Long, OrgStudent> orgStudentMapTemp = new HashMap<Long, OrgStudent>();
            OrgStudent student = null;
            for (Long key : orgStudentMap.keySet()) {
                student = orgStudentMap.get(key);
                if (student.getName().contains(keyword)) {
                    orgStudentMapTemp.put(key, student);
                }
            }
            orgStudentMap = orgStudentMapTemp;
        }

        return orgStudentMap;
    }


    @Override
    public StudentDetailStatisticsDto getStudentDetailStatisticsDto(Long orgId, Long studentUserId) {
        StudentDetailStatisticsDto dto = new StudentDetailStatisticsDto();
        Date startTime = DateUtil.getCurrentDate();
        Date endTime = DateUtil.getDiffDateTime(startTime, 1);

        OrgStudent student = orgStudentDao.getStudentByUserId(orgId, studentUserId);
        Map<Long, KexiaoStudentStat> map = kexiaoApiService.queryUserKexiaoStat(orgId, Arrays.asList(studentUserId));
        Integer classCount = orgStudentCourseDao.getStudentSignupCourseCount(orgId, studentUserId, StudentCourseStatus.NORMAL.getCode());
        KexiaoStudentStat stat = map.get(studentUserId);
        if (stat == null) {
            stat = new KexiaoStudentStat();
        }
        Long payMoney = 0L;
        Long remainingMoney = 0L;
        Double todayKexiaoHour = 0.00;
        Long todayKexiaoHourMoney = 0L;
        Integer todayKexiaoTimes = 0;
        Long todayKexiaoTimesMoney = 0L;
        Long todayKexiaoTotalMoney = 0L;
        Long quitClassMoney = 0L;

        //今日数据
        List<OrgStudentKexiaoRecord> todayKexiaoRecords = orgStudentKexiaoRecordDao.listByUserId(orgId, null, studentUserId, startTime, endTime);
        List<OrgSignupRefund> todaySignupRefunRecords = orgSignupRefundDao.listByUserId(orgId, null, studentUserId, startTime, endTime);

        for (OrgStudentKexiaoRecord record : todayKexiaoRecords) {
            if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                todayKexiaoTimes += DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES;
                todayKexiaoTimesMoney += record.getAmount();
            } else {
                todayKexiaoHour += record.getLessonDurationHour();
                todayKexiaoHourMoney += record.getAmount();
            }
        }

        for (OrgSignupRefund record : todaySignupRefunRecords) {
            quitClassMoney += record.getRefundFee();
        }
        todayKexiaoTotalMoney += todayKexiaoTimesMoney;
        todayKexiaoTotalMoney += todayKexiaoHourMoney;
        todayKexiaoTotalMoney += quitClassMoney;

        dto.setStudentUserId(student.getUserId());
        dto.setStudentName(student.getName());
        dto.setClassCount(classCount);

        TxStudentFinanceAccount account = studentFinanceAccountDao.getFinanceAccount(orgId, student.getId());
        int balance = 0;
        if (account != null) {
            balance += account.getBalance();
        }
        dto.setPayMoney(stat.getTotalAmount() + balance);
        dto.setRemainingMoney(stat.getLeftAmount());

        dto.setTodayKexiaoHour(todayKexiaoHour);
        dto.setTodayKexiaoHourMoney(todayKexiaoHourMoney);
        dto.setTodayKexiaoTimes(todayKexiaoTimes);
        dto.setTodayKexiaoTimesMoney(todayKexiaoTimesMoney);
        dto.setTodayKexiaoTotalMoney(todayKexiaoTotalMoney);
        dto.setTodayQuitClassMoney(quitClassMoney);

        return dto;
    }

    @Override
    public List<StudentDetailListDto> listStudentDetailListDto(StudentDetailListParamDto param, PageDto pageDto) {
        Long orgId = param.getOrgId();
        Long userId = param.getStudentUserId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();

        //数据筛选
        Map<Long, OrgCourse> orgClassMap = studentDetailListSearch(param);
        if (MapUtils.isEmpty(orgClassMap)) {
            log.info("listStudentDetailListDto - return - studentCourses is empty");
            return new ArrayList<StudentDetailListDto>();
        }

        //查询数据
        Set<Long> classIds = orgClassMap.keySet();
        List<Long> kexiaoRecordIds = orgStudentKexiaoRecordDao.listIdsByUserId(orgId, classIds, userId, startTime, endTime);
        List<Integer> signupRefunIds = orgSignupRefundDao.listIdsByUserId(orgId, classIds, userId, startTime, endTime);
        List<OrgStudentKexiaoRecord> kexiaoRecords = null;
        List<OrgSignupRefund> signupRefunRecords = null;

        Integer count = kexiaoRecordIds.size() + signupRefunIds.size();
        if (pageDto != null) {
            pageDto.setCount(count);
        }
        if (count == 0) {
            log.info("listStudentDetailListDto - return - kexiao record is empty");
            return new ArrayList<StudentDetailListDto>();
        } else {
            if (pageDto != null) {
                List<Long> kexiaoRecordIdsTemp = new ArrayList<Long>();
                List<Integer> signupRefunIdsTemp = new ArrayList<Integer>();

                int cursor = 0;
                int limitFrom = pageDto.firstNum();
                int limitTo = pageDto.firstNum() + pageDto.getPageSize() - 1;
                for (Long kxid : kexiaoRecordIds) {
                    if (cursor > limitTo) {
                        break;
                    } else if (cursor >= limitFrom) {
                        kexiaoRecordIdsTemp.add(kxid);
                    }
                    cursor++;
                }

                for (Integer srid : signupRefunIds) {
                    if (cursor > limitTo) {
                        break;
                    } else if (cursor >= limitFrom) {
                        signupRefunIdsTemp.add(srid);
                    }
                    cursor++;
                }
                kexiaoRecordIds = kexiaoRecordIdsTemp;
                signupRefunIds = signupRefunIdsTemp;
            }
        }

        if (CollectionUtils.isNotEmpty(kexiaoRecordIds)) {
            kexiaoRecords = orgStudentKexiaoRecordDao.listOrderByStartTime(kexiaoRecordIds);
        }
        if (CollectionUtils.isNotEmpty(signupRefunIds)) {
            signupRefunRecords = orgSignupRefundDao.listOrderByCreateTime(signupRefunIds);
        }

        Set<Long> lessonIds = new HashSet<>();
        if (CollectionUtils.isNotEmpty(kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                lessonIds.add(record.getLessonId());
            }
        }
        Map<Long, Teacher> lessonTeacherMap = getLessonTeacherMap(orgId, lessonIds);

        //数据填充
        List<StudentDetailListDto> result = new ArrayList<StudentDetailListDto>();
        StudentDetailListDto dto = null;
        OrgCourse orgClass = null;

        if (CollectionUtils.isNotEmpty(kexiaoRecords)) {
            Map<Long, Integer> lessonIdVsSigninStatusMap = orgLessonSignDao.mapKeyLessonIdValueStatus(orgId, userId);

            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                orgClass = orgClassMap.get(record.getClassId());

                dto = new StudentDetailListDto();
                Teacher teacher = lessonTeacherMap.get(record.getLessonId());
                if (teacher != null) {
                    dto.setTeacherName(teacher.getRealName());
                }
                dto.setClassId(orgClass.getId());
                dto.setClassName(orgClass.getName());
                dto.setLessonStartTime(record.getStartTime());
                dto.setLessonEndTime(DateUtil.getDiffMinute(record.getStartTime(), record.getLessonDuration()));
                dto.setKexiaoMoney(record.getAmount());
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    dto.setLessonTimes(DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES);
                } else {
                    dto.setLessonMinute(record.getLessonDuration());
                }

                dto.setSigninStatus(lessonIdVsSigninStatusMap.get(record.getLessonId()));

                result.add(dto);
            }
        }

        if (CollectionUtils.isNotEmpty(signupRefunIds)) {
            for (OrgSignupRefund record : signupRefunRecords) {
                orgClass = orgClassMap.get(record.getClassId());

                dto = new StudentDetailListDto();
                dto.setClassId(orgClass.getId());
                dto.setClassName(orgClass.getName());
                dto.setLessonStartTime(record.getCreateTime());
                dto.setKexiaoMoney(record.getRefundFee());
                dto.setQuitClassTime(record.getCreateTime());

                result.add(dto);
            }
        }

        return result;
    }

    @Override
    public StudentDetailListDto getStudentDetailListTotal(StudentDetailListParamDto param) {
        StudentDetailListDto result = new StudentDetailListDto();
        Long orgId = param.getOrgId();
        Long userId = param.getStudentUserId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();

        //数据筛选
        Map<Long, OrgCourse> orgClassMap = studentDetailListSearch(param);
        if (MapUtils.isEmpty(orgClassMap)) {
            log.info("getStudentDetailListDtoTotal - return - studentCourses is empty");
            result.setLessonHour(null);
            result.setLessonTimes(null);
            result.setKexiaoMoney(0L);
            return result;
        }

        Set<Long> classIds = orgClassMap.keySet();
        List<OrgStudentKexiaoRecord> kexiaoRecords = orgStudentKexiaoRecordDao.listByUserId(orgId, classIds, userId, startTime, endTime);
        List<OrgSignupRefund> signupRefuns = orgSignupRefundDao.listByUserId(orgId, classIds, userId, startTime, endTime);

        Double lessonHour = 0.00;
        Integer lessonTimes = 0;
        Long kexiaoMoney = 0L;

        if (CollectionUtils.isNotEmpty(kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                kexiaoMoney += record.getAmount();
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    lessonTimes += DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES;
                } else {
                    lessonHour += record.getLessonDurationHour();
                }
            }
        }
        if (CollectionUtils.isNotEmpty(signupRefuns)) {
            for (OrgSignupRefund record : signupRefuns) {
                kexiaoMoney += record.getRefundFee();
            }
        }

        result.setLessonHour(lessonHour);
        result.setLessonTimes(lessonTimes);
        result.setKexiaoMoney(kexiaoMoney);
        return result;
    }


    Map<Long, OrgCourse> studentDetailListSearch(StudentDetailListParamDto param) {
        Long orgId = param.getOrgId();
        Long userId = param.getStudentUserId();
        String keyword = param.getKeyword();

        //查询班级
        List<OrgStudentCourse> studentClass = orgStudentCourseDao.listByUserId(orgId, userId, null, null);
        Set<Long> classIds = null;

        if (CollectionUtils.isNotEmpty(studentClass)) {
            classIds = new HashSet<Long>();
            for (OrgStudentCourse osc : studentClass) {
                classIds.add(osc.getCourseId());
            }
        } else {
            log.info("StudentDetailListDtoSearch - return - studentCourses is empty");
            return null;
        }

        //搜索词筛选
        Map<Long, OrgCourse> orgClassMap = orgCourseDao.getOrgCourseMap(classIds);

        if (StringUtils.isNotBlank(keyword)) {
            Map<Long, OrgCourse> orgClassMapTemp = new HashMap<Long, OrgCourse>();
            OrgCourse orgClass = null;
            for (Long key : orgClassMap.keySet()) {
                orgClass = orgClassMap.get(key);
                if (orgClass.getName().contains(keyword)) {
                    orgClassMapTemp.put(key, orgClass);
                }
            }
            orgClassMap = orgClassMapTemp;
        }

        return orgClassMap;
    }


//	Map<Long,LinkedHashMap<Long,RemainingDataDto>> getRemainingDataByUserId(Long orgId, Long userId){
//		Map<Long,LinkedHashMap<Long,RemainingDataDto>> result = new HashMap<Long,LinkedHashMap<Long,RemainingDataDto>>();
//		Map<Long, OrgSignupCourse> signupCourseMap = orgSignupCourseDao.mapKeyClassId(orgId, userId);
//		List<OrgStudentKexiaoRecord> records = orgStudentKexiaoRecordDao.listByUserId(orgId, null, userId, null, null);
//		
//		LinkedHashMap<Long,RemainingDataDto> remainingDataMap = null;
//		RemainingDataDto remainingData = null;
//		RemainingDataDto preRemainingData = null;
//		OrgSignupCourse orgSignupCourse = null;
//		
//		if(CollectionUtils.isNotEmpty(records)){
//			for(OrgStudentKexiaoRecord record:records){
//				remainingDataMap = result.get(record.getClassId());
//				orgSignupCourse = signupCourseMap.get(record.getClassId());
//				
//				if(orgSignupCourse==null){
//					orgSignupCourse = new OrgSignupCourse();
//					orgSignupCourse.setPayPrice(0L);
//					orgSignupCourse.setStudentPayPrice(0L);
//					orgSignupCourse.setLessonCount(0);
//				}
//				
//				if(remainingDataMap==null){
//					remainingDataMap = new LinkedHashMap<Long,RemainingDataDto>();
//					result.put(record.getClassId(), remainingDataMap);
//					
//					preRemainingData = new RemainingDataDto();
//					preRemainingData.setRemainingMoney( orgSignupCourse.getTotalPayPrice() );
//					if(record.getChargeUnit() == ChargeUnit.BY_TIMES.getCode()){
//						preRemainingData.setRemainingTimes( orgSignupCourse.getLessonCount() );
//					}else{						
//						preRemainingData.setRemainingHour( orgSignupCourse.getLessonCount().doubleValue() );
//					}
//				}else{
//					for(RemainingDataDto dto : remainingDataMap.values()){
//						preRemainingData = dto;
//					}
//				}
//				remainingData = new RemainingDataDto();
//				remainingDataMap.put(record.getLessonId(), remainingData);
//				
//				if(record.getChargeUnit() == ChargeUnit.BY_TIMES.getCode()){
//					remainingData.setRemainingTimes( preRemainingData.getRemainingTimes()-1 );
//				}else{						
//					remainingData.setRemainingHour( preRemainingData.getRemainingHour() - record.getLessonDurationHour() );
//				}
//			}
//		}
//		
//		return result;
//	}
//	
//	
//	Map<Long,LinkedHashMap<Long,RemainingDataDto>> getRemainingDataByClassId(Long orgId, Long classId){
//		Map<Long,LinkedHashMap<Long,RemainingDataDto>> result = new HashMap<Long,LinkedHashMap<Long,RemainingDataDto>>();
//		Map<Long, OrgSignupCourse> signupCourseMap = orgSignupCourseDao.mapKeyUserId(orgId, classId);
//		
//		
//		List<OrgStudentKexiaoRecord> records = orgStudentKexiaoRecordDao.listByClassId(orgId, classId, null, null, null);
//		LinkedHashMap<Long,RemainingDataDto> remainingDataMap = null;
//		RemainingDataDto remainingData = null;
//		RemainingDataDto preRemainingData = null;
//		OrgSignupCourse orgSignupCourse = null;
//		
//		if(CollectionUtils.isNotEmpty(records)){
//			for(OrgStudentKexiaoRecord record:records){
//				remainingDataMap = result.get(record.getUserId());
//				orgSignupCourse = signupCourseMap.get(record.getUserId());
//				if(orgSignupCourse==null){
//					orgSignupCourse = new OrgSignupCourse();
//					orgSignupCourse.setPayPrice(0L);
//					orgSignupCourse.setStudentPayPrice(0L);
//					orgSignupCourse.setLessonCount(0);
//				}
//				
//				if(remainingDataMap==null){
//					remainingDataMap = new LinkedHashMap<Long,RemainingDataDto>();
//					result.put(record.getUserId(), remainingDataMap);
//					
//					preRemainingData = new RemainingDataDto();
//					if(record.getChargeUnit() == ChargeUnit.BY_TIMES.getCode()){
//						preRemainingData.setRemainingTimes( orgSignupCourse.getLessonCount() );
//					}else{						
//						preRemainingData.setRemainingHour( orgSignupCourse.getLessonCount().doubleValue() );
//					}
//				}else{
//					for(RemainingDataDto dto : remainingDataMap.values()){
//						preRemainingData = dto;
//					}
//				}
//				remainingData = new RemainingDataDto();
//				remainingDataMap.put(record.getLessonId(), remainingData);
//				if(record.getChargeUnit() == ChargeUnit.BY_TIMES.getCode()){
//					remainingData.setRemainingTimes( preRemainingData.getRemainingTimes()-1 );
//				}else{
//					remainingData.setRemainingHour( preRemainingData.getRemainingHour() - record.getLessonDurationHour() );
//				}
//			}
//		}
//		
//		return result;
//	}


    /** Map<userId,LinkedHashMap<lessonId,RemainingDataDto>> */
//	Map<Long,LinkedHashMap<Long,RemainingDataDto>> getRemainingDataByClassId1(Long orgId, Long classId, List<Long> userIds){
//		
//		Map<Long,LinkedHashMap<Long,RemainingDataDto>> result = new HashMap<Long,LinkedHashMap<Long,RemainingDataDto>>();
//		
//		//报名记录
//		List<OrgSignupCourse> signupCourses = null;//orgSignupCourseDao.mapKeyUserId(orgId, classId);
//		//退班记录
//		List<OrgSignupRefund> signupRefunds = null;//orgSignupRefundDao.mapKeyUserId(orgId, classId);
//		//课消记录
//		List<OrgStudentKexiaoRecord> records = null;//orgStudentKexiaoRecordDao.listByClassId(orgId, classId, null, null, null);
//		//课节记录
//		List<OrgSignupCourseLesson> lessons = null; 
//		
//		
//		
//		Map<Long,List<OrgStudentKexiaoRecord>> kexiaoMapKeyUserId = new HashMap<Long,List<OrgStudentKexiaoRecord>>();
//		if(CollectionUtils.isNotEmpty(records)){
//			List<OrgStudentKexiaoRecord> list = null;
//			for(OrgStudentKexiaoRecord record:records){
//				list = kexiaoMapKeyUserId.get(record.getUserId());
//				if(list==null){
//					records = new ArrayList<OrgStudentKexiaoRecord>();
//					kexiaoMapKeyUserId.put(record.getUserId(),records);
//				}
//				records.add(record);
//			}
//		}
//		
//		Map<Long,List<Long>> mapUserIdVsPurchaseId = new HashMap<Long,List<Long>>();
//		if(CollectionUtils.isNotEmpty(lessons)){
//			List<Long> list = null;
//			for(OrgSignupCourseLesson lesson:lessons){
//				list = mapUserIdVsPurchaseId.get(lesson.getUserId());
//				if(list==null){
//					list = new ArrayList<Long>();
//					mapUserIdVsPurchaseId.put(lesson.getUserId(),list);
//				}
//				
//				Long signupCourseId = lesson.getSignupCourseId();
//				OrgSignupCourse orgSignupCourse = orgSignupCourseDao.getById(signupCourseId);
//				list.add(orgSignupCourse.getSignupPurchaseId());
//			}
//		}
//		
//		LinkedHashMap<Long,OrgSignupCourse> mapKeyPurchaseIdVsPo = new LinkedHashMap<Long,OrgSignupCourse>();
//		Map<Long,SignupCourseReaminDto> mapKeyPurchaseIdVsReamin = new HashMap<Long,SignupCourseReaminDto>();
//		SignupCourseReaminDto signupCourseReaminDto = null;
//		if(CollectionUtils.isNotEmpty(signupCourses)){
//			for(OrgSignupCourse osc:signupCourses){
//				signupCourseReaminDto = new SignupCourseReaminDto();
//				signupCourseReaminDto.setReaminPayPrice(osc.getPayPrice());
//				signupCourseReaminDto.setReaminTimes(osc.getLessonCount());
//				signupCourseReaminDto.setReaminHour(osc.getLessonCount().doubleValue());
//				mapKeyPurchaseIdVsReamin.put(osc.getSignupPurchaseId(), signupCourseReaminDto);
//				
//				mapKeyPurchaseIdVsPo.put(osc.getSignupPurchaseId(), osc);
//			}
//		}
//		
//		LinkedHashMap<Long,OrgSignupRefund> mapKeySignupRefundPurchaseIdVsPo = new LinkedHashMap<Long,OrgSignupRefund>();
//		if(CollectionUtils.isNotEmpty(signupRefunds)){
//			for(OrgSignupRefund refund:signupRefunds){
//				mapKeySignupRefundPurchaseIdVsPo.put(refund.getSignupPurchaseId(), refund);
//			}
//		}
//		
//		
//		if(CollectionUtils.isNotEmpty(userIds)){
//			for(Long userId:userIds){
//				List<OrgStudentKexiaoRecord> kexiaoRecords = kexiaoMapKeyUserId.get(userId);
//				Map<Long,OrgSignupCourse> signupCourseMapKeyId = new HashMap<Long,OrgSignupCourse>();
//				
//				LinkedHashMap<Long,RemainingDataDto> dataMapKeyLessonId = result.get(userId);
//				if(dataMapKeyLessonId == null){
//					dataMapKeyLessonId = new LinkedHashMap<Long,RemainingDataDto>();
//					result.put(userId, dataMapKeyLessonId);
//				}
//				
//				if(CollectionUtils.isNotEmpty(kexiaoRecords)){
//					for(int i=0; i<kexiaoRecords.size();i++){
//						OrgStudentKexiaoRecord kexiaoRecord = kexiaoRecords.get(i);
//						Long lessonId = kexiaoRecord.getLessonId();
//						List<Long> purchaseIds = mapUserIdVsPurchaseId.get(lessonId);
//						Long kexiaoRecordReaminAmount = kexiaoRecord.getAmount();
//						Double kexiaoRecordReaminHour = DashboadrKexiaoDtoHelper.durationM2H(kexiaoRecord.getLessonDuration());
//						
//						if(CollectionUtils.isEmpty(purchaseIds)){
//							RemainingDataDto dto = new RemainingDataDto();
//							dto.setRemainingHour(0.00);
//							dto.setRemainingMoney(0L);
//							dto.setRemainingTimes(0);
//							dataMapKeyLessonId.put(lessonId, dto);
//							continue;
//						}else{
//							if(i==0){
//								Long reaminAmount = kexiaoRecord.getAmount();
//								Long reamin = 0L; 
//								for(Long purchaseId:purchaseIds){
//									//依次消耗订单 最后一个订单剩的钱就是剩余学费
//									if(mapKeySignupRefundPurchaseIdVsPo.get(purchaseId)!=null){
//										//TODO
//										//判断是否在此节退班（单） 是则该订单不参与计算
//										continue;
//									}else{
//										SignupCourseReaminDto scReaminDto = mapKeyPurchaseIdVsReamin.get(purchaseId);
//										
//										if(scReaminDto.getReaminPayPrice() - kexiaoRecord.getAmount()>0){
//											//订单被消耗完
//											if(kexiaoRecord.getChargeUnit() == ChargeUnit.BY_TIMES.getCode()){
//												scReaminDto.subReaminTimes(1);
//											}else{
//												scReaminDto.subReaminHour(kexiaoRecord.getLessonDurationHour());
//											}
//										}else{
//											//订单未被消耗完
//											kexiaoRecordReaminAmount = scReaminDto.getReaminPayPrice() - kexiaoRecordReaminAmount;
//											if(kexiaoRecord.getChargeUnit() == ChargeUnit.BY_TIMES.getCode()){
//												kexiaoRecordReaminAmount -= scReaminDto.getReaminPayPrice();
//											}else{
//												//FIXME
//												//按次的课节 会存在一个订单消耗不完一节课？
//											}
//										}
//									}
//								}
//							}else{
//								
//							}
//						}
//					}
//				}
//			}
//		}
//		
//	}

}