package com.baijia.tianxiao.biz.dashboard.service.impl;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.biz.dashboard.constants.DashboardKeXiaoVersion;
import com.baijia.tianxiao.biz.dashboard.dto.DashboardKeXiaoConfigDto;
import com.baijia.tianxiao.biz.dashboard.service.DashboardKeXiaoConfigService;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;

/**   
 * @title       : DashboardKeXiaoConfigServiceImpl 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2017年2月10日 上午11:24:43 
 */
@Service
@Slf4j
public class DashboardKeXiaoConfigServiceImpl implements DashboardKeXiaoConfigService {
	
	@Autowired
	private OrgAccountDao orgAccountDao;
	@Autowired
	private OrgSubAccountDao orgSubAccountDao;
	
	
	@Override
	public DashboardKeXiaoConfigDto getConfig(Long orgId) {
		DashboardKeXiaoConfigDto dto = new DashboardKeXiaoConfigDto();
		dto.setVersion(DashboardKeXiaoVersion.DEFALUT.getVersion());
		
		Long orgPid = null;
		OrgSubAccount orgSubAccount = orgSubAccountDao.getByOrgId(orgId.intValue());
		
		if(orgSubAccount!=null && orgSubAccount.getPid()!=null && orgSubAccount.getPid()>0){
			orgPid = orgSubAccount.getPid().longValue();
		}else{
			orgPid = orgId;
		}
		
		//TODO 稳定后可考虑将配置存到表中
		if(orgPid == 123){
			dto.setVersion(DashboardKeXiaoVersion.V1.getVersion());
		}
		
		return dto;
	}

	
}
