package com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail;


import java.util.Date;

import com.baijia.tianxiao.biz.dashboard.dto.kexiao.DashboadrKexiaoDtoHelper;
import com.baijia.tianxiao.excel.ExcelColumn;
import com.baijia.tianxiao.excel.ExcelExporterDto;

import lombok.Data;

/**   
 * @title       : OrgDetailKexiaoListDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2017年1月3日 上午11:56:59 
 */
@Data
@ExcelExporterDto
public class OrgDetailKexiaoListDto  {
	
	@ExcelColumn("学员")
	private String studentName;
	private Long studentUserId;
	
	@ExcelColumn("班级")
	private String className;
	private Long classId;
	
	@ExcelColumn("班级类型")
	private String courseTypeStr;
	private Integer courseType;
	
	@ExcelColumn("收费类型")
	private String chargeTypeStr;
	private Integer chargeType;
	
	@ExcelColumn("计费单位")
	private String chargeUnitStr;
	private Integer chargeUnit;

	@ExcelColumn("上课时间")
	private Double lessonTimeStr;
	private Date lessonStartTime;
	private Date lessonEndTime;

    @ExcelColumn("上课老师")
    private String teacherName;
	
	@ExcelColumn("上课小时数")
	private Double lessonHour;
	private Integer lessonMinute;
	
	@ExcelColumn("上课次数")
	private Integer lessonTimes;
	
	@ExcelColumn("课消金额")
	private Long kexiaoMoney;
	
	@ExcelColumn("退班手续费")
	private Long quitClassMoney;
	
	@ExcelColumn("课消总额")
	private Long totalKexiaoMoney;
	
	private Date quitClassTime;
	

	public String getCourseTypeStr(){
		return DashboadrKexiaoDtoHelper.getCourseTypeStr(this.courseType);
	}
	
	public String getChargeTypeStr(){
		return DashboadrKexiaoDtoHelper.getChargeTypeStr(this.chargeType);
	}
	
	public String getChargeUnitStr(){
		return DashboadrKexiaoDtoHelper.getChargeUnitStr(this.chargeUnit);
	}
	
	public String getLessonTimeStr(){
		return DashboadrKexiaoDtoHelper.getLessonTimeStr(this.lessonStartTime, this.lessonEndTime, this.quitClassTime);
	}
	
	
	public Double getLessonHour(){
		if(this.lessonHour!=null){
			return DashboadrKexiaoDtoHelper.twoDecimal(this.lessonHour);
		}
		if(this.lessonMinute!=null){
			return DashboadrKexiaoDtoHelper.durationM2H(this.lessonMinute);
		}
		return null;
	}
	
	
	
	public Double getQuitClassMoney(){
		if(this.quitClassMoney!=null){
			return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.quitClassMoney);
		}
		return null;
	}
	
	public Double getTotalKexiaoMoney(){
		if(this.totalKexiaoMoney!=null){
			return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.totalKexiaoMoney);
		}
		return null;
	}
	
	public Double getKexiaoMoney(){
		if(this.kexiaoMoney!=null){
			return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.kexiaoMoney);
		}
		return null;
	}
	
	public Long getTotalKexiaoMoneyLong(){
		return this.totalKexiaoMoney;
	}
	public Long getQuitClassMoneyLong(){
		return this.quitClassMoney;
	}
	public Long getKexiaoMoneyLong(){
		return this.kexiaoMoney;
	}
	
}
