/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.dashboard.sync.impl;

import com.baijia.tianxiao.biz.dashboard.sync.SyncSourceService;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.constant.ConsulterStatus;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.dao.TxUserSourceStatisticDayDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.dal.sync.po.TxUserSourceStatisticDay;
import com.baijia.tianxiao.util.date.DateUtil;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年10月14日
 * @desc
 */
@Service
@Slf4j
public class SyncSourceServiceImpl implements SyncSourceService{
    
    private AtomicBoolean msgSourceDayFlag = new AtomicBoolean(false);
    private AtomicBoolean consultUserSourceDayFlag = new AtomicBoolean(false);

    @Autowired
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Autowired
    private TxUserSourceStatisticDayDao txUserSourceStatisticDayDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private MessageDao messageDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    
    @Override
    @Transactional
    public void syncConsultSource(Long maxId, MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = getSyncInfo(syncType);
        if(syncInfo.getSyncId() < maxId){
            syncTask(syncType, msgSourceDayFlag);
//            syncConsultSource(maxId, syncType);
        }
    }
    
    @Transactional
    @Override
    public void sync() {
        /**
         * tx_message_record同步咨询来源
         */
        syncTask(MsgSyncType.USER_SOURCE, msgSourceDayFlag);
        
        /**
         * 按天tx_consult_user同步线索来源
         */
        syncTask(MsgSyncType.CLUE_SOURCE, consultUserSourceDayFlag);

    }
    
    private void syncTask(MsgSyncType syncType, AtomicBoolean flag){
        TxMsgSyncTimestamp syncInfo = getSyncInfo(syncType);
        try {
            if (!flag.get()) {
                log.info("sync consult stat info :{}", syncInfo);
                flag.set(true);
                switch (syncType) {
                    case CLUE_SOURCE:
                        syncClueSource(syncInfo);;
                        break;
                    case USER_SOURCE:
                        syncUserSource(syncInfo);;
                        break;
                    default:
                        break;
                }
                flag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", e);
        } finally {
            flag.set(false);
        }
        log.info("save sync info:{}", syncInfo);
        txMsgSyncTimestampDao.saveOrUpdate(syncInfo);
    }
    
    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
//        System.out.println("syncInfo============" + syncInfo);
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(0l);
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(syncType.getSyncType());
        }
        return syncInfo;
    }
    
    //按天统计用户咨询来源  包括线索 学员 咨询
    private void syncUserSource(TxMsgSyncTimestamp syncInfo) {
        List<ConsultMessage> consultMessages = messageDao.getConsultMessageListByMinId(syncInfo.getSyncId(),
            syncInfo.getSyncTime(), 100, "senderId", "receiverId", "receiverRole", "consultType", "createTime");
        log.info("[SysConsultMessage] save consultMessages:{} success", consultMessages.size());
        if (CollectionUtils.isNotEmpty(consultMessages)) {
            List<Long> consultIds = new ArrayList<>();
            for(ConsultMessage consultMessage : consultMessages){
                consultIds.add(consultMessage.getSenderId());
            }
            //批量查询咨询用户
            Map<Long, TxConsultUser> consultUserMap = txConsultUserDao.getConsultUserByIds(null, consultIds, null);
            for (ConsultMessage consultMessage : consultMessages) {
                // 按照consultId和orgId判断本月状态监控表
                if (consultMessage.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(consultMessage.getId());
                }
                
                TxConsultUser txConsultUser = consultUserMap.get(consultMessage.getSenderId());
                if(txConsultUser == null){
                    continue;
                }
                //查询用户咨询来源统计
                TxUserSourceStatisticDay txUserSourceStatisticDay = 
                    txUserSourceStatisticDayDao.getTxUserSourceStatisticDay(txConsultUser.getOrgId(), 
                        txConsultUser.getId(), consultMessage.getConsultType(), DateUtil.getStartOfDay(consultMessage.getCreateTime()), DateUtil.getEndOfDay(consultMessage.getCreateTime()));
                
                log.info("[SysConsultMessageSource] txUserSourceStatisticDay param:{}, consultMessage.getId", txUserSourceStatisticDay, consultMessage.getId());
                // 统计用户咨询来源
                if (txUserSourceStatisticDay == null) {
                    txUserSourceStatisticDay = buildTxUserSourceStatisticDayInstance(txConsultUser.getOrgId(), txConsultUser.getId(), consultMessage.getConsultType(), consultMessage.getCreateTime(), 1);
                    txUserSourceStatisticDayDao.save(txUserSourceStatisticDay);
                } else {
                    /**
                     * 微信和IM 当天有更新 不更新记录更新次数
                     */
                    log.info("[SysConsultMessage] update souceStatistic txConsultSourceStatisticMonth param:{}",
                        txUserSourceStatisticDay);
                    if (consultMessage.getConsultType() != MessageSource.WECHAT.getValue()
                        && consultMessage.getConsultType() != MessageSource.ONLINE_IM.getValue()) {
                        txUserSourceStatisticDay.setNumber(txUserSourceStatisticDay.getNumber() +1);
                        txUserSourceStatisticDay.setUpdateTime(new Date());
                        txUserSourceStatisticDayDao.update(txUserSourceStatisticDay);
                        log.info("[SysConsultMessage] update souceStatistic param:{}", txUserSourceStatisticDay);
                    }
                }
            }
        }
    }
    
    private void syncClueSource(TxMsgSyncTimestamp syncInfo) {
        List<TxConsultUser> consultUsers =
            txConsultUserDao.getOrgConsultUserListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100);
        log.info("[SysnConsultUser] save consultUser size:{} success", consultUsers.size());

        if (CollectionUtils.isNotEmpty(consultUsers)) {
            for (TxConsultUser consultUser : consultUsers) {
                if (consultUser.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(consultUser.getId());
                }
                //值统计线索来源
                if(consultUser.getIsConsulter() == ConsulterStatus.NOT.getValue()){
                    continue;
                }
                //查询用户咨询来源统计
                TxUserSourceStatisticDay txUserSourceStatisticDay = 
                    txUserSourceStatisticDayDao.getTxUserSourceStatisticDay(consultUser.getOrgId(),
                        consultUser.getId(), consultUser.getConsultSource(), DateUtil.getStartOfDay(consultUser.getCreateTime()), DateUtil.getEndOfDay(consultUser.getCreateTime()));
                log.info("[SysConsultUserSource] txUserSourceStatisticDay param:{}, consultUserId:{}", txUserSourceStatisticDay, consultUser.getId());
                // 统计用户咨询来源
                if (txUserSourceStatisticDay == null) {
                    txUserSourceStatisticDay = buildTxUserSourceStatisticDayInstance(consultUser.getOrgId(),
                        consultUser.getId(), consultUser.getConsultSource(), consultUser.getCreateTime(), 1);
                    txUserSourceStatisticDayDao.save(txUserSourceStatisticDay);
                }
            }
        }
    }
    
    private TxUserSourceStatisticDay buildTxUserSourceStatisticDayInstance(Long orgId, Long consultUserId, Integer sourceType, Date visitDate, Integer number){
        TxUserSourceStatisticDay userSource = new TxUserSourceStatisticDay();
        userSource.setOrgId(orgId);
        userSource.setConsultUserId(consultUserId);
        userSource.setSourceType(sourceType);
        userSource.setVisitDate(visitDate);
        userSource.setNumber(number);
//        userSource.setUserType(userType);
        return userSource;
    }
    
    private boolean checkIsStudent(TxConsultUser consultUser) {
        boolean isStudent = false;
        Long userId = consultUser.getUserId();
        Long orgId = consultUser.getOrgId();
        Long studentId = consultUser.getStudentId();
        OrgStudent orgStudent = null;
        if (studentId != null && studentId > 0) {
            orgStudent = this.orgStudentDao.getById(studentId);
        } else {
            orgStudent = this.orgStudentDao.getStudentByUserId(orgId, userId);
        }
        
        if(orgStudent != null && orgStudent.getDelStatus() == DeleteStatus.NORMAL.getValue()){
            isStudent = true;
        }
        return isStudent;
    }
    
}
