package com.baijia.tianxiao.biz.dashboard.service;

import java.util.List;

import com.baijia.tianxiao.biz.dashboard.dto.kexiao.allorg.AllOrgListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.allorg.AllOrgStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.allorg.MainStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.classdetail.ClassDetailListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.classdetail.ClassDetailStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail.OrgDetailClassListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail.OrgDetailKexiaoListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail.OrgDetailStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail.OrgDetailStudentListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.AllOrgListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.ClassDetailListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.OrgDetailClassListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.OrgDetailKexiaoListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.OrgDetailStudentListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.StudentDetailListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.studentdetail.StudentDetailListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.studentdetail.StudentDetailStatisticsDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

/**   
 * @title       : DashboardKeXiaoService 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2017年1月3日 上午11:56:43 
 */
public interface DashboardKeXiaoService {
	
	//统计
	MainStatisticsDto getMainStatisticsDto(Long mainOrgId);

	//机构列表
	AllOrgStatisticsDto getAllOrgStatisticsDto(Long mainOrgId);

	List<AllOrgListDto> listAllOrgListDto(AllOrgListParamDto param, PageDto pageDto);

	AllOrgListDto       getAllOrgListTotal(AllOrgListParamDto param);
	
	
	//机构详情
	OrgDetailStatisticsDto getOrgDetailStatisticsDto(Long orgId);
	
	List<OrgDetailClassListDto> listOrgDetailClassListDto(OrgDetailClassListParamDto param, PageDto pageDto);

	OrgDetailClassListDto       getOrgDetailClassListTotal(OrgDetailClassListParamDto param);
	
	List<OrgDetailStudentListDto> listOrgDetailStudentListDto(OrgDetailStudentListParamDto param, PageDto pageDto);

	OrgDetailStudentListDto       getOrgDetailStudentListTotal(OrgDetailStudentListParamDto param);
	
	List<OrgDetailKexiaoListDto> listOrgDetailKexiaoListDto(OrgDetailKexiaoListParamDto param, PageDto pageDto);

	OrgDetailKexiaoListDto       getOrgDetailKexiaoListTotal(OrgDetailKexiaoListParamDto param);
	
	
	//班级详情
	ClassDetailStatisticsDto getClassDetailStatisticsDto(Long orgId, Long classId);
	
	List<ClassDetailListDto> listClassDetailListDto(ClassDetailListParamDto param, PageDto pageDto);
	
	ClassDetailListDto       getClassDetailListTotal(ClassDetailListParamDto param);
	
	
	//学员详情
	StudentDetailStatisticsDto getStudentDetailStatisticsDto(Long orgId, Long studentUserId);
	
	List<StudentDetailListDto> listStudentDetailListDto(StudentDetailListParamDto param, PageDto pageDto);
	
	StudentDetailListDto       getStudentDetailListTotal(StudentDetailListParamDto param);
	
	
    
}
