package com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.teacherlist;



import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.DashboadrKexiaoDtoHelper;
import com.baijia.tianxiao.excel.ExcelColumn;
import com.baijia.tianxiao.excel.ExcelExporterDto;

import lombok.Data;

/**   
 * @title       : TeacherListDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2017年1月3日 上午11:56:50 
 */
@Data
@ExcelExporterDto
public class TeacherListDto  {
	
	private Long teacherId;
	
	@ExcelColumn("老师")
	private String teacherName;
	
	@ExcelColumn("手机号")
	private String mobile;
	
	@ExcelColumn("校区")
	private String orgName;
	
	@ExcelColumn("课消金额")
	private Long kexiaoMoney;
	
	@ExcelColumn("带班数")
	private Integer classCount;//带班数
	
	@ExcelColumn("已上课次")
	private Integer lessonTimes;//已上课次
	
	@ExcelColumn("已上课时")
	private String lessonDurationStr;
	private Long lessonMinute;//已上课时
	
	@ExcelColumn("预计签到人次")
	private Integer originalSigninCount;//预计签到数
	
	@ExcelColumn("实际到课人次")
	private Integer signinCount;//实际签到数
	
	@ExcelColumn("实际请假人次")
	private Integer askForLeaveCount;//请假数
	
	@ExcelColumn("实际缺课人次")
	private Integer absenteeismcCount;//缺勤数
	
	@ExcelColumn("实际未签到人次")
	private Integer notSigninCount;//未签到数
	
	
	
	public Double getKexiaoMoney(){
		if(this.kexiaoMoney!=null){
			return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.kexiaoMoney);
		}
		return null;
	}
	
	public String getLessonDurationStr(){
		return DashboadrKexiaoDtoHelper.getTimeStr(this.lessonMinute);
	}
	
	public Long getKexiaoMoneyLong(){
		return this.kexiaoMoney;
	}
}
