/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.dashboard.dto.kexiaov1;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.dal.constant.ChargeType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;

import lombok.Data;

/**   
 * @title       : DashboadrKexiaoDtoHelper 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2017年1月3日 上午11:57:08 
 */
@Data
public class DashboadrKexiaoDtoHelper {
	
	public static int DEFAULT_LESSON_TIMES = 1;

	static DecimalFormat df = new DecimalFormat("0.00");
	
	static final String hourFmt = "%s小时";
	static final String minuteFmt = "%s小时%s分钟";
	
	
	public static String getLessonTimeStr(Date lessonStartTime, Date lessonEndTime, Date quitClassTime){
		
		SimpleDateFormat sdf = null;
		if(quitClassTime!=null){
			sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm\n    (退班时间)");
			return sdf.format(quitClassTime);
		}
		
		if(lessonStartTime!=null && lessonEndTime!=null){
			sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
			StringBuilder builder = new StringBuilder();
			builder.append( sdf.format(lessonStartTime) );
			
			sdf = new SimpleDateFormat("HH:mm");
			builder.append(" ~ ").append( sdf.format(lessonEndTime) );
			return builder.toString();
		}else{
			return null;
		}
	}
	
	
	
	public static String getSigninStatusStr(Integer signinStatus, Date quitClassTime){
		if(quitClassTime!=null){
			return "退班手续费";
		}
		if(signinStatus!=null){
			SignStatus signStatusEnum = SignStatus.getSignStatusByCode(signinStatus.intValue());
			if(signStatusEnum!=null){
				return signStatusEnum.getMessage();
			}
		}
		
		return "未签到";
	}
	
	
	public static String getCourseTypeStr(Integer courseType){
		if(courseType!=null){
			CourseTypeEnum courseTypeEnum = CourseTypeEnum.getByCode(courseType.intValue());
			if(courseTypeEnum!=null){
				return courseTypeEnum.getMsg();
			}
		}
		return null;
	}
	
	
	
	public static String getChargeTypeStr(Integer chargeType){
		if(chargeType!=null){
			ChargeType chargeTypeEnum = ChargeType.getByCode(chargeType.intValue());
			if(chargeTypeEnum!=null){
				return chargeTypeEnum.getLabel();
			}
		}
		return null;
	}
	
	
	
	public static String getChargeUnitStr(Integer chargeUnit){
		if(chargeUnit!=null){
			ChargeUnit chargeUnitEnum = ChargeUnit.getByCode(chargeUnit.intValue());
			if(chargeUnitEnum!=null){
				return chargeUnitEnum.getDesc();
			}
		}
		return null;
	}
	
	
	public static String getKexiaoRuleStr(Integer kexiaoRule){
		if(kexiaoRule!=null){
			CourseConsumeRuleEnum courseConsumeRuleEnum = CourseConsumeRuleEnum.getRuleByValue(kexiaoRule);
			if(courseConsumeRuleEnum!=null){
				return courseConsumeRuleEnum.getDesc();
			}
		}
		return CourseConsumeRuleEnum.TIME_0.getDesc();
	}
	
	
	public static Double DoubleFormat(Double value){
		if(value==null){
			return null;
		}
		BigDecimal bValue = new BigDecimal(value);
		return bValue.setScale(2,BigDecimal.ROUND_HALF_UP).doubleValue();
	}
	
	//分钟转换小时 保留两位小数
	public static Double durationM2H(Long value){
		if(value==null){
			return null;
		}
		double doubleValue = (double)value;
		doubleValue = doubleValue/60;//分钟转换小时
		return twoDecimal(doubleValue);
	}
	
	public static Double durationM2H(Integer value){
		if(value==null){
			return null;
		}
		double doubleValue = (double)value;
		doubleValue = doubleValue/60;//分钟转换小时
		return twoDecimal(doubleValue);
	}
	
	//计费单位:分转元 保留两位小数
	public static Double moneyDividedBy100(Long value){
		if(value==null){
			return null;
		}
		double doubleValue = (double)value;
		doubleValue = doubleValue/100;
		BigDecimal bValue = new BigDecimal(doubleValue);
		return bValue.setScale(2,BigDecimal.ROUND_HALF_UP).doubleValue();
	}
	
	public static Double twoDecimal(Double value){
		BigDecimal bValue = new BigDecimal(value);
		return bValue.setScale(2,BigDecimal.ROUND_HALF_UP).doubleValue();
	}
	
	
	public static String getTimeStr(Long minute){
		if(minute==null){
			return String.format(hourFmt, 0);
		}
		if(minute%60==0){
			return String.format(hourFmt, minute/60);
		}else{
			return String.format(minuteFmt, (minute-minute%60)/60, minute%60);
		}
	};
}

