package com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail;


import com.baijia.tianxiao.biz.dashboard.dto.kexiao.DashboadrKexiaoDtoHelper;
import com.baijia.tianxiao.excel.ExcelColumn;
import com.baijia.tianxiao.excel.ExcelExporterDto;

import lombok.Data;

/**   
 * @title       : OrgDetailStudentListDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2017年1月3日 上午11:57:02 
 */
@Data
@ExcelExporterDto
public class OrgDetailStudentListDto  {
	
	
	@ExcelColumn("学员")
	private String studentName;
	private Long studentUserId;

	@ExcelColumn("课消小时")
	private Double kexiaoHour;
	private Integer kexiaoMinute;

	@ExcelColumn("课消次数")
	private Integer kexiaoTimes;

	@ExcelColumn("按小时课消金额")
	private Long kexiaoHourMoney;

	@ExcelColumn("按次课消金额")
	private Long kexiaoTimesMoney;

	@ExcelColumn("退班手续费")
	private Long quitClassMoney;
	
	@ExcelColumn("课消总额")
	private Long totalKexiaoMoney;
	
	
	public Double getKexiaoHour(){
		if(this.kexiaoHour!=null){
			return DashboadrKexiaoDtoHelper.twoDecimal(this.kexiaoHour);
		}
		if(this.kexiaoMinute!=null){
			return DashboadrKexiaoDtoHelper.durationM2H(this.kexiaoMinute);
		}
		return null;
	}
	
	
	public Double getKexiaoHourMoney(){
		if(this.kexiaoHourMoney!=null){
			return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.kexiaoHourMoney);
		}
		return null;
	}
	
	public Double getKexiaoTimesMoney(){
		if(this.kexiaoTimesMoney!=null){
			return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.kexiaoTimesMoney);
		}
		return null;
	}
	
	public Double getQuitClassMoney(){
		if(this.quitClassMoney!=null){
			return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.quitClassMoney);
		}
		return null;
	}
	
	public Double getTotalKexiaoMoney(){
		if(this.totalKexiaoMoney!=null){
			return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.totalKexiaoMoney);
		}
		return null;
	}
	
	public Long getTotalKexiaoMoneyLong(){
		return this.totalKexiaoMoney;
	}
	public Long getQuitClassMoneyLong(){
		return this.quitClassMoney;
	}
	public Long getKexiaoHourMoneyLong(){
		return this.kexiaoHourMoney;
	}
	public Long getKexiaoTimesMoneyLong(){
		return this.kexiaoTimesMoney;
	}
}
