package com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail;



import com.baijia.tianxiao.biz.dashboard.dto.kexiao.DashboadrKexiaoDtoHelper;
import com.baijia.tianxiao.excel.ExcelColumn;
import com.baijia.tianxiao.excel.ExcelExporterDto;

import lombok.Data;

/**   
 * @title       : OrgDetailClassListDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2017年1月3日 上午11:56:58 
 */
@Data
@ExcelExporterDto
public class OrgDetailClassListDto  {
	
	
	@ExcelColumn("班级")
	private String className;
	private Long classId;

	@ExcelColumn("课程类型")
	private String courseTypeStr;
	private Integer courseType;

	@ExcelColumn("收费类型")
	private String chargeTypeStr;
	private Integer chargeType;

	@ExcelColumn("计费单位")
	private String chargeUnitStr;
	private Integer chargeUnit;

	@ExcelColumn("课消小时")
	private Double kexiaoHour;
	private Integer kexiaoMinute;
	
	@ExcelColumn("课消次数")
	private Integer kexiaoTimes;
	
	@ExcelColumn("课消金额")
	private Long kexiaoMoney;
	
	@ExcelColumn("退班手续费")
	private Long quitClassMoney;
	
	@ExcelColumn("课消总额")
	private Long totalKexiaoMoney;
	
	
	public String getCourseTypeStr(){
		return DashboadrKexiaoDtoHelper.getCourseTypeStr(this.courseType);
	}
	
	public String getChargeTypeStr(){
		return DashboadrKexiaoDtoHelper.getChargeTypeStr(this.chargeType);
	}
	
	public String getChargeUnitStr(){
		return DashboadrKexiaoDtoHelper.getChargeUnitStr(this.chargeUnit);
	}
	
	
	public Double getKexiaoHour(){
		if(this.kexiaoHour!=null){
			return DashboadrKexiaoDtoHelper.twoDecimal(this.kexiaoHour);
		}
		if(this.kexiaoMinute!=null){
			return DashboadrKexiaoDtoHelper.durationM2H(this.kexiaoMinute);
		}
		return null;
	}
	
	
	public Double getKexiaoMoney(){
		if(this.kexiaoMoney!=null){
			return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.kexiaoMoney);
		}
		return null;
	}
	
	public Double getTotalKexiaoMoney(){
		if(this.totalKexiaoMoney!=null){
			return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.totalKexiaoMoney);
		}
		return null;
	}
	
	public Double getQuitClassMoney(){
		if(this.quitClassMoney!=null){
			return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.quitClassMoney);
		}
		return null;
	}
	
	public Long getKexiaoMoneyLong(){
		return this.kexiaoMoney;
	}
	public Long getTotalKexiaoMoneyLong(){
		return this.totalKexiaoMoney;
	}
	public Long getQuitClassMoneyLong(){
		return this.quitClassMoney;
	}
	
}
