package com.baijia.tianxiao.biz.dashboard.dto.kexiao.classdetail;


import com.baijia.tianxiao.biz.dashboard.dto.kexiao.DashboadrKexiaoDtoHelper;

import lombok.Data;

/**   
 * @title       : ClassDetailStatisticsDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2017年1月3日 上午11:56:48 
 */
@Data
public class ClassDetailStatisticsDto  {
	
	private Long classId;
	private String className;
	private Integer studentCount;
	private Integer kexiaoRule;
	private Integer chargeType;
	private Integer chargeUnit;
	private Integer todayKexiaoMinute;
	private Double todayKexiaoHour;
	private Integer todayKexiaoTimes;
	private Long todayKexiaoMoney;
	private Long todayQuitClassMoney;
	
	public String getKexiaoRuleStr(){
		return DashboadrKexiaoDtoHelper.getKexiaoRuleStr(this.kexiaoRule);
	}
	
	public String getChargeTypeStr(){
		return DashboadrKexiaoDtoHelper.getChargeTypeStr(this.chargeType);
	}
	
	public String getChargeUnitStr(){
		return DashboadrKexiaoDtoHelper.getChargeUnitStr(this.chargeUnit);
	}
    
	
	public Double getTodayKexiaoHour(){
		if(this.todayKexiaoHour!=null){
			return DashboadrKexiaoDtoHelper.twoDecimal(this.todayKexiaoHour);
		}
		if(this.todayKexiaoMinute!=null){
			return DashboadrKexiaoDtoHelper.durationM2H(this.todayKexiaoMinute);
		}
		return null;
	}
	
	
	public Double getTodayKexiaoMoney(){
		if(this.todayKexiaoMoney!=null){
			return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.todayKexiaoMoney);
		}
		return null;
	}
	
	public Double getTodayQuitClassMoney(){
		if(this.todayQuitClassMoney!=null){
			return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.todayQuitClassMoney);
		}
		return null;
	}
}
