package com.baijia.tianxiao.biz.dashboard.constants;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;

/**
 * Created by wengshengli on 15/12/24.
 */
public enum DashboardErrorCode implements UniverseErrorCode {

    PARAM_ERROR(1001,"请求参数错误"),
    ;

    private int code;
    private String message;

    DashboardErrorCode(int code, String msg) {
        this.code = code;
        this.message = msg;
    }

    @Override
    public ErrorSide getErrorSide() {
        return ErrorSide.SERVER;
    }

    @Override
    public Subsystem getSystem() {
        return Subsystem.DASHBOARD;
    }

    @Override
    public Platform getPlatform() {
        return Platform.PC;
    }

    @Override
    public int getSubsystemErrorCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public UniverseErrorCode fromCode(int code) {
        for (DashboardErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return CommonErrorCode.UNKNOW;
    }
}
