/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.constants;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;

public enum DashboardErrorCode implements UniverseErrorCode
{
    PARAM_ERROR(1001, "\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");

    private int code;
    private String message;

    private DashboardErrorCode(int code, String msg) {
        this.code = code;
        this.message = msg;
    }

    public ErrorSide getErrorSide() {
        return ErrorSide.SERVER;
    }

    public Subsystem getSystem() {
        return Subsystem.DASHBOARD;
    }

    public Platform getPlatform() {
        return Platform.PC;
    }

    public int getSubsystemErrorCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public UniverseErrorCode fromCode(int code) {
        DashboardErrorCode[] dashboardErrorCodeArray = DashboardErrorCode.values();
        int n = dashboardErrorCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DashboardErrorCode errorCode = dashboardErrorCodeArray[n2];
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
            ++n2;
        }
        return CommonErrorCode.UNKNOW;
    }
}

