package com.baijia.tianxiao.biz.dashboard.sync.impl;

import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.baijia.tianxiao.biz.dashboard.sync.SyncDataService;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.dao.TxOrgCourseStatDao;
import com.baijia.tianxiao.dal.sync.dao.TxOrgCourseStatHourDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.dal.sync.po.TxOrgCourseStat;
import com.baijia.tianxiao.dal.sync.po.TxOrgCourseStatHour;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by wengshengli on 15/12/23.
 * <p/>
 * 每小时一次对数据库中的数据统计
 *
 * 每小时对大数据的基础数据 入库,由于延时太久,目前暂没有用到
 */
@Service("syncStatPVService")
@Slf4j
public class SyncStatPVServiceImpl implements SyncDataService {

    @Resource
    private TxOrgCourseStatDao txOrgCourseStatDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private TxOrgCourseStatHourDao txOrgCourseStatHourDao;

    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;

    private AtomicBoolean orgCourseStatFlag = new AtomicBoolean(false);
    private AtomicBoolean wxIndexStatFlag = new AtomicBoolean(false);

    @Override
    public void sync() {

        /**
         * 清洗机构课程数据
         */
        syncTask(MsgSyncType.STAT_ORG_COURSE_PV, orgCourseStatFlag);

        /**
         * 清洗网校主页数据
         */
        syncTask(MsgSyncType.STAT_WX_INDEX_PV, wxIndexStatFlag);

    }

    private void syncTask(MsgSyncType syncType, AtomicBoolean flag) {
        TxMsgSyncTimestamp syncInfo = getSyncInfo(syncType);

        if (flag.get()) {
            log.warn("last sync is not complete");
            return;
        }
        flag.set(true);
        try {
            switch (syncType) {
                case STAT_ORG_COURSE_PV:
                    syncOrgCourseStat(syncInfo);
                    break;
                case STAT_WX_INDEX_PV:
                    syncWxIndexStat(syncInfo);
                    break;
                default:
                    break;
            }

        } catch (Exception e) {
            log.error("catch error:", e);
        } finally {
            flag.set(false);
        }
        log.info("save sync info:{}", syncInfo);
        txMsgSyncTimestampDao.saveOrUpdate(syncInfo);
    }

    private void syncOrgCourseStat(TxMsgSyncTimestamp syncInfo) {
        List<TxOrgCourseStatHour> list =
            txOrgCourseStatHourDao.getListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 500);
        log.info("save TxOrgCourseStatHour size :{}", list.size());

        for (TxOrgCourseStatHour dto : list) {
            if (dto.getId() > syncInfo.getSyncId()) {
                syncInfo.setSyncId(dto.getId());
            }
            OrgCourse orgCourse = orgCourseDao.getByCourseNumber(dto.getNumber());
            if (orgCourse == null) {
                continue;
            }
            TxOrgCourseStat orgCourseStat =
                txOrgCourseStatDao.getOrgAndCourseNumber(orgCourse.getOrgNumber(), orgCourse.getNumber());
            if (orgCourseStat == null) {
                orgCourseStat = new TxOrgCourseStat();
                orgCourseStat.setCourseNumber(orgCourse.getNumber());
                orgCourseStat.setOrgNumber(orgCourse.getOrgNumber());
                orgCourseStat.setCourseName(orgCourse.getName());
                orgCourseStat.setPv(dto.getPv());
                orgCourseStat.setUv(dto.getUv());
            } else {
                orgCourseStat.setPv(orgCourseStat.getPv() + dto.getPv());
                orgCourseStat.setUv(orgCourseStat.getUv() + dto.getUv());
            }

            txOrgCourseStatDao.saveOrUpdate(orgCourseStat);
        }

    }

    private void syncWxIndexStat(TxMsgSyncTimestamp syncInfo) {
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(0l);
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(syncType.getSyncType());
        }
        return syncInfo;
    }
}
