package com.baijia.tianxiao.biz.dashboard.dto.kexiao.classdetail;


import java.util.Date;

import com.baijia.tianxiao.biz.dashboard.dto.kexiao.DashboadrKexiaoDtoHelper;
import com.baijia.tianxiao.excel.ExcelColumn;
import com.baijia.tianxiao.excel.ExcelExporterDto;

import lombok.Data;

/**   
 * @title       : ClassDetailListDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2017年1月3日 上午11:56:50 
 */
@Data
@ExcelExporterDto
public class ClassDetailListDto  {
	
	@ExcelColumn("学员")
	private String studentName;
	private Long studentUserId;

	@ExcelColumn("上课时间")
	private Double lessonTimeStr;
	private Date lessonStartTime;
	private Date lessonEndTime;
	
	@ExcelColumn("上课小时数")
	private Double lessonHour;
	private Integer lessonMinute;
	
	@ExcelColumn("上课次数")
	private Integer lessonTimes;

	@ExcelColumn("本次课消金额")
	private Long kexiaoMoney;

	@ExcelColumn("签到状态")
	private String signinStatusStr;
	private Integer signinStatus;

	@ExcelColumn("剩余课时")
	private Double remainingHour;
	private Integer remainingMinute;
	
	@ExcelColumn("剩余课次")
	private Integer remainingTimes;

	@ExcelColumn("剩余学费")
	private Long remainingMoney;
	
	private Date quitClassTime;

	
	public String getLessonTimeStr(){
		return DashboadrKexiaoDtoHelper.getLessonTimeStr(this.lessonStartTime, this.lessonEndTime, this.quitClassTime);
	}
	public String getSigninStatusStr(){
		return DashboadrKexiaoDtoHelper.getSigninStatusStr(this.signinStatus, this.quitClassTime);
	}
	
	
	public Double getLessonHour(){
		if(this.lessonHour!=null){
			return DashboadrKexiaoDtoHelper.twoDecimal(this.lessonHour);
		}
		if(this.lessonMinute!=null){
			return DashboadrKexiaoDtoHelper.durationM2H(this.lessonMinute);
		}
		return null;
	}
	
	public Double getRemainingHour(){
		if(this.remainingHour!=null){
			return DashboadrKexiaoDtoHelper.twoDecimal(this.remainingHour);
		}
		if(this.remainingMinute!=null){
			return DashboadrKexiaoDtoHelper.durationM2H(this.remainingMinute);
		}
		return null;
	}
	
	public Double getKexiaoMoney(){
		if(this.kexiaoMoney!=null){
			return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.kexiaoMoney);
		}
		return null;
	}
	
	public Double getRemainingMoney(){
		if(this.remainingMoney!=null){
			return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.remainingMoney);
		}
		return null;
	}
	
}
