
package com.baijia.tianxiao.biz.club;

import java.util.List;

import com.baijia.tianxiao.biz.club.protocol.GetBatchOrgClubLevelResponse;
import com.baijia.tianxiao.biz.club.protocol.GetSingleOrgClubLevelResponse;
import com.baijia.tianxiao.biz.club.protocol.GetUpgradeInfo;
import com.baijia.tianxiao.dal.club.po.OrgVip;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;

public interface OrgClubEssentialInfoService {

    /**
     * 获取单个机构会员级别
     * 
     * @param orgNumber
     * @return GetSingleOrgClubLevelResponse 
     */
    public GetSingleOrgClubLevelResponse getSigleOrgClubLevel(String orgNumber) throws ParameterException, BussinessException;
    
    /**
     * 批量获取机构会员级别
     * 
     * @param orgNumbers
     * @return GetSingleOrgClubLevelResponse 
     */
    public GetBatchOrgClubLevelResponse getBatchOrgClubLevel(String orgNumbers) throws ParameterException, BussinessException;
    
    /**
     * 全量获取机构会员级别
     * 
     * @return GetSingleOrgClubLevelResponse 
     */
    public GetBatchOrgClubLevelResponse getAllOrgClubLevel() throws ParameterException, BussinessException;
    
    /**
     * 获取会员信息
     * 
     * @param orgNumber
     * @return
     * @throws ParameterException
     * @throws BussinessException
     */
    public List<OrgVip> getOrgVipByOrgNumber(Integer orgNumber) throws ParameterException, BussinessException;
    
    /**
     * 获取会员剩余天数
     * 
     * @param orgNumber
     * @return
     * @throws ParameterException
     * @throws BussinessException
     */
    public Integer getOrgVipRemainDay(Integer orgNumber) throws ParameterException, BussinessException;
    
    /**
     * 获取会员升级信息
     * 
     * @param orgNumber
     * @return
     * @throws ParameterException
     * @throws BussinessException
     */
    public GetUpgradeInfo getUpgradeInfo(String mobile, String beginTime) throws Exception;
}
