
package com.baijia.tianxiao.biz.club.constant;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;

public enum OrgClubErrorCode implements UniverseErrorCode {

    UNKNOW(1, "未知类型错误"),
    AUDIT_NOT_PASSED(1011, "机构未生效"),
    SYSTEM_ERROR(9999, "系统处理异常");

    private Platform platform;
    private int code;
    private String message;

    OrgClubErrorCode(int code, String msg) {
        this.code = code;
        this.message = msg;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getErrorSide()
     */
    @Override
    public ErrorSide getErrorSide() {
        return ErrorSide.SERVER;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getSystem()
     */
    @Override
    public Subsystem getSystem() {
        return Subsystem.ORGANIZATION;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getPlatform()
     */
    @Override
    public Platform getPlatform() {
        return Platform.UNKNOW;
    }

    @Override
    public int getSubsystemErrorCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public OrgClubErrorCode fromCode(int code) {
        for (OrgClubErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return OrgClubErrorCode.UNKNOW;
    }

}

    