//
//package com.baijia.tianxiao.biz.club.impl;
//
//import java.util.Date;
//import java.util.List;
//import java.util.Map;
//
//import com.google.common.collect.Lists;
//import org.apache.commons.collections.CollectionUtils;
//import org.joda.time.DateTime;
//import org.joda.time.Days;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Service;
//import org.springframework.transaction.annotation.Transactional;
//
//import com.baijia.tianxiao.biz.club.OrgClubOperateService;
//import com.baijia.tianxiao.biz.club.constant.CasAccountStatus;
//import com.baijia.tianxiao.biz.club.constant.ClubRole;
//import com.baijia.tianxiao.biz.club.util.MqsUtils;
//import com.baijia.tianxiao.dal.cas.po.Account;
//import com.baijia.tianxiao.dal.cas.po.AccountRole;
//import com.baijia.tianxiao.dal.cas.po.Role;
//import com.baijia.tianxiao.dal.club.po.OrgVip;
//import com.baijia.tianxiao.dal.club.po.OrgVipChargingHistory;
//import com.baijia.tianxiao.dal.club.po.OrgVipScanRecord;
//import com.baijia.tianxiao.dal.constant.VipStatus;
//import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
//import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
//import com.baijia.tianxiao.dal.org.po.OrgAccount;
//import com.baijia.tianxiao.dal.shoukuan.po.GoodsMembership;
//import com.baijia.tianxiao.dal.shoukuan.po.SuccessOrderInfo;
//import com.baijia.tianxiao.sal.club.OrgVipChargingHistoryService;
//import com.baijia.tianxiao.sal.club.OrgVipScanRecordService;
//import com.baijia.tianxiao.sal.club.OrgVipService;
//import com.baijia.tianxiao.sal.club.ReceivablesService;
//import com.baijia.tianxiao.sal.club.cas.CasService;
//import com.baijia.tianxiao.sal.club.constant.App;
//import com.baijia.tianxiao.sal.club.constant.OrgVipChargingHistoryStatus;
//import com.baijia.tianxiao.sal.club.constant.SalConstant;
//import com.baijia.tianxiao.util.BaseUtils;
//import com.baijia.tianxiao.util.json.JacksonUtil;
//import com.baijia.tianxiao.util.properties.PropertiesReader;
//import com.google.common.collect.Maps;
//
//import net.sf.json.JSONObject;
//
//@Service
//public class OrgClubOperateServiceImpl implements OrgClubOperateService {
//
//    private Logger logger = LoggerFactory.getLogger(this.getClass());
//
//    @Autowired
//    private OrgVipChargingHistoryService orgVipChargingHistoryService;
//    @Autowired
//    private OrgVipService orgVipService;
//    @Autowired
//    private ReceivablesService receivablesService;
//    @Autowired
//    private CasService casService;
//    @Autowired
//    private OrgAccountDao orgAccountDao;
//    @Autowired
//    private OrgVipScanRecordService orgVipScanRecordService;
//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public void signHistoryHandled(String orgVipHistoryIdsStr) throws Exception {
//
//        List<Integer> orgVipChargingHistoryIds = JacksonUtil.str2List(orgVipHistoryIdsStr, Integer.class);
//        logger.debug("signHistoryHandled ids:{}", orgVipChargingHistoryIds);
//        orgVipChargingHistoryService.batchUpdateStatus(orgVipChargingHistoryIds,
//            OrgVipChargingHistoryStatus.HANDLED.getCode());
//    }
//
//    /**
//     * 先orgvip表remainDay--，再在orgvipcharginghistory中插入一条待处理数据
//     */
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public int dailySyncOrgVip() {
//        int syncCount = 0;
//        int index = 0;
//        boolean toBeContinued = true;
//        do {
//            OrgVip orgVip = orgVipService.getSingleNormalOrgVip(index);
//            if (orgVip != null) {
//                if (orgVip.getStartTime().getTime() <= System.currentTimeMillis()) {
//                    int remainDay = orgVip.getRemainDay();
//                    orgVip.setRemainDay(--remainDay);
//                    orgVip.setUpdateTime(new Date());
//                    orgVipService.updateOrgVip(orgVip);
//                    if (remainDay == 0) {
//                        casService.updateAccountRoleStatus(orgVip.getOrgNumber().toString(),
//                            CasAccountStatus.PAUSE.getCode(), ClubRole.getRoleByCode(orgVip.getVipLevel()).getTag());
//                    }
//                    if (orgVip.getPurchaseId() > 0) {
//                        ++syncCount;
//                        OrgVipChargingHistory history = new OrgVipChargingHistory();
//                        history.setOrgNumber(orgVip.getOrgNumber());
//                        history.setStatus(OrgVipChargingHistoryStatus.WAITING.getCode());
//                        history.setVipId(orgVip.getId());
//                        history.setRemainDay(orgVip.getRemainDay());
//                        orgVipChargingHistoryService.saveOrgVipChargingHistory(history);
//                    }
//                }
//                index = orgVip.getId();
//            } else {
//                toBeContinued = false;
//            }
//        } while (toBeContinued);
//        return syncCount;
//    }
//
//    @SuppressWarnings("unchecked")
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public int syncNewOrgVip() {
//        int syncCount = 0;
//        int index = 0;
//        OrgVip lastOrgVip = orgVipService.getLastOrgVip();
//        if (lastOrgVip != null) {
//            index = lastOrgVip.getOrderId();
//        }
//        List<SuccessOrderInfo> newOrderInfos = receivablesService.getPayedOrderInfo(index);
//        if (CollectionUtils.isNotEmpty(newOrderInfos)) {
//            List<Long> purchaseIds = BaseUtils.getListFilter(newOrderInfos, "purchaseId");
//            List<GoodsMembership> goodsList = receivablesService.getByPurchaseIds(purchaseIds);
//            Map<Long, GoodsMembership> goodsMap = BaseUtils.listToMap(goodsList, "purchaseId");
//            List<OrgVip> orgVips = Lists.newArrayList();
//            List<AccountRole> acs = Lists.newArrayList();
//            for (SuccessOrderInfo orderInfo : newOrderInfos) {
//                GoodsMembership goods = goodsMap.get(orderInfo.getPurchaseId());
//                if (goods != null) {
//                    generateOrgVips(orgVips, goods, orderInfo);
//                    generateAccountRoles(acs, goods);
//                }
//            }
//            orgVipService.saveAll(orgVips);
//            // cas表中插入会员标记
//            casService.saveAllAccountRole(acs);
//            // 通知老师端刷新老师信息
//            noticeTeacherToRefresh(orgVips);
//            syncCount = orgVips.size();
//        }
//        return syncCount;
//
//    }
//
//    @SuppressWarnings("unchecked")
//    private void noticeTeacherToRefresh(List<OrgVip> orgVips) {
//        Map<String, List<Integer>> map = Maps.newHashMap();
//        try {
//            if (CollectionUtils.isNotEmpty(orgVips)) {
//                List<Integer> numbers = BaseUtils.getListFilter(orgVips, "orgNumber");
//                List<OrgAccount> orgAccounts = orgAccountDao.getAccountByNumbers(numbers);
//                if (CollectionUtils.isNotEmpty(orgAccounts)) {
//                    List<Integer> orgIds = BaseUtils.getListFilter(orgAccounts, "id");
//                    MqsUtils util = new MqsUtils();
//                    map.put("org_id", orgIds);
//                    util.sendMessage(PropertiesReader.getValue("mqs", "mns.queue.clear_org_teacher_cache"),
//                        JSONObject.fromObject(map).toString());
//                }
//            }
//        } catch (Exception e) {
//            logger.error("send mqs error!info:{}", map, e);
//        }
//    }
//
//    private void generateAccountRoles(List<AccountRole> acs, GoodsMembership goods) {
//        Account account = casService.getAccountByName(goods.getOrgNumber().toString());
//        if (account == null) {
//            return;
//        }
//        Role role = casService.getRoleByTag(ClubRole.getRoleByCode(goods.getGrade()).getTag());
//        if (role == null) {
//            return;
//        }
//        AccountRole ar = new AccountRole();
//        ar.setAppId(App.JIGOU.getId());
//        ar.setCreatetime(new Date());
//        ar.setAccountId(account.getId());
//        ar.setRoleId(role.getId());
//        acs.add(ar);
//    }
//
//    private void generateOrgVips(List<OrgVip> orgVips, GoodsMembership goods, SuccessOrderInfo orderInfo) {
//        OrgVip orgVip = new OrgVip();
//        orgVip.setCreateTime(new Date());
//        orgVip.setEndTime(goods.getEndTime());
//        orgVip.setIsdel(DeleteStatus.NORMAL.getValue());
//        orgVip.setOrderId(orderInfo.getId());
//        orgVip.setOrderPrice(goods.getPrice());
//        orgVip.setOrgNumber(goods.getOrgNumber());
//        orgVip.setPayPrice(goods.getPayMoney());
//        orgVip.setPurchaseId(goods.getPurchaseId());
//        DateTime startTime = new DateTime(goods.getBeginTime().getTime());
//        DateTime endTime = new DateTime(goods.getEndTime().getTime());
//        int days = Days.daysBetween(startTime, endTime).getDays();
//        orgVip.setRemainDay(days);
//        orgVip.setStartTime(goods.getBeginTime());
//        orgVip.setStatus(VipStatus.NORMAL.getCode());
//        orgVip.setTotalDay(days);
//        orgVip.setUserRole(SalConstant.ORG_ROLE);
//        orgVip.setUpdateTime(new Date());
//        orgVip.setVipLevel(goods.getGrade());
//        orgVips.add(orgVip);
//    }
//
//    @SuppressWarnings("unchecked")
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public int syncUpgradeOrgVip() {
//        int syncCount = 0;
//        int index = 0;
//        OrgVipScanRecord lastRecord = orgVipScanRecordService.getLastUpgradeOrgVipScanRecord();
//        if (lastRecord != null) {
//            index = lastRecord.getSuccessOrderInfoId();
//        }
//        List<SuccessOrderInfo> newOrderInfos = receivablesService.getPayedUpgradeOrderInfo(index);
//        if (CollectionUtils.isNotEmpty(newOrderInfos)) {
//            List<Long> purchaseIds = BaseUtils.getListFilter(newOrderInfos, "purchaseId");
//            List<GoodsMembership> goodsList = receivablesService.getByPurchaseIds(purchaseIds);
//            Map<Long, GoodsMembership> goodsMap = BaseUtils.listToMap(goodsList, "purchaseId");
//            List<OrgVip> orgVips = Lists.newArrayList();
//            List<AccountRole> acs = Lists.newArrayList();
//            for (SuccessOrderInfo orderInfo : newOrderInfos) {
//                GoodsMembership goods = goodsMap.get(orderInfo.getPurchaseId());
//                if (goods != null) {
//                    // TODO 删除已有机构会员身份和cas身份
//                    delOrgVipAndAccountRole(goods);
//                    generateOrgVips(orgVips, goods, orderInfo);
//                    generateAccountRoles(acs, goods);
//                    saveScanRecord(orderInfo);
//                }
//            }
//            orgVipService.saveAll(orgVips);
//            // cas表中插入会员标记
//            casService.saveAllAccountRole(acs);
//            // 通知老师端刷新老师信息
//            noticeTeacherToRefresh(orgVips);
//            syncCount = orgVips.size();
//        }
//        return syncCount;
//
//    }
//
//    /**
//     * @param orderInfo
//     */
//
//    private void saveScanRecord(SuccessOrderInfo orderInfo) {
//        OrgVipScanRecord record = new OrgVipScanRecord();
//        record.setCreateTime(new Date());
//        record.setPurchaseId(orderInfo.getPurchaseId());
//        record.setSubType(orderInfo.getSubType());
//        record.setSuccessOrderInfoId(orderInfo.getId());
//        record.setType(orderInfo.getType());
//        orgVipScanRecordService.saveUpgradeRecord(record);
//    }
//
//    private void delOrgVipAndAccountRole(GoodsMembership goods) {
//        List<OrgVip> orgVips = orgVipService.getOrgVipByOrgNumber(goods.getOrgNumber());
//        if (CollectionUtils.isEmpty(orgVips)) {
//            return;
//        }
//        for (OrgVip orgVip : orgVips) {
//            orgVip.setStatus(VipStatus.DISABLE.getCode());
//            orgVipService.updateOrgVip(orgVip);
//            casService.updateAccountRoleStatus(goods.getOrgNumber().toString(), DeleteStatus.DELETED.getValue(),
//                ClubRole.getRoleByCode(orgVip.getVipLevel()).getTag());
//        }
//    }
//}
