
package com.baijia.tianxiao.biz.club.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.cas.ac.dto.AccountDto;
import com.baijia.cas.ac.dto.RoleDto;
import com.baijia.cas.ac.protocol.GetAccountResponse;
import com.baijia.cas.ac.protocol.GetAccountsResponse;
import com.baijia.cas.ac.protocol.GetSubAccountsResponse;
import com.baijia.tianxiao.biz.club.OrgClubEssentialInfoService;
import com.baijia.tianxiao.biz.club.constant.BizConstant;
import com.baijia.tianxiao.biz.club.constant.ClubRole;
import com.baijia.tianxiao.biz.club.constant.OrgClubLevel;
import com.baijia.tianxiao.biz.club.protocol.Deductible;
import com.baijia.tianxiao.biz.club.protocol.GetBatchOrgClubLevelResponse;
import com.baijia.tianxiao.biz.club.protocol.GetSingleOrgClubLevelResponse;
import com.baijia.tianxiao.biz.club.protocol.GetUpgradeInfo;
import com.baijia.tianxiao.dal.club.po.OrgVip;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.club.OrgVipService;
import com.baijia.tianxiao.sal.club.cas.CasAccountApi;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Maps;

@Service
public class OrgClubEssentialInfoServiceImpl implements OrgClubEssentialInfoService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private CasAccountApi casAccountApi;
    @Autowired
    private OrgVipService orgVipService;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private OrgInfoDao orgInfoDao;

    @Override
    public GetSingleOrgClubLevelResponse getSigleOrgClubLevel(String orgNumber) {

        GetSingleOrgClubLevelResponse response = new GetSingleOrgClubLevelResponse();
        logger.debug("orgNumber:{}", orgNumber);

        if (StringUtils.isBlank(orgNumber)) {
            throw new ParameterException("orgNumber must not be null");
        }

        GetAccountResponse acResponse = null;
        try {
            acResponse = casAccountApi.getAccount(orgNumber);
        } catch (Exception e) {
            logger.error("getSigleOrgClubLevel error", e);
            throw new BussinessException(CommonErrorCode.SYSTEM_ERROR, "system error");
        }

        if (acResponse.getAccount() == null) {
            response.setLevel(OrgClubLevel.NORMAL.getCode());
        } else {
            List<RoleDto> roles = acResponse.getAccount().getHasRoles();
            if (CollectionUtils.isEmpty(roles)) {
                response.setLevel(OrgClubLevel.NORMAL.getCode());
            } else {
                for (RoleDto role : roles) {
                    response.setLevel(OrgClubLevel.getCodeByRole(ClubRole.getRoleByTag(role.getTag())));
                }
            }
        }

        return response;

    }

    @Override
    public GetBatchOrgClubLevelResponse getBatchOrgClubLevel(String orgNumbers)
        throws ParameterException, BussinessException {

        GetBatchOrgClubLevelResponse response = new GetBatchOrgClubLevelResponse();
        Map<String, Integer> data = Maps.newLinkedHashMap();
        logger.debug("orgNumbers:{}", orgNumbers);

        if (StringUtils.isBlank(orgNumbers)) {
            throw new ParameterException("orgNumbers must not be null");
        }

        List<String> orgNumberList = null;
        try {
            orgNumberList = JacksonUtil.str2List(orgNumbers, String.class);
        } catch (Exception e) {
            throw new ParameterException("The pattern of orgNumbers must be wrong!orgNumbers:" + orgNumbers);
        }

        if (orgNumberList.size() > BizConstant.QUERY_BATCH) {
            throw new ParameterException("orgNumbers' length must less than " + BizConstant.QUERY_BATCH);
        }

        GetAccountsResponse acResponse = null;
        try {
            acResponse = casAccountApi.getAccounts(orgNumberList);
        } catch (Exception e) {
            logger.error("getBatchOrgClubLevel error", e);
            throw new BussinessException(CommonErrorCode.SYSTEM_ERROR, "system error");
        }

        for (String orgNumber : orgNumberList) {
            data.put(orgNumber, OrgClubLevel.NORMAL.getCode());
        }

        if (CollectionUtils.isNotEmpty(acResponse.getAccounts())) {
            for (AccountDto dto : acResponse.getAccounts()) {
                List<RoleDto> roles = dto.getHasRoles();
                if (CollectionUtils.isNotEmpty(roles)) {
                    for (RoleDto role : roles) {
                        data.put(dto.getName(), OrgClubLevel.getCodeByRole(ClubRole.getRoleByTag(role.getTag())));
                    }
                }
            }
        }

        response.setLevel(data);
        return response;
    }

    @Override
    public GetBatchOrgClubLevelResponse getAllOrgClubLevel() throws ParameterException, BussinessException {

        GetSubAccountsResponse acResponse = null;
        try {
            acResponse = casAccountApi.getSubAccounts();
        } catch (Exception e) {
            logger.error("getAllOrgClubLevel error!", e);
            throw new BussinessException(CommonErrorCode.SYSTEM_ERROR, "system error");
        }
        Map<String, Integer> data = Maps.newHashMap();

        if (CollectionUtils.isNotEmpty(acResponse.getAccounts())) {
            for (AccountDto dto : acResponse.getAccounts()) {
                List<RoleDto> roles = dto.getHasRoles();
                if (CollectionUtils.isNotEmpty(roles)) {
                    for (RoleDto role : roles) {
                        data.put(dto.getName(), OrgClubLevel.getCodeByRole(ClubRole.getRoleByTag(role.getTag())));
                    }
                }
            }
        }

        GetBatchOrgClubLevelResponse response = new GetBatchOrgClubLevelResponse();
        response.setLevel(data);
        return response;
    }

    @Override
    public List<OrgVip> getOrgVipByOrgNumber(Integer orgNumber) throws ParameterException, BussinessException {

        if (orgNumber == null) {
            throw new ParameterException("orgNumber must not be null");
        }

        List<OrgVip> result = null;
        try {
            result = orgVipService.getOrgVipByOrgNumber(orgNumber);
        } catch (Exception e) {
            logger.error("getOrgVipByOrgNumber error!", e);
            throw new BussinessException(CommonErrorCode.SYSTEM_ERROR, "system error");
        }

        return result;
    }

    @Override
    public Integer getOrgVipRemainDay(Integer orgNumber) throws ParameterException, BussinessException {

        if (orgNumber == null) {
            throw new ParameterException("orgNumber must not be null");
        }

        int remainDay = -1;

        List<OrgVip> orgVips = null;
        try {
            orgVips = orgVipService.getOrgVipByOrgNumber(orgNumber);
        } catch (Exception e) {
            logger.error("getOrgVipByOrgNumber error!", e);
            throw new BussinessException(CommonErrorCode.SYSTEM_ERROR, "system error");
        }

        logger.info("orgVips:{}", orgVips);
        if (CollectionUtils.isNotEmpty(orgVips)) {
            for (OrgVip orgVip : orgVips) {
                logger.info("orgVip:{}", orgVip);
                if (orgVip.getRemainDay() > remainDay) {
                    remainDay = orgVip.getRemainDay();
                }
            }
        }

        return remainDay;
    }

    @Override
    public GetUpgradeInfo getUpgradeInfo(String mobile, String beginTime) throws Exception {
        if (StringUtils.isBlank(mobile)) {
            throw new ParameterException("mobile must not be null");
        }

        if (StringUtils.isBlank(beginTime)) {
            throw new ParameterException("beginTime must not be null");
        }

        OrgAccount orgAccount = orgAccountService.getOrgAccountByMobile(mobile);
        if (orgAccount == null) {
            throw new ParameterException("mobile does not exist");
        }

        List<OrgVip> orgVips = orgVipService.getOrgVipByOrgNumber(orgAccount.getNumber());
        if (CollectionUtils.isEmpty(orgVips)) {
            OrgVip orgVip = new OrgVip();
            orgVip.setVipLevel(0);
            orgVip.setRemainDay(0);
            orgVip.setTotalDay(0);
            orgVips.add(orgVip);
            // throw new ParameterException("Organization is not a member");
        }

        // 曾经允许买多个，但2016-3-10日开发时，又定为只能买一个会员
        // 如以后能买多个会员，此处需要升级
        Map<String, String> priceLevel = Maps.newHashMap();
        priceLevel.put(ClubRole.GOLD_ROLE.getCode().toString(),
            PropertiesReader.getValue(BizConstant.ORG_VIP_LEVEL_FILE_NAME, ClubRole.GOLD_ROLE.getCode().toString()));
        priceLevel.put(ClubRole.PLATINUM_ROLE.getCode().toString(), PropertiesReader
            .getValue(BizConstant.ORG_VIP_LEVEL_FILE_NAME, ClubRole.PLATINUM_ROLE.getCode().toString()));
        priceLevel.put(ClubRole.DIAMOND_ROLE.getCode().toString(),
            PropertiesReader.getValue(BizConstant.ORG_VIP_LEVEL_FILE_NAME, ClubRole.DIAMOND_ROLE.getCode().toString()));
        OrgVip orgVip = orgVips.get(0);
        GetUpgradeInfo response = new GetUpgradeInfo();
        OrgInfoSimpleDto orgInfo = orgInfoService.getOrgInfo(Long.valueOf(orgAccount.getId()));
        response.setUserName(orgInfo.getShortName());
        response.setNumber(orgAccount.getNumber());
        response.setRemainDays(orgVip.getRemainDay());
        response.setUserId(orgAccount.getId());
        OrgInfo auditOrgInfo = orgInfoDao.getOrgInfo(orgAccount.getId());
        if (auditOrgInfo.getAuditStatus() != AuditStatus.PASS.getValue()) {
            // throw new ParameterException(OrgClubErrorCode.AUDIT_NOT_PASSED, "org audit is not passed");
            // 支付不进行rd联调，要上beta发现不生效机构还要机构信息，给个标识
            response.setVipLevel(-1);
        } else {
            response.setVipLevel(orgVip.getVipLevel());
        }
        response.setLevelPrice(priceLevel);
        // 算剩余价值
        if (orgVip.getVipLevel() != ClubRole.UNKNOW_ROLE.getCode()) {
            Deductible deductible = new Deductible();
            Double remainDay = Double.valueOf(orgVip.getRemainDay());
            Double totalDay = Double.valueOf(orgVip.getTotalDay());
            // 第一次升级，取payprice，第二次升级，取totalprice
            List<OrgVip> totalVips = orgVipService.getTotalOrgVipByOrgNumber(orgAccount.getNumber());
            BigDecimal totalMoney = null;
            if (totalVips.size() > 1) {
                totalMoney = new BigDecimal(orgVip.getOrderPrice());
            } else {
                totalMoney = new BigDecimal(orgVip.getPayPrice());
            }
            BigDecimal btd = new BigDecimal(totalDay);
            BigDecimal perDayIncome = totalMoney.divide(btd, 2, RoundingMode.DOWN);
            Double value =
                totalMoney.subtract(perDayIncome.multiply(new BigDecimal(totalDay - remainDay))).doubleValue();
            deductible.setBeginTime(beginTime);
            DecimalFormat df = new DecimalFormat("######0.00");
            if (remainDay > 1) {
                deductible.setValue(df.format(value));
            } else {
                deductible.setValue("0.00");
            }
            response.setDeductible(deductible);
        }
        return response;
    }

    public static void main(String[] args) {
        DecimalFormat df = new DecimalFormat("######0.00");
        System.out.println(df.format(new BigDecimal(9.90)));
    }
}
