
package com.baijia.tianxiao.biz.club.constant;

public enum ClubRole {
    UNKNOW_ROLE(0,"未知", "unknow"),
    NORMAL_ROLE(1,"普通用户", "normal"),
    GOLD_ROLE(2,"金卡会员", "yunying_jigou_club_gold"),
    PLATINUM_ROLE(3,"白金卡会员", "yunying_jigou_club_platinum"), 
    DIAMOND_ROLE(4, "钻石卡会员", "yunying_jigou_club_diamond");
    
    private Integer code;
    private String name;
    private String tag;
    
    ClubRole(Integer code, String name, String tag){
        this.code = code;
        this.name = name;
        this.tag = tag;
    }

    public Integer getCode() {
    
        return code;
    }

    public void setCode(Integer code) {
    
        this.code = code;
    }

    public String getName() {
    
        return name;
    }

    public void setName(String name) {
    
        this.name = name;
    }
    
    public String getTag() {
    
        return tag;
    }

    public void setTag(String tag) {
    
        this.tag = tag;
    }

    public static ClubRole getRoleByTag(String tag) {
        if(tag == null){
            return null;
        }
        for (ClubRole role : values()) {
            if (role.getTag().equals(tag)) {
                return role;
            }
        }
        return UNKNOW_ROLE;
    }
    
    public static ClubRole getRoleByCode(Integer code) {
        if(code == null){
            return null;
        }
        for (ClubRole role : values()) {
            if (role.getCode() == code) {
                return role;
            }
        }
        return UNKNOW_ROLE;
    }
}

    