package com.baijia.tianxiao.biz.club.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;

import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.model.Message;
import com.aliyun.mns.model.QueueMeta;
import com.baijia.tianxiao.util.properties.PropertiesReader;

import net.sf.json.JSONObject;

public class MqsUtils {
    
    private static final Logger logger = LoggerFactory.getLogger(MqsUtils.class);
    
    //队列消息的长轮询等待时间，单位是秒
    private static final int POLLING_WAIT_SECONDS = 15;
    
    //队列消息的最大长度，单位是byte
    private static final long MAX_MSG_SIZE = 2048L;
    
    private MNSClient client;
    public MqsUtils() {
        CloudAccount account = new CloudAccount(
            PropertiesReader.getValue("mqs", "mns.accesskeyid"),
            PropertiesReader.getValue("mqs", "mns.accesskeysecret"),
            PropertiesReader.getValue("mqs", "mns.accountendpoint"));
        client = account.getMNSClient();
    }
    
    /**
     * 创建队列
     * @param queueName
     * @return
     */
    public CloudQueue getAndCreateQueue(String queueName) {
        CloudQueue queue = client.getQueueRef(queueName);
        if (queue == null) {
            QueueMeta meta = new QueueMeta();
            meta.setQueueName(queueName);
            meta.setPollingWaitSeconds(POLLING_WAIT_SECONDS);
            meta.setMaxMessageSize(MAX_MSG_SIZE);
            queue = client.createQueue(meta);
        }
        return queue;
    }
    
    /**
     * 发送队列消息
     * @param queueName
     * @param messageBody
     */
    public void sendMessage(String queueName, String messageBody) {
        CloudQueue queue = this.getAndCreateQueue(queueName);
        String msgId = UUID.randomUUID().toString();
        
        // 发送消息
        Message message = new Message();
        message.setMessageBody(messageBody);
        message.setRequestId(msgId);
        
        logger.info("sendMessage.queueName:{}, messageBody:{}", queueName, messageBody);
        queue.putMessage(message);
    }
    
    /**
     * 关闭消息队列连接
     */
    public void doAfter() {
        if (client != null) {
            client.close();
        }
    }
    
    public MNSClient getClient() {
        return client;
    }

    public void setClient(MNSClient client) {
        this.client = client;
    }

    public static void main(String args[]) {
//        MqsUtils mqs = null;
//        try {
//            String queueName = "YUNYING-SZ-ORG-REGIST";
//            mqs = new MqsUtils();
//            Map<String,Integer> map = Maps.newHashMap();
//            map.put("org_id", 123);
//            String messageBody = JSONObject.fromObject(map).toString();
//            mqs.sendMessage(queueName, messageBody);
//            
//        } finally {
//            mqs.doAfter();
//        }
        Map<String, ArrayList<Integer>> map = Maps.newHashMap();
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        list.add(3);
        map.put("org_id", list);
        String msg = JSONObject.fromObject(map).toString();
        System.out.println(msg);
    }
}
