/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.club.impl;

import com.baijia.tianxiao.biz.club.OrgClubOperateService;
import com.baijia.tianxiao.biz.club.constant.CasAccountStatus;
import com.baijia.tianxiao.biz.club.constant.ClubRole;
import com.baijia.tianxiao.dal.cas.po.Account;
import com.baijia.tianxiao.dal.cas.po.AccountRole;
import com.baijia.tianxiao.dal.cas.po.Role;
import com.baijia.tianxiao.dal.club.po.OrgVip;
import com.baijia.tianxiao.dal.club.po.OrgVipChargingHistory;
import com.baijia.tianxiao.dal.constant.VipStatus;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.shoukuan.po.GoodsMembership;
import com.baijia.tianxiao.dal.shoukuan.po.SuccessOrderInfo;
import com.baijia.tianxiao.sal.club.OrgVipChargingHistoryService;
import com.baijia.tianxiao.sal.club.OrgVipService;
import com.baijia.tianxiao.sal.club.ReceivablesService;
import com.baijia.tianxiao.sal.club.cas.CasService;
import com.baijia.tianxiao.sal.club.constant.App;
import com.baijia.tianxiao.sal.club.constant.OrgVipChargingHistoryStatus;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.beust.jcommander.internal.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgClubOperateServiceImpl
implements OrgClubOperateService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OrgVipChargingHistoryService orgVipChargingHistoryService;
    @Autowired
    private OrgVipService orgVipService;
    @Autowired
    private ReceivablesService receivablesService;
    @Autowired
    private CasService casService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void signHistoryHandled(String orgVipHistoryIdsStr) throws Exception {
        List orgVipChargingHistoryIds = JacksonUtil.str2List((String)orgVipHistoryIdsStr, Integer.class);
        this.logger.debug("signHistoryHandled ids:{}", (Object)orgVipChargingHistoryIds);
        this.orgVipChargingHistoryService.batchUpdateStatus(orgVipChargingHistoryIds, Integer.valueOf(OrgVipChargingHistoryStatus.HANDLED.getCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int dailySyncOrgVip() {
        int syncCount = 0;
        int index = 0;
        boolean toBeContinued = true;
        do {
            OrgVip orgVip;
            if ((orgVip = this.orgVipService.getSingleNormalOrgVip(Integer.valueOf(index))) != null) {
                if (orgVip.getStartTime().getTime() <= System.currentTimeMillis()) {
                    ++syncCount;
                    int remainDay = orgVip.getRemainDay();
                    orgVip.setRemainDay(Integer.valueOf(--remainDay));
                    orgVip.setUpdateTime(new Date());
                    this.orgVipService.updateOrgVip(orgVip);
                    if (remainDay == 0) {
                        this.casService.updateAccountStatus(orgVip.getOrgNumber().toString(), Integer.valueOf(CasAccountStatus.PAUSE.getCode()));
                    }
                    if (orgVip.getPurchaseId() > 0L) {
                        OrgVipChargingHistory history = new OrgVipChargingHistory();
                        history.setOrgNumber(orgVip.getOrgNumber());
                        history.setStatus(Integer.valueOf(OrgVipChargingHistoryStatus.WAITING.getCode()));
                        history.setVipId(orgVip.getId());
                        history.setRemainDay(orgVip.getRemainDay());
                        this.orgVipChargingHistoryService.saveOrgVipChargingHistory(history);
                    }
                }
                index = orgVip.getId();
                continue;
            }
            toBeContinued = false;
        } while (toBeContinued);
        return syncCount;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int syncNewOrgVip() {
        List newOrderInfos;
        int syncCount = 0;
        int index = 0;
        OrgVip lastOrgVip = this.orgVipService.getLastOrgVip();
        if (lastOrgVip != null) {
            index = lastOrgVip.getOrderId();
        }
        if (CollectionUtils.isNotEmpty((Collection)(newOrderInfos = this.receivablesService.getPayedOrderInfo(index)))) {
            List purchaseIds = BaseUtils.getListFilter((List)newOrderInfos, (String)"purchaseId");
            List goodsList = this.receivablesService.getByPurchaseIds(purchaseIds);
            Map goodsMap = BaseUtils.listToMap((List)goodsList, (String)"purchaseId");
            List orgVips = Lists.newArrayList();
            List acs = Lists.newArrayList();
            for (SuccessOrderInfo orderInfo : newOrderInfos) {
                GoodsMembership goods = (GoodsMembership)goodsMap.get(orderInfo.getPurchaseId());
                if (goods == null) continue;
                this.generateOrgVips(orgVips, goods, orderInfo);
                this.generateAccountRoles(acs, goods);
            }
            this.orgVipService.saveAll(orgVips);
            this.casService.saveAllAccountRole(acs);
            syncCount = orgVips.size();
        }
        return syncCount;
    }

    private void generateAccountRoles(List<AccountRole> acs, GoodsMembership goods) {
        Account account = this.casService.getAccountByName(goods.getOrgNumber().toString());
        if (account == null) {
            return;
        }
        Role role = this.casService.getRoleByTag(ClubRole.getRoleByCode(goods.getGrade()).getTag());
        if (role == null) {
            return;
        }
        AccountRole ar = new AccountRole();
        ar.setAppId(Integer.valueOf(App.JIGOU.getId()));
        ar.setCreatetime(new Date());
        ar.setAccountId(Integer.valueOf(account.getId()));
        ar.setRoleId(Integer.valueOf(role.getId()));
        acs.add(ar);
    }

    private void generateOrgVips(List<OrgVip> orgVips, GoodsMembership goods, SuccessOrderInfo orderInfo) {
        OrgVip orgVip = new OrgVip();
        orgVip.setCreateTime(new Date());
        orgVip.setEndTime(goods.getEndTime());
        orgVip.setIsdel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        orgVip.setOrderId(orderInfo.getId());
        orgVip.setOrderPrice(goods.getPrice());
        orgVip.setOrgNumber(goods.getOrgNumber());
        orgVip.setPayPrice(goods.getPayMoney());
        orgVip.setPurchaseId(goods.getPurchaseId());
        DateTime startTime = new DateTime(goods.getBeginTime().getTime());
        DateTime endTime = new DateTime(goods.getEndTime().getTime());
        int days = Days.daysBetween((ReadableInstant)startTime, (ReadableInstant)endTime).getDays();
        orgVip.setRemainDay(Integer.valueOf(days));
        orgVip.setStartTime(goods.getBeginTime());
        orgVip.setStatus(Integer.valueOf(VipStatus.NORMAL.getCode()));
        orgVip.setTotalDay(Integer.valueOf(days));
        orgVip.setUserRole(Integer.valueOf(6));
        orgVip.setUpdateTime(new Date());
        orgVip.setVipLevel(goods.getGrade());
        orgVips.add(orgVip);
    }

    public static void main(String[] args) {
        DateTime startTime = new DateTime(new Date(2016, 2, 25).getTime());
        DateTime endTime = new DateTime(new Date(2017, 2, 15).getTime());
        System.out.println(Days.daysBetween((ReadableInstant)startTime, (ReadableInstant)endTime).getDays());
    }
}

