/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.campus.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.biz.campus.constant.CampusType;
import com.baijia.tianxiao.biz.campus.dto.BaseCampusDto;
import com.baijia.tianxiao.biz.campus.dto.EnrollOverriew;
import com.baijia.tianxiao.biz.campus.dto.EnrollOverriewDto;
import com.baijia.tianxiao.biz.campus.dto.OverriewCampusDto;
import com.baijia.tianxiao.biz.campus.dto.OverriewCampusListDto;
import com.baijia.tianxiao.biz.campus.service.OverriewService;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgFinanceAccountDto;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;

import lombok.extern.slf4j.Slf4j;

/**
 * @author caoliang
 * @version 1.0
 * @title OverriewServiceImpl
 * @desc TODO
 * @date 2016年5月10日
 */
@Slf4j
@Service
public class OverriewServiceImpl implements OverriewService {

    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private OrgTeacherDao orgTeacherDao;
    @Autowired
    private OrgStudentDao orgStudentDAo;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private TxFinanceRecordDayDao txFinanceRecordDayDao;
    @Autowired
    private OrgFinanceAccountService orgFinanceAccountService;

    @Override
    public List<OverriewCampusListDto> getCampusList(Integer orgId, PageDto pageDto)
        throws BussinessException, Exception {
        List<OverriewCampusListDto> data = Lists.newArrayList();
        if (pageDto != null) {
            if (pageDto.getPageNum() == 1) {
                pageDto.setPageSize(pageDto.getPageSize() - 1);
            } else {
                pageDto.setCurPageCount((pageDto.getPageNum() - 1) * pageDto.getPageSize() - 1);
                data.clear();
            }
        }
        log.debug("1111111111111pageDto={}",pageDto);
        // 分校区
        List<OrgSubAccount> slaves = orgSubAccountService.getSlaves(orgId, pageDto);
        List<Integer> subOrgIds = Lists.newArrayList();
        List<Long> subOrgIdsLong = Lists.newArrayList();
        subOrgIds.add(orgId);
        subOrgIdsLong.add(orgId.longValue());
        if (CollectionUtils.isNotEmpty(slaves)) {
            for (OrgSubAccount ca : slaves) {
                subOrgIds.add(ca.getOrgId());
                subOrgIdsLong.add(ca.getOrgId().longValue());
            }
        }
        // 批量取各类数据
        Map<Integer, OrgInfo> orgInfoMap = orgInfoService.getOrgInfoMap(subOrgIds);
        Map<Integer, OrgAccount> orgAccountMap = orgAccountService.getOrgAccountMap(subOrgIds);
        Map<Integer, Integer> signupCountMap = orgSignupInfoDao.countSubOrgByTime(subOrgIds, null, null);
        Map<Integer, Integer> teacherCountMap = orgTeacherDao.getSignedTeacherCountMap(subOrgIds);
        Map<Integer, Integer> studentCountMap = orgStudentDAo.getStudentCountMap(subOrgIds);
        Map<Integer, Double> financeMap = txFinanceRecordDayDao.queryByOrgIds(subOrgIds,DateUtil.getStartOfMonth(), DateUtil.getEndOfMonth());
        Map<Integer, OrgFinanceAccountDto> financeAccountMap = orgFinanceAccountService.getAccountInfos(subOrgIdsLong);
        // 主校区
        OrgAccount orgAccount = orgAccountMap.get(orgId);
        OrgSubAccount masterSub = orgSubAccountService.getMaster(orgId);
        if(orgAccount == null || masterSub == null){
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "无法查询账户信息，请刷新重试");
        }
        OverriewCampusListDto master = new OverriewCampusListDto();
        OrgInfo orgInfo = orgInfoMap.get(orgId);
        master.setCampusName(orgInfo.getShortName());
        master.setCampusNumber(orgAccount.getNumber());
        master.setCampusType(CampusType.MASTER.getCode());
        master.setCampusTypeName(CampusType.MASTER.getLabel());
        master.setCoverUrl(masterSub.getCoverUrl());
        data.add(master);
        log.debug("22222222222pageDto={}",pageDto);
        if (pageDto != null) {
            if (pageDto.getPageNum() == 1) {
                pageDto.setPageSize(pageDto.getPageSize() - 1);
            } else {
                pageDto.setCurPageCount((pageDto.getPageNum() - 1) * pageDto.getPageSize() - 1);
                // 不是第一页时，不需要主校区
                data.clear();
            }
        }
        log.debug("33333333333pageDto={}",pageDto);
        if (CollectionUtils.isNotEmpty(slaves)) {
            for (OrgSubAccount orgSubAccount : slaves) {
                OrgInfo orgInfo2 = orgInfoMap.get(orgSubAccount.getOrgId());
                OrgAccount orgAccount2 = orgAccountMap.get(orgSubAccount.getOrgId());
                if (orgInfo2 == null || orgAccount2 == null) {
                    continue;
                }
                OverriewCampusListDto slave = new OverriewCampusListDto();
                slave.setCampusName(orgInfo2.getShortName());
                slave.setCampusNumber(orgAccount2.getNumber());
                slave.setCampusType(orgSubAccount.getAccountType());
                slave.setCampusTypeName(CampusType.getLabelByCode(orgSubAccount.getAccountType()));
                slave.setCoverUrl(orgSubAccount.getCoverUrl());
                OrgFinanceAccountDto dto = financeAccountMap.get(orgSubAccount.getOrgId().intValue());
                if (dto != null) {
                    Double balance = dto.getBalance() != null ? Double.parseDouble(dto.getBalance()) : 0.00;
                    Double freeze = dto.getFreeze_money() != null ? Double.parseDouble(dto.getFreeze_money()) : 0.00;
                    Double expected = dto.getExpected_earning() != null ? Double.parseDouble(dto.getExpected_earning()) : 0.00;
                    slave.setBalance(balance + freeze + expected);
                    Double income = financeMap.get(orgSubAccount.getOrgId());
                    slave.setIncomeSum(income != null ? income : 0.00);
                } else {
                    slave.setBalance(0.00);
                    Double income = financeMap.get(orgSubAccount.getOrgId());
                    slave.setIncomeSum(income != null ? income : 0.00);
                }
                slave.setEnrollSum(
                    signupCountMap.get(orgAccount2.getId()) == null ? 0 : signupCountMap.get(orgAccount2.getId()));
                slave.setStudentSum(
                    studentCountMap.get(orgAccount2.getId()) == null ? 0 : studentCountMap.get(orgAccount2.getId()));
                slave.setTeacherSum(
                    teacherCountMap.get(orgAccount2.getId()) == null ? 0 : teacherCountMap.get(orgAccount2.getId()));
                data.add(slave);
            }

        }
        // 设置主校区金额
        OrgFinanceAccount masterAccount= orgFinanceAccountService.getAccountInfo(orgId.longValue());
        if(masterAccount==null){
            log.info("cannot find the financeAccount - masterAccountId:{}",orgId);
            return data;
        }
        master.setBalance(masterAccount.getBalance()+masterAccount.getFreezeMoney()+masterAccount.getExpectedEarning());
        Double income = txFinanceRecordDayDao.getIncome(orgId.longValue(),DateUtil.getStartOfMonth(), DateUtil.getEndOfMonth());
        master.setIncomeSum(income);
        int enrollSum = signupCountMap.get(orgId) == null ? 0 : signupCountMap.get(orgId);
        master.setEnrollSum(enrollSum);
        int teacherSum = teacherCountMap.get(orgId) == null ? 0 : teacherCountMap.get(orgId);
        master.setTeacherSum(teacherSum);
        int studentSum = studentCountMap.get(orgId) == null ? 0 : studentCountMap.get(orgId);
        master.setStudentSum(studentSum);
        if (pageDto != null) {
            Integer count = orgSubAccountService.getSlaveCount(orgId);
            pageDto.setCount(++count);
        }
        return data;
    }

    @Override
    public OverriewCampusDto getCampusOverriew(Integer orgId) throws Exception {
        OverriewCampusDto data = new OverriewCampusDto();
        List<OrgSubAccount> slaves = orgSubAccountService.getSlaves(orgId, null);
        int teacherSum = 0;
        int studentSum = 0;

        // 加分校区数据
        List<Integer> subOrgIds = Lists.newArrayList();
        // 总校区＋直营校区
        List<Integer> ids = Lists.newArrayList();
        List<Long> orgIds = Lists.newArrayList();
        orgIds.add(Long.valueOf(orgId));
        subOrgIds.add(orgId);
        ids.add(orgId);
        if (CollectionUtils.isNotEmpty(slaves)) {
            for (OrgSubAccount slave : slaves) {
                if (slave.getStatus() == OrgSubAccountStatus.NORMAL.getCode().intValue()) {
                    subOrgIds.add(slave.getOrgId());
                    if (slave.getAccountType() != CampusType.LEAGUE.getCode()) {
                        ids.add(slave.getOrgId());
                    }
                }
                orgIds.add(Long.valueOf(slave.getOrgId()));
            }
        }
        // 加主校区数据
        teacherSum = orgTeacherDao.getSignedTeacherCount(orgIds);
        studentSum += orgStudentDAo.getStudentSum(orgIds);
        log.debug("enroll count week orgIds:{},start{},end{}", orgIds, DateUtil.getStartOfWeek(),
            DateUtil.getEndOfWeek());
        log.debug("enroll count month orgIds:{},start{},end{}", orgIds, DateUtil.getStartOfMonth(),
            DateUtil.getEndOfMonth());
        int weekEnroll = orgSignupInfoDao.countByTime(orgIds, DateUtil.getStartOfWeek(), DateUtil.getEndOfWeek());
        int monthEnroll = orgSignupInfoDao.countByTime(orgIds, DateUtil.getStartOfMonth(), DateUtil.getEndOfMonth());
        data.setMonthEnroll(monthEnroll);
        data.setStudentSum(studentSum);
        data.setWeekEnroll(weekEnroll);
        data.setTeacherSum(teacherSum);
        // 总收入=总校区收入＋直营区收入
        Double week = txFinanceRecordDayDao.getIncomes(ids, DateUtil.getStartOfWeek(), DateUtil.getEndOfWeek());
        Double month = txFinanceRecordDayDao.getIncomes(ids, DateUtil.getStartOfMonth(), DateUtil.getEndOfMonth());
        data.setWeekIncome(week);
        data.setMonthIncome(month);
        /*
         * RestfulResult<OrgAccountDetailDto> masterResult; try { masterResult =
         * PayMentSystemApiHelper.orgAccountDetail(orgId, subOrgIds);
         * log.info("call - payMentSystem api - orgAccountDetail - masterOrgId:{} ,subOrgIds:{}, restfulResult:{}",
         * orgId, subOrgIds, masterResult); } catch (Exception e) {
         * log.error("call - payMentSystem api - orgAccountDetail - exception - masterOrgId:{},subOrgIds:{}", orgId,
         * subOrgIds); return data; } if (masterResult.getCode() != TianXiaoConstant.SUCC_CODE) { log.error(
         * "call - payMentSystem api - orgAccountDetail - fail - masterOrgId:{},subOrgids:{} restfulResult:{}", orgId,
         * subOrgIds, masterResult); return data; } data.setMonthIncome(masterResult.getData().getIncomeMonth());
         * data.setWeekIncome(masterResult.getData().getIncomeWeek());
         */
        return data;

    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * com.baijia.tianxiao.biz.campus.service.OverriewService#getCampusList(com.baijia.tianxiao.dal.org.po.OrgAccount)
     */

    @Override
    public List<BaseCampusDto> getCampusList(Integer orgId) throws Exception {
        OrgAccount orgAccount = orgAccountService.getOrgAccountById(orgId);
        List<BaseCampusDto> data = Lists.newArrayList();
        BaseCampusDto master = new BaseCampusDto();
        OrgInfoSimpleDto orgInfo = orgInfoService.getOrgInfo(Long.valueOf(orgId));
        master.setCampusId(orgId);
        master.setCampusName(orgInfo.getShortName());
        master.setCampusNumber(orgAccount.getNumber());
        master.setCampusType(CampusType.MASTER.getCode());
        data.add(master);

        List<OrgSubAccount> slaves = orgSubAccountService.getSlaves(orgId, null);

        if (CollectionUtils.isNotEmpty(slaves)) {
            List<Integer> orgIds = Lists.newArrayList();
            for (OrgSubAccount orgSubAccount : slaves) {
                orgIds.add(orgSubAccount.getOrgId());
            }
            Map<Integer, OrgAccount> orgAccountMap = orgAccountService.getOrgAccountMap(orgIds);
            Map<Integer, OrgInfo> orgInfoMap = orgInfoService.getOrgInfoMap(orgIds);
            for (OrgSubAccount orgSubAccount : slaves) {
                OrgAccount orgAccount2 = orgAccountMap.get(orgSubAccount.getOrgId());
                OrgInfo orgInfo2 = orgInfoMap.get(orgSubAccount.getOrgId());
                if (orgAccount2 == null || orgInfo2 == null) {
                    continue;
                }
                BaseCampusDto slave = new BaseCampusDto();
                slave.setCampusId(orgSubAccount.getOrgId());
                slave.setCampusName(orgInfo2.getShortName());
                slave.setCampusNumber(orgAccount2.getNumber());
                slave.setCampusType(orgSubAccount.getAccountType());
                slave.setCampusTypeName(CampusType.getLabelByCode(orgSubAccount.getAccountType()));
                data.add(slave);
            }
        }

        // if (CollectionUtils.isNotEmpty(slaves)) {
        // for (OrgSubAccount ca : slaves) {
        // OrgAccount oa = orgAccountService.getOrgAccountById(ca.getOrgId());
        // if (oa == null) {
        // continue;
        // }
        // OrgInfoSimpleDto slaveOrgInfo = orgInfoService.getOrgInfo(Long.valueOf(oa.getId()));
        // BaseCampusDto slave = new BaseCampusDto();
        // slave.setCampusId(ca.getOrgId());
        // slave.setCampusName(slaveOrgInfo.getShortName());
        // slave.setCampusNumber(oa.getNumber());
        // slave.setCampusType(ca.getAccountType());
        // slave.setCampusTypeName(CampusType.getLabelByCode(ca.getAccountType()));
        // data.add(slave);
        // }
        // }
        return data;
    }

    @Override
    public EnrollOverriewDto enrollOverriew(Integer orgId) throws Exception {
        List<OrgSubAccount> slaves = orgSubAccountService.getSlaves(orgId, null);
        List<Integer> orgIds = Lists.newArrayList();
        orgIds.add(orgId);
        if (CollectionUtils.isNotEmpty(slaves)) {
            for (OrgSubAccount slave : slaves) {
                orgIds.add(slave.getOrgId());
            }
        }
        EnrollOverriewDto data = new EnrollOverriewDto();
        int studentSum = 0;
        Date now = new Date();
        Date yestoday = DateUtil.getDayDiff(-1);
        List<Long> countOrgIds = Lists.newArrayList();
        for (Integer id : orgIds) {
            // studentSum += orgStudentDAo.getStudentSum(id);
            countOrgIds.add(Long.valueOf(id));
        }
        studentSum = orgStudentDAo.getStudentSum(countOrgIds);
        int todayEnroll =
            orgSignupInfoDao.countByTime(countOrgIds, DateUtil.getStartOfDay(now), DateUtil.getEndOfDay(now));
        int yestodayEnroll =
            orgSignupInfoDao.countByTime(countOrgIds, DateUtil.getStartOfDay(yestoday), DateUtil.getEndOfDay(yestoday));
        int weekEnroll = orgSignupInfoDao.countByTime(countOrgIds, DateUtil.getStartOfWeek(), DateUtil.getEndOfWeek());
        int monthEnroll =
            orgSignupInfoDao.countByTime(countOrgIds, DateUtil.getStartOfMonth(), DateUtil.getEndOfMonth());
        data.setMonthEnroll(monthEnroll);
        data.setTodayEnroll(todayEnroll);
        data.setWeekEnroll(weekEnroll);
        data.setYestodayEnroll(yestodayEnroll);
        data.setStudentSum(studentSum);
        return data;
    }

    @Override
    public List<EnrollOverriew> enrollList(Integer orgNumber, Integer orgId, Date startTime, Date endTime,
        PageDto pageDto) throws BussinessException, Exception {
        List<Long> orgIds = Lists.newArrayList();
        List<Integer> intOrgIds = Lists.newArrayList();
        // 归拢orgId
        if (orgNumber != null && orgNumber > 0) {
            OrgAccount orgAccount = orgAccountService.getOrgAccountByNumber(orgNumber);
            if (orgAccount != null) {
                orgIds.add(Long.valueOf(orgAccount.getId()));
                intOrgIds.add(orgAccount.getId());
            }
        } else {
            orgIds.add(Long.valueOf(orgId));
            intOrgIds.add(orgId);
            List<OrgSubAccount> subAccounts = orgSubAccountService.getSlaves(orgId, null);
            if (CollectionUtils.isNotEmpty(subAccounts)) {
                for (OrgSubAccount subAccount : subAccounts) {
                    orgIds.add(Long.valueOf(subAccount.getOrgId()));
                    intOrgIds.add(subAccount.getOrgId());
                }
            }
        }
        List<EnrollOverriew> data = Lists.newArrayList();
        if (CollectionUtils.isEmpty(orgIds)) {
            return data;
        }

        // 取订单信息
        List<OrgSignupInfo> orgSignupInfos = orgSignupInfoDao.getPurchases(startTime, endTime, orgIds, pageDto);
        if (CollectionUtils.isEmpty(orgSignupInfos)) {
            return data;
        }
        // 归拢purchaseId，取出所有关联的课程
        List<Long> purchaseIds = Lists.newArrayList();
        List<Long> studentIds = Lists.newArrayList();
        for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
            purchaseIds.add(orgSignupInfo.getSignupPurchaseId());
            studentIds.add(orgSignupInfo.getUserId());
        }

        // 取课程详细信息
        List<Long> courseIds = Lists.newArrayList();
        Multimap<Long, Long> pidCidsMap = ArrayListMultimap.create();
        List<OrgSignupCourse> orgSignupCourses = orgSignupCourseDao.loadByPurchaseIds(purchaseIds);
        if (CollectionUtils.isNotEmpty(orgSignupCourses)) {
            for (OrgSignupCourse orgSignupCourse : orgSignupCourses) {
                courseIds.add(orgSignupCourse.getOrgCourseId());
                pidCidsMap.put(orgSignupCourse.getSignupPurchaseId(), orgSignupCourse.getOrgCourseId());
            }
        }
        Map<Long, OrgCourse> cidCourseMap = Maps.newHashMap();
        List<OrgCourse> orgCourses = orgCourseDao.getByIds(courseIds);
        if (CollectionUtils.isNotEmpty(orgCourses)) {
            for (OrgCourse orgCourse : orgCourses) {
                cidCourseMap.put(orgCourse.getId(), orgCourse);
            }
        }

        // 取学生信息
        Map<Long, OrgStudent> studentsMap = orgStudentDAo.getOrgStudentMapByUserIds(studentIds);

        // 取orgInfo信息
        // Map<Long, OrgInfoSimpleDto> orgInfoMap = Maps.newHashMap();
        // for (Long tempOrgId : orgIds) {
        // OrgInfoSimpleDto orgInfoSimpleDto = orgInfoService.getOrgInfo(tempOrgId);
        // if (orgInfoSimpleDto != null) {
        // orgInfoMap.put(tempOrgId, orgInfoSimpleDto);
        // }
        // }
        Map<Integer, OrgInfo> orgInfoMap = orgInfoService.getOrgInfoMap(intOrgIds);

        // 构建返回信息
        for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
            // OrgInfoSimpleDto orgInfoSimpleDto = orgInfoMap.get(orgSignupInfo.getOrgId());
            OrgInfo orgInfo = orgInfoMap.get(orgSignupInfo.getOrgId().intValue());
            EnrollOverriew dto = new EnrollOverriew();
            if (orgInfo != null) {
                dto.setCampusName(orgInfo.getShortName());
            }
            dto.setCreateTime(orgSignupInfo.getCreateTime().getTime());
            dto.setExportTime(orgSignupInfo.getCreateTime());
            dto.setPrice(orgSignupInfo.getTotalPrices().doubleValue() / 100);
            Collection<Long> cids = pidCidsMap.get(orgSignupInfo.getSignupPurchaseId());
            if (CollectionUtils.isNotEmpty(cids)) {
                StringBuilder courseName = new StringBuilder();
                List<Long> tempCids = new ArrayList<Long>(cids);
                for (int i = 0; i < tempCids.size(); i++) {
                    Long cid = tempCids.get(i);
                    OrgCourse orgCourse = cidCourseMap.get(cid);
                    if (orgCourse != null) {
                        courseName.append(orgCourse.getName());
                    }
                    if ((i + 1) < tempCids.size()) {
                        courseName.append(",");
                    }
                }
                dto.setCourseName(courseName.toString());
            }
            OrgStudent orgStudent = studentsMap.get(orgSignupInfo.getUserId());
            if (orgStudent != null) {
                if (StringUtils.isBlank(orgStudent.getName())) {
                    if (StringUtils.isNotEmpty(orgStudent.getNickName())) {
                        dto.setStudentName(orgStudent.getNickName());
                    } else {
                        dto.setStudentName(MaskUtil.maskMobile(orgStudent.getMobile()));
                    }
                } else {
                    dto.setStudentName(orgStudent.getName());
                }
            }
            data.add(dto);
        }
        return data;
    }

    @Override
    public boolean isRequestValid() {

        boolean flag = false;
        Integer orgId = TianxiaoPCContext.getOrgId();
        Integer txAccountId = TianxiaoPCContext.getTXLoginAccountId();

        OrgAccount orgAccount = orgAccountService.getOrgAccountById(orgId);
        if (orgAccount != null) {
            flag = true;
        }

        TXAccount txAccount = null;
        if (txAccountId != null && orgId != null) {
            txAccount = txAccountService.getByIdAndOrgId(txAccountId, orgId);
        }
        if (txAccount == null) {
            // 主校区下的主管也可以操作
            if (TianxiaoPCContext.getTXCascadeId() != null) {
                TXCascadeAccount cascadeAccount =
                    txCascadeAccountDao.getByIdAndOrgId(TianxiaoPCContext.getTXCascadeId(), orgId);
                if (cascadeAccount != null) {
                    if (txAccountService.getByOrgId(orgId) != null) {
                        flag = true;
                    }
                }
            }
        } else {
            flag = true;
        }
        return flag;

    }

}