package com.baijia.tianxiao.biz.campus.service.impl;

import com.baijia.tianxiao.biz.campus.constant.BankCardOpType;
import com.baijia.tianxiao.biz.campus.dto.finance.BindCardForPerVerifyDto;
import com.baijia.tianxiao.biz.campus.service.finance.OrgBankCardService;
import com.baijia.tianxiao.biz.campus.utils.PayMentSystemApiHelper;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.dal.finance.po.OrgBankCard;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPayPasswordDao;
import com.baijia.tianxiao.dal.org.po.OrgBaseInfoDto;
import com.baijia.tianxiao.dal.org.po.OrgPayPassword;
import com.baijia.tianxiao.dto.BaseResponse;
import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.ResponseStatus;
import com.baijia.tianxiao.enums.SMSType;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgAccountBankListDto;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgBankCardDto;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgBankInfoDto;
import com.baijia.tianxiao.sal.organization.finance.dto.SmsDto;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/7/1
 * Time: 下午5:43
 * To change this template use File | Settings | File Templates.
 */
@Service
@Slf4j
public class OrgBankCardServiceImpl implements OrgBankCardService {

//    @Autowired
//    private OrgInfoDao infoDao;
//
//    @Autowired
//    private OrgPayPasswordDao orgPayPasswordDao;
//
//
//    @Override
//    public List<OrgBankInfoDto> commonList() {
//        RestfulResult<Object> restfulResult = null;
//        List<OrgBankInfoDto> result = Lists.newArrayList();
//        try {
//            restfulResult = PayMentSystemApiHelper.commonBanks();
//            if (restfulResult.getCode() != 0) {
//                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "获取银行卡失败!");
//            }
//            if (isNotNullJsonNode(restfulResult.getData())) {
//                JSONObject data = JSONObject.fromObject(restfulResult.getData());
//                JSONArray records = data.getJSONArray("list");
//                JSONObject record;
//                OrgBankInfoDto dto;
//                if (records != null && records.size() > 0) {
//                    for (int i = 0; i < records.size(); i++) {
//                        record = records.getJSONObject(i);
//                        dto = new OrgBankInfoDto();
//                        dto.setName(record.getString("name"));
//                        dto.setCode(record.getString("code"));
//                        dto.setIcon_url(record.getString("icon_url"));
//                        result.add(dto);
//                    }
//                }
//            }
//        } catch (Exception e) {
//            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "获取银行卡失败!");
//        }
//        return result;
//    }
//
//    @Override
//    public OrgAccountBankListDto getOrgBankCardByOrgId(Long orgId) {
//        RestfulResult<OrgAccountBankListDto> restfulResult = null;
//        try {
//            restfulResult = PayMentSystemApiHelper.orgAccountBankList(orgId);
//        } catch (Exception e) {
//            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "获取银行卡失败!");
//        }
//        if (restfulResult.getCode() != 0) {
//            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "获取银行卡失败!");
//        }
//        return restfulResult.getData();
//    }
//
//    @Override
//    public BaseResponse addOrgBankCard(OrgBankCard orgBankCard, String logInfo) {
//        RestfulResult<Object> restfulResult = null;
//        try {
//
//            restfulResult = PayMentSystemApiHelper.bindCardForCot(orgBankCard.getOrgId(), orgBankCard.getBankNo(), orgBankCard.getCardNum(), orgBankCard.getCardOwnerName(),
//                    orgBankCard.getRegion(), orgBankCard.getCardOpenLocation());
//            log.info("call - payMentSystem api - bindCardForCot - logInfo:" + logInfo + ", restfulResult:" + restfulResult);
//        } catch (Exception e) {
//            log.warn("call - payMentSystem api - bindCardForCot - exception - logInfo:" + logInfo);
//            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "创建银行账号失败!");
//        }
//        if (restfulResult.getCode() != 0) {
//            log.warn("call - payMentSystem api - bindCardForCot - fail - logInfo:" + logInfo + ", restfulResult:" + restfulResult);
//            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "创建银行账号失败!");
//        }
//
//        BaseResponse baseResponse = new BaseResponse();
//        baseResponse.setStatus(ResponseStatus.OK.getCode());
//
//        //发送解绑银行卡短信
//        SmsDto dto = new SmsDto();
//        OrgBaseInfoDto data = infoDao.getBaseInfo(orgBankCard.getOrgId().intValue());
//        dto.setCardNo(orgBankCard.getCardNum());
//        dto.setCountryCode(data.getCountryCode());
//        dto.setMobile(data.getMobile());
//        dto.setShortName(data.getShortName());
//        dto.setCountryCode(data.getCountryCode());
//        sendMessage(dto, BankCardOpType.BIND_CARD);
//        return baseResponse;
//    }
//
//    @Override
//    public BaseResponse updateOrgBankCard(OrgBankCard orgBankCard, String logInfo) {
//
//        OrgPayPassword orgPayPassword = orgPayPasswordDao.getPayPwdByOrgId(orgBankCard.getOrgId().intValue());
//        if (orgPayPassword == null) {
//            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "请设置提现密码后再解绑银行卡");
//        }
//
//        RestfulResult<Object> restfulResult = null;
//        try {
//
//            restfulResult = PayMentSystemApiHelper.unbindCard(orgBankCard.getOrgId(), orgPayPassword.getPassword());
//            log.info("call - payMentSystem api - unbindCard - logInfo:" + logInfo + ", restfulResult:" + restfulResult);
//        } catch (Exception e) {
//            log.error("call - payMentSystem api - unbindCard - exception - logInfo:" + logInfo + ",e:" + e);
//            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "更新银行账号失败");
//        }
//        if (restfulResult.getCode() != 0) {
//            log.error("call - payMentSystem api - unbindCard - fail - logInfo:" + logInfo + ", restfulResult:" + restfulResult);
//            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "更新银行账号失败");
//        }
//
//        BaseResponse baseResponse = new BaseResponse();
//        baseResponse.setStatus(ResponseStatus.OK.getCode());
//
//        //发送解绑银行卡短信
//        SmsDto dto = new SmsDto();
//        OrgBaseInfoDto data = infoDao.getBaseInfo(orgBankCard.getOrgId().intValue());
//        dto.setCardNo(orgBankCard.getCardNum());
//        dto.setCountryCode(data.getCountryCode());
//        dto.setMobile(data.getMobile());
//        dto.setShortName(data.getShortName());
//        dto.setCountryCode(data.getCountryCode());
//        sendMessage(dto, BankCardOpType.UNBIND_CARD);
//        return baseResponse;
//    }
//
////    @Override
////    public OrgBankInfo getBankInfoByNo(String bankNo) {
////        //兼容 bankcode不匹配问题 (临时)
////        OrgBankInfo info = orgBankInfoDao.getCardByNo(bankNo);
////        if (info == null) {
////            String fmt = "http://img.gsxservice.com/0app/motopay/%s.png";
////            String iconUrl = String.format(fmt, bankNo.toLowerCase());
////            info = orgBankInfoDao.getCardByIconUrl(iconUrl);
////        }
////        return info;
////    }
//
//    private void sendMessage(SmsDto bankCard, BankCardOpType opType) {
//        String sms = "";
//        String shortName = bankCard.getShortName();
//        String mobile = bankCard.getMobile();
//        String countryCode = bankCard.getCountryCode();
//        String cardNo = bankCard.getCardNo();
//        switch (opType) {
//            case BIND_CARD:
//                sms = SmsSendUtil.ORG_BANK_BIND_CARD;
//                break;
//            case UNBIND_CARD:
//                sms = SmsSendUtil.ORG_BANK_UNBIND_CARD;
//                break;
//            default:
//                break;
//        }
//
//        if (StringUtils.isNotBlank(sms)) {
//            if (StringUtils.isNotBlank(cardNo)) {
//                if (cardNo.length() > 4) {
//                    cardNo = cardNo.substring(cardNo.length() - 4, cardNo.length());
//                }
//            }
//            log.info("sendMessage.sms:{}, bankCard:{}", sms, bankCard);
//            sms = sms.replace("{shortName}", shortName).replace("{cardNo}", cardNo);
//
//            Integer channelType = null;
//            if (!"86".equals(countryCode)) {
//                channelType = SMSType.SMS_INTERNAL_MSG.getValue();
//            } else {
//                channelType = SMSType.SMS_NOTICE.getValue();
//            }
//            boolean result = SmsSendUtil.sendSms(mobile, sms, SmsMessageType.TIANXIAO_NOTIFY.getCode(), null, null, true);
//            log.info("sendMessage.bankCard:{}, resp:{}", bankCard, result);
//        }
//    }
//
//    @Override
//    public BindCardForPerVerifyDto sendMessage(Long orgId, OrgBankCardDto bankCard) {
//        RestfulResult<BindCardForPerVerifyDto> result = null;
//        String ownerName = bankCard.getName();
//        String idNumber = bankCard.getIdNumber();
//        String mobile = bankCard.getMobile();
//        String cardNumber = bankCard.getCardNumber();
//        String bankNo = bankCard.getBankNo();
//        try {
//
//            result = PayMentSystemApiHelper.bindCardForPerVerify(orgId, idNumber, bankNo, cardNumber, ownerName, mobile);
//            log.info("OrgBankCardServiceImpl.sendMessage     ----  result:{}", result);
//            if (result == null) {
//                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "支付接口异常");
//            }
//
//            if (result.getCode() == 1) {
//                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "支付接口返回失败");
//            }
//            return result.getData();
//        } catch (Exception e) {
//            log.error("OrgBankCardServiceImpl.sendMessage   ---  Excepiton:" + e);
//            log.warn("OrgBankCardServiceImpl.sendMessage   --- bankCard:{}, result:{}", bankCard, result);
//            if (result == null || result.getCode() != 0) {
//                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "支付接口返回失败");
//            }
//        }
//        return null;
//    }
//
//    @Override
//    public boolean boundCard(Long orgId, OrgBankCardDto bankCard) {
//        String ownerName = bankCard.getName();
//        String idNumber = bankCard.getIdNumber();
//        String mobile = bankCard.getMobile();
//        String cardNumber = bankCard.getCardNumber();
//        String purchaseId = bankCard.getPurchaseId().toString();
//        String code = bankCard.getCode();
//        String bankNo = bankCard.getBankNo();
//        String region = bankCard.getRegion();
//        String token = bankCard.getToken();
//        Integer thirdType = bankCard.getThirdType();
//
//        RestfulResult<Object> restfulResult = null;
//        try {
//
//            restfulResult = PayMentSystemApiHelper.bindCardForPer(orgId, idNumber, purchaseId, bankNo, cardNumber, ownerName, region, "", mobile, code, token, thirdType);
//            log.info("call - payMentSystem api - bindCardForPer - orgId:{}, bankCard:{}, restfulResult:{}", orgId, bankCard, restfulResult);
//            if (restfulResult == null) {
//                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "支付接口异常");
//            }
//
//            if (restfulResult.getCode() != 0) {
//                log.info("call - payMentSystem api - bindCardForPer - BussinessExcepsion - orgId:{}, bankCard:{}, restfulResult:{}", orgId, bankCard, restfulResult);
//                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "支付接口返回失败");
//            }
//        } catch (Exception e) {
//            log.info("call - payMentSystem api - bindCardForPer - Excepsion - orgId:{}, bankCard:{}, restfulResult:{}", orgId, bankCard, restfulResult);
//            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "支付接口异常");
//        }
//
//
//        //绑定银行卡成功后发送短信
//        SmsDto dto = new SmsDto();
//        OrgBaseInfoDto data = infoDao.getBaseInfo(bankCard.getOrgId());
//        dto.setCardNo(bankCard.getCardNumber());
//        dto.setCountryCode(data.getCountryCode());
//        dto.setMobile(data.getMobile());
//        dto.setShortName(data.getShortName());
//        dto.setCountryCode(data.getCountryCode());
//        sendMessage(dto, BankCardOpType.BIND_CARD);
//        return true;
//    }
//
//
//    private static boolean isNotNullJsonNode(Object node) {
//        if (node != null && !node.equals("null") && !node.toString().equals("{}") && !node.toString().equals("[]")) {
//            return true;
//        }
//        return false;
//    }
}
