
/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.campus.dto;


import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author caoliang
 * @version 1.0
 * @title ModAccountRequest
 * @desc O(∩_∩)O~
 * @date 2016年5月16日
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ModAccountRequest extends AddAccountRequest {
    // txcascadeaccount.id
    private Integer cascadeId;
    private String code;
    private Integer status;
    private String campusName;

    @Override
    public boolean validRequest() {
        return type != null && (campusNumber != null || cascadeId != null) && CampusAccountType.isTypeValid(type);
    }
}

    