
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.biz.campus.service;

import java.util.Date;
import java.util.List;

import com.baijia.tianxiao.biz.campus.dto.BaseCampusDto;
import com.baijia.tianxiao.biz.campus.dto.EnrollOverriew;
import com.baijia.tianxiao.biz.campus.dto.EnrollOverriewDto;
import com.baijia.tianxiao.biz.campus.dto.OverriewCampusDto;
import com.baijia.tianxiao.biz.campus.dto.OverriewCampusListDto;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

/**
 * @title OverriewService
 * @desc O(∩_∩)O~ 
 * @author caoliang
 * @date 2016年5月10日
 * @version 1.0
 */

public interface OverriewService {
    
    public boolean isRequestValid();
    
    /**
     * 概况-校区列表
     * 
     * @param orgAccount
     * @param pageDto
     * @return
     * @throws BussinessException
     * @throws Exception
     */
    public List<OverriewCampusListDto> getCampusList(Integer orgId, PageDto pageDto) throws BussinessException, Exception;
    
    /**
     * 校区概况
     * 
     * @param orgAccount
     * @return
     */
    public OverriewCampusDto getCampusOverriew(Integer orgId) throws Exception;
    
    
    /**
     * 校区列表，左上角以及下拉用
     * 
     * @param orgAccount
     * @return
     * @throws Exception
     */
    public List<BaseCampusDto> getCampusList(Integer orgId) throws Exception;
    
    /**
     * 招生概况
     * 
     * @param orgId
     * @return
     * @throws Exception
     */
    public EnrollOverriewDto enrollOverriew(Integer orgId) throws Exception;
    
    /**
     * orgNumber不为空，忽视orgId
     * 
     * @param orgNumber
     * @param orgId
     * @return
     * @throws Exception 
     * @throws BussinessException 
     */
        
    public List<EnrollOverriew> enrollList(Integer orgNumber, Integer orgId, Date startTime, Date endTime, PageDto pageDto) throws BussinessException, Exception;
}

    