package com.baijia.tianxiao.biz.campus.utils;

import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.properties.PropertiesReader;

@Repository
public class PayRestUtils {

    private static final Logger logger = LoggerFactory.getLogger(PayRestUtils.class);

    public enum RestMethod {
        GET, POST
    }

    private static final String URL_SPLIT = "/";
    private static final String SIGN_SPLIT = "-";
    private static final String DEF_CHARSET = "UTF-8";
    private static final String HMAC_SHA1 = "HmacSHA1";

    private static final byte[] LOGIN_LOCK = new byte[0];
    private static final long EXPIRE_TIME = 1000 * 60 * 60 * 24 * 7;

    public static String APP_ID;
    public static String APP_KEY;

    public static String DEF_BASE_URL;
    public static String DEF_BASE_URL_NEW;

    public static volatile String authToken = null;
    public static volatile long loginTime = -1;

    public static String TTS_WEBSERVICE_URL;

    public PayRestUtils(String appId, String appKey, String baseUrl) {
        APP_ID = appId;
        APP_KEY = appKey;
        DEF_BASE_URL = baseUrl;
    }

    public PayRestUtils() {
        Properties prop = PropertiesReader.getProperties("rest.properties");
        if (prop != null) {
            APP_ID = prop.getProperty("rest.appId");
            APP_KEY = prop.getProperty("rest.appKey");
            DEF_BASE_URL = prop.getProperty("rest.appServiceUrl");
            DEF_BASE_URL_NEW = prop.getProperty("rest.appServiceUrl.new");
            TTS_WEBSERVICE_URL = prop.getProperty("tts.webservice.url");
        }
    }

    static {
        Properties prop = PropertiesReader.getProperties("rest.properties");
        if (prop != null) {
            APP_ID = prop.getProperty("rest.appId");
            APP_KEY = prop.getProperty("rest.appKey");
            DEF_BASE_URL = prop.getProperty("rest.appServiceUrl");
            DEF_BASE_URL_NEW = prop.getProperty("rest.appServiceUrl.new");
            TTS_WEBSERVICE_URL = prop.getProperty("tts.webservice.url");
        }
    }

    @SuppressWarnings("unchecked")
    public static <T> RestfulResult<T> rest(RestMethod restMethod, String baseUrl, String controller, String action,
        List<String> urlVarList, Map<String, String> params, T dataType) throws Exception {
        // 创建url
        StringBuilder loginUrl = new StringBuilder();
        loginUrl.append(DEF_BASE_URL_NEW);
        loginUrl.append(URL_SPLIT).append(controller);
        loginUrl.append(URL_SPLIT).append(action);

        // 生成签名
        String signData = createSignData(restMethod.toString(), controller, action, urlVarList, params);
        String sign = getSignature(signData.getBytes(DEF_CHARSET), APP_KEY.getBytes(DEF_CHARSET));

        // 设置签名
        params.put("sign", sign);

        logger.info("loginUrl:{}, postData:{}", loginUrl.toString(), params);
        Set<String> keys = params.keySet();
        StringBuffer sb = new StringBuffer();
        Iterator<String> ik = keys.iterator();
        while (ik.hasNext()) {
            String k = ik.next();
            sb.append(k);
            sb.append("=");
            sb.append(URLEncoder.encode(params.get(k)));
            sb.append("&");
        }
        logger.info("loginUrl:{}, ik:{}", loginUrl.toString(), sb.toString());

        // 发送请求
        String resultJson = null;
        switch (restMethod) {
            case POST:
                resultJson = HttpClientUtils.doPost(loginUrl.toString(), params, DEF_CHARSET);
                break;
            case GET:
                resultJson = HttpClientUtils.doGet(loginUrl.toString(), params, DEF_CHARSET);
                break;
            default:
                throw new Exception("不支持的REST方法");
        }

        // 解析结果
        ObjectMapper mapper = new ObjectMapper();
        logger.info("rest.resultJson:{}", resultJson);
        mapper.disable(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES);
        RestfulResult<T> result = null;
        if (StringUtils.isNotBlank(resultJson)) {
            result = mapper.readValue(resultJson, RestfulResult.class);
        } else {
            result = new RestfulResult<T>();
            result.setCode(TianXiaoConstant.ERRO_CODE);
            result.setMsg("返回信息异常");
        }

        return result;
    }

    public static String getAuthToken() throws Exception {
        // TODO 是否可以避免JAVA中双重检查成例的构造和赋值无序的问题？
        // if(loginTime - System.currentTimeMillis() < EXPIRE_TIME && authToken != null){
        // return authToken;
        // }
        synchronized (LOGIN_LOCK) {
            if (loginTime - System.currentTimeMillis() < EXPIRE_TIME && authToken != null) {
                return authToken;
            }
            String result = null;
            try {
                String controller = "auth";
                String action = "login";
                // 设置参数
                Map<String, String> params = new HashMap<String, String>();
                params.put("app_id", APP_ID);
                params.put("app_key", APP_KEY);
                params.put("timestamp", String.valueOf(System.currentTimeMillis()));
                Map<String, Object> dataType = null;// new HashMap<String, Object>(0);
                RestfulResult<Map<String, Object>> loginResult =
                    rest(RestMethod.POST, DEF_BASE_URL, controller, action, null, params, dataType);
                if (loginResult == null) {
                    return null;
                }
                if (loginResult.getCode() != 0) {
                    throw new Exception(loginResult.getMsg());
                }
                result = loginResult.getData().get("auth_token").toString();
                return result;
            } finally {
                loginTime = System.currentTimeMillis();
                authToken = result;
            }
        }
    }

    public static RestfulResult<Map<String, Object>> createTeacher(String mobile, String password, String email,
        String name, String invite_code, String authToken, int orgId) throws Exception {
        logger.trace("mobile:" + mobile + ",password:" + password + ",email:" + email + ",name:" + name
            + ",invite_code:" + invite_code);
        RestfulResult<Map<String, Object>> createResult = null;
        if (StringUtils.isBlank(mobile) || StringUtils.isBlank(password)) {
            createResult = new RestfulResult<Map<String, Object>>();
            createResult.setCode(1);
            createResult.setMsg("参数不完整");
            return createResult;
        }
        if (email == null) {
            email = "";
        }
        if (name == null) {
            name = "";
        }
        if (invite_code == null) {
            invite_code = "";
        }
        if (StringUtils.isBlank(authToken)) {
            authToken = getAuthToken();
            if (StringUtils.isBlank(authToken)) {
                createResult = new RestfulResult<Map<String, Object>>();
                createResult.setCode(1);
                createResult.setMsg("验证失败");
                return createResult;
            }
        }
        String controller = "teacher";
        String action = "create";
        // 设置参数
        Map<String, String> params = new HashMap<String, String>();
        params.put("app_id", APP_ID);
        params.put("auth_token", authToken);
        params.put("mobile", mobile);
        params.put("password", password);
        params.put("email", email);
        params.put("realname", name);
        params.put("invite_code", invite_code);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));

        params.put("org_id", orgId + "");
        Map<String, Object> dataType = null;// new HashMap<String, Object>(0);
        createResult = rest(RestMethod.POST, DEF_BASE_URL, controller, action, null, params, dataType);
        logger.info("ResUtils.createTeacher   params:{}, createResult:{}", params, createResult);
        return createResult;
    }

    public static RestfulResult<Map<String, Object>> addRole(String mobile, Integer target_role, String invite_code,
        String authToken, int orgId) throws Exception {
        logger.trace("mobile:" + mobile + ",target_role" + target_role);
        RestfulResult<Map<String, Object>> addResult = null;
        if (StringUtils.isBlank(mobile) || (target_role != 0 && target_role != 2)) {
            addResult = new RestfulResult<Map<String, Object>>();
            addResult.setCode(1);
            addResult.setMsg("参数不完整");
            return addResult;
        }
        if (StringUtils.isBlank(authToken)) {
            authToken = getAuthToken();
            if (StringUtils.isBlank(authToken)) {
                addResult = new RestfulResult<Map<String, Object>>();
                addResult.setCode(1);
                addResult.setMsg("验证失败");
                return addResult;
            }
        }
        String controller = "user";
        String action = "addRole";

        Map<String, String> params = new HashMap<String, String>();
        params.put("app_id", APP_ID);
        params.put("auth_token", authToken);
        params.put("mobile", mobile);
        params.put("target_role", target_role.toString());
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("org_id", orgId + "");
        // params.put("invite_code", invite_code);
        Map<String, Object> dataType = null;
        addResult = rest(RestMethod.POST, DEF_BASE_URL, controller, action, null, params, dataType);
        logger.info("ResUtils.addRole   params:{}, addResult:{}", params, addResult);
        return addResult;
    }

    public static RestfulResult<Map<String, Object>> createStudent(String mobile, String password, String email,
        String name, String invite_code, String authToken, String controller, String action) throws Exception {
        logger.trace("mobile:" + mobile + ",password:" + password + ",email:" + email + ",name:" + name
            + ",invite_code:" + invite_code);
        RestfulResult<Map<String, Object>> createResult = null;
        if (StringUtils.isBlank(mobile) || StringUtils.isBlank(password)) {
            createResult = new RestfulResult<Map<String, Object>>();
            createResult.setCode(1);
            createResult.setMsg("参数不完整");
            return createResult;
        }
        if (email == null) {
            email = "";
        }
        if (name == null) {
            name = "";
        }
        if (invite_code == null) {
            invite_code = "";
        }
        if (StringUtils.isBlank(authToken)) {
            authToken = getAuthToken();
            if (StringUtils.isBlank(authToken)) {
                createResult = new RestfulResult<Map<String, Object>>();
                createResult.setCode(1);
                createResult.setMsg("验证失败");
                return createResult;
            }
        }

        // 设置参数
        Map<String, String> params = new HashMap<String, String>();
        params.put("app_id", APP_ID);
        params.put("auth_token", authToken);
        params.put("mobile", mobile);
        params.put("password", password);
        params.put("email", email);
        params.put("realname", name);
        params.put("invite_code", invite_code);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        Map<String, Object> dataType = null;// new HashMap<String, Object>(0);
        createResult = rest(RestMethod.POST, DEF_BASE_URL, controller, action, null, params, dataType);
        return createResult;
    }

    @SuppressWarnings({ "unchecked", "rawtypes" })
    public static RestfulResult<Map<String, Object>> sendBoundCardMessage(String orgId, String ownerName,
        String idNumber, String mobile, String cardNumber, String bankNo, String authToken) throws Exception {
        logger.info("orgId:" + orgId + ",ownerName:" + ownerName + ",idNumber:" + idNumber + ",mobile:" + mobile
            + ",cardNumber:" + cardNumber + ",bankNo:" + bankNo);
        RestfulResult<Map<String, Object>> sendMessage = null;
        if (StringUtils.isBlank(orgId) || StringUtils.isBlank(ownerName) || StringUtils.isBlank(idNumber)
            || StringUtils.isBlank(mobile) || StringUtils.isBlank(cardNumber)) {
            sendMessage = new RestfulResult<Map<String, Object>>();
            sendMessage.setCode(1);
            sendMessage.setMsg("参数不完整");
            return sendMessage;
        }
        if (StringUtils.isBlank(authToken)) {
            authToken = getAuthToken();
            if (StringUtils.isBlank(authToken)) {
                sendMessage = new RestfulResult<Map<String, Object>>();
                sendMessage.setCode(1);
                sendMessage.setMsg("验证失败");
                return sendMessage;
            }
        }
        String controller = "pay";
        String action = "sendOrgBindCardSms";
        // 设置参数
        Map<String, String> params = new HashMap<String, String>();
        params.put("app_id", APP_ID);
        params.put("auth_token", authToken);
        params.put("org_id", orgId);
        params.put("owner_name", ownerName);
        params.put("id_number", idNumber);
        params.put("mobile", mobile);
        params.put("card_num", cardNumber);
        params.put("bank_no", bankNo);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        Map<String, Object> dataType = null;// new HashMap<String, Object>(0);
        RestfulResult sendMessages =
            rest(RestMethod.POST, DEF_BASE_URL_NEW, controller, action, null, params, dataType);

        logger.info("ResUtils.createTeacher   params:{}, createResult:{}", params, sendMessages);
        return sendMessages;
    }

    public static RestfulResult<Map<String, Object>> boundCard(String orgId, String ownerName, String idNumber,
        String bankNo, String mobile, String cardNumber, String purchaseId, String smsCode, String authToken)
            throws Exception {
        logger.info("orgId:" + orgId + ",ownerName:" + ownerName + ",idNumber:" + idNumber + ",mobile:" + mobile
            + ",cardNumber:" + cardNumber);
        RestfulResult<Map<String, Object>> boundCard = null;
        if (StringUtils.isBlank(orgId) || StringUtils.isBlank(ownerName) || StringUtils.isBlank(idNumber)
            || StringUtils.isBlank(bankNo) || StringUtils.isBlank(mobile) || StringUtils.isBlank(cardNumber)
            || StringUtils.isBlank(purchaseId) || StringUtils.isBlank(smsCode)) {
            boundCard = new RestfulResult<Map<String, Object>>();
            boundCard.setCode(1);
            boundCard.setMsg("参数不完整");
            return boundCard;
        }
        if (StringUtils.isBlank(authToken)) {
            authToken = getAuthToken();
            if (StringUtils.isBlank(authToken)) {
                boundCard = new RestfulResult<Map<String, Object>>();
                boundCard.setCode(1);
                boundCard.setMsg("验证失败");
                return boundCard;
            }
        }
        String controller = "pay";
        String action = "checkOrgBindCardSms";
        // String controller = "org";
        // String action = "bindCardForPer";

        // 设置参数
        Map<String, String> params = new HashMap<String, String>();
        params.put("app_id", APP_ID);
        params.put("auth_token", authToken);
        params.put("org_id", orgId);
        params.put("owner_name", ownerName);
        params.put("id_number", idNumber);
        params.put("bank_no", bankNo);
        params.put("mobile", mobile);
        params.put("card_num", cardNumber);
        params.put("purchase_id", purchaseId);
        params.put("sms_code", smsCode);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        Map<String, Object> dataType = null;// new HashMap<String, Object>(0);
        boundCard = rest(RestMethod.POST, DEF_BASE_URL_NEW, controller, action, null, params, dataType);
        logger.info("ResUtils.boundCard   params:{}, createResult:{}", params, boundCard);
        return boundCard;
    }

    // public static void main(String[] args) throws InvalidKeyException, NoSuchAlgorithmException, JsonParseException,
    // JsonMappingException, IOException {
    // String resultJson = "{\"code\":0,\"msg\":\"success\",\"data\":null}";
    // ObjectMapper mapper = new ObjectMapper();
    // mapper.disable(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES);
    // RestfulResult result = mapper.readValue(resultJson, RestfulResult.class);
    // Object obj = result.getData();
    // System.out.println(obj == null);
    // System.out.println(obj instanceof List);
    // }

    public static String createSignData(String restMethod, String controllerName, String actionName,
        List<String> urlVarList, Map<String, String> params) {
        StringBuilder signData = new StringBuilder();
        signData.append(restMethod.toLowerCase());
        signData.append(SIGN_SPLIT).append(controllerName);
        signData.append(SIGN_SPLIT).append(actionName);

        if (urlVarList != null && urlVarList.isEmpty() == false) {
            for (String urlVar : urlVarList) {
                if (urlVar == null) {
                    signData.append(SIGN_SPLIT).append("");
                } else {
                    signData.append(SIGN_SPLIT).append(urlVar);
                }
            }
        }

        if (params != null && params.isEmpty() == false) {
            String[] paraNames = new String[params.size()];
            Arrays.sort(params.keySet().toArray(paraNames));
            for (String paraName : paraNames) {
                String value = params.get(paraName);
                if (StringUtils.isBlank(value)) {
                    value = "";
                }
                signData.append(SIGN_SPLIT).append(value);
            }
        }
        return signData.toString();
    }

    /**
     * 生成签名数据
     *
     * @param data 待加密的数据
     * @param key 加密使用的key
     * @return 生成BASE64编码的字符串
     * @throws InvalidKeyException
     * @throws NoSuchAlgorithmException
     */
    public static String getSignature(byte[] data, byte[] key) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKeySpec signingKey = new SecretKeySpec(key, HMAC_SHA1);
        Mac mac = Mac.getInstance(HMAC_SHA1);
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(data);
        return Base64.encodeBase64String(rawHmac);
    }

    public static String doService(String controller, String action, Map<String, String> params) {
        try {
            String token = getAuthToken();
            int timestamp = (int) (System.currentTimeMillis() / 1000);
            params.put("app_id", APP_ID);
            params.put("auth_token", token);
            params.put("timestamp", String.valueOf(timestamp));
            Map<String, Object> dataType = null;
            RestfulResult<Map<String, Object>> response =
                rest(RestMethod.POST, DEF_BASE_URL, controller, action, null, params, dataType); // request1(controller,
            // action, params);
            logger.info("response:{}", response);

            return response.getMsg();
        } catch (Exception e) {
            throw new WebServiceException(e);
        }
    }

}
