
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.campus.service.impl;

import com.baijia.tianxiao.biz.campus.constant.BizConf;
import com.baijia.tianxiao.biz.campus.constant.CommonRuleValue;
import com.baijia.tianxiao.biz.campus.dto.CascadeAccountDto;
import com.baijia.tianxiao.biz.campus.dto.CommonRuleDto;
import com.baijia.tianxiao.biz.campus.dto.KefuRuleDto;
import com.baijia.tianxiao.biz.campus.dto.RuleDetailDto;
import com.baijia.tianxiao.biz.campus.dto.RuleDetialRequest;
import com.baijia.tianxiao.biz.campus.dto.SaleClueRuleDto;
import com.baijia.tianxiao.biz.campus.service.RuleService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.constant.AuditColumType;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgTxtMsgDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.dal.org.po.TXKefuRule;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.card.dto.TimescardRuleDto;
import com.baijia.tianxiao.sal.card.service.TxTimescardRuleService;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.constant.OrgHomepageType;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXCommonRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TXKefuRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.util.date.DateUtil;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @author caoliang
 * @version 1.0
 * @title RuleServiceImpl
 * @desc O(∩_∩)O~
 * @date 2016年6月1日
 */
@Service
@Transactional
@Slf4j
public class RuleServiceImpl implements RuleService {

    @Autowired
    private TXKefuRuleService txKefuRuleService;
    @Autowired
    private TXSaleClueRuleService txSaleClueRuleService;
    @Autowired
    private TXCommonRuleService txCommonRuleService;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Resource
    private OrgTxtMsgDao orgTxtMsgDao;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private OrgCourseService orgCourseService;
    @Autowired
    private TxTimescardRuleService txTimescardRuleService;

    @Override
    public RuleDetailDto getRuleDetail(Integer orgId) {
        RuleDetailDto dto = new RuleDetailDto();
        TXKefuRule txKefuRule = txKefuRuleService.getByOrgId(orgId);
        TXSaleClueRule txSaleClueRule = txSaleClueRuleService.getByOrgId(orgId);
        TXCommonRule txCommonRule = txCommonRuleService.getByOrgId(orgId);
        OrgTxtMsg txtMsg = orgTxtMsgDao.getOrgTxtByIdAndType(orgId, AuditColumType.PHONE.getValue());
        dto.setKefuRule(KefuRuleDto.from(txKefuRule, txtMsg));
        dto.setSaleClueRule(SaleClueRuleDto.from(txSaleClueRule));
        CommonRuleDto commonRule = CommonRuleDto.from(txCommonRule);
        Integer findSigninStatus = this.orgInfoService.findSigninStatus(orgId);
        commonRule.setTeacherSignRule(findSigninStatus);
        dto.setCommonRule(commonRule);
        TimescardRuleDto timescardRuleDto = this.txTimescardRuleService.getRuleByOrgId(orgId.longValue());
        dto.setTimescardRule(timescardRuleDto);
        return dto;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveRule(RuleDetialRequest request, OrgAccount orgAccount) {
        // 挨个存
        handleKefuRule(request.getKefuRule(), orgAccount);
        handleSalClueRule(request.getSaleClueRule(), orgAccount);
        handleCommonrule(request.getCommonRule(), orgAccount);
        handleTimescardRule(request.getTimescardRule(), orgAccount);
    }
    
    @Transactional(rollbackFor = Exception.class)
    private void handleTimescardRule(TimescardRuleDto timescardRule, OrgAccount orgAccount) {
        if (null == timescardRule) {
            return;
        }
        this.txTimescardRuleService.updateOrSave(orgAccount.getId().longValue(), timescardRule);
    }

    @Transactional(rollbackFor = Exception.class)
    private void handleCommonrule(CommonRuleDto commonRuleDto, OrgAccount orgAccount) {
        if (commonRuleDto == null) {
            return;
        }
        TXCommonRule txCommonRule = txCommonRuleService.getByOrgId(orgAccount.getId());
        if (txCommonRule == null) {
            txCommonRule = new TXCommonRule();
            txCommonRule.setCreateTime(new Date());
            txCommonRule.setOrgId(orgAccount.getId());
            txCommonRule.setOrgNumber(orgAccount.getNumber());
        }
        txCommonRule.setUpdateTime(new Date());
        if (commonRuleDto.getCallMobileRule() != null) {
            txCommonRule.setCallMobileRule(commonRuleDto.getCallMobileRule());
        }
        if (commonRuleDto.getStudentMobileRule() != null) {
            txCommonRule.setStudentMobileRule(commonRuleDto.getStudentMobileRule());
        }
        if (commonRuleDto.getLeftKexiaoRule() != null) {
            txCommonRule.setLeftKexiaoRule(commonRuleDto.getLeftKexiaoRule());
        }
        if (commonRuleDto.getFullClassRule() != null) {
            txCommonRule.setFullClassRule(commonRuleDto.getFullClassRule());
            if (txCommonRule.getFullClassRule().intValue() == CommonRuleValue.FULL_CLASS_NOT_SIGNUP_NOT_SHOW
                .getCode()) {
                log.info("Tx Common Rule show change course ....cadcadeid={}", TianxiaoPCContext.getTXCascadeId());
                orgCourseService.batchChangeStatus(orgAccount.getNumber().longValue(), DataStatus.DELETE.getValue());
            }
        }
        if (commonRuleDto.getTeacherSignRule() != null) {
            // 更新app端的teacherSignStatus
            orgInfoService.updateTeacherSigninStatus(orgAccount.getId().longValue(),
                commonRuleDto.getTeacherSignRule());
        }
        if (commonRuleDto.getConsumeRule() != null) {
            txCommonRule.setConsumeRule(commonRuleDto.getConsumeRule());
        }
        if (commonRuleDto.getVipConsumeRule() != null) {
            if (commonRuleDto.getVipConsumeRule() != 1 && commonRuleDto.getVipConsumeRule() != 3
                && commonRuleDto.getVipConsumeRule() != 5 && commonRuleDto.getVipConsumeRule() != 7) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "一对一课消设置规则参数错误");
            }
            txCommonRule.setVipConsumeRule(commonRuleDto.getVipConsumeRule());// 设置一对一的默认课消规则
        }
        txCommonRuleService.saveTXCommonRule(txCommonRule);
    }

    @Transactional(rollbackFor = Exception.class)
    public void handleSalClueRule(SaleClueRuleDto saleClueRuleDto, OrgAccount orgAccount) {
        if (saleClueRuleDto == null) {
            return;
        }
        TXSaleClueRule txSaleClueRule = txSaleClueRuleService.getByOrgId(orgAccount.getId());
        if (txSaleClueRule == null) {
            txSaleClueRule = new TXSaleClueRule();
            txSaleClueRule.setCreateTime(new Date());
            txSaleClueRule.setOrgId(orgAccount.getId());
            txSaleClueRule.setOrgNumber(orgAccount.getNumber());
        }
        txSaleClueRule.setUpdateTime(new Date());
        if (saleClueRuleDto.getClueAllot() != null) {
            txSaleClueRule.setClueAllot(saleClueRuleDto.getClueAllot());
        }
        if (saleClueRuleDto.getClueTransValid() != null) {
            txSaleClueRule.setClueTransValid(saleClueRuleDto.getClueTransValid());
        }
        if (saleClueRuleDto.getMaxClueCount() != null) {
            txSaleClueRule.setMaxClueCount(saleClueRuleDto.getMaxClueCount());
        }
        if (saleClueRuleDto.getMaxClueDelay() != null) {
            txSaleClueRule.setMaxClueDelay(saleClueRuleDto.getMaxClueDelay());
        }
        if (saleClueRuleDto.getReturnClue() != null) {
            txSaleClueRule.setReturnClue(saleClueRuleDto.getReturnClue());
        }
        if (saleClueRuleDto.getEvaluateMsg() != null) {
            txSaleClueRule.setEvaluateMsg(saleClueRuleDto.getEvaluateMsg());
        }
        if (saleClueRuleDto.getAttendClassMsg() != null) {
            txSaleClueRule.setAttendClassMsg(saleClueRuleDto.getAttendClassMsg());
        }
        if (saleClueRuleDto.getSigninMsg() != null) {
            txSaleClueRule.setSigninMsg(saleClueRuleDto.getSigninMsg());
        }
        if (saleClueRuleDto.getSignupMsg() != null) {
            txSaleClueRule.setSignupMsg(saleClueRuleDto.getSignupMsg());
        }
        log.debug("*********************txSaleClueRule:{}", txSaleClueRule);
        txSaleClueRuleService.saveTXSaleClueRule(txSaleClueRule);
    }

    @Transactional(rollbackFor = Exception.class)
    private void handleKefuRule(KefuRuleDto kefuRuleDto, OrgAccount orgAccount) {
        if (kefuRuleDto == null) {
            return;
        }
        TXKefuRule txKefuRule = txKefuRuleService.getByOrgId(orgAccount.getId());
        if (txKefuRule == null) {
            txKefuRule = new TXKefuRule();
            txKefuRule.setCreateTime(new Date());
            txKefuRule.setOrgId(orgAccount.getId());
            txKefuRule.setOrgNumber(orgAccount.getNumber());
        }
        txKefuRule.setUpdateTime(new Date());
        if (kefuRuleDto.getConsultRule() != null) {
            txKefuRule.setConsultRule(kefuRuleDto.getConsultRule());
        }
        if (kefuRuleDto.getBespeakOrder() != null) {
            txKefuRule.setBespeakRule(kefuRuleDto.getBespeakOrder());
        }
        // 机构客服电话，存在OrgTxtMsg
        // 传入为空时，清空客服电话
        // 传入不为空时，覆盖之前的电话
        String mobiles = "";
        if (CollectionUtils.isNotEmpty(kefuRuleDto.getConsultMobiles())) {
            if (kefuRuleDto.getConsultMobiles().size() > BizConf.MAX_KEFU_MOBILE_COUNT) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "客服电话数量过多");
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < kefuRuleDto.getConsultMobiles().size(); i++) {
                sb.append(kefuRuleDto.getConsultMobiles().get(i));
                if ((i + 1) < kefuRuleDto.getConsultMobiles().size()) {
                    sb.append(",");
                }
            }
            mobiles = sb.toString();
        }

        OrgTxtMsg orgTxtMsg = orgTxtMsgDao.getOrgTxtByIdAndType(orgAccount.getId(), AuditColumType.PHONE.getValue());
        // 没有电话新增，有电话修改
        if (orgTxtMsg == null) {
            orgTxtMsg = new OrgTxtMsg();
            orgTxtMsg.setAuditstatus(AuditStatus.PASS.getValue());
            orgTxtMsg.setCreateTime(DateUtil.getToday());
            orgTxtMsg.setOrgId(orgAccount.getId());
            orgTxtMsg.setType(AuditColumType.PHONE.getValue());
            orgTxtMsg.setGroupId(OrgHomepageType.BASE_INFO.getGroup());
            orgTxtMsg.setValue(mobiles);
            orgTxtMsgDao.save(orgTxtMsg);
        } else {
            orgTxtMsg.setValue(mobiles);
            orgTxtMsg.setUpdateTime(DateUtil.getToday());
            orgTxtMsgDao.update(orgTxtMsg);
        }
        txKefuRuleService.saveTXKefuRule(txKefuRule);
    }

    @Override
    public List<CascadeAccountDto> getCascadeAccount() {
        OrgAccount orgAccount = orgAccountService.getOrgAccountById(TianxiaoPCContext.getOrgId());
        if (orgAccount == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "无当前用户信息");
        }
        List<TXCascadeAccount> txCascadeAccounts =
            txCascadeAccountDao.getTXCascadeAccountListByOrgId(orgAccount.getId().longValue());
        if (CollectionUtils.isEmpty(txCascadeAccounts)) {
            return null;
        }
        Multimap<Integer, CascadeAccountDto> dtoMap = ArrayListMultimap.create();
        List<Integer> ids = Lists.newArrayList();
        for (TXCascadeAccount txCascadeAccount : txCascadeAccounts) {
            CascadeAccountDto dto = new CascadeAccountDto();
            dto.setTitle(txCascadeAccount.getTitle());
            ids.add(txCascadeAccount.getCredentialId());
            dtoMap.put(txCascadeAccount.getCredentialId(), dto);
        }
        List<TXCascadeCredential> txCascadeCredentials = txCascadeCredentialDao.getByIds(ids);
        if (CollectionUtils.isEmpty(txCascadeCredentials)) {
            return null;
        }
        List<CascadeAccountDto> data = Lists.newArrayList();
        for (TXCascadeCredential txCascadeCredential : txCascadeCredentials) {
            List<CascadeAccountDto> dtos = new ArrayList<CascadeAccountDto>(dtoMap.get(txCascadeCredential.getId()));
            if (CollectionUtils.isNotEmpty(dtos)) {
                for (CascadeAccountDto dto : dtos) {
                    dto.setMobile(txCascadeCredential.getMobile());
                    dto.setUName(txCascadeCredential.getName());
                }
                data.addAll(dtos);
            }
        }
        return data;

    }

    @Override
    public RuleDetailDto getRuleDetail(Integer orgId, Integer cascadeAccountId) {
        RuleDetailDto dto = new RuleDetailDto();
        TXKefuRule txKefuRule = txKefuRuleService.getByOrgId(orgId);
        TXSaleClueRule txSaleClueRule = txSaleClueRuleService.getByOrgId(orgId);
        TXCommonRule txCommonRule = txCommonRuleService.getByOrgId(orgId);
        OrgTxtMsg txtMsg = orgTxtMsgDao.getOrgTxtByIdAndType(orgId, AuditColumType.PHONE.getValue());
        dto.setKefuRule(KefuRuleDto.from(txKefuRule, txtMsg));
        dto.setSaleClueRule(SaleClueRuleDto.from(txSaleClueRule));
        CommonRuleDto commonRule = CommonRuleDto.from(txCommonRule);
        Integer findSigninStatus = this.orgInfoService.findSigninStatus(orgId);
        commonRule.setTeacherSignRule(findSigninStatus);
        TXAccount txAccount = txAccountService.getByOrgId(orgId);
        log.debug("***************txAccount:{}", txAccount);
        if (txAccount != null && txAccount.getVipLevel().intValue() == TXAccountType.DAZHONG.getCode()) {
            commonRule.setCallMobileRule(CommonRuleValue.CAN_USE_OWN_CALL.getCode());
            commonRule.setStudentMobileRule(CommonRuleValue.STUDENT_MOBILE_SHOW.getCode());
            log.debug("***************commonRule  dazhong:{}", txAccount);
        } else {
            if (cascadeAccountId == null) {
                commonRule.setCallMobileRule(CommonRuleValue.CALL_MOBILE_OWN.getCode());
                commonRule.setStudentMobileRule(CommonRuleValue.STUDENT_MOBILE_SHOW.getCode());
                log.debug("***************commonRule  zizhanghao:{}", txAccount);
            }
        }
        dto.setCommonRule(commonRule);
        return dto;
    }
}
