
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.biz.campus.dto;

import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.dal.pcAuthority.po.TxAccountPermission;

import lombok.Data;
import lombok.ToString;

/**
 * @title TXPermissionNodeDto
 * @desc O(∩_∩)O~ 
 * @author caoliang
 * @date 2016年6月2日
 * @version 1.0
 */
@Data
@ToString
public class TXPermissionNodeDto {
    private String name;//权限名
    private Long code;//权限码
    private Integer type;//拥有or失去,0->拥有,1->失去
    private Boolean display;
    private Boolean disabled;
    private Boolean hidden;
    
    /**
     * 
     * @param txPermission 固定的权限
     * @param txAccountPermission 子账号该权限拥有情况
     * @return 根据权限表与子账号对应该权限的拥有情况构造一条权限dto
     */
    public static TXPermissionNodeDto from(TXPermission txPermission, TxAccountPermission txAccountPermission){
        if(txPermission == null || txAccountPermission == null){
            return null;
        }
        TXPermissionNodeDto dto = new TXPermissionNodeDto();
        dto.setCode(txPermission.getCode());
        dto.setName(txPermission.getName());
        dto.setType(txAccountPermission.getPType());
        return dto;
    }
}

    