
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.biz.campus.dto;

import com.baijia.tianxiao.dal.statistic.dto.TxFinanceStatistics;
import com.baijia.tianxiao.dal.statistic.dto.TxSignupRecordStatistics;
import com.baijia.tianxiao.util.money.MoneyUtil;
import lombok.Data;

/**
 * @title OverriewCampusDto
 * @desc TODO 
 * @author caoliang
 * @date 2016年5月11日
 * @version 1.0
 */
@Data
public class OverriewCampusDto {

//    private Integer weekEnroll;
//    private Integer monthEnroll;
//    private Double weekIncome;
//    private Double monthIncome;

    private Integer studentSum;//学生总数
    private Integer teacherSum;//老师总数

    private Double monthKexiaoMoney;//本月课消
    private Double weekKexiaoMoney;//本周课消

    private Integer weekCollectionCount = 0;//本周收款笔数
    private Double weekCollectionMoney = 0.00;//本周收款金额
    private Integer monthCollectionCount = 0;//本月收款笔数
    private Double monthCollectionMoney = 0.00;//本月收款金额

    private Integer weekRefundCount = 0;//本周退款笔数
    private Double weekRefundMoney = 0.00;//本周退款金额
    private Integer monthRefundCount = 0;//本月退款笔数
    private Double monthRefundMoney = 0.00;//本月退款金额

    public void setSignupStatisticsInfo(TxSignupRecordStatistics weekStatisticsSum, TxSignupRecordStatistics monthStatisticsSum){
        if(weekStatisticsSum!=null){
            weekCollectionCount=weekStatisticsSum.getCollectionStatistics().getCount();
            weekCollectionMoney=MoneyUtil.dividedBy100With2Decimals(weekStatisticsSum.getCollectionStatistics().getMoney());
            weekRefundCount=weekStatisticsSum.getRefundStatistics().getCount();
            weekRefundMoney=MoneyUtil.dividedBy100With2Decimals(weekStatisticsSum.getRefundStatistics().getMoney());
        }
        if(monthStatisticsSum!=null){
            monthCollectionCount=monthStatisticsSum.getCollectionStatistics().getCount();
            monthCollectionMoney=MoneyUtil.dividedBy100With2Decimals(monthStatisticsSum.getCollectionStatistics().getMoney());
            monthRefundCount=monthStatisticsSum.getRefundStatistics().getCount();
            monthRefundMoney=MoneyUtil.dividedBy100With2Decimals(monthStatisticsSum.getRefundStatistics().getMoney());
        }
    }

    public void setFinanceStatisticsInfo(TxFinanceStatistics weekStatisticsSum, TxFinanceStatistics monthStatisticsSum){
        if(weekStatisticsSum!=null){
            weekCollectionCount=weekStatisticsSum.getCollectionStatistics().getCount();
            weekCollectionMoney=MoneyUtil.dividedBy100With2Decimals(weekStatisticsSum.getCollectionStatistics().getMoney());
            weekRefundCount=weekStatisticsSum.getRefundStatistics().getCount();
            weekRefundMoney=MoneyUtil.dividedBy100With2Decimals(weekStatisticsSum.getRefundStatistics().getMoney());
        }
        if(monthStatisticsSum!=null){
            monthCollectionCount=monthStatisticsSum.getCollectionStatistics().getCount();
            monthCollectionMoney=MoneyUtil.dividedBy100With2Decimals(monthStatisticsSum.getCollectionStatistics().getMoney());
            monthRefundCount=monthStatisticsSum.getRefundStatistics().getCount();
            monthRefundMoney=MoneyUtil.dividedBy100With2Decimals(monthStatisticsSum.getRefundStatistics().getMoney());
        }
    }
}

    