
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.biz.campus.dto;

import com.baijia.tianxiao.dal.statistic.dto.TxCollectionStatistics;
import com.baijia.tianxiao.dal.statistic.dto.TxSignupRecordStatistics;
import com.baijia.tianxiao.util.money.MoneyUtil;
import lombok.Data;

/**
 * @title EnrollOverriewDto
 * @desc TODO 
 * @author caoliang
 * @date 2016年5月12日
 * @version 1.0
 */
@Data
public class EnrollOverriewDto {

    //招生信息
//    private Integer todayEnroll;
//    private Integer yestodayEnroll;
//    private Integer weekEnroll;
//    private Integer monthEnroll;

    private Integer studentSum;//学生总数

    private Integer todayCollectionCount = 0;//今日收款笔数
    private Double todayCollectionMoney = 0.00;//今日收款金额
    private Integer yestodayCollectionCount = 0;//昨日收款笔数
    private Double yestodayCollectionMoney = 0.00;//昨日收款金额

    private Integer weekCollectionCount = 0;//本周收款笔数
    private Double weekCollectionMoney = 0.00;//本周收款金额
    private Integer monthCollectionCount = 0;//本月收款笔数
    private Double monthCollectionMoney = 0.00;//本月收款金额

    public void setSignupCollectionInfo(TxCollectionStatistics todayCollection, TxCollectionStatistics yestodayCollection, TxCollectionStatistics weekCollection, TxCollectionStatistics monthCollection){
        if(todayCollection!=null){
            todayCollectionCount = todayCollection.getCount();
            todayCollectionMoney = MoneyUtil.dividedBy100With2Decimals(todayCollection.getMoney());
        }
        if(yestodayCollection!=null){
            yestodayCollectionCount = yestodayCollection.getCount();
            yestodayCollectionMoney = MoneyUtil.dividedBy100With2Decimals(yestodayCollection.getMoney());
        }
        if(weekCollection!=null){
            weekCollectionCount = weekCollection.getCount();
            weekCollectionMoney = MoneyUtil.dividedBy100With2Decimals(weekCollection.getMoney());
        }
        if(monthCollection!=null){
            monthCollectionCount = monthCollection.getCount();
            monthCollectionMoney = MoneyUtil.dividedBy100With2Decimals(monthCollection.getMoney());
        }
    }

    public void setFinanceCollectionInfo(TxCollectionStatistics todayCollection, TxCollectionStatistics yestodayCollection, TxCollectionStatistics weekCollection, TxCollectionStatistics monthCollection){
        if(todayCollection!=null){
            todayCollectionCount = todayCollection.getCount();
            todayCollectionMoney = MoneyUtil.dividedBy100With2Decimals(todayCollection.getMoney());
        }
        if(yestodayCollection!=null){
            yestodayCollectionCount = yestodayCollection.getCount();
            yestodayCollectionMoney = MoneyUtil.dividedBy100With2Decimals(yestodayCollection.getMoney());
        }
        if(weekCollection!=null){
            weekCollectionCount = weekCollection.getCount();
            weekCollectionMoney = MoneyUtil.dividedBy100With2Decimals(weekCollection.getMoney());
        }
        if(monthCollection!=null){
            monthCollectionCount = monthCollection.getCount();
            monthCollectionMoney = MoneyUtil.dividedBy100With2Decimals(monthCollection.getMoney());
        }
    }

}

    