
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.campus.constant;

/**
 * @title CampusType
 * @desc TODO
 * @author caoliang
 * @date 2016年5月10日
 * @version 1.0
 */

public enum CampusType {
    MASTER(1, "总校区"), SUB_CAMPUS(2, "直营校区"), LEAGUE(3, "加盟校区");

    private Integer code;
    private String label;

    CampusType(Integer code, String label) {
        this.code = code;
        this.label = label;
    }

    public Integer getCode() {

        return code;
    }

    public void setCode(Integer code) {

        this.code = code;
    }

    public String getLabel() {

        return label;
    }

    public void setLabel(String label) {

        this.label = label;
    }

    public static String getLabelByCode(int code) {
        for (CampusType ct : CampusType.values()) {
            if (ct.getCode() == code) {
                return ct.getLabel();
            }
        }
        return null;
    }

    public static boolean isTypeValid(Integer code) {
        if (code == null) {
            return false;
        }
        for(CampusType cType : CampusType.values()){
            if(cType.getCode().intValue() == code){
                return true;
            }
        }
        return false;
    }
}
