
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.campus.dto;

import com.baijia.tianxiao.biz.campus.constant.CommonRuleValue;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.sal.organization.constant.TXCommonRuleValue;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import lombok.Data;

/**
 * @author caoliang
 * @version 1.0
 * @title CommonRuleDto
 * @desc O(∩_∩)O~
 * @date 2016年6月1日
 */
@Data
public class CommonRuleDto {
    private Integer studentMobileRule;
    private Integer callMobileRule;
    private Integer teacherSignRule;
    private Integer consumeRule;
    private Integer vipConsumeRule;//一对一默认的课消规则
    private Integer leftKexiaoRule;//剩余课消
    private Integer fullClassRule;//满班后是否可继续报名，是否下架

    public static CommonRuleDto from(TXCommonRule txCommonRule) {
        if (txCommonRule == null) {
            return null;
        }
        CommonRuleDto dto = new CommonRuleDto();
        dto.setCallMobileRule(txCommonRule.getCallMobileRule());
        dto.setStudentMobileRule(txCommonRule.getStudentMobileRule());
        dto.setConsumeRule(txCommonRule.getConsumeRule());
        if (txCommonRule.getVipConsumeRule() == null || txCommonRule.getVipConsumeRule() == 0) {
            txCommonRule.setVipConsumeRule(TXCommonRuleValue.DEFAULT_VIP_CONSUME_RULE.getCode());
        }
        dto.setVipConsumeRule(txCommonRule.getVipConsumeRule());//设置一对一默认课消规则
        dto.setLeftKexiaoRule(txCommonRule.getLeftKexiaoRule());//学生中心是否显示课消
        dto.setFullClassRule(txCommonRule.getFullClassRule());
        return dto;
    }

    public boolean valid() {
        if (studentMobileRule != null) {
            if (studentMobileRule != CommonRuleValue.STUDENT_MOBILE_NOT_SHOW.getCode()
                    && studentMobileRule != CommonRuleValue.STUDENT_MOBILE_SHOW.getCode()) {
                return false;
            }
        }
        if (callMobileRule != null) {
            if (callMobileRule != CommonRuleValue.CALL_MOBILE_NOT_OWN.getCode()
                    && callMobileRule != CommonRuleValue.CALL_MOBILE_OWN.getCode()) {
                return false;
            }
        }
        if (teacherSignRule != null) {
            if (teacherSignRule != CommonRuleValue.TEACER_SING_NOT_PERMIT.getCode()
                    && teacherSignRule != CommonRuleValue.TEACER_SING_PERMIT.getCode()) {
                return false;
            }
        }

        if (leftKexiaoRule != null) {
            if (leftKexiaoRule.intValue() != CommonRuleValue.STUDNET_SHOW_LEFT_KEXIAO.getCode()
                    && leftKexiaoRule.intValue() != CommonRuleValue.STUDNET_VILID_LEFT_KEXIAO.getCode()) {
                return false;
            }
        }

        if (fullClassRule != null) {
            if (fullClassRule.intValue() != CommonRuleValue.FULL_CLASS_CAN_SIGNUP.getCode()
                    && fullClassRule.intValue() != CommonRuleValue.FULL_CLASS_NOT_SIGNUP_BUT_SHOW.getCode()
                    && fullClassRule.intValue() != CommonRuleValue.FULL_CLASS_NOT_SIGNUP_NOT_SHOW.getCode()) {
                return false;
            }
        }

        return true;
    }
}
