
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.campus.dto;

import java.io.IOException;
import java.util.List;

import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.util.exception.BussinessPreconditions;
import com.baijia.tianxiao.util.json.JacksonUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.dal.org.constant.CampusAccountType;

import lombok.Data;
/**
 * @title AddAccountRequest
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年5月16日
 * @version 1.0
 */
@Data
public class AddAccountRequest {
    protected Integer campusNumber;
    protected String name;
    protected String mobile;
    protected String title;
    protected Integer type;
    protected String authListJson;

    public List<TXPermissionNodeDto> getAuthList() {
        if (CollectionUtils.isEmpty(authList)){
            BussinessPreconditions.checkArgument(StringUtils.isNotBlank(authListJson), "authListJson is empty!");
            try {
                this.authList = JacksonUtil.str2List(authListJson, TXPermissionNodeDto.class);
            } catch (IOException e) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "authListJson parse error!");
            }
        }
        return authList;
    }

    protected List<TXPermissionNodeDto> authList;

    public boolean validRequest() {
        return campusNumber != null && CampusAccountType.isTypeValid(type) && StringUtils.isNotBlank(mobile)
            && StringUtils.isNotBlank(name);
    }
}
