
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.campus.service.impl;

import com.baijia.tianxiao.biz.campus.constant.BizConf;
import com.baijia.tianxiao.biz.campus.constant.CampusAccountStatus;
import com.baijia.tianxiao.biz.campus.constant.CampusType;
import com.baijia.tianxiao.biz.campus.constant.OnlineType;
import com.baijia.tianxiao.biz.campus.dto.AccountRoleDto;
import com.baijia.tianxiao.biz.campus.dto.AddAccountRequest;
import com.baijia.tianxiao.biz.campus.dto.AddCampusRequest;
import com.baijia.tianxiao.biz.campus.dto.CampusAccountDto;
import com.baijia.tianxiao.biz.campus.dto.ModAccountRequest;
import com.baijia.tianxiao.biz.campus.dto.ModCampusRequest;
import com.baijia.tianxiao.biz.campus.dto.SettingCampusListDto;
import com.baijia.tianxiao.biz.campus.dto.SimpleCampusDto;
import com.baijia.tianxiao.biz.campus.dto.TXPermissionNodeDto;
import com.baijia.tianxiao.biz.campus.service.OverriewService;
import com.baijia.tianxiao.biz.campus.service.SettingService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.AvatarConstants;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXCascadeAccountStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.pcAuthority.dao.TxAccountPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.dal.pcAuthority.po.TxAccountPermission;
import com.baijia.tianxiao.dal.roster.constant.ConsulterOperation;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsulterOperationLogDao;
import com.baijia.tianxiao.dal.roster.po.TxConsulterOperationLog;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dal.util.SerialNumberUtil;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.enums.SMSErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.common.api.CommonMsgService;
import com.baijia.tianxiao.sal.marketing.commons.exceptions.BusinessException;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionAccountType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionHasType;
import com.baijia.tianxiao.sal.organization.mqs.OrganizationRegist;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.wechat.api.UnifiedWechatAccountService;
import com.baijia.tianxiao.sal.wechat.dto.unifiedWechatAccount.CampusWechatInfoDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.MqsUtils;
import com.baijia.tianxiao.util.SmsContentHelper;
import com.baijia.tianxiao.util.VerifyCodeUtil;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.yunying.hag.dal.bo.Entity;
import com.baijia.yunying.hag.service.HagService;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import lombok.extern.slf4j.Slf4j;

/**
 * @author caoliang
 * @version 1.0
 * @title SettingServiceImpl
 * @desc O(∩_∩)O~
 * @date 2016年5月13日
 */
@Service
@Transactional
@Slf4j
public class SettingServiceImpl implements SettingService {
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired(required = false)
    private HagService hagService;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;
    @Autowired
    private TXPermissionService txPermissionService;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private TxConsulterOperationLogDao txConsulterOperationLogDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private TxAccountPermissionDao txAccountPermissionDao;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private UnifiedWechatAccountService unifiedWechatAccountService;
    @Autowired
    private OverriewService overriewService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private CommonMsgService commonMsgService;

    @Override
    public List<SettingCampusListDto> getCampusList(Integer orgId, String campusName, String name, String mobile,
        Integer campusNumber, Integer campusType, PageDto pageDto) {
        List<Integer> orgIds;
        if (null != campusNumber) {
            OrgAccount orgAccount = orgAccountService.getOrgAccountByNumber(campusNumber, "id");
            orgIds = Lists.newArrayList(orgAccount.getId());
        } else {
            orgIds = orgSubAccountService.getMasterAndSlaves(orgId, null, "orgId").stream()
                .map(orgSubAccount -> orgSubAccount.getOrgId()).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank(mobile)) {
            orgIds = orgAccountDao.getIdsByOrgIdsAndMobile(orgIds, mobile);
        }
        if (StringUtils.isNotBlank(campusName) || StringUtils.isNotBlank(name)) {
            orgIds = orgInfoDao.getOrgIdsByName(orgIds, campusName, name);
        }
        List<OrgSubAccount> slaves = orgSubAccountDao.getByOrgIds(orgIds, null, campusType, pageDto);
        List<SettingCampusListDto> ret = toSettingCampusListDto(orgId, slaves);
        return ret;
    }

    private List<SettingCampusListDto> toSettingCampusListDto(Integer orgId, List<OrgSubAccount> slaves) {
        List<SettingCampusListDto> data = Lists.newArrayList();
        Map<Integer, OrgSubAccount> orgSubAccountMap = GenericsUtils.toFieldMap(slaves, "orgId");
        Set<Integer> orgIds = orgSubAccountMap.keySet();
        Set<Integer> allOrgIds = Sets.newHashSet();
        allOrgIds.addAll(orgIds);
        Map<Integer, CampusWechatInfoDto> wechatInfoDtoMap =
            unifiedWechatAccountService.findCampusWechatStatus(allOrgIds, orgId);
        if (CollectionUtils.isNotEmpty(slaves)) {
            for (OrgSubAccount subAccount : slaves) {
                OrgAccount oAccount = orgAccountService.getOrgAccountById(subAccount.getOrgId());
                if (oAccount != null) {
                    OrgInfo oInfo = orgInfoDao.getOrgInfo(oAccount.getId());
                    Integer subCount = txCascadeAccountDao.getCountByOrgId(oAccount.getId());
                    SettingCampusListDto slave = new SettingCampusListDto();
                    // 算上自己
                    slave.setAccountSum(++subCount);
                    slave.setCampusName(oInfo.getShortName());
                    slave.setCampusNumber(oAccount.getNumber());
                    slave.setCampusType(subAccount.getAccountType());
                    slave.setOnlineType(subAccount.getOnlineType());
                    slave.setOnlineTypeName(OnlineType.getLable(subAccount.getOnlineType()));
                    slave.setAreaId(oInfo.getAreaId());
                    slave.setCampusId(subAccount.getId());
                    slave.setMobile(oAccount.getMobile());
                    slave.setCoverUrl(subAccount.getCoverUrl());
                    if (oInfo.getAreaId() != null) {
                        Map<String, String> areaMap = AreaUtils.getAreaNameByCode(oInfo.getAreaId());
                        slave.setProvince(areaMap.get("province"));
                        slave.setCity(areaMap.get("city"));
                    }
                    slave.setPresidentName(oInfo.getContacts());
                    if (slave.getOnlineType() == Flag.TRUE.getInt()) {
                        CampusWechatInfoDto masterWechat = wechatInfoDtoMap.get(orgId);
                        if (null != masterWechat) {
                            setWechatInfo(slave, masterWechat);
                        }
                    } else {
                        setWechatInfo(slave, wechatInfoDtoMap.get(oInfo.getOrgId()));
                    }
                    data.add(slave);
                }
            }
        }
        return data;
    }

    /**
     * 设置机构公众号的信息
     */
    private void setWechatInfo(SettingCampusListDto settingCampusListDto, CampusWechatInfoDto wechatInfoDto) {
        if (wechatInfoDto == null) {
            wechatInfoDto = CampusWechatInfoDto.UN_KNOW_INFO;
        }
        settingCampusListDto.setWechatTypeStr(wechatInfoDto.getWechatStatusStr());
        settingCampusListDto.setWechatUrl(wechatInfoDto.getWechatUr());
        settingCampusListDto.setWechatName(wechatInfoDto.getWechatName());
        settingCampusListDto.setWechatType(wechatInfoDto.getWechatStatus());
        settingCampusListDto.setOrgWechatType(wechatInfoDto.getOrgWehatType());
    }

    @Override
    public void addCampus(AddCampusRequest addCampusRequest) {
        Integer subCount = orgSubAccountService.getSlaveCount(TianxiaoPCContext.getOrgId());
        TXAccount txAccount = txAccountDao.getByOrgId(TianxiaoPCContext.getOrgId(), TXAccountStatus.VALID.getCode());
        if (txAccount.getCampusCount() <= (subCount + 1)) {
            throw new BussinessException(CrmErrorCode.EXCESS_CAMPUS_COUNT);
        }
        OrgAccount orgAccount = orgAccountService.getOrgAccountByMobile(addCampusRequest.getMobile());
        // 手机号已存在，校验验证码
        // 手机号不存在，浅注册一个机构
        if (orgAccount != null) {
            if (orgAccount.getId().intValue() == txAccount.getOrgId()) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "不能添加自己");
            }
            // code为空或者不正确，kill
            if (StringUtils.isBlank(addCampusRequest.getCode())
                || VerifyCodeUtil.valid(false, addCampusRequest.getMobile(), addCampusRequest.getCode(),
                    TxSmsCodeType.INVITE_TOBE_CAMPUS.getCacheKey())) {
                throw new BussinessException(SMSErrorCode.CODE_INVALID);
            }
        } else {
            orgAccount = saveOrgAccount(addCampusRequest.getMobile());
            saveOrgInfo(addCampusRequest.getAreaId(), orgAccount.getId(), addCampusRequest.getCampusName(),
                addCampusRequest.getPrincipal());
            try {
                sendMQSMsg(orgAccount.getId(), addCampusRequest.getAreaId(), null);
            } catch (Exception e) {
                log.warn("can not semd MQMSG ,please notify it :{} ", e);
            }
            boolean sendResult = false;
            try {
                String content = SmsContentHelper.createNewOrgPwdSmsContent(addCampusRequest.getMobile(),
                    TXCascadeCredential.DEFAULT_PWD);
                sendResult = commonMsgService.sendTxSms(TianxiaoPCContext.getOrgId().longValue(),
                    TianxiaoPCContext.getOrgId().longValue(), UserRole.ORGANIZATION.getRole(), null, null,
                    TxSmsCodeType.NEW_ORG_PWD, null, addCampusRequest.getMobile(), content);
            } catch (Throwable e) {
                log.error("send invite campus sms error:", e);
            }
            if (!sendResult) {
                log.info("send invite campus sms to :{} error:{}!code :{}", addCampusRequest.getMobile(), sendResult,
                    TXCascadeCredential.DEFAULT_PWD);
            }
            log.info("send default campus pwd sms to :{} error:{}!code :{}", addCampusRequest.getMobile(), sendResult,
                TXCascadeCredential.DEFAULT_PWD);
        }

        OrgSubAccount slaveInDB = orgSubAccountService.getByOrgIdIgnoreDelStatus(orgAccount.getId());
        if (slaveInDB == null) {
            OrgSubAccount slave = new OrgSubAccount();
            slave.setAccountType(addCampusRequest.getCampusType());
            slave.setOnlineType(Flag.FALSE.getInt());
            slave.setOrgWechatType(addCampusRequest.getOrgWechatType());
            slave.setComment(addCampusRequest.getPrincipal());
            slave.setOrgId(orgAccount.getId());
            slave.setCreateTime(new Date());
            slave.setPid(TianxiaoPCContext.getOrgId());
            slave.setCoverUrl(PropertiesReader.getValue("upload", "campus.cover.url"));
            orgSubAccountService.addOrgSubAccount(slave);
            slaveInDB = slave;
        } else if (slaveInDB.getIsdel().intValue() == DeleteStatus.DELETED.getValue()) {// 对于删除状态的子校区,更改状态
            slaveInDB.setAccountType(addCampusRequest.getCampusType());
            slaveInDB.setOrgWechatType(addCampusRequest.getOrgWechatType());
            slaveInDB.setComment(addCampusRequest.getPrincipal());
            slaveInDB.setOrgId(orgAccount.getId());
            slaveInDB.setUpdateTime(new Date());
            slaveInDB.setPid(TianxiaoPCContext.getOrgId());
            slaveInDB.setCoverUrl(PropertiesReader.getValue("upload", "campus.cover.url"));
            slaveInDB.setStatus(OrgSubAccountStatus.NORMAL.getCode());
            slaveInDB.setIsdel(DeleteStatus.NORMAL.getValue());
            slaveInDB.setAccountVersion(slaveInDB.getAccountVersion() + 1);
            orgSubAccountService.update(slaveInDB);
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgAccount.getId());
            orgInfo.setAreaId(addCampusRequest.getAreaId());
            orgInfo.setShortName(addCampusRequest.getCampusName());
            orgInfoDao.update(orgInfo);
        } else if (slaveInDB.getIsdel().intValue() == DeleteStatus.NORMAL.getValue() && slaveInDB.getPid() != 0) {// 生效中的分校区
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "此校区已绑定主校区，不可重复绑定(在原校区上删除该校区后可以再次绑定).");
        } else if (slaveInDB.getIsdel().intValue() == DeleteStatus.NORMAL.getValue() && slaveInDB.getPid() == 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "该校区已经是天校帐号,无法绑定成为分校区.");
        }
        // 主校区第一次添加时才创建
        OrgSubAccount masterInDB = orgSubAccountService.getByOrgIdIgnoreDelStatus(TianxiaoPCContext.getOrgId());
        checkoutWechatSetting(TianxiaoPCContext.getOrgId(), slaveInDB.getOrgId(), addCampusRequest.getOrgWechatType());
        if (masterInDB == null) {
            OrgSubAccount master = new OrgSubAccount();
            master.setAccountType(CampusType.MASTER.getCode());
            master.setOnlineType(Flag.FALSE.getInt());
            master.setCreateTime(new Date());
            master.setOrgId(TianxiaoPCContext.getOrgId());
            master.setPid(OrgSubAccount.MASTER_PID);
            master.setCoverUrl(PropertiesReader.getValue("upload", "campus.cover.url"));
            orgSubAccountService.addOrgSubAccount(master);
        }
        addToHag(orgAccount.getNumber());
    }

    /**
     * @param orgWechatType
     */
    private void checkoutWechatSetting(Integer masterOrgId, Integer slaveOrgId, Integer orgWechatType) {
        log.info("will check MasterOrgId:{} and slaveOrgId :{} orgWechatType:{} ", masterOrgId, slaveOrgId,
            orgWechatType);
        if (masterOrgId == null || slaveOrgId == null) {
            throw new BussinessException(CommonErrorCode.REQUIRE_PARAM,
                String.format("masterOrg:%s or slaveOrgId:%s can not be empty ", masterOrgId, slaveOrgId));
        }
        if (orgWechatType == 0) {
            this.unifiedWechatAccountService.addUnifiedWechatAccount(slaveOrgId.longValue(), masterOrgId.longValue());
        }
    }

    private void sendMQSMsg(int orgId, long areaId, String mobile) {
        OrganizationRegist regist = new OrganizationRegist();
        regist.setAreaId(areaId);
        regist.setMobile("");
        // regist.setMobile(StringUtils.isNotBlank(mobile) ? mobile : "");
        regist.setOrgId(orgId);
        regist.setTime(String.valueOf(System.currentTimeMillis() / 1000));

        String messageBody = JacksonUtil.obj2Str(regist);
        MqsUtils mqs = new MqsUtils();
        String queueName = PropertiesReader.getValue("mns", "mqs.queue.org.reg");
        mqs.sendMessage(queueName, messageBody);
    }

    @Override
    public void addToHag(Integer orgNumber) {
        log.info("add to hag orgNumber:{}", orgNumber);
        if (orgNumber == null) {
            return;
        }
        List<Entity> entities = Lists.newArrayList();
        Entity entity = new Entity();
        entity.setName(orgNumber);
        entities.add(entity);
        // 天校白名单
        com.baijia.yunying.hag.common.web.WebResponse<String> result1 =
            hagService.addEntitiesToResource(Long.valueOf(PropertiesReader.getValue("hag", "hag.token.id")),
                PropertiesReader.getValue("hag", "hag.token"), entities, BizConf.HAG_RESOURSE_ORG_TIANXIAO_NUMBER);
        log.info("add {} to hag {} result:{}", orgNumber, BizConf.HAG_RESOURSE_ORG_TIANXIAO_NUMBER, result1);
        // 3810白名单
        com.baijia.yunying.hag.common.web.WebResponse<String> result2 =

            hagService.addEntitiesToResource(Long.valueOf(PropertiesReader.getValue("hag", "hag.token.id")),
                PropertiesReader.getValue("hag", "hag.token"), entities, BizConf.HAG_RESOURCE_PYXIS_ORG_NUMBER);
        log.info("add {} to hag {} result:{}", orgNumber, BizConf.HAG_RESOURCE_PYXIS_ORG_NUMBER, result2);
        // 每日提现白名单
        com.baijia.yunying.hag.common.web.WebResponse<String> result3 =
            hagService.addEntitiesToResource(Long.valueOf(PropertiesReader.getValue("hag", "hag.token.id")),
                PropertiesReader.getValue("hag", "hag.token"), entities, BizConf.HAG_RESOURSE_ORG_TIXIAN_NUMBER);

        log.info("add {} to hag {} result:{}", orgNumber, BizConf.HAG_RESOURSE_ORG_TIXIAN_NUMBER, result3);
    }

    private OrgAccount saveOrgAccount(String mobile) {
        OrgAccount saveToDB = new OrgAccount();
        saveToDB.setCreateTime(new Date());
        saveToDB.setMobile(mobile);
        saveToDB.setPassword(PasswordUtil.createHash(TXCascadeCredential.DEFAULT_PWD));
        saveToDB.setUpdateTime(new Date());
        orgAccountDao.save(saveToDB);
        Integer id = saveToDB.getId();
        if (id != null) {
            saveToDB.setNumber(SerialNumberUtil.generateNumber(id, SerialNumberUtil.MAX));
            orgAccountDao.update(saveToDB);
        } else {
            throw new BusinessException("浅注册账户失败");
        }
        return saveToDB;
    }

    private void saveOrgInfo(Long areaId, int org_id, String shortName, String contacts) {
        OrgInfo info = new OrgInfo();
        Date time = new Date();
        info.setName("");
        info.setShortName(shortName);
        info.setOrgType(0);
        info.setAreaId(areaId);
        info.setContacts(contacts);
        info.setIdCardType(0);
        info.setIdCard("");
        info.setIdCardStorageId(0);
        info.setBizLicense("");
        info.setBizLicenseStorageId(0);
        info.setSchLicenseType(0);
        info.setSchLicense("");
        info.setSchLicenseStorageId(0);
        info.setAuditStatus(AuditStatus.INIT.getValue());
        info.setRejectReason("");
        info.setRejectReasonOther("");
        info.setSignStatus(SignStatus.UNSIGN.getCode());
        info.setOrgId(org_id);
        info.setCreateTime(time);
        info.setUpdateTime(time);

        orgInfoDao.save(info);
    }

    @Override
    public void modCampus(ModCampusRequest modCampusRequest) throws BussinessException, Exception {
        OrgAccount orgAccount = orgAccountService.getOrgAccountByNumber(modCampusRequest.getCampusNumber());
        if (orgAccount == null) {
            return;
        }
        boolean subChange = false;
        OrgSubAccount subAccount = null;
        boolean isMaster = false;
        if (modCampusRequest.getCampusType().intValue() == CampusType.MASTER.getCode()) {
            isMaster = true;
            subAccount = orgSubAccountService.getMaster(orgAccount.getId());
        } else {
            log.debug("mod subCampus orgId:{},pid:{}", orgAccount.getId(), TianxiaoPCContext.getOrgId());
            subAccount = orgSubAccountService.getSlaveIgnoreStatus(orgAccount.getId(), TianxiaoPCContext.getOrgId());
        }

        if (subAccount == null) {
            // 没查到分校区信息，说明出现脏数据，直接返回
            log.error("Oops! check orgsubAccount data! orgId:{}", orgAccount.getId());
            return;
        }
        if (StringUtils.isNotBlank(modCampusRequest.getPrincipal())) {
            subAccount.setComment(modCampusRequest.getPrincipal());
            subAccount.setUpdateTime(new Date());
            subChange = true;
        }
        if (StringUtils.isNotBlank(modCampusRequest.getCoverUrl())) {
            subAccount.setCoverUrl(modCampusRequest.getCoverUrl());
            subAccount.setUpdateTime(new Date());
            subChange = true;
        }
        log.info("modCampusRequest is :{} and isMaster:{} ,and orgSubAccount is :{} ", modCampusRequest, isMaster,
            subAccount);
        if (modCampusRequest.getOrgWechatType() != null && !isMaster
            && subAccount.getOrgWechatType() != modCampusRequest.getOrgWechatType()
            && subAccount.getOnlineType() == Flag.FALSE.getInt()) {
            log.info("will add ");
            // 校验编辑后校区微信公众号设置
            this.checkoutWechatSetting(TianxiaoPCContext.getOrgId(), orgAccount.getId(),
                modCampusRequest.getOrgWechatType());
            subAccount.setOrgWechatType(modCampusRequest.getOrgWechatType());
            subAccount.setUpdateTime(new Date());
            subChange = true;
            if (modCampusRequest.getOrgWechatType() == 1) { // 如果设置为独立公众号了
                this.unifiedWechatAccountService.deleteSlaveCampus(orgAccount.getId(), TianxiaoPCContext.getOrgId());
            }
        }
        if (subChange) {
            orgSubAccountService.update(subAccount);
        }
        OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgAccount.getId());
        if (orgInfo == null) {
            log.error("Oops! check orgInfo data! orgId:{}", orgAccount.getId());
            return;
        }
        boolean orgInfoChange = false;
        if (StringUtils.isNotBlank(modCampusRequest.getCampusName())) {
            orgInfo.setShortName(modCampusRequest.getCampusName());
            orgInfoChange = true;
        }
        if (modCampusRequest.getAreaId() != null && modCampusRequest.getAreaId() > 0) {
            orgInfo.setAreaId(modCampusRequest.getAreaId());
            orgInfoChange = true;
        }
        if (StringUtils.isNotBlank(modCampusRequest.getPrincipal())) {
            orgInfo.setContacts(modCampusRequest.getPrincipal());
        }
        if (orgInfoChange) {
            orgInfo.setUpdateTime(new Date());
            orgInfoDao.update(orgInfo);
        }

        // if (StringUtils.isNotBlank(modCampusRequest.getMobile())) {
        // OrgAccount temp = orgAccountService.getOrgAccountByMobile(modCampusRequest.getMobile());
        // if (temp != null) {
        //
        // if (!modCampusRequest.getMobile().equals(orgAccount.getMobile())) {
        // throw new BussinessException(CrmErrorCode.MOBILE_EXIST);
        // }
        // orgAccount.setMobile(modCampusRequest.getMobile());
        // orgAccount.setUpdateTime(new Date());
        // orgAccountDao.update(orgAccount);
        // } else {
        // orgAccount.setMobile(modCampusRequest.getMobile());
        // orgAccount.setUpdateTime(new Date());
        // orgAccountDao.update(orgAccount);
        // }
        // }
    }

    @Override
    public void delCampus(Integer campusNumber) {
        OrgAccount orgAccount = orgAccountDao.getAccountByNumber(campusNumber);
        if (null == orgAccount) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "找不到对应的机构!");
        }
        OrgSubAccount orgSubAccount = orgSubAccountService.getByOrgId(orgAccount.getId());
        if (null == orgSubAccount) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "找不到对应的子校区!");
        }
        if (Flag.TRUE.getInt() == orgSubAccount.getOnlineType()) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "线上校区不支持删除!");
        }

        List<TXCascadeAccount> cascadeAccountList =
            txCascadeAccountDao.getTXCascadeAccountListByOrgId(orgAccount.getId().longValue());
        for (TXCascadeAccount cascadeAccount : cascadeAccountList) {
            try {
                releaseConsulter(cascadeAccount.getId().longValue());
                // 释放班主任
                orgCourseDao.batchUpdateHeadTeacher(orgAccount.getNumber(), cascadeAccount.getId(), -1);
            } catch (Exception e) {
                log.error("modDirectorStatus - releaseConsulter - cascadeAccount:{}", cascadeAccount.getId());
                log.error("modDirectorStatus - releaseConsulter - error:{}", e);
                throw new BusinessException("释放线索失败，可尝试手动清空账号线索后再进行此操作。");
            }
        }

        this.unifiedWechatAccountService.deleteSlaveCampus(orgAccount.getId(), TianxiaoPCContext.getOrgId());
        log.info("success to remove slave campus :{} with masterOrgId:{}", orgAccount.getId(),
            TianxiaoPCContext.getOrgId());
        delInHag(orgAccount.getNumber());
        orgSubAccountDao.deleteByOrgid(orgAccount.getId());
        txCascadeAccountDao.deleteByOrgId(orgAccount.getId());
    }

    /**
     * 涉及多张表的翻页，ಥ_ಥ， 拼信息时，为了看起来逻辑清晰些，有重复的代码段在不同的if中
     *
     * @param orgAccount 两种情况:1未指定num,传入主校区 此时isAll为true 2指定了num,传入特定校区 此时isAll为false
     * @param pageDto
     * @return
     * @throws BussinessException
     * @throws Exception
     */
    @Override
    public List<CampusAccountDto> getAccountList(OrgAccount orgAccount, PageDto pageDto, String name, String mobile,
        Integer type, boolean isAll) {
        List<CampusAccountDto> data = Lists.newArrayList();
        TXAccount txAccount = txAccountDao.getByOrgId(orgAccount.getId(), TXAccountStatus.VALID.getCode());
        Map<Integer, TXAccount> txAccountMap = Maps.newHashMap();
        if (txAccount != null) {
            txAccountMap.put(txAccount.getOrgId(), txAccount);
        }
        OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgAccount.getId());
        CampusAccountDto master = makeMasterDto(orgAccount, orgInfo);
        if (StringUtils.isBlank(name) && StringUtils.isBlank(mobile) && null == type) {
            data.add(master);
        } else if ((StringUtils.isNotBlank(name) && master.getName().contains(name))
            || (StringUtils.isNotBlank(mobile) && master.getMobile().contains(mobile))
            || (null != type && master.getType().intValue() == type)) {
            data.add(master);
        }
        List<Integer> orgIds = Lists.newArrayList();
        orgIds.add(orgAccount.getId());
        if (isAll) {
            List<OrgSubAccount> subAccounts = orgSubAccountService.getSlavesIgnoreStatus(orgAccount.getId(), null);
            if (CollectionUtils.isNotEmpty(subAccounts)) {
                List<Integer> subAccountOrgIds = Lists.newArrayList();
                Map<Integer, OrgSubAccount> subAccountMap = Maps.newHashMap();
                for (OrgSubAccount subAccount : subAccounts) {
                    subAccountOrgIds.add(subAccount.getOrgId());
                    orgIds.add(subAccount.getOrgId());
                    subAccountMap.put(subAccount.getOrgId(), subAccount);
                }
                Map<Integer, OrgAccount> slaveAccountMap = orgAccountService.getOrgAccountMap(subAccountOrgIds);
                Map<Integer, OrgInfo> slaveInfoMap = orgInfoDao.getOrgInfoMap(subAccountOrgIds);
                List<CampusAccountDto> slaves = makeSlaveDto(slaveAccountMap, slaveInfoMap, subAccountMap, txAccount);
                for (CampusAccountDto dto : slaves) {
                    if (StringUtils.isNotBlank(name) && !dto.getName().contains(name)) {
                        continue;
                    }
                    if (StringUtils.isNotBlank(mobile) && !dto.getMobile().contains(mobile)) {
                        continue;
                    }
                    if (null != type && dto.getType().intValue() != type) {
                        continue;
                    }
                    data.add(dto);
                }
            }
        }
        int curPageCount = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
        // 第一页时，如果校长帐号数量>20 ，截断返回。<20填充子帐号返回
        // 从第二页开始，先看校长帐号数量是否超过curPageCount，超过的话，看超过的部分是否超过pagesize，超过截断，不超过取子帐号填充
        if (curPageCount == 0) {
            if (data.size() >= pageDto.getPageSize()) {
                data = data.subList(0, pageDto.getPageSize());
            } else {
                pageDto.setPageSize(pageDto.getPageSize() - data.size());// 刨去校区占用的空间,剩下子账号的可占用的最大个数
                List<TXCascadeAccount> cascadeAccounts =
                    txCascadeAccountDao.getByOrgIds(orgIds, mobile, name, type, pageDto);
                if (CollectionUtils.isNotEmpty(cascadeAccounts)) {
                    // 所有子账号的parentorgid取出所有<orgId,orgaccount>
                    // 所有orgid取出所有<orgId,orginfo>
                    // 所有子账号credentialid取出所有<credentialId,credential>
                    // cascadeaccounts 从credentialid取credential，从parentorgid取orgaccount和orginfo
                    Set<Integer> cascadeAccountOrgIds = Sets.newHashSet();
                    Set<Integer> credentialIds = Sets.newHashSet();
                    for (TXCascadeAccount cascadeAccount : cascadeAccounts) {
                        cascadeAccountOrgIds.add(cascadeAccount.getOrgId());
                        credentialIds.add(cascadeAccount.getCredentialId());
                    }
                    Map<Integer, OrgAccount> orgAccountMap =
                        orgAccountService.getOrgAccountMap(new ArrayList<Integer>(cascadeAccountOrgIds));
                    Map<Integer, OrgInfo> orgInfoMap =
                        orgInfoDao.getOrgInfoMap(new ArrayList<Integer>(cascadeAccountOrgIds));
                    Map<Integer, TXCascadeCredential> credentialMap =
                        txCascadeCredentialDao.getCredentialMap(new ArrayList<Integer>(credentialIds));
                    List<CampusAccountDto> dtos =
                        makeCascadeDto(orgAccountMap, orgInfoMap, credentialMap, cascadeAccounts, txAccountMap);
                    data.addAll(dtos);
                }
            }
        } else if (data.size() >= curPageCount) {
            // 走到这里，说明校长帐号超过了一页，有钱！！！
            data = data.subList(curPageCount, data.size());
            // 还是超过一页，真壕
            if (data.size() >= pageDto.getPageSize()) {
                data.subList(0, pageDto.getPageSize());
            } else {
                //  校长帐号不足一页，用子帐号补全一页
                pageDto.setCurPageCount(0);
                pageDto.setPageSize(pageDto.getPageSize() - data.size());
                List<TXCascadeAccount> cascadeAccounts =
                    txCascadeAccountDao.getByOrgIds(orgIds, mobile, name, type, pageDto);
                if (CollectionUtils.isNotEmpty(cascadeAccounts)) {
                    // 所有子账号的parentorgid取出所有<orgId,orgaccount>
                    // 所有orgid取出所有<orgId,orginfo>
                    // 所有子账号credentialid取出所有<credentialId,credential>
                    // cascadeaccounts 从credentialid取credential，从parentorgid取orgaccount和orginfo
                    Set<Integer> cascadeAccountOrgIds = Sets.newHashSet();
                    Set<Integer> credentialIds = Sets.newHashSet();
                    for (TXCascadeAccount cascadeAccount : cascadeAccounts) {
                        cascadeAccountOrgIds.add(cascadeAccount.getOrgId());
                        credentialIds.add(cascadeAccount.getCredentialId());
                    }
                    Map<Integer, OrgAccount> orgAccountMap =
                        orgAccountService.getOrgAccountMap(new ArrayList<Integer>(cascadeAccountOrgIds));
                    Map<Integer, OrgInfo> orgInfoMap =
                        orgInfoDao.getOrgInfoMap(new ArrayList<Integer>(cascadeAccountOrgIds));
                    Map<Integer, TXCascadeCredential> credentialMap =
                        txCascadeCredentialDao.getCredentialMap(new ArrayList<Integer>(credentialIds));
                    List<CampusAccountDto> dtos =
                        makeCascadeDto(orgAccountMap, orgInfoMap, credentialMap, cascadeAccounts, txAccountMap);
                    data.addAll(dtos);
                }
            }
        } else {
            // 不是第一页，校长帐号也未超过当前 curPageCount应当减校长帐号数量，得出上一次补全的子帐号offset位置
            pageDto.setCurPageCount(curPageCount - data.size());
            log.debug("getAccountList the 3pageDto is:{}", pageDto);
            data.clear();
            List<TXCascadeAccount> cascadeAccounts =
                txCascadeAccountDao.getByOrgIds(orgIds, mobile, name, type, pageDto);
            log.debug("getAccountList the cascadeAccounts is:{}", cascadeAccounts);
            if (CollectionUtils.isNotEmpty(cascadeAccounts)) {
                // 所有子账号的parentorgid取出所有<orgId,orgaccount>
                // 所有orgid取出所有<orgId,orginfo>
                // 所有子账号credentialid取出所有<credentialId,credential>
                // cascadeaccounts 从credentialid取credential，从parentorgid取orgaccount和orginfo
                Set<Integer> cascadeAccountOrgIds = Sets.newHashSet();
                Set<Integer> credentialIds = Sets.newHashSet();
                for (TXCascadeAccount cascadeAccount : cascadeAccounts) {
                    cascadeAccountOrgIds.add(cascadeAccount.getOrgId());
                    credentialIds.add(cascadeAccount.getCredentialId());
                }
                Map<Integer, OrgAccount> orgAccountMap =
                    orgAccountService.getOrgAccountMap(new ArrayList<Integer>(cascadeAccountOrgIds));
                Map<Integer, OrgInfo> orgInfoMap =
                    orgInfoDao.getOrgInfoMap(new ArrayList<Integer>(cascadeAccountOrgIds));
                Map<Integer, TXCascadeCredential> credentialMap =
                    txCascadeCredentialDao.getCredentialMap(new ArrayList<Integer>(credentialIds));
                List<CampusAccountDto> dtos =
                    makeCascadeDto(orgAccountMap, orgInfoMap, credentialMap, cascadeAccounts, txAccountMap);
                data.addAll(dtos);
            }
        }

        Integer count = txCascadeAccountDao.getCountByOrgIds(orgIds, null);
        log.debug("the length of orgIds is:{},the casAcc count is:{}", orgIds.size(), count);
        pageDto.setCount(count + orgIds.size());
        return data;
    }

    private List<CampusAccountDto> makeCascadeDto(Map<Integer, OrgAccount> orgAccountMap,
        Map<Integer, OrgInfo> orgInfoMap, Map<Integer, TXCascadeCredential> credentialMap,
        List<TXCascadeAccount> cascadeAccounts, Map<Integer, TXAccount> txAccountMap) {
        List<CampusAccountDto> data = Lists.newArrayList();
        for (TXCascadeAccount cascadeAccount : cascadeAccounts) {
            OrgAccount orgAccount = orgAccountMap.get(cascadeAccount.getOrgId());
            OrgInfo orgInfo = orgInfoMap.get(cascadeAccount.getOrgId());
            TXCascadeCredential credential = credentialMap.get(cascadeAccount.getCredentialId());
            TXAccount txAccount = txAccountMap.get(cascadeAccount.getOrgId());
            if (orgAccount == null || orgInfo == null || credential == null) {
                continue;
            }
            CampusAccountDto dto = new CampusAccountDto();
            dto.setType(cascadeAccount.getAccountType());// 主管or员工
            dto.setCampusName(orgInfo.getShortName());// 所属机构名
            dto.setCampusNumber(orgAccount.getNumber());// 所属机构num
            // txAccount不为空，但orgId==子账号的orgId，说明子账号是主校区的账号
            if (txAccount != null && txAccount.getOrgId() == cascadeAccount.getOrgId().intValue()) {
                OrgSubAccount orgSubAccount = orgSubAccountService.getByOrgId(orgAccount.getId());
                dto.setOnlineType(orgSubAccount.getOnlineType());
                dto.setOnlineTypeName(OnlineType.getLable(dto.getOnlineType()));
                dto.setCampusType(CampusType.MASTER.getCode());
                dto.setTypeStr("总校" + CampusAccountType.getLabelByCode(cascadeAccount.getAccountType()));
            } else {
                // txAccount不为空，但orgId！=子账号的orgId，说明子账号是分校区的账号，txAccount上一次查过了，缓存
                if (txAccount != null) {
                    OrgSubAccount orgSubAccount = orgSubAccountService.getByOrgId(orgAccount.getId());
                    dto.setCampusType(orgSubAccount.getAccountType());
                    dto.setOnlineType(orgSubAccount.getOnlineType());
                    dto.setOnlineTypeName(OnlineType.getLable(dto.getOnlineType()));
                    dto.setTypeStr(CampusAccountType.getLabelByCode(cascadeAccount.getAccountType()));
                } else {
                    OrgSubAccount orgSubAccount = orgSubAccountService.getByOrgId(orgAccount.getId());
                    if (orgSubAccount != null) {
                        dto.setCampusType(orgSubAccount.getAccountType());// 总校 or 直营 or 加盟
                        dto.setOnlineType(orgSubAccount.getOnlineType());
                        dto.setOnlineTypeName(OnlineType.getLable(dto.getOnlineType()));
                        dto.setTypeStr(CampusAccountType.getLabelByCode(cascadeAccount.getAccountType()));
                        txAccount = txAccountDao.getByOrgId(orgSubAccount.getPid(), TXAccountStatus.VALID.getCode());
                        txAccountMap.put(cascadeAccount.getOrgId(), txAccount);
                    }
                }
            }
            dto.setName(credential.getName());// 姓名
            dto.setMobile(credential.getMobile());// 手机
            dto.setStatus(cascadeAccount.getStatus());// 启用 or 停用
            dto.setTitle(cascadeAccount.getTitle());// 职务字段
            dto.setCascadeId(cascadeAccount.getId());// 子账号id
            Map<Integer, TxAccountPermission> txAccountPermissions = // 得到这个子账户对应的权限集合 **** device为null意思是权限包括pc
                // app,重复的code将被map过滤掉
                txAccountPermissionService.getPMapByUidLevelRoleDevice(cascadeAccount.getOrgId().longValue(),
                    cascadeAccount.getId(), txAccount, cascadeAccount.getAccountType(), null);
            List<TXPermission> Permissions =
                txPermissionService.getAllByPid(new ArrayList<Integer>(txAccountPermissions.keySet()));
            List<TXPermissionNodeDto> result = new ArrayList<>();
            for (TXPermission txPermission : Permissions) {
                TxAccountPermission txAccountPermission = txAccountPermissions.get(txPermission.getId());
                TXPermissionNodeDto nodeDto = new TXPermissionNodeDto();
                nodeDto.setCode(txPermission.getCode());
                nodeDto.setName(txPermission.getName());
                nodeDto.setType(txAccountPermission.getPType());
                result.add(nodeDto);
            }
            dto.setAuthList(result);
            data.add(dto);
        }
        return data;
    }

    private List<CampusAccountDto> makeSlaveDto(Map<Integer, OrgAccount> orgAccountMap,
        Map<Integer, OrgInfo> orgInfoMap, Map<Integer, OrgSubAccount> subAccountMap, TXAccount txAccount) {
        Map<Integer, TxAccountPermission> txAccountPermissions = // 得到这个子账户对应的权限集合 **** device为null意思是权限包括pc
            // app,重复的code将被map过滤掉
            txAccountPermissionService.getPMapByUidLevelRoleDevice(txAccount.getOrgId().longValue(), null, txAccount,
                RoleType.BRANCH_SCH_PRESIDENT.type, null);
        List<TXPermission> Permissions =
            txPermissionService.getAllByPid(new ArrayList<Integer>(txAccountPermissions.keySet()));
        List<CampusAccountDto> data = Lists.newArrayList();
        for (Integer orgId : orgAccountMap.keySet()) {
            OrgAccount orgAccount = orgAccountMap.get(orgId);
            OrgInfo orgInfo = orgInfoMap.get(orgId);
            OrgSubAccount subAccount = subAccountMap.get(orgId);
            if (orgAccount == null || orgInfo == null || subAccount == null) {
                continue;
            }
            CampusAccountDto dto = new CampusAccountDto();
            dto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
            dto.setTypeStr(CampusAccountType.SLAVE_PRINCIPAL.getLabel());
            dto.setOnlineType(subAccount.getOnlineType());
            dto.setOnlineTypeName(OnlineType.getLable(dto.getOnlineType()));
            dto.setCampusType(subAccount.getAccountType());
            dto.setCampusName(orgInfo.getShortName());
            dto.setCampusNumber(orgAccount.getNumber());
            dto.setName(orgInfo.getContacts());
            dto.setMobile(orgAccount.getMobile());
            dto.setStatus(subAccount.getStatus());
            dto.setTitle(subAccount.getTitle());
            log.debug("makeSlaveDto orgAccount is:{}", orgAccount);
            log.debug("makeSlaveDto txAccount is:{}", txAccount);
            List<TXPermissionNodeDto> result = new ArrayList<>();
            for (TXPermission txPermission : Permissions) {
                TxAccountPermission txAccountPermission = txAccountPermissions.get(txPermission.getId());
                TXPermissionNodeDto nodeDto = new TXPermissionNodeDto();
                nodeDto.setCode(txPermission.getCode());
                nodeDto.setName(txPermission.getName());
                nodeDto.setType(txAccountPermission.getPType());
                result.add(nodeDto);
            }
            dto.setAuthList(result);
            data.add(dto);
        }
        return data;
    }

    private CampusAccountDto makeMasterDto(OrgAccount orgAccount, OrgInfo orgInfo) {
        CampusAccountDto dto = new CampusAccountDto();
        dto.setType(CampusAccountType.MASTER_PRINCIPAL.getCode());
        dto.setTypeStr(CampusAccountType.MASTER_PRINCIPAL.getLabel());
        dto.setCampusType(CampusType.MASTER.getCode());
        dto.setCampusName(orgInfo.getShortName());
        dto.setCampusNumber(orgAccount.getNumber());
        dto.setName(orgInfo.getContacts());
        dto.setMobile(orgAccount.getMobile());

        Map<Integer, TxAccountPermission> txAccountPermissions = null;
        // 得到这个子账户对应的权限集合 **** device为null意思是权限包括pc app,重复的code将被map过滤掉

        TXAccount txAccount = txAccountService.getTXAccountByOrgId(orgAccount.getId());
        OrgSubAccount orgSubAccount = orgSubAccountService.getByOrgId(orgAccount.getId());
        if (null != orgSubAccount && orgSubAccount.getPid() > 0) {
            txAccount = txAccountDao.getByOrgId(orgSubAccount.getPid(), TXAccountStatus.VALID.getCode());
            dto.setOnlineType(orgSubAccount.getOnlineType());
            dto.setOnlineTypeName(OnlineType.getLable(dto.getOnlineType()));
            dto.setCampusType(orgSubAccount.getAccountType());
            dto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
            dto.setTypeStr(CampusAccountType.SLAVE_PRINCIPAL.getLabel());
            dto.setTitle(orgSubAccount.getTitle());
            txAccountPermissions = txAccountPermissionService.getPMapByUidLevelRoleDevice(
                orgAccount.getId().longValue(), null, txAccount, RoleType.BRANCH_SCH_PRESIDENT.type, null);
            dto.setStatus(orgSubAccount.getStatus());
        } else {
            txAccountPermissions = txAccountPermissionService.getPMapByUidLevelRoleDevice(
                orgAccount.getId().longValue(), null, txAccount, RoleType.PRESIDENT.type, null);
            dto.setTitle(orgSubAccount.getTitle());
            dto.setStatus(CampusAccountStatus.NORMAL.getCode());
            dto.setOnlineType(orgSubAccount.getOnlineType());
            dto.setOnlineTypeName(OnlineType.getLable(dto.getOnlineType()));
        }
        List<TXPermission> Permissions =
            txPermissionService.getAllByPid(new ArrayList<Integer>(txAccountPermissions.keySet()));
        List<TXPermissionNodeDto> result = new ArrayList<>();
        for (TXPermission txPermission : Permissions) {
            TxAccountPermission txAccountPermission = txAccountPermissions.get(txPermission.getId());
            TXPermissionNodeDto nodeDto = new TXPermissionNodeDto();
            nodeDto.setCode(txPermission.getCode());
            nodeDto.setName(txPermission.getName());
            nodeDto.setType(txAccountPermission.getPType());
            result.add(nodeDto);
        }
        dto.setAuthList(result);
        return dto;
    }

    public static void main(String[] args) {
        List<Integer> list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        list.add(5);
        list.add(6);
        list = list.subList(5, list.size());
        System.out.println(list);
    }

    @Override
    public boolean addAccount(AddAccountRequest request) {
        TXAccount txAccount = txAccountDao.getByOrgId(TianxiaoPCContext.getOrgId(), TXAccountStatus.VALID.getCode());
        if (txAccount == null) {
            throw new BussinessException(CommonErrorCode.SIGN_INVALIDATE);
        }
        List<Integer> orgIds = Lists.newArrayList();
        orgIds.add(TianxiaoPCContext.getOrgId());
        List<OrgSubAccount> subAccounts =
            orgSubAccountService.getSlavesIgnoreStatus(TianxiaoPCContext.getOrgId(), null);
        if (CollectionUtils.isNotEmpty(subAccounts)) {
            for (OrgSubAccount subAccount : subAccounts) {
                orgIds.add(subAccount.getOrgId());
            }
        }
        boolean sendSms = false;
        Integer count = txCascadeAccountDao.getCountByOrgIds(orgIds);
        if ((count + 1) > +(txAccount.getCascadeAccountCount() - txAccount.getCampusCount())) {
            throw new BussinessException(CrmErrorCode.EXCESS_CASCADE_ACCOUNT_COUNT);
        }
        OrgAccount master = orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        TXCascadeCredential credential = txCascadeCredentialDao.getByMobile(request.getMobile());
        if (credential == null) {
            credential = new TXCascadeCredential();
            credential.setCreateTime(new Date());
            credential.setMobile(request.getMobile());
            credential.setName(request.getName());
            OrgAccount credentialOrg = orgAccountService.getOrgAccountByMobile(request.getMobile());
            if (credentialOrg == null) {
                credential.setPassword(PasswordUtil.createHash(TXCascadeCredential.DEFAULT_PWD));
                sendSms = true;
            }
            txCascadeCredentialDao.save(credential);

        }
        TXCascadeAccount txCascadeAccount = new TXCascadeAccount();
        txCascadeAccount.setAccountType(request.getType());
        txCascadeAccount.setCreateTime(new Date());
        txCascadeAccount.setCredentialId(credential.getId());
        txCascadeAccount.setOrgId(master.getId());
        txCascadeAccount.setStatus(TXCascadeAccountStatus.VALID.getCode());
        txCascadeAccount.setTitle(request.getTitle());
        txCascadeAccountDao.save(txCascadeAccount);
        // 初始化权限
        TXAccount superAcc = this.findSuperTXAccount(txCascadeAccount);
        modPermission(txCascadeAccount, request, superAcc);

        boolean sendResult = false;
        if (sendSms) {
            try {
                String content =
                    SmsContentHelper.createNewNewCascadePwdSmsMsg(request.getMobile(), TXCascadeCredential.DEFAULT_PWD);
                sendResult = commonMsgService.sendTxSms(TianxiaoPCContext.getOrgId().longValue(),
                    TianxiaoPCContext.getOrgId().longValue(), UserRole.ORGANIZATION.getRole(), null, null,
                    TxSmsCodeType.NEW_CASCADE_PWD, null, request.getMobile(), content);
            } catch (Throwable e) {
                log.error("send invite campus sms error:", e);
            }
            if (!sendResult) {
                log.error("send invite campus sms to :{} error:{}!code :{}", request.getMobile(), sendResult,
                    TXCascadeCredential.DEFAULT_PWD);
            } else {
                log.info("send default campus pwd sms to :{} error:{}!code :{}", request.getMobile(), sendResult,
                    TXCascadeCredential.DEFAULT_PWD);
            }
        }
        return sendResult;
    }

    @Override
    public void modAccount(ModAccountRequest request) {
        CampusAccountType accountType = CampusAccountType.getTypeByCode(request.getType());
        switch (accountType) {
            case MASTER_PRINCIPAL:// 更改手机号码,姓名
                modMasterPrincipal(request);
                break;
            case SLAVE_PRINCIPAL:// 更改手机号码,姓名,校区名字
                modSlavePrincipal(request);
                break;
            case DIRECTOR:
                modDirector(request);
                break;
            case STAFF:
                modDirector(request);
                break;
            default:
                break;
        }
    }

    @Override
    public void delAccount(ModAccountRequest request) {
        if (request.getType().intValue() != CampusAccountType.DIRECTOR.getCode()
            && request.getType().intValue() != CampusAccountType.STAFF.getCode()) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "只能删除员工或主管!");
        }
        TXCascadeAccount cascadeAccount = txCascadeAccountDao.getById(request.getCascadeId());
        OrgAccount orgAccount = orgAccountDao.getAccountById(cascadeAccount.getOrgId());
        try {
            releaseConsulter(cascadeAccount.getId().longValue());
            // 释放班主任
            orgCourseDao.batchUpdateHeadTeacher(orgAccount.getNumber(), cascadeAccount.getId(), -1);
        } catch (Exception e) {
            log.error("modDirectorStatus - releaseConsulter - cascadeAccount:{}", cascadeAccount.getId());
            log.error("modDirectorStatus - releaseConsulter - error:{}", e);
            throw new BusinessException("释放线索失败，可尝试手动清空账号线索后再进行此操作。");
        }
        txCascadeAccountDao.deleteById(request.getCascadeId());
    }

    private void modMasterPrincipal(ModAccountRequest request) {
        OrgAccount orgAccount = orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        if (StringUtils.isNotBlank(request.getMobile()) && !orgAccount.getMobile().equals(request.getMobile())) {
            if (StringUtils.isBlank(request.getCode())) {
                throw new BussinessException(SMSErrorCode.CODE_INVALID);
            }
            // 这里校验验证码
            if (!VerifyCodeUtil.valid(false, orgAccount.getMobile(), request.getCode(),
                TxSmsCodeType.MOD_ORG_MOBILE.getCacheKey())) {
                throw new BussinessException(SMSErrorCode.CODE_INVALID);
            }
            orgAccount.setMobile(request.getMobile());
            orgAccountDao.update(orgAccount);
            OrgSubAccount orgSubAccount = orgSubAccountService.getByOrgId(orgAccount.getId());
            orgSubAccount.setAccountVersion(orgSubAccount.getAccountVersion() + 1);
            orgSubAccount.setTitle(request.getTitle());
            orgSubAccountService.update(orgSubAccount);
        }

        if (StringUtils.isNotBlank(request.getName())) {
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgAccount.getId());
            orgInfo.setContacts(request.getName());
            orgInfoDao.update(orgInfo);
        }
    }

    /**
     * @param request
     */

    private void modSlavePrincipal(ModAccountRequest request) {
        if (request.getCampusNumber() == null || StringUtils.isEmpty(request.getCampusName())) {
            throw new BussinessException(CommonErrorCode.REQUIRE_PARAM);
        }
        OrgAccount orgAccount = orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        if (orgAccount != null) {
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgAccount.getId());
            orgInfo.setShortName(request.getCampusName());
            orgInfo.setContacts(request.getName());
            orgInfo.setUpdateTime(new Date());
            orgInfoDao.update(orgInfo);
        } else {
            throw new BussinessException(CommonErrorCode.REQUIRE_PARAM);
        }
        if (!request.getMobile().equals(orgAccount.getMobile())) {
            OrgSubAccount orgSubAccount =
                orgSubAccountService.getSlaveIgnoreStatus(orgAccount.getId(), TianxiaoPCContext.getOrgId());
            if (orgSubAccount != null) {
                if (orgSubAccount.getAccountType().intValue() == CampusType.LEAGUE.getCode()) {
                    // 李可小需求
                    // throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "加盟分校不支持修改电话，请联系师资");
                }
                OrgAccount temp = orgAccountService.getOrgAccountByMobile(request.getMobile());
                if (temp != null) {
                    throw new BussinessException(CrmErrorCode.MOBILE_EXIST);
                }
                orgAccount.setMobile(request.getMobile());
                orgAccount.setUpdateTime(new Date());
                orgAccountDao.update(orgAccount);
                orgSubAccount.setAccountVersion(orgSubAccount.getAccountVersion() + 1);
                orgSubAccount.setTitle(request.getTitle());
                orgSubAccountService.update(orgSubAccount);
            }
        }
    }

    /**
     * @param request
     */
    private void modDirector(ModAccountRequest request) {
        if (request.getCampusNumber() == null || request.getCascadeId() == null) {
            throw new BussinessException(CommonErrorCode.REQUIRE_PARAM);
        }
        TXCascadeAccount cascadeAccount = txCascadeAccountDao.getById(request.getCascadeId());
        TXCascadeCredential credential = txCascadeCredentialDao.getById(cascadeAccount.getCredentialId());
        if (cascadeAccount == null || credential == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgAccount orgAccount = orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        if (cascadeAccount.getOrgId().intValue() != orgAccount.getId()) {// 所属机构有变动
            try {
                releaseConsulter(cascadeAccount.getId().longValue());
                // 释放班主任
                orgCourseDao.batchUpdateHeadTeacher(orgAccountDao.getById(cascadeAccount.getOrgId()).getNumber(),
                    cascadeAccount.getId(), -1);
            } catch (Exception e) {
                log.error("modDirectorStatus - releaseConsulter - cascadeAccount:{}", cascadeAccount.getId());
                log.error("modDirectorStatus - releaseConsulter - error:{}", e);
                throw new BusinessException("释放线索失败，可尝试手动清空账号线索后再进行此操作。");
            }
            cascadeAccount.setOrgId(orgAccount.getId());
        }
        cascadeAccount.setTitle(request.getTitle());
        cascadeAccount.setUpdateTime(new Date());
        cascadeAccount.setAccountVersion(cascadeAccount.getAccountVersion() + 1);
        txCascadeAccountDao.update(cascadeAccount);
        if (!credential.getMobile().equals(request.getMobile())) {// 手机号码有变动
            TXCascadeCredential temp = txCascadeCredentialDao.getByMobile(request.getMobile());
            if (temp == null) {
                credential.setName(request.getName());
                credential.setUpdateTime(new Date());
                credential.setMobile(request.getMobile());

                OrgAccount credentialOrg = orgAccountService.getOrgAccountByMobile(request.getMobile());
                if (credentialOrg == null) {
                    credential.setPassword(PasswordUtil.createHash(TXCascadeCredential.DEFAULT_PWD));
                    boolean sendResult = false;
                    try {
                        String content = SmsContentHelper.createNewOrgPwdSmsContent(request.getMobile(),
                            TXCascadeCredential.DEFAULT_PWD);
                        sendResult = commonMsgService.sendTxSms(TianxiaoPCContext.getOrgId().longValue(),
                            TianxiaoPCContext.getOrgId().longValue(), UserRole.ORGANIZATION.getRole(), null, null,
                            TxSmsCodeType.NEW_ORG_PWD, null, request.getMobile(), content);
                    } catch (Throwable e) {
                        log.error("send invite campus sms error:", e);
                    }
                    if (!sendResult) {
                        log.error("send invite campus sms to :{} error:{}!code :{}", request.getMobile(), sendResult,
                            TXCascadeCredential.DEFAULT_PWD);
                    } else {
                        log.info("send default campus pwd sms to :{} error:{}!code :{}", request.getMobile(),
                            sendResult, TXCascadeCredential.DEFAULT_PWD);
                    }
                }

                txCascadeCredentialDao.update(credential);
                txCascadeAccountDao.update(cascadeAccount);
            } else {
                temp.setName(request.getName());
                temp.setUpdateTime(new Date());
                txCascadeCredentialDao.update(temp);
                cascadeAccount.setCredentialId(temp.getId());
                cascadeAccount.setUpdateTime(new Date());
                cascadeAccount.setAccountVersion(cascadeAccount.getAccountVersion() + 1);
                txCascadeAccountDao.update(cascadeAccount);
            }
        } else {
            credential.setName(request.getName());
            credential.setUpdateTime(new Date());
            txCascadeCredentialDao.update(credential);
        }
        TXAccount superAcc = findSuperTXAccount(cascadeAccount);
        // 修改权限
        modPermission(cascadeAccount, request, superAcc);
        modAccountType(cascadeAccount, request);
    }

    private TXAccount findSuperTXAccount(TXCascadeAccount cascadeAccount) {
        OrgSubAccount subAcc = orgSubAccountService.getByOrgId(cascadeAccount.getOrgId());
        if (subAcc.getPid() == 0) {
            return txAccountDao.getByOrgId(subAcc.getOrgId(), TXAccountStatus.VALID.getCode());
        } else {
            return txAccountDao.getByOrgId(subAcc.getPid(), TXAccountStatus.VALID.getCode());
        }
    }

    /**
     * @param cascadeAccount
     * @param request
     */
    private void modAccountType(TXCascadeAccount cascadeAccount, ModAccountRequest request) {
        if (cascadeAccount.getAccountType().intValue() == request.getType()) {
            return;
        }
        if (request.getType() == CampusAccountType.DIRECTOR.getCode().intValue()) {
            cascadeAccount.setAccountType(request.getType());
            txCascadeAccountDao.update(cascadeAccount);
        }
        if (request.getType() == CampusAccountType.STAFF.getCode().intValue()) {
            cascadeAccount.setAccountType(request.getType());
            txCascadeAccountDao.update(cascadeAccount);
        }
    }

    /**
     * @param cascadeAccount
     * @param request
     */
    private void modPermission(TXCascadeAccount cascadeAccount, AddAccountRequest request, TXAccount superAcc) {
        List<TxAccountPermission> txAccountPermissions = // 所有的权限 包括pc app
            txAccountPermissionService.getAllPByUidLevelRoleDevice(cascadeAccount.getOrgId().longValue(), null,
                superAcc, cascadeAccount.getAccountType(), null);
        List<TXPermissionNodeDto> subAuths = request.getAuthList();// 前端请求更改的内容
        Map<Long, TXPermission> allPCodeMap = txPermissionService.getAllTXPermissionsCodeMap();
        Map<Long, Integer> pCodeTypeMap = Maps.newHashMap();
        for (TXPermissionNodeDto nodeDto : subAuths) {// 先把前端给的权限拥有情况保存到map中
            pCodeTypeMap.put(allPCodeMap.get(nodeDto.getCode()).getCode(), nodeDto.getType());
        }
        specialTypeOperate(pCodeTypeMap, cascadeAccount);
        // 特殊逻辑结束
        Map<Integer, TxAccountPermission> pcMap = Maps.newHashMap();// 更新查询出来的权限开始
        Map<Integer, TxAccountPermission> appMap = Maps.newHashMap();
        for (TxAccountPermission txAccountPermission : txAccountPermissions) {
            if (txAccountPermission.getDeviceType() == DeviceType.APP.getCode()) {
                appMap.put(txAccountPermission.getPId(), txAccountPermission);
            }
            if (txAccountPermission.getDeviceType() == DeviceType.PC.getCode()) {
                pcMap.put(txAccountPermission.getPId(), txAccountPermission);
            }
        }
        Map<Integer, TXPermission> allPIdMap = txPermissionService.getAllTXPermissionsIDMap();
        Integer pTypeTemp;
        for (TXPermission txPermission : allPIdMap.values()) {
            // pc
            TxAccountPermission pc = pcMap.get(txPermission.getId());
            if ((pTypeTemp = pCodeTypeMap.get(txPermission.getCode())) != null)
                pc.setPType(pTypeTemp);
            // app
            TxAccountPermission app = appMap.get(txPermission.getId());
            if ((pTypeTemp = pCodeTypeMap.get(txPermission.getCode())) != null)
                app.setPType(pTypeTemp);
        } // 更新查询出来的权限结束
        List<TxAccountPermission> ownedPList = txAccountPermissionDao.listAllConfigs(null, null, cascadeAccount.getId(),
            TXPermissionAccountType.CASCADE_ACCOUNT.getCode());
        Map<String, TxAccountPermission> ownedPMap = Maps.newHashMap();
        for (TxAccountPermission tap : ownedPList) {
            if (tap.getDeviceType().equals(DeviceType.PC.getCode())) {
                ownedPMap.put("pc_" + tap.getPId(), tap);
            } else if (tap.getDeviceType().equals(DeviceType.APP.getCode())) {
                ownedPMap.put("app_" + tap.getPId(), tap);
            }
        } // 得到了数据库中已经有的集合
        log.debug("the owned permission set size is:{}", ownedPMap.size());
        List<TxAccountPermission> updatePermissions = Lists.newArrayList();
        List<TxAccountPermission> savePermissions = Lists.newLinkedList();
        for (TxAccountPermission tap : txAccountPermissions) {
            if (tap.getDeviceType().equals(DeviceType.PC.getCode())) {
                if (ownedPMap.containsKey("pc_" + tap.getPId())) {
                    TxAccountPermission temp = ownedPMap.get("pc_" + tap.getPId());
                    temp.setPType(pCodeTypeMap.get(allPIdMap.get(tap.getPId()).getCode()));
                    updatePermissions.add(temp);
                } else {
                    tap.setCreateTime(new Date());// 补全信息
                    tap.setUId(cascadeAccount.getId());
                    tap.setUpdateTime(new Date());
                    savePermissions.add(tap);
                }
            } else if (tap.getDeviceType().equals(DeviceType.APP.getCode())) {
                if (ownedPMap.containsKey("app_" + tap.getPId())) {
                    TxAccountPermission temp = ownedPMap.get("app_" + tap.getPId());
                    temp.setPType(pCodeTypeMap.get(allPIdMap.get(tap.getPId()).getCode()));
                    updatePermissions.add(temp);
                } else {
                    tap.setCreateTime(new Date());// 补全信息
                    tap.setUId(cascadeAccount.getId());
                    tap.setUpdateTime(new Date());
                    savePermissions.add(tap);
                }
            }
        }
        log.debug("the update permission list size is:{}", updatePermissions.size());
        txAccountPermissionService.updateAll(updatePermissions);

        /* 控制保存指定的权限 网校子帐号保存网校权限, 通用版子帐号保存通用版权限 */
        log.debug("before pick save permission list size is:{}", savePermissions.size());
        OrgSubAccount orgSubAccount = orgSubAccountDao.getByOrgId(cascadeAccount.getOrgId());
        Integer onlineType = orgSubAccount.getOnlineType();
        Integer pid = orgSubAccount.getPid();
        if (onlineType == Flag.TRUE.getInt()) {
            pickPermissions(savePermissions, allPIdMap, TXPermissionConst.WANGXIAO_PERMISSION_SET);
        } else if (onlineType == Flag.FALSE.getInt()) {
            if (pid == 0 && cascadeAccount.getAccountType() == RoleType.CHARAGE.type) {
                pickPermissions(savePermissions, allPIdMap, TXPermissionConst.NORMAL_PERMISSION_SET,
                    TXPermissionConst.MAIN_CAMPUS_MANAGER_ADDITIONAL_PERMISSION_SET,
                    TXPermissionConst.TIMESCARD_PERMISSION_SET);
            } else {
                pickPermissions(savePermissions, allPIdMap, TXPermissionConst.NORMAL_PERMISSION_SET,
                    TXPermissionConst.TIMESCARD_PERMISSION_SET);
            }
        }

        log.debug("the save permission set size is:{}", savePermissions.size());
        txAccountPermissionService.saveAll(savePermissions);
    }

    private void pickPermissions(List<TxAccountPermission> savePermissions, Map<Integer, TXPermission> allPIdMap,
        Set<Long>...controlSet) {
        Iterator<TxAccountPermission> iter = savePermissions.iterator();
        Set<Long> allSet = Sets.newHashSet();
        Arrays.stream(controlSet).forEach(set -> allSet.addAll(set));
        while (iter.hasNext()) {
            if (!allSet.contains(allPIdMap.get(iter.next().getPId()).getCode())) {
                iter.remove();
            }
        }
    }

    /**
     * nodeDto中code可能对应多个code，有些code的权限，和角色相关 如果你看到这里看不懂，是正常的 先找pm周希，了解app界面上，不同角色，拥有不同操作权限，但操作权限，是由后端决定。
     *
     * @param pTypeMap
     * @param cascadeAccount
     */
    private void specialTypeOperate(Map<Long, Integer> pTypeMap, TXCascadeAccount cascadeAccount) {
        if (!overriewService.isMasterHead()) {// 针对主管
            TxAccountPermissionsDto pNow =
                txAccountPermissionService.universalGetPermissions(TianxiaoPCContext.getOrgId(), cascadeAccount.getId(),
                    Lists.newArrayList(TXPermissionConst.FINANCE_MANAGEMENT.getPCode()));

            if (null == pNow | CollectionUtils.isEmpty(pNow.getAPPps()) | CollectionUtils.isEmpty(pNow.getPCps())) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "权限校验异常");
            }

            Integer hasType = pNow.getAPPps().get(0).getPType() | pNow.getPCps().get(0).getPType();
            if (!hasType.equals(pTypeMap.get(TXPermissionConst.FINANCE_MANAGEMENT.getPCode()))) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "总校主管无法设置子帐号资金管理权限!");
            }
        }

        Map<Long, Integer> tempMap = Maps.newHashMap();
        for (Long pCode : pTypeMap.keySet()) {
            if (pCode.equals(TXPermissionConst.IF_CLASS_ARRANGE.getPCode())
                && pTypeMap.get(pCode).equals(TXPermissionHasType.OWN.getCode())) {
                if (cascadeAccount.getAccountType() == CascadeType.MANAGER.getValue()) {
                    tempMap.put(pCode, TXPermissionHasType.OWN.getCode());
                }
                if (cascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                    tempMap.put(pCode, TXPermissionHasType.LOST.getCode());
                }
            }
            // } else if (pCode == TXPermissionConst.SHOW_ENTER_CLASS_SCHEDULE.getPCode()
            // && pTypeMap.get(pCode).equals(TXPermissionHasType.OWN.getCode())) {
            // if (cascadeAccount.getAccountType() == CascadeType.MANAGER.getValue()) {
            // tempMap.put(pCode, TXPermissionHasType.OWN.getCode());
            // }
            // if (cascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
            // tempMap.put(pCode, TXPermissionHasType.LOST.getCode());
            // }
            // }
        } // pick done
        for (Long pCode : tempMap.keySet()) {
            pTypeMap.put(pCode, tempMap.get(pCode));
        } // put done
    }

    @Override
    public void modAccountStatus(ModAccountRequest request) {
        CampusAccountType accountType = CampusAccountType.getTypeByCode(request.getType());
        switch (accountType) {
            case SLAVE_PRINCIPAL:
                modSlavePrincipalStatus(request);
                break;
            case DIRECTOR:
                modDirectorStatus(request);
                break;
            case STAFF:
                modDirectorStatus(request);
                break;
            default:
                break;
        }
    }

    /**
     * @param request
     */

    private void modSlavePrincipalStatus(ModAccountRequest request) {
        OrgAccount orgAccount = orgAccountService.getOrgAccountByNumber(request.getCampusNumber());

        OrgSubAccount subAccount =
            orgSubAccountService.getSlaveIgnoreStatus(orgAccount.getId(), TianxiaoPCContext.getOrgId());
        if (request.getStatus().intValue() == OrgSubAccountStatus.NORMAL.getCode()) {
            OrgSubAccount mainAcc = orgSubAccountService.getMaster(orgAccount.getId());
            if (null != mainAcc) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "该账号已经独立开通天校账号,无法启用");
            }
            subAccount.setStatus(request.getStatus());
            subAccount.setUpdateTime(new Date());
            orgSubAccountService.update(subAccount);
            addToHag(orgAccount.getNumber());
        }
        if (request.getStatus().intValue() == OrgSubAccountStatus.FIRE.getCode()) {
            subAccount.setStatus(request.getStatus());
            subAccount.setFireTime(new Date());
            subAccount.setUpdateTime(new Date());
            subAccount.setAccountVersion(subAccount.getAccountVersion() + 1);
            orgSubAccountService.update(subAccount);
            delInHag(orgAccount.getNumber());
        }
    }

    private void delInHag(Integer orgNumber) {
        log.info("del hag orgNumber:{}", orgNumber);
        if (orgNumber == null) {
            return;
        }
        List<Entity> entities = Lists.newArrayList();
        Entity entity = new Entity();
        entity.setName(orgNumber);
        entities.add(entity);
        // 天校白名单
        com.baijia.yunying.hag.common.web.WebResponse<String> result1 =
            hagService.delEntitiesOfResource(Long.valueOf(PropertiesReader.getValue("hag", "hag.token.id")),
                PropertiesReader.getValue("hag", "hag.token"), entities, BizConf.HAG_RESOURSE_ORG_TIANXIAO_NUMBER);
        log.info("del hag {} in {} result:{}", orgNumber, BizConf.HAG_RESOURSE_ORG_TIANXIAO_NUMBER, result1);
        // 3810白名单
        com.baijia.yunying.hag.common.web.WebResponse<String> result2 =
            hagService.delEntitiesOfResource(Long.valueOf(PropertiesReader.getValue("hag", "hag.token.id")),
                PropertiesReader.getValue("hag", "hag.token"), entities, BizConf.HAG_RESOURCE_PYXIS_ORG_NUMBER);
        log.info("del hag {} in {} result:{}", orgNumber, BizConf.HAG_RESOURCE_PYXIS_ORG_NUMBER, result2);
        // 每日提现白名单
        com.baijia.yunying.hag.common.web.WebResponse<String> result3 =
            hagService.delEntitiesOfResource(Long.valueOf(PropertiesReader.getValue("hag", "hag.token.id")),
                PropertiesReader.getValue("hag", "hag.token"), entities, BizConf.HAG_RESOURSE_ORG_TIXIAN_NUMBER);
        log.info("del hag {} in {} result:{}", orgNumber, BizConf.HAG_RESOURSE_ORG_TIXIAN_NUMBER, result3);
    }

    /**
     * @param request
     */

    private void modDirectorStatus(ModAccountRequest request) {
        // 控制启用的总量
        TXAccount txAccount = txAccountDao.getByOrgId(TianxiaoPCContext.getOrgId(), TXAccountStatus.VALID.getCode());
        if (request.getStatus().intValue() == TXCascadeAccountStatus.VALID.getCode()) {
            if (txAccount == null) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "账户不存在");
            }
            List<Integer> orgIds = Lists.newArrayList();
            orgIds.add(TianxiaoPCContext.getOrgId());
            List<OrgSubAccount> subAccounts =
                orgSubAccountService.getSlavesIgnoreStatus(TianxiaoPCContext.getOrgId(), null);
            if (CollectionUtils.isNotEmpty(subAccounts)) {
                for (OrgSubAccount subAccount : subAccounts) {
                    orgIds.add(subAccount.getOrgId());
                }
            }
            Integer count = txCascadeAccountDao.getCountByOrgIds(orgIds);
            if ((count + 1) > +(txAccount.getCascadeAccountCount() - txAccount.getCampusCount())) {
                throw new BussinessException(CrmErrorCode.EXCESS_CASCADE_ACCOUNT_COUNT);
            }
        }
        TXCascadeAccount cascadeAccount = txCascadeAccountDao.getById(request.getCascadeId());
        if (request.getStatus().intValue() == TXCascadeAccountStatus.VALID.getCode()
            || request.getStatus().intValue() == TXCascadeAccountStatus.PAUSE.getCode()) {
            cascadeAccount.setStatus(request.getStatus());
            cascadeAccount.setAccountVersion(cascadeAccount.getAccountVersion() + 1);
            txCascadeAccountDao.update(cascadeAccount);

            // 释放班主任
            if (request.getStatus().intValue() == TXCascadeAccountStatus.PAUSE.getCode()) {
                try {
                    releaseConsulter(cascadeAccount.getId().longValue());

                    // 释放班主任
                    orgCourseDao.batchUpdateHeadTeacher(txAccount.getOrgNumber(), cascadeAccount.getId(), -1);
                } catch (Exception e) {
                    log.error("modDirectorStatus - releaseConsulter - cascadeAccount:{}", cascadeAccount.getId());
                    log.error("modDirectorStatus - releaseConsulter - error:{}", e);
                    throw new BusinessException("释放线索失败，可尝试手动清空账号线索后再进行此操作。");
                }
            }
        }
    }

    /**
     * @Description : 释放指定账号的线索
     * @Author : zhenyujian
     * @Date : 2016年6月22日 下午3:40:13
     * @Return : void
     */
    public void releaseConsulter(Long cascadeId) {

        Date now = new Date();
        List<Long> consulterIds = consultUserDao.listConsulterUserIdsByCascade(cascadeId);
        log.info("modAccountStatus - consulter - Release - consulterIds:{}, size:{},time:{}", consulterIds,
            consulterIds.size(), now.getTime());

        if (CollectionUtils.isNotEmpty(consulterIds)) {
            // 释放线索
            consultUserDao.release(consulterIds, now);

            List<TxConsulterOperationLog> manualLogs = new ArrayList<TxConsulterOperationLog>();
            TxConsulterOperationLog log;
            for (int i = 0; i > consulterIds.size(); i++) {
                // 添加操作记录
                log = new TxConsulterOperationLog(consulterIds.get(i), Flag.NULL.getLong(), Flag.NULL.getLong(),
                    ConsulterOperation.PUSH_MANUAL);
                manualLogs.add(log);
                if (i % 100 == 0 || i == consulterIds.size() - 1) {// 每100条 批量插入
                    txConsulterOperationLogDao.saveAll(manualLogs);
                }
            }
        }
    }

    @Override
    public List<SimpleCampusDto> getCampusList(Integer loginOrgId, Integer loginCascadeId, Integer visitorOrgId,
        Integer visitorCascadeId, String keyword, PageDto pageDto) {
        PageDto page = null;
        // 如果筛选,则只能在内存中分页
        if (StringUtils.isBlank(keyword)) {
            page = pageDto;
        }

        List<OrgSubAccount> slaves = new ArrayList<>();
        if (visitorCascadeId != null && visitorCascadeId > 0) {
            TXCascadeAccount account = txCascadeAccountDao.getById(visitorCascadeId);
            if (account.getAccountType() == CampusAccountType.DIRECTOR.getCode()) {
                slaves = orgSubAccountService.getMasterAndSlaves(visitorOrgId, page);
            } else {
                slaves.add(orgSubAccountService.getByOrgId(visitorOrgId));
            }
        } else {
            slaves = orgSubAccountService.getMasterAndSlaves(visitorOrgId, page);
        }

        Set<Integer> orgIdSet = new LinkedHashSet<>();

        if (slaves != null && slaves.size() > 0) {
            for (OrgSubAccount account : slaves) {
                orgIdSet.add(account.getOrgId());
            }
        }
        Map<Integer, OrgInfo> orgInfoMap = new HashMap<>();
        if (!orgIdSet.isEmpty()) {
            List<OrgInfo> infos = orgInfoDao.getOrgInfos(orgIdSet);
            orgInfoMap = CollectionHelper.toKeyMap(infos, "orgId");
        }

        Map<Integer, OrgAccount> accountMap = new HashMap<>();
        if (!orgIdSet.isEmpty()) {
            List<OrgAccount> accounts = orgAccountDao.getByIds(orgIdSet);
            accountMap = CollectionHelper.toKeyMap(accounts, "id");
        }

        List<SimpleCampusDto> ret = new ArrayList<>();
        for (OrgSubAccount subAccount : slaves) {
            if (subAccount.getStatus() == 0) {
                SimpleCampusDto dto = new SimpleCampusDto();
                OrgInfo info = orgInfoMap.get(subAccount.getOrgId());
                OrgAccount account = accountMap.get(subAccount.getOrgId());
                dto.setCampusName(info.getShortName());
                dto.setCampusType(subAccount.getAccountType());
                dto.setLogo(orgInfoService.getLogo(subAccount.getOrgId()));
                dto.setOrgNumber(account.getNumber());
                ret.add(dto);
            } else {
                log.info("Account forbidden.account={}", subAccount);
            }
        }

        if (StringUtils.isNotBlank(keyword)) {
            log.info("search campus,keyword={}", keyword);
            for (Iterator<SimpleCampusDto> iter = ret.iterator(); iter.hasNext();) {
                if (!iter.next().getCampusName().contains(keyword)) {
                    iter.remove();
                }
            }
            pageDto.setCount(ret.size());
            if (ret.size() > 0) {
                int start = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
                start = Math.min(start, ret.size() - 1);
                int end = pageDto.getPageNum() * pageDto.getPageSize();
                end = Math.min(end, ret.size());
                return ret.subList(start, end);
            }
        }

        return ret;
    }

    @Override
    public List<AccountRoleDto> getAccountRoleList(Integer orgId, Integer cascadeId) {
        List<AccountRoleDto> ret = new ArrayList<>();
        TXCascadeCredential credential = null;
        OrgAccount orgAccount = null;
        List<TXCascadeAccount> cascadeAccounts = new ArrayList<>();// 子账号

        if (cascadeId != null && cascadeId > 0) {
            Map<Integer, TXCascadeCredential> credentialMap =
                txCascadeCredentialDao.getTxCascadeNameAndAvatar(Arrays.asList(cascadeId));

            if (credentialMap == null || credentialMap.isEmpty()) {
                log.info("Cascade id is not existed.orgId={},cascadeId={}", orgId, cascadeId);
                throw new ParameterException("子账号不存在");
            }
            Iterator<TXCascadeCredential> iter = credentialMap.values().iterator();
            credential = iter.next();
            cascadeAccounts = txCascadeAccountDao.getByCIdAndOrgId(orgId, credential.getId());
            OrgAccount org = orgAccountDao.getAccountByMobile(credential.getMobile());
            if (org != null && org.getId().equals(orgId)) {
                orgAccount = org;
            } else {
                log.info("Not current campus stuff.org={},currentOrgId={}", org, orgId);
            }
        } else {
            orgAccount = orgAccountDao.getById(orgId);
            credential = txCascadeCredentialDao.getByMobile(orgAccount.getMobile());
            if (credential != null) {
                cascadeAccounts = txCascadeAccountDao.getByCIdAndOrgId(orgId, credential.getId());
            }
        }

        OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId);
        OrgSubAccount subAccount = orgSubAccountDao.getByOrgId(orgId);
        OrgAccount org = orgAccountDao.getAccountById(orgId);
        if (orgInfo == null || subAccount == null || org == null) {
            log.info("Account orgInfo={},org={},subAccount={}", orgInfo, org, subAccount);
            throw new ParameterException("账号信息不存在");
        }

        if (orgAccount != null && subAccount.getStatus() == 0) {
            AccountRoleDto roleDto = new AccountRoleDto();
            roleDto.setAvatar(orgInfoService.getLogo(orgAccount.getId()));
            roleDto.setCampusName(orgInfo.getShortName());
            roleDto.setUsername(orgInfo.getContacts());
            roleDto.setRoleName(CampusAccountType.getLabelByCode(subAccount.getAccountType()));
            roleDto.setMobile(orgAccount.getMobile());
            roleDto.setOrgNumber(orgAccount.getNumber());
            roleDto.setCascadeId(0);
            if (StringUtils.isBlank(roleDto.getAvatar())) {
                roleDto.setAvatar(AvatarConstants.CONSULT_AVATAR_URL);
            }
            ret.add(roleDto);
        }

        if (cascadeAccounts != null && cascadeAccounts.size() > 0) {
            for (TXCascadeAccount account : cascadeAccounts) {
                if (account.getStatus() == TXCascadeAccountStatus.PAUSE.getCode()) {
                    continue;
                }
                AccountRoleDto roleDto = new AccountRoleDto();
                roleDto.setAvatar(credential.getAvatar());
                if (StringUtils.isBlank(roleDto.getAvatar())) {
                    roleDto.setAvatar(AvatarConstants.CONSULT_AVATAR_URL);
                }
                roleDto.setCampusName(orgInfo.getShortName());
                roleDto.setUsername(credential.getName());
                roleDto.setRoleName(CampusAccountType.getLabelByCode(account.getAccountType()));
                roleDto.setOrgNumber(org.getNumber());
                roleDto.setCascadeId(account.getId());
                roleDto.setMobile(credential.getMobile());
                ret.add(roleDto);
            }
        }

        return ret;
    }

    @Override
    public Integer getMasterOrgId(int loginOrgId, Integer cascadeId) {
        OrgSubAccount subAccount = orgSubAccountDao.getByOrgId((int) loginOrgId);

        int masterOrgId = loginOrgId;
        if (subAccount.getPid() > 0) {
            masterOrgId = subAccount.getPid();
        }

        OrgAccount loginOrg = orgAccountDao.getById(loginOrgId);

        if (cascadeId != null && cascadeId > 0) {
            TXCascadeAccount account = txCascadeAccountDao.getById(cascadeId);
            Preconditions.checkNotNull(account);

            TXCascadeCredential credential = txCascadeCredentialDao.getById(account.getCredentialId());
            Preconditions.checkNotNull(credential);

            List<TXCascadeAccount> cascadeAccounts =
                txCascadeAccountDao.getByCIdAndOrgId(masterOrgId, credential.getId());
            for (TXCascadeAccount cascadeAccount : cascadeAccounts) {// 总校区主管
                if (cascadeAccount.getStatus() == TXCascadeAccountStatus.PAUSE.getCode()) {
                    continue;
                }
                if (cascadeAccount.getAccountType() == CampusAccountType.DIRECTOR.getCode()) {
                    return masterOrgId;
                }
            }
            log.info("It is not master campus director.");
            OrgAccount org = orgAccountDao.getAccountByMobile(credential.getMobile());
            if (org != null && org.getId() == masterOrgId) {// 登陆的账号同时是主校区校长
                return masterOrgId;
            }

        } else {
            // 总校区校长登陆
            if (subAccount.getPid() == 0) {
                return loginOrgId;
            } else {// 分校区校长登陆
                TXCascadeCredential credential = txCascadeCredentialDao.getByMobile(loginOrg.getMobile());
                if (credential != null) {
                    List<TXCascadeAccount> cascadeAccounts =
                        txCascadeAccountDao.getByCIdAndOrgId(masterOrgId, credential.getId());
                    for (TXCascadeAccount cascadeAccount : cascadeAccounts) {// 总校区主管
                        if (cascadeAccount.getStatus() == TXCascadeAccountStatus.PAUSE.getCode()) {
                            continue;
                        }
                        if (cascadeAccount.getAccountType() == CampusAccountType.DIRECTOR.getCode()) {
                            return masterOrgId;
                        }
                    }
                } else {
                    log.info("The mobile not band sub account.mobile={}", loginOrg.getMobile());
                }

                OrgAccount orgAccount = orgAccountDao.getById(subAccount.getPid());
                // 是另一个总校的校长
                if (loginOrg.getMobile().equals(orgAccount.getMobile())) {
                    return orgAccount.getId();
                } else {
                    log.info("Branch campus head.");
                }
            }
        }
        return null;
    }
}
