/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.campus.service.impl;

import com.baijia.tianxiao.biz.campus.constant.BankCardOpType;
import com.baijia.tianxiao.biz.campus.dto.finance.BindCardForPerVerifyDto;
import com.baijia.tianxiao.biz.campus.service.finance.OrgBankCardService;
import com.baijia.tianxiao.biz.campus.utils.PayMentSystemApiHelper;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.dal.finance.po.OrgBankCard;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPayPasswordDao;
import com.baijia.tianxiao.dal.org.po.OrgBaseInfoDto;
import com.baijia.tianxiao.dal.org.po.OrgPayPassword;
import com.baijia.tianxiao.dto.BaseResponse;
import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.ResponseStatus;
import com.baijia.tianxiao.enums.SMSType;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgAccountBankListDto;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgBankCardDto;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgBankInfoDto;
import com.baijia.tianxiao.sal.organization.finance.dto.SmsDto;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgBankCardServiceImpl
implements OrgBankCardService {
    private static final Logger log = LoggerFactory.getLogger(OrgBankCardServiceImpl.class);
    @Autowired
    private OrgInfoDao infoDao;
    @Autowired
    private OrgPayPasswordDao orgPayPasswordDao;

    @Override
    public List<OrgBankInfoDto> commonList() {
        RestfulResult<Object> restfulResult = null;
        ArrayList result = Lists.newArrayList();
        try {
            JSONObject data;
            JSONArray records;
            restfulResult = PayMentSystemApiHelper.commonBanks();
            if (restfulResult.getCode() != 0) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u94f6\u884c\u5361\u5931\u8d25!");
            }
            if (OrgBankCardServiceImpl.isNotNullJsonNode(restfulResult.getData()) && (records = (data = JSONObject.fromObject((Object)restfulResult.getData())).getJSONArray("list")) != null && records.size() > 0) {
                for (int i = 0; i < records.size(); ++i) {
                    JSONObject record = records.getJSONObject(i);
                    OrgBankInfoDto dto = new OrgBankInfoDto();
                    dto.setName(record.getString("name"));
                    dto.setCode(record.getString("code"));
                    dto.setIcon_url(record.getString("icon_url"));
                    result.add(dto);
                }
            }
        }
        catch (Exception e) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u94f6\u884c\u5361\u5931\u8d25!");
        }
        return result;
    }

    @Override
    public OrgAccountBankListDto getOrgBankCardByOrgId(Long orgId) {
        RestfulResult<OrgAccountBankListDto> restfulResult = null;
        try {
            restfulResult = PayMentSystemApiHelper.orgAccountBankList(orgId);
        }
        catch (Exception e) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u94f6\u884c\u5361\u5931\u8d25!");
        }
        if (restfulResult.getCode() != 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u94f6\u884c\u5361\u5931\u8d25!");
        }
        return (OrgAccountBankListDto)restfulResult.getData();
    }

    @Override
    public BaseResponse addOrgBankCard(OrgBankCard orgBankCard, String logInfo) {
        RestfulResult<Object> restfulResult = null;
        try {
            restfulResult = PayMentSystemApiHelper.bindCardForCot(orgBankCard.getOrgId(), orgBankCard.getBankNo(), orgBankCard.getCardNum(), orgBankCard.getCardOwnerName(), orgBankCard.getRegion(), orgBankCard.getCardOpenLocation());
            log.info("call - payMentSystem api - bindCardForCot - logInfo:" + logInfo + ", restfulResult:" + restfulResult);
        }
        catch (Exception e) {
            log.warn("call - payMentSystem api - bindCardForCot - exception - logInfo:" + logInfo);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u94f6\u884c\u8d26\u53f7\u5931\u8d25!");
        }
        if (restfulResult.getCode() != 0) {
            log.warn("call - payMentSystem api - bindCardForCot - fail - logInfo:" + logInfo + ", restfulResult:" + restfulResult);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u94f6\u884c\u8d26\u53f7\u5931\u8d25!");
        }
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setStatus(ResponseStatus.OK.getCode());
        SmsDto dto = new SmsDto();
        OrgBaseInfoDto data = this.infoDao.getBaseInfo(orgBankCard.getOrgId().intValue());
        dto.setCardNo(orgBankCard.getCardNum());
        dto.setCountryCode(data.getCountryCode());
        dto.setMobile(data.getMobile());
        dto.setShortName(data.getShortName());
        dto.setCountryCode(data.getCountryCode());
        this.sendMessage(dto, BankCardOpType.BIND_CARD);
        return baseResponse;
    }

    @Override
    public BaseResponse updateOrgBankCard(OrgBankCard orgBankCard, String logInfo) {
        OrgPayPassword orgPayPassword = this.orgPayPasswordDao.getPayPwdByOrgId(Integer.valueOf(orgBankCard.getOrgId().intValue()));
        if (orgPayPassword == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u8bbe\u7f6e\u63d0\u73b0\u5bc6\u7801\u540e\u518d\u89e3\u7ed1\u94f6\u884c\u5361");
        }
        RestfulResult<Object> restfulResult = null;
        try {
            restfulResult = PayMentSystemApiHelper.unbindCard(orgBankCard.getOrgId(), orgPayPassword.getPassword());
            log.info("call - payMentSystem api - unbindCard - logInfo:" + logInfo + ", restfulResult:" + restfulResult);
        }
        catch (Exception e) {
            log.error("call - payMentSystem api - unbindCard - exception - logInfo:" + logInfo + ",e:" + e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u66f4\u65b0\u94f6\u884c\u8d26\u53f7\u5931\u8d25");
        }
        if (restfulResult.getCode() != 0) {
            log.error("call - payMentSystem api - unbindCard - fail - logInfo:" + logInfo + ", restfulResult:" + restfulResult);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u66f4\u65b0\u94f6\u884c\u8d26\u53f7\u5931\u8d25");
        }
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setStatus(ResponseStatus.OK.getCode());
        SmsDto dto = new SmsDto();
        OrgBaseInfoDto data = this.infoDao.getBaseInfo(orgBankCard.getOrgId().intValue());
        dto.setCardNo(orgBankCard.getCardNum());
        dto.setCountryCode(data.getCountryCode());
        dto.setMobile(data.getMobile());
        dto.setShortName(data.getShortName());
        dto.setCountryCode(data.getCountryCode());
        this.sendMessage(dto, BankCardOpType.UNBIND_CARD);
        return baseResponse;
    }

    private void sendMessage(SmsDto bankCard, BankCardOpType opType) {
        String sms = "";
        String shortName = bankCard.getShortName();
        String mobile = bankCard.getMobile();
        String countryCode = bankCard.getCountryCode();
        String cardNo = bankCard.getCardNo();
        switch (opType) {
            case BIND_CARD: {
                sms = "\u5c0a\u656c\u7684{shortName}\u673a\u6784,\u60a8\u7684\u8ddf\u8c01\u5b66\u8d26\u6237\u6210\u529f\u7ed1\u5b9a\u4e86\u5c3e\u53f7\u4e3a{cardNo}\u7684\u94f6\u884c\u5361\uff0c\u8bf7\u77e5\u6089\uff0c\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u53ca\u65f6\u62e8\u62534000-910-910";
                break;
            }
            case UNBIND_CARD: {
                sms = "\u5c0a\u656c\u7684{shortName},\u60a8\u5df2\u6210\u529f\u4ece\u8ddf\u8c01\u5b66\u8d26\u6237\u89e3\u7ed1\u5c3e\u53f7\u4e3a{cardNo}\u7684\u94f6\u884c\u5361\uff0c\u8bf7\u77e5\u6089\uff0c\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u53ca\u65f6\u62e8\u62534000-910-910";
                break;
            }
        }
        if (StringUtils.isNotBlank((String)sms)) {
            if (StringUtils.isNotBlank((String)cardNo) && cardNo.length() > 4) {
                cardNo = cardNo.substring(cardNo.length() - 4, cardNo.length());
            }
            log.info("sendMessage.sms:{}, bankCard:{}", (Object)sms, (Object)bankCard);
            sms = sms.replace("{shortName}", shortName).replace("{cardNo}", cardNo);
            Integer channelType = null;
            channelType = !"86".equals(countryCode) ? Integer.valueOf(SMSType.SMS_INTERNAL_MSG.getValue()) : Integer.valueOf(SMSType.SMS_NOTICE.getValue());
            boolean result = SmsSendUtil.sendSms((String)mobile, (String)sms, (Integer)SmsMessageType.TIANXIAO_NOTIFY.getCode(), null, null, (boolean)true);
            log.info("sendMessage.bankCard:{}, resp:{}", (Object)bankCard, (Object)result);
        }
    }

    @Override
    public BindCardForPerVerifyDto sendMessage(Long orgId, OrgBankCardDto bankCard) {
        RestfulResult<BindCardForPerVerifyDto> result = null;
        String ownerName = bankCard.getName();
        String idNumber = bankCard.getIdNumber();
        String mobile = bankCard.getMobile();
        String cardNumber = bankCard.getCardNumber();
        String bankNo = bankCard.getBankNo();
        try {
            result = PayMentSystemApiHelper.bindCardForPerVerify(orgId, idNumber, bankNo, cardNumber, ownerName, mobile);
            log.info("OrgBankCardServiceImpl.sendMessage     ----  result:{}", result);
            if (result == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u652f\u4ed8\u63a5\u53e3\u5f02\u5e38");
            }
            if (result.getCode() == 1) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u652f\u4ed8\u63a5\u53e3\u8fd4\u56de\u5931\u8d25");
            }
            return (BindCardForPerVerifyDto)result.getData();
        }
        catch (Exception e) {
            log.error("OrgBankCardServiceImpl.sendMessage   ---  Excepiton:" + e);
            log.warn("OrgBankCardServiceImpl.sendMessage   --- bankCard:{}, result:{}", (Object)bankCard, result);
            if (result == null || result.getCode() != 0) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u652f\u4ed8\u63a5\u53e3\u8fd4\u56de\u5931\u8d25");
            }
            return null;
        }
    }

    @Override
    public boolean boundCard(Long orgId, OrgBankCardDto bankCard) {
        String ownerName = bankCard.getName();
        String idNumber = bankCard.getIdNumber();
        String mobile = bankCard.getMobile();
        String cardNumber = bankCard.getCardNumber();
        String purchaseId = bankCard.getPurchaseId().toString();
        String code = bankCard.getCode();
        String bankNo = bankCard.getBankNo();
        String region = bankCard.getRegion();
        String token = bankCard.getToken();
        Integer thirdType = bankCard.getThirdType();
        RestfulResult<Object> restfulResult = null;
        try {
            restfulResult = PayMentSystemApiHelper.bindCardForPer(orgId, idNumber, purchaseId, bankNo, cardNumber, ownerName, region, "", mobile, code, token, thirdType);
            log.info("call - payMentSystem api - bindCardForPer - orgId:{}, bankCard:{}, restfulResult:{}", new Object[]{orgId, bankCard, restfulResult});
            if (restfulResult == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u652f\u4ed8\u63a5\u53e3\u5f02\u5e38");
            }
            if (restfulResult.getCode() != 0) {
                log.info("call - payMentSystem api - bindCardForPer - BussinessExcepsion - orgId:{}, bankCard:{}, restfulResult:{}", new Object[]{orgId, bankCard, restfulResult});
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u652f\u4ed8\u63a5\u53e3\u8fd4\u56de\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.info("call - payMentSystem api - bindCardForPer - Excepsion - orgId:{}, bankCard:{}, restfulResult:{}", new Object[]{orgId, bankCard, restfulResult});
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u652f\u4ed8\u63a5\u53e3\u5f02\u5e38");
        }
        SmsDto dto = new SmsDto();
        OrgBaseInfoDto data = this.infoDao.getBaseInfo(bankCard.getOrgId().intValue());
        dto.setCardNo(bankCard.getCardNumber());
        dto.setCountryCode(data.getCountryCode());
        dto.setMobile(data.getMobile());
        dto.setShortName(data.getShortName());
        dto.setCountryCode(data.getCountryCode());
        this.sendMessage(dto, BankCardOpType.BIND_CARD);
        return true;
    }

    private static boolean isNotNullJsonNode(Object node) {
        return node != null && !node.equals("null") && !node.toString().equals("{}") && !node.toString().equals("[]");
    }
}

