
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.campus.service;

import com.baijia.tianxiao.biz.campus.dto.*;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;

/**
 * @title OverriewService
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年5月10日
 * @version 1.0
 */

public interface OverriewService {

    /**
     * pc登录是总校校长,总校主管
     * 
     * @return
     */
    boolean isRequestValid();

    /**
     * 分校身份返回为总校身份
     * @param request
     * @param response
     * @return
     */
    boolean loginRoleRevert(HttpServletRequest request, HttpServletResponse response);

    /**
     * pc登录是总校校长
     * 
     * @return
     */
    boolean isMasterHead();

    /**
     * 获取当前pc登录角色
     * @return
     */
    Integer getLoginRole();

    /**
     * 概况-校区列表
     * 
     * @param orgAccount
     * @param pageDto
     * @return
     * @throws BussinessException
     * @throws Exception
     */
    List<OverriewCampusListDto> getCampusList(Integer orgId, PageDto pageDto) throws BussinessException, Exception;

    /**
     * 校区概况
     * 
     * @param orgAccount
     * @return
     */
    OverriewCampusDto getCampusOverriew(Integer orgId) throws Exception;

    /**
     * 校区列表，左上角以及下拉用
     * 
     * @param orgAccount
     * @return
     * @throws Exception
     */
    List<BaseCampusDto> getCampusList(Integer orgId) throws Exception;

    /**
     * 招生概况
     * 
     * @param orgId
     * @return
     * @throws Exception
     */
    EnrollOverriewDto enrollOverriew(Integer orgId) throws Exception;

    /**
     * orgNumber不为空，忽视orgId
     * 
     * @param orgNumber
     * @param orgId
     * @return
     * @throws Exception
     * @throws BussinessException
     */

    List<EnrollOverriew> enrollList(Integer orgNumber, Integer orgId, Date startTime, Date endTime, PageDto pageDto)
        throws BussinessException, Exception;
    
    Integer isWangxiao();
    
    Integer getTxModuleVersion();
    
    String getLoginMobile(Integer orgId, Integer cascadeId);
}
