/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.campus.service.impl;

import com.baijia.tianxiao.biz.campus.constant.CampusAccountStatus;
import com.baijia.tianxiao.biz.campus.constant.CampusType;
import com.baijia.tianxiao.biz.campus.constant.OnlineType;
import com.baijia.tianxiao.biz.campus.dto.AddAccountRequest;
import com.baijia.tianxiao.biz.campus.dto.AddCampusRequest;
import com.baijia.tianxiao.biz.campus.dto.CampusAccountDto;
import com.baijia.tianxiao.biz.campus.dto.ModAccountRequest;
import com.baijia.tianxiao.biz.campus.dto.ModCampusRequest;
import com.baijia.tianxiao.biz.campus.dto.SettingCampusListDto;
import com.baijia.tianxiao.biz.campus.dto.TXPermissionNodeDto;
import com.baijia.tianxiao.biz.campus.service.OverriewService;
import com.baijia.tianxiao.biz.campus.service.SettingService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXCascadeAccountStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.pcAuthority.dao.TxAccountPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.dal.pcAuthority.po.TxAccountPermission;
import com.baijia.tianxiao.dal.roster.constant.ConsulterOperation;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsulterOperationLogDao;
import com.baijia.tianxiao.dal.roster.po.TxConsulterOperationLog;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dal.util.SerialNumberUtil;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.enums.SMSErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.marketing.commons.exceptions.BusinessException;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionAccountType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionHasType;
import com.baijia.tianxiao.sal.organization.mqs.OrganizationRegist;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.wechat.api.UnifiedWechatAccountService;
import com.baijia.tianxiao.sal.wechat.dto.unifiedWechatAccount.CampusWechatInfoDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.MqsUtils;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.tianxiao.util.VerifyCodeUtil;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.yunying.hag.common.web.WebResponse;
import com.baijia.yunying.hag.dal.bo.Entity;
import com.baijia.yunying.hag.service.HagService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SettingServiceImpl
implements SettingService {
    private static final Logger log = LoggerFactory.getLogger(SettingServiceImpl.class);
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired(required=false)
    private HagService hagService;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;
    @Autowired
    private TXPermissionService txPermissionService;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private TxConsulterOperationLogDao txConsulterOperationLogDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private TxAccountPermissionDao txAccountPermissionDao;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private UnifiedWechatAccountService unifiedWechatAccountService;
    @Autowired
    private OverriewService overriewService;

    @Override
    public List<SettingCampusListDto> getCampusList(Integer orgId, PageDto pageDto) throws Exception {
        ArrayList data = Lists.newArrayList();
        Integer mCascadeCount = this.txCascadeAccountDao.getCountByOrgId(orgId);
        List slaves = this.orgSubAccountService.getMasterAndSlaves(orgId, pageDto);
        Map orgSubAccountMap = GenericsUtils.toFieldMap((Collection)slaves, (String[])new String[]{"orgId"});
        Set orgIds = orgSubAccountMap.keySet();
        HashSet allOrgIds = Sets.newHashSet();
        allOrgIds.addAll(orgIds);
        Map wechatInfoDtoMap = this.unifiedWechatAccountService.findCampusWechatStatus((Collection)allOrgIds, orgId);
        if (CollectionUtils.isNotEmpty((Collection)slaves)) {
            for (OrgSubAccount subAccount : slaves) {
                OrgAccount oAccount = this.orgAccountService.getOrgAccountById(subAccount.getOrgId());
                if (oAccount == null) continue;
                OrgInfo oInfo = this.orgInfoDao.getOrgInfo(oAccount.getId(), new String[0]);
                Integer subCount = this.txCascadeAccountDao.getCountByOrgId(oAccount.getId());
                SettingCampusListDto slave = new SettingCampusListDto();
                subCount = subCount + 1;
                slave.setAccountSum(subCount);
                slave.setCampusName(oInfo.getShortName());
                slave.setCampusNumber(oAccount.getNumber());
                slave.setCampusType(subAccount.getAccountType());
                slave.setOnlineType(subAccount.getOnlineType());
                slave.setOnlineTypeName(OnlineType.getLable(subAccount.getOnlineType()));
                slave.setAreaId(oInfo.getAreaId());
                slave.setCampusId(subAccount.getId());
                slave.setMobile(oAccount.getMobile());
                slave.setCoverUrl(subAccount.getCoverUrl());
                if (oInfo.getAreaId() != null) {
                    Map areaMap = AreaUtils.getAreaNameByCode((Long)oInfo.getAreaId());
                    slave.setProvince((String)areaMap.get("province"));
                    slave.setCity((String)areaMap.get("city"));
                }
                slave.setPrincipal(oInfo.getContacts());
                this.setWechatInfo(slave, (CampusWechatInfoDto)wechatInfoDtoMap.get(oInfo.getOrgId()));
                data.add(slave);
            }
        }
        Integer slaveCount = this.orgSubAccountService.getSlaveCount(orgId);
        return data;
    }

    private void setWechatInfo(SettingCampusListDto settingCampusListDto, CampusWechatInfoDto wechatInfoDto) {
        if (wechatInfoDto == null) {
            wechatInfoDto = CampusWechatInfoDto.UN_KNOW_INFO;
        }
        settingCampusListDto.setWechatTypeStr(wechatInfoDto.getWechatStatusStr());
        settingCampusListDto.setWechatUrl(wechatInfoDto.getWechatUr());
        settingCampusListDto.setWechatName(wechatInfoDto.getWechatName());
        settingCampusListDto.setWechatType(wechatInfoDto.getWechatStatus());
        settingCampusListDto.setOrgWechatType(wechatInfoDto.getOrgWehatType());
    }

    @Override
    public void addCampus(AddCampusRequest addCampusRequest) {
        OrgSubAccount slaveInDB;
        Integer subCount = this.orgSubAccountService.getSlaveCount(TianxiaoPCContext.getOrgId());
        TXAccount txAccount = this.txAccountDao.getByOrgId(TianxiaoPCContext.getOrgId(), TXAccountStatus.VALID.getCode(), new String[0]);
        if (txAccount.getCampusCount() <= subCount + 1) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.EXCESS_CAMPUS_COUNT);
        }
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByMobile(addCampusRequest.getMobile());
        if (orgAccount != null) {
            if (orgAccount.getId().intValue() == txAccount.getOrgId().intValue()) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0d\u80fd\u6dfb\u52a0\u81ea\u5df1");
            }
            if (StringUtils.isBlank((CharSequence)addCampusRequest.getCode()) || VerifyCodeUtil.valid((boolean)false, (String)addCampusRequest.getMobile(), (String)addCampusRequest.getCode(), (String)TxSmsCodeType.INVITE_TOBE_CAMPUS.getCacheKey())) {
                throw new BussinessException((UniverseErrorCode)SMSErrorCode.CODE_INVALID);
            }
        } else {
            orgAccount = this.saveOrgAccount(addCampusRequest.getMobile());
            this.saveOrgInfo(addCampusRequest.getAreaId(), orgAccount.getId(), addCampusRequest.getCampusName(), addCampusRequest.getPrincipal());
            this.sendMQSMsg(orgAccount.getId(), addCampusRequest.getAreaId(), null);
            boolean sendResult = false;
            try {
                sendResult = SmsSendUtil.sendSms((String)addCampusRequest.getMobile(), (String)TxSmsCodeType.getSmsMsg((TxSmsCodeType)TxSmsCodeType.NEW_ORG_PWD, (String)"a123456"), (Integer)SmsMessageType.TIANXIAO_NOTIFY.getCode(), (Integer)TianxiaoPCContext.getOrgId(), (Integer)UserRole.ORGANIZATION.getRole(), (boolean)true, (Integer)this.txAccountService.getTxAccountSmsGate(TianxiaoPCContext.getOrgId()));
            }
            catch (Throwable e) {
                log.error("send invite campus sms error:", e);
            }
            if (!sendResult) {
                log.info("send invite campus sms to :{} error:{}!code :{}", new Object[]{addCampusRequest.getMobile(), sendResult, "a123456"});
            }
            log.info("send default campus pwd sms to :{} error:{}!code :{}", new Object[]{addCampusRequest.getMobile(), sendResult, "a123456"});
        }
        if ((slaveInDB = this.orgSubAccountService.getByOrgIdIgnoreDelStatus(orgAccount.getId())) == null) {
            OrgSubAccount slave = new OrgSubAccount();
            slave.setAccountType(addCampusRequest.getCampusType());
            slave.setOnlineType(Integer.valueOf(Flag.FALSE.getInt()));
            slave.setOrgWechatType(addCampusRequest.getOrgWechatType());
            slave.setComment(addCampusRequest.getPrincipal());
            slave.setOrgId(orgAccount.getId());
            slave.setCreateTime(new Date());
            slave.setPid(TianxiaoPCContext.getOrgId());
            slave.setCoverUrl(PropertiesReader.getValue((String)"upload", (String)"campus.cover.url"));
            this.orgSubAccountService.addOrgSubAccount(slave);
            slaveInDB = slave;
        } else if (slaveInDB.getIsdel().intValue() == DeleteStatus.DELETED.getValue()) {
            slaveInDB.setAccountType(addCampusRequest.getCampusType());
            slaveInDB.setOrgWechatType(addCampusRequest.getOrgWechatType());
            slaveInDB.setComment(addCampusRequest.getPrincipal());
            slaveInDB.setOrgId(orgAccount.getId());
            slaveInDB.setUpdateTime(new Date());
            slaveInDB.setPid(TianxiaoPCContext.getOrgId());
            slaveInDB.setCoverUrl(PropertiesReader.getValue((String)"upload", (String)"campus.cover.url"));
            slaveInDB.setStatus(OrgSubAccountStatus.NORMAL.getCode());
            slaveInDB.setIsdel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
            slaveInDB.setAccountVersion(Integer.valueOf(slaveInDB.getAccountVersion() + 1));
            this.orgSubAccountService.update(slaveInDB);
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgAccount.getId(), new String[0]);
            orgInfo.setAreaId(addCampusRequest.getAreaId());
            orgInfo.setShortName(addCampusRequest.getCampusName());
            this.orgInfoDao.update((Object)orgInfo, new String[0]);
        } else {
            if (slaveInDB.getIsdel().intValue() == DeleteStatus.NORMAL.getValue() && slaveInDB.getPid() != 0) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6b64\u6821\u533a\u5df2\u7ed1\u5b9a\u4e3b\u6821\u533a\uff0c\u4e0d\u53ef\u91cd\u590d\u7ed1\u5b9a(\u5728\u539f\u6821\u533a\u4e0a\u5220\u9664\u8be5\u6821\u533a\u540e\u53ef\u4ee5\u518d\u6b21\u7ed1\u5b9a).");
            }
            if (slaveInDB.getIsdel().intValue() == DeleteStatus.NORMAL.getValue() && slaveInDB.getPid() == 0) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8be5\u6821\u533a\u5df2\u7ecf\u662f\u5929\u6821\u5e10\u53f7,\u65e0\u6cd5\u7ed1\u5b9a\u6210\u4e3a\u5206\u6821\u533a.");
            }
        }
        OrgSubAccount masterInDB = this.orgSubAccountService.getByOrgIdIgnoreDelStatus(TianxiaoPCContext.getOrgId());
        this.checkoutWechatSetting(TianxiaoPCContext.getOrgId(), slaveInDB.getOrgId(), addCampusRequest.getOrgWechatType());
        if (masterInDB == null) {
            OrgSubAccount master = new OrgSubAccount();
            master.setAccountType(CampusType.MASTER.getCode());
            master.setOnlineType(Integer.valueOf(Flag.FALSE.getInt()));
            master.setCreateTime(new Date());
            master.setOrgId(TianxiaoPCContext.getOrgId());
            master.setPid(Integer.valueOf(0));
            master.setCoverUrl(PropertiesReader.getValue((String)"upload", (String)"campus.cover.url"));
            this.orgSubAccountService.addOrgSubAccount(master);
        }
        this.addToHag(orgAccount.getNumber());
    }

    private void checkoutWechatSetting(Integer masterOrgId, Integer slaveOrgId, Integer orgWechatType) {
        log.info("will check MasterOrgId:{} and slaveOrgId :{} orgWechatType:{} ", new Object[]{masterOrgId, slaveOrgId, orgWechatType});
        if (masterOrgId == null || slaveOrgId == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.REQUIRE_PARAM, String.format("masterOrg:%s or slaveOrgId:%s can not be empty ", masterOrgId, slaveOrgId));
        }
        if (orgWechatType == 0) {
            this.unifiedWechatAccountService.addUnifiedWechatAccount(Long.valueOf(slaveOrgId.longValue()), Long.valueOf(masterOrgId.longValue()));
        }
    }

    private void sendMQSMsg(int orgId, long areaId, String mobile) {
        OrganizationRegist regist = new OrganizationRegist();
        regist.setAreaId(Long.valueOf(areaId));
        regist.setMobile("");
        regist.setOrgId(Integer.valueOf(orgId));
        regist.setTime(String.valueOf(System.currentTimeMillis() / 1000L));
        String messageBody = JacksonUtil.obj2Str((Object)regist);
        MqsUtils mqs = new MqsUtils();
        String queueName = PropertiesReader.getValue((String)"mns", (String)"mqs.queue.org.reg");
        mqs.sendMessage(queueName, messageBody);
    }

    @Override
    public void addToHag(Integer orgNumber) {
        log.info("add to hag orgNumber:{}", (Object)orgNumber);
        if (orgNumber == null) {
            return;
        }
        ArrayList entities = Lists.newArrayList();
        Entity entity = new Entity();
        entity.setName((Object)orgNumber);
        entities.add(entity);
        WebResponse result1 = this.hagService.addEntitiesToResource(Long.valueOf(PropertiesReader.getValue((String)"hag", (String)"hag.token.id")), PropertiesReader.getValue((String)"hag", (String)"hag.token"), (Collection)entities, "jigou_tianxiao_orgNumber");
        log.info("add {} to hag {} result:{}", new Object[]{orgNumber, "jigou_tianxiao_orgNumber", result1});
        WebResponse result2 = this.hagService.addEntitiesToResource(Long.valueOf(PropertiesReader.getValue((String)"hag", (String)"hag.token.id")), PropertiesReader.getValue((String)"hag", (String)"hag.token"), (Collection)entities, "jigou_3810_orgNumber");
        log.info("add {} to hag {} result:{}", new Object[]{orgNumber, "jigou_3810_orgNumber", result2});
        WebResponse result3 = this.hagService.addEntitiesToResource(Long.valueOf(PropertiesReader.getValue((String)"hag", (String)"hag.token.id")), PropertiesReader.getValue((String)"hag", (String)"hag.token"), (Collection)entities, "jigou_tixian_orgNumber");
        log.info("add {} to hag {} result:{}", new Object[]{orgNumber, "jigou_tixian_orgNumber", result3});
    }

    private OrgAccount saveOrgAccount(String mobile) {
        OrgAccount saveToDB = new OrgAccount();
        saveToDB.setCreateTime(new Date());
        saveToDB.setMobile(mobile);
        saveToDB.setPassword(PasswordUtil.createHash((String)"a123456"));
        saveToDB.setUpdateTime(new Date());
        this.orgAccountDao.save((Object)saveToDB, new String[0]);
        Integer id = saveToDB.getId();
        if (id == null) {
            throw new BusinessException("\u6d45\u6ce8\u518c\u8d26\u6237\u5931\u8d25");
        }
        saveToDB.setNumber(Integer.valueOf(SerialNumberUtil.generateNumber((int)id, (int)99999999)));
        this.orgAccountDao.update((Object)saveToDB, new String[0]);
        return saveToDB;
    }

    private void saveOrgInfo(Long areaId, int org_id, String shortName, String contacts) {
        OrgInfo info = new OrgInfo();
        Date time = new Date();
        info.setName("");
        info.setShortName(shortName);
        info.setOrgType(Integer.valueOf(0));
        info.setAreaId(areaId);
        info.setContacts(contacts);
        info.setIdCardType(Integer.valueOf(0));
        info.setIdCard("");
        info.setIdCardStorageId(Integer.valueOf(0));
        info.setBizLicense("");
        info.setBizLicenseStorageId(Integer.valueOf(0));
        info.setSchLicenseType(Integer.valueOf(0));
        info.setSchLicense("");
        info.setSchLicenseStorageId(Integer.valueOf(0));
        info.setAuditStatus(Integer.valueOf(AuditStatus.INIT.getValue()));
        info.setRejectReason("");
        info.setRejectReasonOther("");
        info.setSignStatus(Integer.valueOf(SignStatus.UNSIGN.getCode()));
        info.setOrgId(Integer.valueOf(org_id));
        info.setCreateTime(time);
        info.setUpdateTime(time);
        this.orgInfoDao.save((Object)info, new String[0]);
    }

    @Override
    public void modCampus(ModCampusRequest modCampusRequest) throws BussinessException, Exception {
        OrgInfo orgInfo;
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(modCampusRequest.getCampusNumber());
        if (orgAccount == null) {
            return;
        }
        boolean subChange = false;
        OrgSubAccount subAccount = null;
        boolean isMaster = false;
        if (modCampusRequest.getCampusType().intValue() == CampusType.MASTER.getCode().intValue()) {
            isMaster = true;
            subAccount = this.orgSubAccountService.getMaster(orgAccount.getId());
        } else {
            log.debug("mod subCampus orgId:{},pid:{}", (Object)orgAccount.getId(), (Object)TianxiaoPCContext.getOrgId());
            subAccount = this.orgSubAccountService.getSlaveIgnoreStatus(orgAccount.getId(), TianxiaoPCContext.getOrgId());
        }
        if (subAccount == null) {
            log.error("Oops! check orgsubAccount data! orgId:{}", (Object)orgAccount.getId());
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)modCampusRequest.getPrincipal())) {
            subAccount.setComment(modCampusRequest.getPrincipal());
            subAccount.setUpdateTime(new Date());
            subChange = true;
        }
        if (StringUtils.isNotBlank((CharSequence)modCampusRequest.getCoverUrl())) {
            subAccount.setCoverUrl(modCampusRequest.getCoverUrl());
            subAccount.setUpdateTime(new Date());
            subChange = true;
        }
        log.info("modCampusRequest is :{} and isMaster:{} ,and orgSubAccount is :{} ", new Object[]{modCampusRequest, isMaster, subAccount});
        if (modCampusRequest.getOrgWechatType() != null && !isMaster && subAccount.getOrgWechatType() != modCampusRequest.getOrgWechatType()) {
            log.info("will add ");
            this.checkoutWechatSetting(TianxiaoPCContext.getOrgId(), orgAccount.getId(), modCampusRequest.getOrgWechatType());
            subAccount.setOrgWechatType(modCampusRequest.getOrgWechatType());
            subAccount.setUpdateTime(new Date());
            subChange = true;
            if (modCampusRequest.getOrgWechatType() == 1) {
                this.unifiedWechatAccountService.deleteSlaveCampus(orgAccount.getId(), TianxiaoPCContext.getOrgId());
            }
        }
        if (subChange) {
            this.orgSubAccountService.update(subAccount);
        }
        if ((orgInfo = this.orgInfoDao.getOrgInfo(orgAccount.getId(), new String[0])) == null) {
            log.error("Oops! check orgInfo data! orgId:{}", (Object)orgAccount.getId());
            return;
        }
        boolean orgInfoChange = false;
        if (StringUtils.isNotBlank((CharSequence)modCampusRequest.getCampusName())) {
            orgInfo.setShortName(modCampusRequest.getCampusName());
            orgInfoChange = true;
        }
        if (modCampusRequest.getAreaId() != null && modCampusRequest.getAreaId() > 0L) {
            orgInfo.setAreaId(modCampusRequest.getAreaId());
            orgInfoChange = true;
        }
        if (StringUtils.isNotBlank((CharSequence)modCampusRequest.getPrincipal())) {
            orgInfo.setContacts(modCampusRequest.getPrincipal());
        }
        if (orgInfoChange) {
            orgInfo.setUpdateTime(new Date());
            this.orgInfoDao.update((Object)orgInfo, new String[0]);
        }
    }

    @Override
    public void delCampus(Integer campusNumber) {
        OrgAccount orgAccount = this.orgAccountDao.getAccountByNumber(campusNumber, new String[0]);
        if (null == orgAccount) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u673a\u6784!");
        }
        OrgSubAccount orgSubAccount = this.orgSubAccountService.getByOrgId(orgAccount.getId(), new String[0]);
        if (null == orgSubAccount) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b50\u6821\u533a!");
        }
        if (Flag.TRUE.getInt() == orgSubAccount.getOnlineType().intValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7ebf\u4e0a\u6821\u533a\u4e0d\u652f\u6301\u5220\u9664!");
        }
        List cascadeAccountList = this.txCascadeAccountDao.getTXCascadeAccountListByOrgId(Long.valueOf(orgAccount.getId().longValue()));
        for (TXCascadeAccount cascadeAccount : cascadeAccountList) {
            try {
                this.releaseConsulter(cascadeAccount.getId().longValue());
                this.orgCourseDao.batchUpdateHeadTeacher(orgAccount.getNumber(), cascadeAccount.getId(), Integer.valueOf(-1));
            }
            catch (Exception e) {
                log.error("modDirectorStatus - releaseConsulter - cascadeAccount:{}", (Object)cascadeAccount.getId());
                log.error("modDirectorStatus - releaseConsulter - error:{}", (Throwable)e);
                throw new BusinessException("\u91ca\u653e\u7ebf\u7d22\u5931\u8d25\uff0c\u53ef\u5c1d\u8bd5\u624b\u52a8\u6e05\u7a7a\u8d26\u53f7\u7ebf\u7d22\u540e\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002");
            }
        }
        this.unifiedWechatAccountService.deleteSlaveCampus(orgAccount.getId(), TianxiaoPCContext.getOrgId());
        log.info("success to remove slave campus :{} with masterOrgId:{}", (Object)orgAccount.getId(), (Object)TianxiaoPCContext.getOrgId());
        this.delInHag(orgAccount.getNumber());
        this.orgSubAccountDao.deleteByOrgid(orgAccount.getId().intValue());
        this.txCascadeAccountDao.deleteByOrgId(orgAccount.getId().intValue());
    }

    @Override
    public List<CampusAccountDto> getAccountList(OrgAccount orgAccount, PageDto pageDto, boolean isAll) throws BussinessException, Exception {
        Map orgInfoMap;
        Object orgAccountMap;
        HashSet credentialIds;
        HashSet cascadeAccountOrgIds;
        List cascadeAccounts;
        int curPageCount;
        List subAccounts;
        List<CampusAccountDto> data = Lists.newArrayList();
        TXAccount txAccount = this.txAccountDao.getByOrgId(orgAccount.getId(), TXAccountStatus.VALID.getCode(), new String[0]);
        HashMap txAccountMap = Maps.newHashMap();
        if (txAccount != null) {
            txAccountMap.put(txAccount.getOrgId(), txAccount);
        }
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgAccount.getId(), new String[0]);
        CampusAccountDto master = this.makeMasterDto(orgAccount, orgInfo);
        data.add(master);
        ArrayList orgIds = Lists.newArrayList();
        orgIds.add(orgAccount.getId());
        if (isAll && CollectionUtils.isNotEmpty((Collection)(subAccounts = this.orgSubAccountService.getSlavesIgnoreStatus(orgAccount.getId(), null)))) {
            ArrayList subAccountOrgIds = Lists.newArrayList();
            HashMap subAccountMap = Maps.newHashMap();
            for (OrgSubAccount subAccount : subAccounts) {
                subAccountOrgIds.add(subAccount.getOrgId());
                orgIds.add(subAccount.getOrgId());
                subAccountMap.put(subAccount.getOrgId(), subAccount);
            }
            Map slaveAccountMap = this.orgAccountService.getOrgAccountMap((List)subAccountOrgIds);
            Map slaveInfoMap = this.orgInfoDao.getOrgInfoMap((Collection)subAccountOrgIds, new String[0]);
            List<CampusAccountDto> slaves = this.makeSlaveDto(slaveAccountMap, slaveInfoMap, subAccountMap, txAccount);
            data.addAll(slaves);
        }
        if ((curPageCount = (pageDto.getPageNum() - 1) * pageDto.getPageSize()) == 0) {
            if (data.size() >= pageDto.getPageSize()) {
                data = data.subList(0, pageDto.getPageSize());
            } else {
                pageDto.setPageSize(Integer.valueOf(pageDto.getPageSize() - data.size()));
                cascadeAccounts = this.txCascadeAccountDao.getByOrgIds((List)orgIds, pageDto);
                if (CollectionUtils.isNotEmpty((Collection)cascadeAccounts)) {
                    cascadeAccountOrgIds = Sets.newHashSet();
                    credentialIds = Sets.newHashSet();
                    for (TXCascadeAccount cascadeAccount : cascadeAccounts) {
                        cascadeAccountOrgIds.add(cascadeAccount.getOrgId());
                        credentialIds.add(cascadeAccount.getCredentialId());
                    }
                    orgAccountMap = this.orgAccountService.getOrgAccountMap(new ArrayList(cascadeAccountOrgIds));
                    orgInfoMap = this.orgInfoDao.getOrgInfoMap(new ArrayList(cascadeAccountOrgIds), new String[0]);
                    Map credentialMap = this.txCascadeCredentialDao.getCredentialMap(new ArrayList(credentialIds));
                    List<CampusAccountDto> dtos = this.makeCascadeDto((Map<Integer, OrgAccount>)orgAccountMap, orgInfoMap, credentialMap, cascadeAccounts, txAccountMap);
                    data.addAll(dtos);
                }
            }
        } else if (data.size() >= curPageCount) {
            if ((data = data.subList(curPageCount, data.size())).size() >= pageDto.getPageSize()) {
                data.subList(0, pageDto.getPageSize());
            } else {
                pageDto.setCurPageCount(Integer.valueOf(0));
                pageDto.setPageSize(Integer.valueOf(pageDto.getPageSize() - data.size()));
                cascadeAccounts = this.txCascadeAccountDao.getByOrgIds((List)orgIds, pageDto);
                if (CollectionUtils.isNotEmpty((Collection)cascadeAccounts)) {
                    cascadeAccountOrgIds = Sets.newHashSet();
                    credentialIds = Sets.newHashSet();
                    for (TXCascadeAccount cascadeAccount : cascadeAccounts) {
                        cascadeAccountOrgIds.add(cascadeAccount.getOrgId());
                        credentialIds.add(cascadeAccount.getCredentialId());
                    }
                    orgAccountMap = this.orgAccountService.getOrgAccountMap(new ArrayList(cascadeAccountOrgIds));
                    orgInfoMap = this.orgInfoDao.getOrgInfoMap(new ArrayList(cascadeAccountOrgIds), new String[0]);
                    Map credentialMap = this.txCascadeCredentialDao.getCredentialMap(new ArrayList(credentialIds));
                    List<CampusAccountDto> dtos = this.makeCascadeDto((Map<Integer, OrgAccount>)orgAccountMap, orgInfoMap, credentialMap, cascadeAccounts, txAccountMap);
                    data.addAll(dtos);
                }
            }
        } else {
            pageDto.setCurPageCount(Integer.valueOf(curPageCount - data.size()));
            log.debug("getAccountList the 3pageDto is:{}", (Object)pageDto);
            data.clear();
            cascadeAccounts = this.txCascadeAccountDao.getByOrgIds((List)orgIds, pageDto);
            log.debug("getAccountList the cascadeAccounts is:{}", (Object)cascadeAccounts);
            if (CollectionUtils.isNotEmpty((Collection)cascadeAccounts)) {
                cascadeAccountOrgIds = Sets.newHashSet();
                credentialIds = Sets.newHashSet();
                for (TXCascadeAccount cascadeAccount : cascadeAccounts) {
                    cascadeAccountOrgIds.add(cascadeAccount.getOrgId());
                    credentialIds.add(cascadeAccount.getCredentialId());
                }
                orgAccountMap = this.orgAccountService.getOrgAccountMap(new ArrayList(cascadeAccountOrgIds));
                orgInfoMap = this.orgInfoDao.getOrgInfoMap(new ArrayList(cascadeAccountOrgIds), new String[0]);
                Map credentialMap = this.txCascadeCredentialDao.getCredentialMap(new ArrayList(credentialIds));
                List<CampusAccountDto> dtos = this.makeCascadeDto((Map<Integer, OrgAccount>)orgAccountMap, orgInfoMap, credentialMap, cascadeAccounts, txAccountMap);
                data.addAll(dtos);
            }
        }
        Integer count = this.txCascadeAccountDao.getCountByOrgIds((List)orgIds, null);
        log.debug("the length of orgIds is:{},the casAcc count is:{}", (Object)orgIds.size(), (Object)count);
        pageDto.setCount(Integer.valueOf(count + orgIds.size()));
        return data;
    }

    private List<CampusAccountDto> makeCascadeDto(Map<Integer, OrgAccount> orgAccountMap, Map<Integer, OrgInfo> orgInfoMap, Map<Integer, TXCascadeCredential> credentialMap, List<TXCascadeAccount> cascadeAccounts, Map<Integer, TXAccount> txAccountMap) {
        ArrayList data = Lists.newArrayList();
        for (TXCascadeAccount cascadeAccount : cascadeAccounts) {
            OrgSubAccount orgSubAccount;
            OrgAccount orgAccount = orgAccountMap.get(cascadeAccount.getOrgId());
            OrgInfo orgInfo = orgInfoMap.get(cascadeAccount.getOrgId());
            TXCascadeCredential credential = credentialMap.get(cascadeAccount.getCredentialId());
            TXAccount txAccount = txAccountMap.get(cascadeAccount.getOrgId());
            if (orgAccount == null || orgInfo == null || credential == null) continue;
            CampusAccountDto dto = new CampusAccountDto();
            dto.setType(cascadeAccount.getAccountType());
            dto.setCampusName(orgInfo.getShortName());
            dto.setCampusNumber(orgAccount.getNumber());
            if (txAccount != null && txAccount.getOrgId().intValue() == cascadeAccount.getOrgId().intValue()) {
                orgSubAccount = this.orgSubAccountService.getByOrgId(orgAccount.getId(), new String[0]);
                dto.setOnlineType(orgSubAccount.getOnlineType());
                dto.setOnlineTypeName(OnlineType.getLable(dto.getOnlineType()));
                dto.setCampusType(CampusType.MASTER.getCode());
            } else if (txAccount != null) {
                orgSubAccount = this.orgSubAccountService.getByOrgId(orgAccount.getId(), new String[0]);
                dto.setCampusType(orgSubAccount.getAccountType());
                dto.setOnlineType(orgSubAccount.getOnlineType());
                dto.setOnlineTypeName(OnlineType.getLable(dto.getOnlineType()));
            } else {
                orgSubAccount = this.orgSubAccountService.getByOrgId(orgAccount.getId(), new String[0]);
                if (orgSubAccount != null) {
                    dto.setCampusType(orgSubAccount.getAccountType());
                    dto.setOnlineType(orgSubAccount.getOnlineType());
                    dto.setOnlineTypeName(OnlineType.getLable(dto.getOnlineType()));
                    txAccount = this.txAccountDao.getByOrgId(orgSubAccount.getPid(), TXAccountStatus.VALID.getCode(), new String[0]);
                    txAccountMap.put(cascadeAccount.getOrgId(), txAccount);
                }
            }
            dto.setName(credential.getName());
            dto.setMobile(credential.getMobile());
            dto.setStatus(cascadeAccount.getStatus());
            dto.setTitle(cascadeAccount.getTitle());
            dto.setCascadeId(cascadeAccount.getId());
            Map txAccountPermissions = this.txAccountPermissionService.getPMapByUidLevelRoleDevice(Long.valueOf(cascadeAccount.getOrgId().longValue()), cascadeAccount.getId(), txAccount.getVipLevel(), cascadeAccount.getAccountType(), null);
            List Permissions = this.txPermissionService.getAllByPid(new ArrayList(txAccountPermissions.keySet()));
            ArrayList<TXPermissionNodeDto> result = new ArrayList<TXPermissionNodeDto>();
            for (TXPermission txPermission : Permissions) {
                TxAccountPermission txAccountPermission = (TxAccountPermission)txAccountPermissions.get(txPermission.getId());
                TXPermissionNodeDto nodeDto = new TXPermissionNodeDto();
                nodeDto.setCode(txPermission.getCode());
                nodeDto.setName(txPermission.getName());
                nodeDto.setType(txAccountPermission.getPType());
                result.add(nodeDto);
            }
            dto.setAuthList(result);
            data.add(dto);
        }
        return data;
    }

    private List<CampusAccountDto> makeSlaveDto(Map<Integer, OrgAccount> orgAccountMap, Map<Integer, OrgInfo> orgInfoMap, Map<Integer, OrgSubAccount> subAccountMap, TXAccount txAccount) {
        Map txAccountPermissions = this.txAccountPermissionService.getPMapByUidLevelRoleDevice(null, null, txAccount.getVipLevel(), RoleType.BRANCH_SCH_PRESIDENT.type, null);
        List Permissions = this.txPermissionService.getAllByPid(new ArrayList(txAccountPermissions.keySet()));
        ArrayList data = Lists.newArrayList();
        for (Integer orgId : orgAccountMap.keySet()) {
            OrgAccount orgAccount = orgAccountMap.get(orgId);
            OrgInfo orgInfo = orgInfoMap.get(orgId);
            OrgSubAccount subAccount = subAccountMap.get(orgId);
            if (orgAccount == null || orgInfo == null || subAccount == null) continue;
            CampusAccountDto dto = new CampusAccountDto();
            dto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
            dto.setOnlineType(subAccount.getOnlineType());
            dto.setOnlineTypeName(OnlineType.getLable(dto.getOnlineType()));
            dto.setCampusType(subAccount.getAccountType());
            dto.setCampusName(orgInfo.getShortName());
            dto.setCampusNumber(orgAccount.getNumber());
            dto.setName(orgInfo.getContacts());
            dto.setMobile(orgAccount.getMobile());
            dto.setStatus(subAccount.getStatus());
            dto.setTitle(CampusAccountType.SLAVE_PRINCIPAL.getLabel());
            log.debug("makeSlaveDto orgAccount is:{}", (Object)orgAccount);
            log.debug("makeSlaveDto txAccount is:{}", (Object)txAccount);
            ArrayList<TXPermissionNodeDto> result = new ArrayList<TXPermissionNodeDto>();
            for (TXPermission txPermission : Permissions) {
                TxAccountPermission txAccountPermission = (TxAccountPermission)txAccountPermissions.get(txPermission.getId());
                TXPermissionNodeDto nodeDto = new TXPermissionNodeDto();
                nodeDto.setCode(txPermission.getCode());
                nodeDto.setName(txPermission.getName());
                nodeDto.setType(txAccountPermission.getPType());
                result.add(nodeDto);
            }
            dto.setAuthList(result);
            data.add(dto);
        }
        return data;
    }

    private CampusAccountDto makeMasterDto(OrgAccount orgAccount, OrgInfo orgInfo) {
        CampusAccountDto dto = new CampusAccountDto();
        dto.setType(CampusAccountType.MASTER_PRINCIPAL.getCode());
        dto.setCampusType(CampusType.MASTER.getCode());
        dto.setCampusName(orgInfo.getShortName());
        dto.setCampusNumber(orgAccount.getNumber());
        dto.setName(orgInfo.getContacts());
        dto.setMobile(orgAccount.getMobile());
        dto.setTitle(CampusAccountType.MASTER_PRINCIPAL.getLabel());
        Map txAccountPermissions = null;
        TXAccount txAccount = this.txAccountService.getTXAccountByOrgId(orgAccount.getId(), new String[0]);
        OrgSubAccount orgSubAccount = this.orgSubAccountService.getByOrgId(orgAccount.getId(), new String[0]);
        if (null != orgSubAccount && orgSubAccount.getPid() > 0) {
            txAccount = this.txAccountDao.getByOrgId(orgSubAccount.getPid(), TXAccountStatus.VALID.getCode(), new String[0]);
            dto.setOnlineType(orgSubAccount.getOnlineType());
            dto.setOnlineTypeName(OnlineType.getLable(dto.getOnlineType()));
            dto.setCampusType(orgSubAccount.getAccountType());
            dto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
            dto.setTitle(CampusAccountType.SLAVE_PRINCIPAL.getLabel());
            txAccountPermissions = this.txAccountPermissionService.getPMapByUidLevelRoleDevice(Long.valueOf(orgAccount.getId().longValue()), null, txAccount.getVipLevel(), RoleType.BRANCH_SCH_PRESIDENT.type, null);
            dto.setStatus(orgSubAccount.getStatus());
        } else {
            txAccountPermissions = this.txAccountPermissionService.getPMapByUidLevelRoleDevice(Long.valueOf(orgAccount.getId().longValue()), null, txAccount.getVipLevel(), RoleType.PRESIDENT.type, null);
            dto.setStatus(CampusAccountStatus.NORMAL.getCode());
            dto.setOnlineType(orgSubAccount.getOnlineType());
            dto.setOnlineTypeName(OnlineType.getLable(dto.getOnlineType()));
        }
        List Permissions = this.txPermissionService.getAllByPid(new ArrayList(txAccountPermissions.keySet()));
        ArrayList<TXPermissionNodeDto> result = new ArrayList<TXPermissionNodeDto>();
        for (TXPermission txPermission : Permissions) {
            TxAccountPermission txAccountPermission = (TxAccountPermission)txAccountPermissions.get(txPermission.getId());
            TXPermissionNodeDto nodeDto = new TXPermissionNodeDto();
            nodeDto.setCode(txPermission.getCode());
            nodeDto.setName(txPermission.getName());
            nodeDto.setType(txAccountPermission.getPType());
            result.add(nodeDto);
        }
        dto.setAuthList(result);
        return dto;
    }

    public static void main(String[] args) {
        List list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        list.add(5);
        list.add(6);
        list = list.subList(5, list.size());
        System.out.println(list);
    }

    @Override
    public boolean addAccount(AddAccountRequest request) {
        TXAccount txAccount = this.txAccountDao.getByOrgId(TianxiaoPCContext.getOrgId(), TXAccountStatus.VALID.getCode(), new String[0]);
        if (txAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.SIGN_INVALIDATE);
        }
        ArrayList orgIds = Lists.newArrayList();
        orgIds.add(TianxiaoPCContext.getOrgId());
        List subAccounts = this.orgSubAccountService.getSlavesIgnoreStatus(TianxiaoPCContext.getOrgId(), null);
        if (CollectionUtils.isNotEmpty((Collection)subAccounts)) {
            for (OrgSubAccount subAccount : subAccounts) {
                orgIds.add(subAccount.getOrgId());
            }
        }
        boolean sendSms = false;
        Integer count = this.txCascadeAccountDao.getCountByOrgIds((List)orgIds);
        if (count + 1 > txAccount.getCascadeAccountCount() - txAccount.getCampusCount()) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.EXCESS_CASCADE_ACCOUNT_COUNT);
        }
        OrgAccount master = this.orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        TXCascadeCredential credential = this.txCascadeCredentialDao.getByMobile(request.getMobile());
        if (credential == null) {
            credential = new TXCascadeCredential();
            credential.setCreateTime(new Date());
            credential.setMobile(request.getMobile());
            credential.setName(request.getName());
            OrgAccount credentialOrg = this.orgAccountService.getOrgAccountByMobile(request.getMobile());
            if (credentialOrg == null) {
                credential.setPassword(PasswordUtil.createHash((String)"a123456"));
                sendSms = true;
            }
            this.txCascadeCredentialDao.save((Object)credential, new String[0]);
        }
        TXCascadeAccount txCascadeAccount = new TXCascadeAccount();
        txCascadeAccount.setAccountType(request.getType());
        txCascadeAccount.setCreateTime(new Date());
        txCascadeAccount.setCredentialId(credential.getId());
        txCascadeAccount.setOrgId(master.getId());
        txCascadeAccount.setStatus(TXCascadeAccountStatus.VALID.getCode());
        txCascadeAccount.setTitle(request.getTitle());
        this.txCascadeAccountDao.save((Object)txCascadeAccount, new String[0]);
        TXAccount superAcc = this.findSuperTXAccount(txCascadeAccount);
        this.modPermission(txCascadeAccount, request, superAcc);
        boolean sendResult = false;
        if (sendSms) {
            try {
                sendResult = SmsSendUtil.sendSms((String)request.getMobile(), (String)TxSmsCodeType.getSmsMsg((TxSmsCodeType)TxSmsCodeType.NEW_ORG_PWD, (String)"a123456"), (Integer)SmsMessageType.TIANXIAO_NOTIFY.getCode(), (Integer)TianxiaoPCContext.getOrgId(), (Integer)UserRole.ORGANIZATION.getRole(), (boolean)true, (Integer)this.txAccountService.getTxAccountSmsGate(TianxiaoPCContext.getOrgId()));
            }
            catch (Throwable e) {
                log.error("send invite campus sms error:", e);
            }
            if (!sendResult) {
                log.error("send invite campus sms to :{} error:{}!code :{}", new Object[]{request.getMobile(), sendResult, "a123456"});
            } else {
                log.info("send default campus pwd sms to :{} error:{}!code :{}", new Object[]{request.getMobile(), sendResult, "a123456"});
            }
        }
        return sendResult;
    }

    @Override
    public void modAccount(ModAccountRequest request) {
        CampusAccountType accountType = CampusAccountType.getTypeByCode((int)request.getType());
        switch (accountType) {
            case MASTER_PRINCIPAL: {
                this.modMasterPrincipal(request);
                break;
            }
            case SLAVE_PRINCIPAL: {
                this.modSlavePrincipal(request);
                break;
            }
            case DIRECTOR: {
                this.modDirector(request);
                break;
            }
            case STAFF: {
                this.modDirector(request);
                break;
            }
        }
    }

    @Override
    public void delAccount(ModAccountRequest request) {
        if (request.getType().intValue() != CampusAccountType.DIRECTOR.getCode().intValue() && request.getType().intValue() != CampusAccountType.STAFF.getCode().intValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53ea\u80fd\u5220\u9664\u5458\u5de5\u6216\u4e3b\u7ba1!");
        }
        TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)request.getCascadeId(), new String[0]);
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(cascadeAccount.getOrgId().intValue(), new String[0]);
        try {
            this.releaseConsulter(cascadeAccount.getId().longValue());
            this.orgCourseDao.batchUpdateHeadTeacher(orgAccount.getNumber(), cascadeAccount.getId(), Integer.valueOf(-1));
        }
        catch (Exception e) {
            log.error("modDirectorStatus - releaseConsulter - cascadeAccount:{}", (Object)cascadeAccount.getId());
            log.error("modDirectorStatus - releaseConsulter - error:{}", (Throwable)e);
            throw new BusinessException("\u91ca\u653e\u7ebf\u7d22\u5931\u8d25\uff0c\u53ef\u5c1d\u8bd5\u624b\u52a8\u6e05\u7a7a\u8d26\u53f7\u7ebf\u7d22\u540e\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002");
        }
        this.txCascadeAccountDao.deleteById(request.getCascadeId().intValue());
    }

    private void modMasterPrincipal(ModAccountRequest request) {
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        if (StringUtils.isNotBlank((CharSequence)request.getMobile()) && !orgAccount.getMobile().equals(request.getMobile())) {
            if (StringUtils.isBlank((CharSequence)request.getCode())) {
                throw new BussinessException((UniverseErrorCode)SMSErrorCode.CODE_INVALID);
            }
            if (!VerifyCodeUtil.valid((boolean)false, (String)orgAccount.getMobile(), (String)request.getCode(), (String)TxSmsCodeType.MOD_ORG_MOBILE.getCacheKey())) {
                throw new BussinessException((UniverseErrorCode)SMSErrorCode.CODE_INVALID);
            }
            orgAccount.setMobile(request.getMobile());
            this.orgAccountDao.update((Object)orgAccount, new String[0]);
            OrgSubAccount orgSubAccount = this.orgSubAccountService.getByOrgId(orgAccount.getId(), new String[0]);
            orgSubAccount.setAccountVersion(Integer.valueOf(orgSubAccount.getAccountVersion() + 1));
            this.orgSubAccountService.update(orgSubAccount);
        }
        if (StringUtils.isNotBlank((CharSequence)request.getName())) {
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgAccount.getId(), new String[0]);
            orgInfo.setContacts(request.getName());
            this.orgInfoDao.update((Object)orgInfo, new String[0]);
        }
    }

    private void modSlavePrincipal(ModAccountRequest request) {
        OrgSubAccount orgSubAccount;
        if (request.getCampusNumber() == null || StringUtils.isEmpty((CharSequence)request.getCampusName())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.REQUIRE_PARAM);
        }
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        if (orgAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.REQUIRE_PARAM);
        }
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgAccount.getId(), new String[0]);
        orgInfo.setShortName(request.getCampusName());
        orgInfo.setContacts(request.getName());
        orgInfo.setUpdateTime(new Date());
        this.orgInfoDao.update((Object)orgInfo, new String[0]);
        if (!request.getMobile().equals(orgAccount.getMobile()) && (orgSubAccount = this.orgSubAccountService.getSlaveIgnoreStatus(orgAccount.getId(), TianxiaoPCContext.getOrgId())) != null) {
            if (orgSubAccount.getAccountType().intValue() == CampusType.LEAGUE.getCode().intValue()) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u52a0\u76df\u5206\u6821\u4e0d\u652f\u6301\u4fee\u6539\u7535\u8bdd\uff0c\u8bf7\u8054\u7cfb\u5e08\u8d44");
            }
            OrgAccount temp = this.orgAccountService.getOrgAccountByMobile(request.getMobile());
            if (temp != null) {
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.MOBILE_EXIST);
            }
            orgAccount.setMobile(request.getMobile());
            orgAccount.setUpdateTime(new Date());
            this.orgAccountDao.update((Object)orgAccount, new String[0]);
            orgSubAccount.setAccountVersion(Integer.valueOf(orgSubAccount.getAccountVersion() + 1));
            this.orgSubAccountService.update(orgSubAccount);
        }
    }

    private void modDirector(ModAccountRequest request) {
        if (request.getCampusNumber() == null || request.getCascadeId() == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.REQUIRE_PARAM);
        }
        TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)request.getCascadeId(), new String[0]);
        TXCascadeCredential credential = (TXCascadeCredential)this.txCascadeCredentialDao.getById((Serializable)cascadeAccount.getCredentialId(), new String[0]);
        if (cascadeAccount == null || credential == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        if (cascadeAccount.getOrgId().intValue() != orgAccount.getId().intValue()) {
            try {
                this.releaseConsulter(cascadeAccount.getId().longValue());
                this.orgCourseDao.batchUpdateHeadTeacher(((OrgAccount)this.orgAccountDao.getById((Serializable)cascadeAccount.getOrgId(), new String[0])).getNumber(), cascadeAccount.getId(), Integer.valueOf(-1));
            }
            catch (Exception e) {
                log.error("modDirectorStatus - releaseConsulter - cascadeAccount:{}", (Object)cascadeAccount.getId());
                log.error("modDirectorStatus - releaseConsulter - error:{}", (Throwable)e);
                throw new BusinessException("\u91ca\u653e\u7ebf\u7d22\u5931\u8d25\uff0c\u53ef\u5c1d\u8bd5\u624b\u52a8\u6e05\u7a7a\u8d26\u53f7\u7ebf\u7d22\u540e\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002");
            }
            cascadeAccount.setOrgId(orgAccount.getId());
        }
        cascadeAccount.setTitle(request.getTitle());
        cascadeAccount.setUpdateTime(new Date());
        cascadeAccount.setAccountVersion(Integer.valueOf(cascadeAccount.getAccountVersion() + 1));
        this.txCascadeAccountDao.update((Object)cascadeAccount, new String[0]);
        if (!credential.getMobile().equals(request.getMobile())) {
            TXCascadeCredential temp = this.txCascadeCredentialDao.getByMobile(request.getMobile());
            if (temp == null) {
                credential.setName(request.getName());
                credential.setUpdateTime(new Date());
                credential.setMobile(request.getMobile());
                OrgAccount credentialOrg = this.orgAccountService.getOrgAccountByMobile(request.getMobile());
                if (credentialOrg == null) {
                    credential.setPassword(PasswordUtil.createHash((String)"a123456"));
                    boolean sendResult = false;
                    try {
                        sendResult = SmsSendUtil.sendSms((String)request.getMobile(), (String)TxSmsCodeType.getSmsMsg((TxSmsCodeType)TxSmsCodeType.NEW_CASCADE_PWD, (String)"a123456"), (Integer)SmsMessageType.TIANXIAO_NOTIFY.getCode(), (Integer)TianxiaoPCContext.getOrgId(), (Integer)UserRole.ORGANIZATION.getRole(), (boolean)true, (Integer)this.txAccountService.getTxAccountSmsGate(TianxiaoPCContext.getOrgId()));
                    }
                    catch (Throwable e) {
                        log.error("send invite campus sms error:", e);
                    }
                    if (!sendResult) {
                        log.error("send invite campus sms to :{} error:{}!code :{}", new Object[]{request.getMobile(), sendResult, "a123456"});
                    } else {
                        log.info("send default campus pwd sms to :{} error:{}!code :{}", new Object[]{request.getMobile(), sendResult, "a123456"});
                    }
                }
                this.txCascadeCredentialDao.update((Object)credential, new String[0]);
                this.txCascadeAccountDao.update((Object)cascadeAccount, new String[0]);
            } else {
                temp.setName(request.getName());
                temp.setUpdateTime(new Date());
                this.txCascadeCredentialDao.update((Object)temp, new String[0]);
                cascadeAccount.setCredentialId(temp.getId());
                cascadeAccount.setUpdateTime(new Date());
                cascadeAccount.setAccountVersion(Integer.valueOf(cascadeAccount.getAccountVersion() + 1));
                this.txCascadeAccountDao.update((Object)cascadeAccount, new String[0]);
            }
        } else {
            credential.setName(request.getName());
            credential.setUpdateTime(new Date());
            this.txCascadeCredentialDao.update((Object)credential, new String[0]);
        }
        TXAccount superAcc = this.findSuperTXAccount(cascadeAccount);
        this.modPermission(cascadeAccount, request, superAcc);
        this.modAccountType(cascadeAccount, request);
    }

    private TXAccount findSuperTXAccount(TXCascadeAccount cascadeAccount) {
        OrgSubAccount subAcc = this.orgSubAccountService.getByOrgId(cascadeAccount.getOrgId(), new String[0]);
        if (subAcc.getPid() == 0) {
            return this.txAccountDao.getByOrgId(subAcc.getOrgId(), TXAccountStatus.VALID.getCode(), new String[0]);
        }
        return this.txAccountDao.getByOrgId(subAcc.getPid(), TXAccountStatus.VALID.getCode(), new String[0]);
    }

    private void modAccountType(TXCascadeAccount cascadeAccount, ModAccountRequest request) {
        if (cascadeAccount.getAccountType().intValue() == request.getType().intValue()) {
            return;
        }
        if (request.getType().intValue() == CampusAccountType.DIRECTOR.getCode().intValue()) {
            cascadeAccount.setAccountType(request.getType());
            this.txCascadeAccountDao.update((Object)cascadeAccount, new String[0]);
        }
        if (request.getType().intValue() == CampusAccountType.STAFF.getCode().intValue()) {
            cascadeAccount.setAccountType(request.getType());
            this.txCascadeAccountDao.update((Object)cascadeAccount, new String[0]);
        }
    }

    private void modPermission(TXCascadeAccount cascadeAccount, AddAccountRequest request, TXAccount superAcc) {
        List txAccountPermissions = this.txAccountPermissionService.getAllPByUidLevelRoleDevice(Long.valueOf(cascadeAccount.getOrgId().longValue()), null, superAcc.getVipLevel(), cascadeAccount.getAccountType(), null);
        List<TXPermissionNodeDto> subAuths = request.getAuthList();
        Map allPCodeMap = this.txPermissionService.getAllTXPermissionsCodeMap();
        HashMap pCodeTypeMap = Maps.newHashMap();
        for (TXPermissionNodeDto nodeDto : subAuths) {
            pCodeTypeMap.put(((TXPermission)allPCodeMap.get(nodeDto.getCode())).getCode(), nodeDto.getType());
        }
        this.specialTypeOperate(pCodeTypeMap, cascadeAccount);
        HashMap pcMap = Maps.newHashMap();
        HashMap appMap = Maps.newHashMap();
        for (TxAccountPermission txAccountPermission : txAccountPermissions) {
            if (txAccountPermission.getDeviceType().intValue() == DeviceType.APP.getCode()) {
                appMap.put(txAccountPermission.getPId(), txAccountPermission);
            }
            if (txAccountPermission.getDeviceType().intValue() != DeviceType.PC.getCode()) continue;
            pcMap.put(txAccountPermission.getPId(), txAccountPermission);
        }
        Map allPIdMap = this.txPermissionService.getAllTXPermissionsIDMap();
        for (TXPermission txPermission : allPIdMap.values()) {
            TxAccountPermission pc = (TxAccountPermission)pcMap.get(txPermission.getId());
            Integer pTypeTemp = (Integer)pCodeTypeMap.get(txPermission.getCode());
            if (pTypeTemp != null) {
                pc.setPType(pTypeTemp);
            }
            TxAccountPermission app = (TxAccountPermission)appMap.get(txPermission.getId());
            pTypeTemp = (Integer)pCodeTypeMap.get(txPermission.getCode());
            if (pTypeTemp == null) continue;
            app.setPType(pTypeTemp);
        }
        List ownedPList = this.txAccountPermissionDao.listAllConfigs(null, null, cascadeAccount.getId(), Integer.valueOf(TXPermissionAccountType.CASCADE_ACCOUNT.getCode()));
        HashMap ownedPMap = Maps.newHashMap();
        for (TxAccountPermission tap : ownedPList) {
            if (tap.getDeviceType().equals(DeviceType.PC.getCode())) {
                ownedPMap.put("pc_" + tap.getPId(), tap);
                continue;
            }
            if (!tap.getDeviceType().equals(DeviceType.APP.getCode())) continue;
            ownedPMap.put("app_" + tap.getPId(), tap);
        }
        log.debug("the owned permission set size is:{}", (Object)ownedPMap.size());
        ArrayList updatePermissions = Lists.newArrayList();
        LinkedList savePermissions = Lists.newLinkedList();
        for (TxAccountPermission tap : txAccountPermissions) {
            TxAccountPermission temp;
            if (tap.getDeviceType().equals(DeviceType.PC.getCode())) {
                if (ownedPMap.containsKey("pc_" + tap.getPId())) {
                    temp = (TxAccountPermission)ownedPMap.get("pc_" + tap.getPId());
                    temp.setPType((Integer)pCodeTypeMap.get(((TXPermission)allPIdMap.get(tap.getPId())).getCode()));
                    updatePermissions.add(temp);
                    continue;
                }
                tap.setCreateTime(new Date());
                tap.setUId(cascadeAccount.getId());
                tap.setUpdateTime(new Date());
                savePermissions.add(tap);
                continue;
            }
            if (!tap.getDeviceType().equals(DeviceType.APP.getCode())) continue;
            if (ownedPMap.containsKey("app_" + tap.getPId())) {
                temp = (TxAccountPermission)ownedPMap.get("app_" + tap.getPId());
                temp.setPType((Integer)pCodeTypeMap.get(((TXPermission)allPIdMap.get(tap.getPId())).getCode()));
                updatePermissions.add(temp);
                continue;
            }
            tap.setCreateTime(new Date());
            tap.setUId(cascadeAccount.getId());
            tap.setUpdateTime(new Date());
            savePermissions.add(tap);
        }
        log.debug("the update permission list size is:{}", (Object)updatePermissions.size());
        this.txAccountPermissionService.updateAll((List)updatePermissions);
        log.debug("before pick save permission list size is:{}", (Object)savePermissions.size());
        OrgSubAccount orgSubAccount = this.orgSubAccountDao.getByOrgId(cascadeAccount.getOrgId(), new String[0]);
        Integer onlineType = orgSubAccount.getOnlineType();
        Integer pid = orgSubAccount.getPid();
        if (onlineType.intValue() == Flag.TRUE.getInt()) {
            this.pickPermissions(savePermissions, allPIdMap, TXPermissionConst.WANGXIAO_PERMISSION_SET);
        } else if (onlineType.intValue() == Flag.FALSE.getInt()) {
            if (pid == 0 && cascadeAccount.getAccountType() == RoleType.CHARAGE.type) {
                this.pickPermissions(savePermissions, allPIdMap, TXPermissionConst.NORMAL_PERMISSION_SET, TXPermissionConst.MAIN_CAMPUS_MANAGER_ADDITIONAL_PERMISSION_SET);
            } else {
                this.pickPermissions(savePermissions, allPIdMap, TXPermissionConst.NORMAL_PERMISSION_SET);
            }
        }
        log.debug("the save permission set size is:{}", (Object)savePermissions.size());
        this.txAccountPermissionService.saveAll((List)savePermissions);
    }

    private void pickPermissions(List<TxAccountPermission> savePermissions, Map<Integer, TXPermission> allPIdMap, Set<Long> ... controlSet) {
        Iterator<TxAccountPermission> iter = savePermissions.iterator();
        HashSet allSet = Sets.newHashSet();
        Arrays.stream(controlSet).forEach(set -> allSet.addAll(set));
        while (iter.hasNext()) {
            if (allSet.contains(allPIdMap.get(iter.next().getPId()).getCode())) continue;
            iter.remove();
        }
    }

    private void specialTypeOperate(Map<Long, Integer> pTypeMap, TXCascadeAccount cascadeAccount) {
        if (!this.overriewService.isMasterHead()) {
            TxAccountPermissionsDto pNow = this.txAccountPermissionService.universalGetPermissions(TianxiaoPCContext.getOrgId().intValue(), cascadeAccount.getId(), (Collection)Lists.newArrayList((Object[])new Long[]{TXPermissionConst.FINANCE_MANAGEMENT.getpCode()}));
            if (null == pNow | CollectionUtils.isEmpty((Collection)pNow.getAPPps()) | CollectionUtils.isEmpty((Collection)pNow.getPCps())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6743\u9650\u6821\u9a8c\u5f02\u5e38");
            }
            Integer hasType = ((TxAccountPermissionsDto.AccountPermissionDto)pNow.getAPPps().get(0)).getPType() | ((TxAccountPermissionsDto.AccountPermissionDto)pNow.getPCps().get(0)).getPType();
            if (!hasType.equals(pTypeMap.get((long)TXPermissionConst.FINANCE_MANAGEMENT.getpCode()))) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u603b\u6821\u4e3b\u7ba1\u65e0\u6cd5\u8bbe\u7f6e\u5b50\u5e10\u53f7\u8d44\u91d1\u7ba1\u7406\u6743\u9650!");
            }
        }
        HashMap tempMap = Maps.newHashMap();
        for (Long pCode : pTypeMap.keySet()) {
            if (!pCode.equals(TXPermissionConst.IF_CLASS_ARRANGE.getpCode()) || !pTypeMap.get(pCode).equals(TXPermissionHasType.OWN.getCode())) continue;
            if (cascadeAccount.getAccountType().intValue() == CascadeType.MANAGER.getValue()) {
                tempMap.put(pCode, TXPermissionHasType.OWN.getCode());
            }
            if (cascadeAccount.getAccountType().intValue() != CascadeType.STAFF.getValue()) continue;
            tempMap.put(pCode, TXPermissionHasType.LOST.getCode());
        }
        for (Long pCode : tempMap.keySet()) {
            pTypeMap.put(pCode, (Integer)tempMap.get(pCode));
        }
    }

    @Override
    public void modAccountStatus(ModAccountRequest request) {
        CampusAccountType accountType = CampusAccountType.getTypeByCode((int)request.getType());
        switch (accountType) {
            case SLAVE_PRINCIPAL: {
                this.modSlavePrincipalStatus(request);
                break;
            }
            case DIRECTOR: {
                this.modDirectorStatus(request);
                break;
            }
            case STAFF: {
                this.modDirectorStatus(request);
                break;
            }
        }
    }

    private void modSlavePrincipalStatus(ModAccountRequest request) {
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        OrgSubAccount subAccount = this.orgSubAccountService.getSlaveIgnoreStatus(orgAccount.getId(), TianxiaoPCContext.getOrgId());
        if (request.getStatus().intValue() == OrgSubAccountStatus.NORMAL.getCode().intValue()) {
            OrgSubAccount mainAcc = this.orgSubAccountService.getMaster(orgAccount.getId());
            if (null != mainAcc) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5\u8d26\u53f7\u5df2\u7ecf\u72ec\u7acb\u5f00\u901a\u5929\u6821\u8d26\u53f7,\u65e0\u6cd5\u542f\u7528");
            }
            subAccount.setStatus(request.getStatus());
            subAccount.setUpdateTime(new Date());
            this.orgSubAccountService.update(subAccount);
            this.addToHag(orgAccount.getNumber());
        }
        if (request.getStatus().intValue() == OrgSubAccountStatus.FIRE.getCode().intValue()) {
            subAccount.setStatus(request.getStatus());
            subAccount.setFireTime(new Date());
            subAccount.setUpdateTime(new Date());
            subAccount.setAccountVersion(Integer.valueOf(subAccount.getAccountVersion() + 1));
            this.orgSubAccountService.update(subAccount);
            this.delInHag(orgAccount.getNumber());
        }
    }

    private void delInHag(Integer orgNumber) {
        log.info("del hag orgNumber:{}", (Object)orgNumber);
        if (orgNumber == null) {
            return;
        }
        ArrayList entities = Lists.newArrayList();
        Entity entity = new Entity();
        entity.setName((Object)orgNumber);
        entities.add(entity);
        WebResponse result1 = this.hagService.delEntitiesOfResource(Long.valueOf(PropertiesReader.getValue((String)"hag", (String)"hag.token.id")), PropertiesReader.getValue((String)"hag", (String)"hag.token"), (Collection)entities, "jigou_tianxiao_orgNumber");
        log.info("del hag {} in {} result:{}", new Object[]{orgNumber, "jigou_tianxiao_orgNumber", result1});
        WebResponse result2 = this.hagService.delEntitiesOfResource(Long.valueOf(PropertiesReader.getValue((String)"hag", (String)"hag.token.id")), PropertiesReader.getValue((String)"hag", (String)"hag.token"), (Collection)entities, "jigou_3810_orgNumber");
        log.info("del hag {} in {} result:{}", new Object[]{orgNumber, "jigou_3810_orgNumber", result2});
        WebResponse result3 = this.hagService.delEntitiesOfResource(Long.valueOf(PropertiesReader.getValue((String)"hag", (String)"hag.token.id")), PropertiesReader.getValue((String)"hag", (String)"hag.token"), (Collection)entities, "jigou_tixian_orgNumber");
        log.info("del hag {} in {} result:{}", new Object[]{orgNumber, "jigou_tixian_orgNumber", result3});
    }

    private void modDirectorStatus(ModAccountRequest request) {
        TXAccount txAccount = this.txAccountDao.getByOrgId(TianxiaoPCContext.getOrgId(), TXAccountStatus.VALID.getCode(), new String[0]);
        if (request.getStatus().intValue() == TXCascadeAccountStatus.VALID.getCode().intValue()) {
            Integer count;
            if (txAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8d26\u6237\u4e0d\u5b58\u5728");
            }
            ArrayList orgIds = Lists.newArrayList();
            orgIds.add(TianxiaoPCContext.getOrgId());
            List subAccounts = this.orgSubAccountService.getSlavesIgnoreStatus(TianxiaoPCContext.getOrgId(), null);
            if (CollectionUtils.isNotEmpty((Collection)subAccounts)) {
                for (OrgSubAccount subAccount : subAccounts) {
                    orgIds.add(subAccount.getOrgId());
                }
            }
            if ((count = this.txCascadeAccountDao.getCountByOrgIds((List)orgIds)) + 1 > txAccount.getCascadeAccountCount() - txAccount.getCampusCount()) {
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.EXCESS_CASCADE_ACCOUNT_COUNT);
            }
        }
        TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)request.getCascadeId(), new String[0]);
        if (request.getStatus().intValue() == TXCascadeAccountStatus.VALID.getCode().intValue() || request.getStatus().intValue() == TXCascadeAccountStatus.PAUSE.getCode().intValue()) {
            cascadeAccount.setStatus(request.getStatus());
            cascadeAccount.setAccountVersion(Integer.valueOf(cascadeAccount.getAccountVersion() + 1));
            this.txCascadeAccountDao.update((Object)cascadeAccount, new String[0]);
            if (request.getStatus().intValue() == TXCascadeAccountStatus.PAUSE.getCode().intValue()) {
                try {
                    this.releaseConsulter(cascadeAccount.getId().longValue());
                    this.orgCourseDao.batchUpdateHeadTeacher(txAccount.getOrgNumber(), cascadeAccount.getId(), Integer.valueOf(-1));
                }
                catch (Exception e) {
                    log.error("modDirectorStatus - releaseConsulter - cascadeAccount:{}", (Object)cascadeAccount.getId());
                    log.error("modDirectorStatus - releaseConsulter - error:{}", (Throwable)e);
                    throw new BusinessException("\u91ca\u653e\u7ebf\u7d22\u5931\u8d25\uff0c\u53ef\u5c1d\u8bd5\u624b\u52a8\u6e05\u7a7a\u8d26\u53f7\u7ebf\u7d22\u540e\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002");
                }
            }
        }
    }

    public void releaseConsulter(Long cascadeId) {
        Date now = new Date();
        List consulterIds = this.consultUserDao.listConsulterUserIdsByCascade(cascadeId);
        log.info("modAccountStatus - consulter - Release - consulterIds:{}, size:{},time:{}", new Object[]{consulterIds, consulterIds.size(), now.getTime()});
        if (CollectionUtils.isNotEmpty((Collection)consulterIds)) {
            this.consultUserDao.release(consulterIds, now);
            ArrayList<TxConsulterOperationLog> manualLogs = new ArrayList<TxConsulterOperationLog>();
            for (int i = 0; i > consulterIds.size(); ++i) {
                TxConsulterOperationLog log = new TxConsulterOperationLog((Long)consulterIds.get(i), Long.valueOf(Flag.NULL.getLong()), Long.valueOf(Flag.NULL.getLong()), ConsulterOperation.PUSH_MANUAL);
                manualLogs.add(log);
                if (i % 100 != 0 && i != consulterIds.size() - 1) continue;
                this.txConsulterOperationLogDao.saveAll(manualLogs, new String[0]);
            }
        }
    }

    @Deprecated
    @Transactional(rollbackFor={Exception.class})
    public void enter(Integer orgNumber) throws Exception {
        TXAccount superAcc = this.txAccountDao.getByOrgNumber(orgNumber);
        Preconditions.checkNotNull((Object)superAcc);
        log.info("the superAcc is:{}", (Object)superAcc);
        this.fixData(superAcc);
    }

    @Deprecated
    private void fixData(TXAccount superAcc) throws Exception {
        int i = 0;
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(Integer.valueOf(1));
        pageDto.setPageSize(Integer.valueOf(999));
        OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)superAcc.getOrgId(), new String[0]);
        Preconditions.checkNotNull((Object)superAcc);
        log.info("find orgAccount done! account is:{}", (Object)orgAccount);
        List<CampusAccountDto> before = this.getAccountList(orgAccount, pageDto, true);
        log.info("\u627e\u5230\u4e86\u5b50\u5e10\u53f7 \u5171:{}\u4e2a", (Object)before.size());
        for (CampusAccountDto dto : before) {
            if (dto.getType() != 3 && dto.getType() != 4) continue;
            TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)dto.getCascadeId(), new String[0]);
            Preconditions.checkNotNull((Object)cascadeAccount);
            AddAccountRequest request = new AddAccountRequest();
            request.setName(dto.getName());
            request.setCampusNumber(dto.getCampusNumber());
            request.setMobile(dto.getMobile());
            request.setTitle(dto.getTitle());
            request.setType(dto.getType());
            request.setAuthList(dto.getAuthList());
            this.modPermission(cascadeAccount, request, superAcc);
            log.info("\u66f4\u65b0\u4e86{}\u4e2a!", (Object)i++);
        }
        log.info("done!");
    }
}

