
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.campus.dto;

import com.baijia.tianxiao.biz.campus.constant.SaleClueRuleValue;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;

import lombok.Data;

/**
 * @title SaleClueRuleDto
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年6月1日
 * @version 1.0
 */
@Data
public class SaleClueRuleDto {
    private Integer clueAllot;
    private Integer returnClue;
    private Integer clueTransValid;
    private Integer maxClueCount;
    private Integer maxClueDelay;
    private Integer attendClassMsg; // 上课提醒
    private Integer signupMsg; // 是否发送报名提醒
    private Integer signinMsg; // 是否发送签到提醒
    private Integer evaluateMsg; // 评价提醒

    public static SaleClueRuleDto from(TXSaleClueRule txSaleClueRule) {
        if (txSaleClueRule == null) {
            return null;
        }
        SaleClueRuleDto dto = new SaleClueRuleDto();
        dto.setClueAllot(txSaleClueRule.getClueAllot());
        dto.setClueTransValid(txSaleClueRule.getClueTransValid());
        dto.setMaxClueCount(txSaleClueRule.getMaxClueCount());
        dto.setMaxClueDelay(txSaleClueRule.getMaxClueDelay());
        dto.setReturnClue(txSaleClueRule.getReturnClue());
        dto.setAttendClassMsg(txSaleClueRule.getAttendClassMsg());
        dto.setSigninMsg(txSaleClueRule.getSigninMsg());
        dto.setSignupMsg(txSaleClueRule.getSignupMsg());
        dto.setEvaluateMsg(txSaleClueRule.getEvaluateMsg());
        return dto;
    }

    public boolean valid() {
        if (clueAllot != null) {
            if (clueAllot != SaleClueRuleValue.CLUE_ALLOT_AUTO_GET.getCode()
                && clueAllot != SaleClueRuleValue.CLUE_ALLOT_CAN_GET.getCode()
                && clueAllot != SaleClueRuleValue.CLUE_ALLOT_CAN_NOT_GET.getCode()) {
                return false;
            }
        }
        if (returnClue != null) {
            if (returnClue != SaleClueRuleValue.RETURN_CLUE_NO.getCode()
                && returnClue != SaleClueRuleValue.RETURN_CLUE_YES.getCode()) {
                return false;
            }
        }
        if (clueTransValid != null) {
            if (clueTransValid != SaleClueRuleValue.CLUE_TRANS_VALID_PRIVATE.getCode()
                && clueTransValid != SaleClueRuleValue.CLUE_TRANS_VALID_PUBLIC.getCode()) {
                return false;
            }
        }
        return true;
    }
}
