/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.campus.service.impl;

import com.baijia.tianxiao.biz.campus.constant.CampusType;
import com.baijia.tianxiao.biz.campus.dto.BaseCampusDto;
import com.baijia.tianxiao.biz.campus.dto.EnrollOverriew;
import com.baijia.tianxiao.biz.campus.dto.EnrollOverriewDto;
import com.baijia.tianxiao.biz.campus.dto.OverriewCampusDto;
import com.baijia.tianxiao.biz.campus.dto.OverriewCampusListDto;
import com.baijia.tianxiao.biz.campus.service.OverriewService;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXCascadeAccountStatus;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgFinanceAccountDto;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OverriewServiceImpl
implements OverriewService {
    private static final Logger log = LoggerFactory.getLogger(OverriewServiceImpl.class);
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private OrgTeacherDao orgTeacherDao;
    @Autowired
    private OrgStudentDao orgStudentDAo;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private TxFinanceRecordDayDao txFinanceRecordDayDao;
    @Autowired
    private OrgFinanceAccountService orgFinanceAccountService;

    @Override
    public List<OverriewCampusListDto> getCampusList(Integer orgId, PageDto pageDto) throws BussinessException, Exception {
        ArrayList data = Lists.newArrayList();
        List slaves = this.orgSubAccountService.getMasterAndSlaves(orgId, pageDto);
        ArrayList subOrgIds = Lists.newArrayList();
        ArrayList subOrgIdsLong = Lists.newArrayList();
        subOrgIds.add(orgId);
        subOrgIdsLong.add(orgId.longValue());
        if (CollectionUtils.isNotEmpty((Collection)slaves)) {
            for (OrgSubAccount ca : slaves) {
                subOrgIds.add(ca.getOrgId());
                subOrgIdsLong.add(ca.getOrgId().longValue());
            }
        }
        Map orgInfoMap = this.orgInfoService.getOrgInfoMap((List)subOrgIds);
        Map orgAccountMap = this.orgAccountService.getOrgAccountMap((List)subOrgIds);
        Map signupCountMap = this.orgSignupInfoDao.countSubOrgByTime((List)subOrgIds, null, null);
        Map teacherCountMap = this.orgTeacherDao.getSignedTeacherCountMap((List)subOrgIds);
        Map studentCountMap = this.orgStudentDAo.getStudentCountMap((List)subOrgIds);
        Map financeMap = this.txFinanceRecordDayDao.queryByOrgIds((List)subOrgIds, DateUtil.getStartOfMonth(), DateUtil.getEndOfMonth());
        Map financeAccountMap = this.orgFinanceAccountService.getAccountInfos((List)subOrgIdsLong);
        if (CollectionUtils.isNotEmpty((Collection)slaves)) {
            for (OrgSubAccount orgSubAccount : slaves) {
                OrgInfo orgInfo2 = (OrgInfo)orgInfoMap.get(orgSubAccount.getOrgId());
                OrgAccount orgAccount2 = (OrgAccount)orgAccountMap.get(orgSubAccount.getOrgId());
                if (orgInfo2 == null || orgAccount2 == null) continue;
                OverriewCampusListDto slave = new OverriewCampusListDto();
                slave.setCampusName(orgInfo2.getShortName());
                slave.setCampusNumber(orgAccount2.getNumber());
                slave.setCampusType(orgSubAccount.getAccountType());
                slave.setCampusTypeName(CampusType.getLabelByCode(orgSubAccount.getAccountType()));
                slave.setCoverUrl(orgSubAccount.getCoverUrl());
                OrgFinanceAccountDto dto = (OrgFinanceAccountDto)financeAccountMap.get((int)orgSubAccount.getOrgId());
                if (dto != null) {
                    Double balance = dto.getBalance() != null ? Double.parseDouble(dto.getBalance()) : 0.0;
                    Double freeze = dto.getFreeze_money() != null ? Double.parseDouble(dto.getFreeze_money()) : 0.0;
                    Double expected = dto.getExpected_earning() != null ? Double.parseDouble(dto.getExpected_earning()) : 0.0;
                    slave.setBalance(balance + freeze + expected);
                    Double income = (Double)financeMap.get(orgSubAccount.getOrgId());
                    slave.setIncomeSum(income != null ? income : 0.0);
                } else {
                    slave.setBalance(0.0);
                    Double income = (Double)financeMap.get(orgSubAccount.getOrgId());
                    slave.setIncomeSum(income != null ? income : 0.0);
                }
                slave.setEnrollSum(signupCountMap.get(orgAccount2.getId()) == null ? 0 : (Integer)signupCountMap.get(orgAccount2.getId()));
                slave.setStudentSum(studentCountMap.get(orgAccount2.getId()) == null ? 0 : (Integer)studentCountMap.get(orgAccount2.getId()));
                slave.setTeacherSum(teacherCountMap.get(orgAccount2.getId()) == null ? 0 : (Integer)teacherCountMap.get(orgAccount2.getId()));
                data.add(slave);
            }
        }
        return data;
    }

    @Override
    public OverriewCampusDto getCampusOverriew(Integer orgId) throws Exception {
        OverriewCampusDto data = new OverriewCampusDto();
        List slaves = this.orgSubAccountService.getSlaves(orgId, null);
        int teacherSum = 0;
        int studentSum = 0;
        ArrayList subOrgIds = Lists.newArrayList();
        ArrayList ids = Lists.newArrayList();
        ArrayList orgIds = Lists.newArrayList();
        orgIds.add(Long.valueOf(orgId.intValue()));
        subOrgIds.add(orgId);
        ids.add(orgId);
        if (CollectionUtils.isNotEmpty((Collection)slaves)) {
            for (OrgSubAccount slave : slaves) {
                if (slave.getStatus().intValue() == OrgSubAccountStatus.NORMAL.getCode().intValue()) {
                    subOrgIds.add(slave.getOrgId());
                    if (slave.getAccountType() != CampusType.LEAGUE.getCode()) {
                        ids.add(slave.getOrgId());
                    }
                }
                orgIds.add(Long.valueOf(slave.getOrgId().intValue()));
            }
        }
        teacherSum = this.orgTeacherDao.getSignedTeacherCount((List)orgIds);
        studentSum += this.orgStudentDAo.getStudentSum((List)orgIds).intValue();
        log.debug("enroll count week orgIds:{},start{},end{}", new Object[]{orgIds, DateUtil.getStartOfWeek(), DateUtil.getEndOfWeek()});
        log.debug("enroll count month orgIds:{},start{},end{}", new Object[]{orgIds, DateUtil.getStartOfMonth(), DateUtil.getEndOfMonth()});
        int weekEnroll = this.orgSignupInfoDao.countByTime((List)orgIds, DateUtil.getStartOfWeek(), DateUtil.getEndOfWeek());
        int monthEnroll = this.orgSignupInfoDao.countByTime((List)orgIds, DateUtil.getStartOfMonth(), DateUtil.getEndOfMonth());
        data.setMonthEnroll(monthEnroll);
        data.setStudentSum(studentSum);
        data.setWeekEnroll(weekEnroll);
        data.setTeacherSum(teacherSum);
        Double week = this.txFinanceRecordDayDao.getIncomes((List)ids, DateUtil.getStartOfWeek(), DateUtil.getEndOfWeek());
        Double month = this.txFinanceRecordDayDao.getIncomes((List)ids, DateUtil.getStartOfMonth(), DateUtil.getEndOfMonth());
        data.setWeekIncome(week);
        data.setMonthIncome(month);
        return data;
    }

    @Override
    public List<BaseCampusDto> getCampusList(Integer orgId) throws Exception {
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountById(orgId);
        ArrayList data = Lists.newArrayList();
        BaseCampusDto master = new BaseCampusDto();
        OrgInfoSimpleDto orgInfo = this.orgInfoService.getOrgInfo(Long.valueOf(orgId.intValue()));
        master.setCampusId(orgId);
        master.setCampusName(orgInfo.getShortName());
        master.setCampusNumber(orgAccount.getNumber());
        master.setCampusType(CampusType.MASTER.getCode());
        data.add(master);
        List slaves = this.orgSubAccountService.getSlaves(orgId, null);
        if (CollectionUtils.isNotEmpty((Collection)slaves)) {
            ArrayList orgIds = Lists.newArrayList();
            for (OrgSubAccount orgSubAccount : slaves) {
                orgIds.add(orgSubAccount.getOrgId());
            }
            Map orgAccountMap = this.orgAccountService.getOrgAccountMap((List)orgIds);
            Map orgInfoMap = this.orgInfoService.getOrgInfoMap((List)orgIds);
            for (OrgSubAccount orgSubAccount : slaves) {
                OrgAccount orgAccount2 = (OrgAccount)orgAccountMap.get(orgSubAccount.getOrgId());
                OrgInfo orgInfo2 = (OrgInfo)orgInfoMap.get(orgSubAccount.getOrgId());
                if (orgAccount2 == null || orgInfo2 == null) continue;
                BaseCampusDto slave = new BaseCampusDto();
                slave.setCampusId(orgSubAccount.getOrgId());
                slave.setCampusName(orgInfo2.getShortName());
                slave.setCampusNumber(orgAccount2.getNumber());
                slave.setCampusType(orgSubAccount.getAccountType());
                slave.setCampusTypeName(CampusType.getLabelByCode(orgSubAccount.getAccountType()));
                data.add(slave);
            }
        }
        return data;
    }

    @Override
    public EnrollOverriewDto enrollOverriew(Integer orgId) throws Exception {
        List slaves = this.orgSubAccountService.getSlaves(orgId, null);
        ArrayList orgIds = Lists.newArrayList();
        orgIds.add(orgId);
        if (CollectionUtils.isNotEmpty((Collection)slaves)) {
            for (OrgSubAccount slave : slaves) {
                orgIds.add(slave.getOrgId());
            }
        }
        EnrollOverriewDto data = new EnrollOverriewDto();
        int studentSum = 0;
        Date now = new Date();
        Date yestoday = DateUtil.getDayDiff((int)-1);
        ArrayList countOrgIds = Lists.newArrayList();
        for (Integer id : orgIds) {
            countOrgIds.add(Long.valueOf(id.intValue()));
        }
        studentSum = this.orgStudentDAo.getStudentSum((List)countOrgIds);
        int todayEnroll = this.orgSignupInfoDao.countByTime((List)countOrgIds, DateUtil.getStartOfDay((Date)now), DateUtil.getEndOfDay((Date)now));
        int yestodayEnroll = this.orgSignupInfoDao.countByTime((List)countOrgIds, DateUtil.getStartOfDay((Date)yestoday), DateUtil.getEndOfDay((Date)yestoday));
        int weekEnroll = this.orgSignupInfoDao.countByTime((List)countOrgIds, DateUtil.getStartOfWeek(), DateUtil.getEndOfWeek());
        int monthEnroll = this.orgSignupInfoDao.countByTime((List)countOrgIds, DateUtil.getStartOfMonth(), DateUtil.getEndOfMonth());
        data.setMonthEnroll(monthEnroll);
        data.setTodayEnroll(todayEnroll);
        data.setWeekEnroll(weekEnroll);
        data.setYestodayEnroll(yestodayEnroll);
        data.setStudentSum(studentSum);
        return data;
    }

    @Override
    public List<EnrollOverriew> enrollList(Integer orgNumber, Integer orgId, Date startTime, Date endTime, PageDto pageDto) throws BussinessException, Exception {
        ArrayList orgIds = Lists.newArrayList();
        ArrayList intOrgIds = Lists.newArrayList();
        if (orgNumber != null && orgNumber > 0) {
            OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(orgNumber);
            if (orgAccount != null) {
                orgIds.add(Long.valueOf(orgAccount.getId().intValue()));
                intOrgIds.add(orgAccount.getId());
            }
        } else {
            orgIds.add(Long.valueOf(orgId.intValue()));
            intOrgIds.add(orgId);
            List subAccounts = this.orgSubAccountService.getSlaves(orgId, null);
            if (CollectionUtils.isNotEmpty((Collection)subAccounts)) {
                for (OrgSubAccount subAccount : subAccounts) {
                    orgIds.add(Long.valueOf(subAccount.getOrgId().intValue()));
                    intOrgIds.add(subAccount.getOrgId());
                }
            }
        }
        ArrayList data = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            return data;
        }
        List orgSignupInfos = this.orgSignupInfoDao.getPurchases(startTime, endTime, (List)orgIds, pageDto);
        if (CollectionUtils.isEmpty((Collection)orgSignupInfos)) {
            return data;
        }
        ArrayList purchaseIds = Lists.newArrayList();
        ArrayList studentIds = Lists.newArrayList();
        for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
            purchaseIds.add(orgSignupInfo.getSignupPurchaseId());
            studentIds.add(orgSignupInfo.getUserId());
        }
        ArrayList courseIds = Lists.newArrayList();
        ArrayListMultimap pidCidsMap = ArrayListMultimap.create();
        List orgSignupCourses = this.orgSignupCourseDao.loadByPurchaseIds((Collection)purchaseIds, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)orgSignupCourses)) {
            for (OrgSignupCourse orgSignupCourse : orgSignupCourses) {
                courseIds.add(orgSignupCourse.getOrgCourseId());
                pidCidsMap.put((Object)orgSignupCourse.getSignupPurchaseId(), (Object)orgSignupCourse.getOrgCourseId());
            }
        }
        HashMap cidCourseMap = Maps.newHashMap();
        List orgCourses = this.orgCourseDao.getByIds((Collection)courseIds, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)orgCourses)) {
            for (OrgCourse orgCourse : orgCourses) {
                cidCourseMap.put(orgCourse.getId(), orgCourse);
            }
        }
        Map studentsMap = this.orgStudentDAo.getOrgStudentMapByUserIds((Collection)studentIds);
        Map orgInfoMap = this.orgInfoService.getOrgInfoMap((List)intOrgIds);
        for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
            OrgStudent orgStudent;
            OrgInfo orgInfo = (OrgInfo)orgInfoMap.get(orgSignupInfo.getOrgId().intValue());
            EnrollOverriew dto = new EnrollOverriew();
            if (orgInfo != null) {
                dto.setCampusName(orgInfo.getShortName());
            }
            dto.setCreateTime(orgSignupInfo.getCreateTime().getTime());
            dto.setExportTime(orgSignupInfo.getCreateTime());
            dto.setPrice(orgSignupInfo.getTotalPrices().doubleValue() / 100.0);
            Collection cids = pidCidsMap.get((Object)orgSignupInfo.getSignupPurchaseId());
            if (CollectionUtils.isNotEmpty((Collection)cids)) {
                StringBuilder courseName = new StringBuilder();
                ArrayList tempCids = new ArrayList(cids);
                for (int i = 0; i < tempCids.size(); ++i) {
                    Long cid = (Long)tempCids.get(i);
                    OrgCourse orgCourse = (OrgCourse)cidCourseMap.get(cid);
                    if (orgCourse != null) {
                        courseName.append(orgCourse.getName());
                    }
                    if (i + 1 >= tempCids.size()) continue;
                    courseName.append(",");
                }
                dto.setCourseName(courseName.toString());
            }
            if ((orgStudent = (OrgStudent)studentsMap.get(orgSignupInfo.getUserId())) != null) {
                if (StringUtils.isBlank((CharSequence)orgStudent.getName())) {
                    if (StringUtils.isNotEmpty((CharSequence)orgStudent.getNickName())) {
                        dto.setStudentName(orgStudent.getNickName());
                    } else {
                        dto.setStudentName(MaskUtil.maskMobile((String)orgStudent.getMobile()));
                    }
                } else {
                    dto.setStudentName(orgStudent.getName());
                }
            }
            data.add(dto);
        }
        return data;
    }

    @Override
    public boolean isRequestValid() {
        Integer orgId = TianxiaoPCContext.getOrgId();
        Integer txAccountId = TianxiaoPCContext.getTXLoginAccountId();
        Integer txCascadeId = TianxiaoPCContext.getTXCascadeId();
        log.info("check isRequestValid orgId={},txCascadeId={},txLoginAccountId={}", new Object[]{orgId, txCascadeId, txAccountId});
        if (orgId == null || txAccountId == null) {
            return false;
        }
        OrgSubAccount orgSubAccount = this.orgSubAccountService.getByOrgIdIgnoreIsdel(orgId);
        TXAccount txAccount = this.txAccountService.getByIdAndOrgId(txAccountId, orgId);
        if (txAccount == null | orgSubAccount == null) {
            return false;
        }
        if (txCascadeId == null) {
            return orgSubAccount.getPid() == 0;
        }
        TXCascadeAccount cascadeAccount = this.txCascadeAccountDao.getByIdAndOrgId(txCascadeId, orgId);
        return null == cascadeAccount ? false : cascadeAccount.getAccountType().intValue() == CascadeType.MANAGER.getValue();
    }

    @Override
    public boolean isMasterHead() {
        Integer orgId = TianxiaoPCContext.getOrgId();
        Integer txAccountId = TianxiaoPCContext.getTXLoginAccountId();
        Integer txCascadeId = TianxiaoPCContext.getTXCascadeId();
        log.info("check isMasterHead orgId={},txCascadeId={},txLoginAccountId={}", new Object[]{orgId, txCascadeId, txAccountId});
        if (orgId == null || txAccountId == null) {
            return false;
        }
        OrgSubAccount orgSubAccount = this.orgSubAccountService.getByOrgIdIgnoreIsdel(orgId);
        TXAccount txAccount = this.txAccountService.getByIdAndOrgId(txAccountId, orgId);
        if (txAccount == null | orgSubAccount == null) {
            return false;
        }
        if (txCascadeId == null) {
            return orgSubAccount.getPid() == 0;
        }
        return false;
    }

    @Override
    public Integer getLoginRole() {
        Integer orgId = TianxiaoPCContext.getOrgId();
        Integer txAccountId = TianxiaoPCContext.getTXLoginAccountId();
        Integer txCascadeId = TianxiaoPCContext.getTXCascadeId();
        log.info("getLoginRole orgId={},txCascadeId={},txLoginAccountId={}", new Object[]{orgId, txCascadeId, txAccountId});
        if (orgId == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u767b\u5f55\u8eab\u4efd\u5931\u6548!");
        }
        OrgSubAccount orgSubAccount = this.orgSubAccountService.getByOrgIdIgnoreIsdel(orgId);
        if (orgSubAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u627e\u4e0d\u5230\u5bf9\u5e94\u673a\u6784,\u6216\u5929\u6821\u5e10\u53f7\u88ab\u7981\u7528.");
        }
        if (txCascadeId == null) {
            return orgSubAccount.getPid() == 0 ? RoleType.PRESIDENT.type : RoleType.BRANCH_SCH_PRESIDENT.type;
        }
        TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)txCascadeId, new String[0]);
        if (cascadeAccount == null || cascadeAccount.getStatus() == TXCascadeAccountStatus.PAUSE.getCode() || cascadeAccount.getIsdel().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u627e\u4e0d\u5230\u5bf9\u5e94\u5b50\u5e10\u53f7,\u6216\u5b50\u5e10\u53f7\u88ab\u7981\u7528.");
        }
        return (int)cascadeAccount.getAccountType();
    }
}

